;;; -*- Package: Cl-user; Mode: Lisp; Syntax: Ansi-common-lisp; Base: 10. -*-
;;;
;;;	File:		TimeLogic.lisp
;;;	Author:		Johannes A. G. M. Koomen
;;;	Purpose:	TimeLogic package and system definitions
;;;	Last Edit:	02/11/89 16:34:31
;;;
;;;	Copyright (c) 1989  University of Rochester
;;;
;;;	The TimeLogic System is being made available by the University of
;;;	Rochester for research purposes.  No commercial use or distribution to
;;;	third parties is allowed without the explicit written permission of
;;;	the University of Rochester.
;;;
;;;	The University of Rochester will have a non-exclusive right, at no
;;;	expense, to the derivative works, modifications and enhancements made
;;;	to or resulting from the TimeLogic System, and the University of
;;;	Rochester shall be informed of such development and furnished with the
;;;	source codes to such works, modifications and enhancements when
;;;	available.  The University of Rochester will accept such derivative
;;;	works, modifications and enhancements "as is."
;;;
;;;	For documentation on this implementation see Technical Report #231,
;;;	Department of Computer Science, University of Rochester.
;;;
;;;  Version 5.1 13May93 by Miller - handle tracing of backtrack points (by tempos).

(defparameter user::*timelogic-version* "5.1 13May93 by miller")
(eval-when (compile load eval)
  (export '(user::*timelogic-version*)))

#+symbolics (DECLAIM (OPTIMIZE (SPEED 3) (SAFETY 0) (DEBUG 0) (SPACE 0)))
#-symbolics (DECLAIM (OPTIMIZE (SPEED 2) (SAFETY 1) (DEBUG 1) (SPACE 0)))

(defpackage TimeLogic (:nicknames tl) (:use COMMON-lisp) 
	    (:EXPORT <> ; not-equal symbol for dlinks (superceded by :<> but kept for compatibility reasons)
		     addintconq defintq getintconq 
		     traceintq untraceintq *tld-assert-hook* *tlr-assert-hook*
		     add-interval-constraint define-interval defined-intervals get-interval-constraint interval-defined-p
		     reference-intervals related-intervals sort-intervals test-interval-constraint timelogic-backtrack
		     timelogic-checkpoint timelogic-checkpoint-p timelogic-init timelogic-prop timelogic-reset-props
		     create-context define-context defined-contexts context-defined-p delete-context switch-context
		     current-context push-context pop-context context-tree
		     display-intervals graph-intervals show-interval-constraints timelogic-stats trace-interval
		     untrace-interval tl-demos))

#+explorer
(defsystem timelogic
  (:name		"TimeLogic Temporal Reasoning System")
  (:short-name		"TimeLogic")
  (:pathname-default	"timelogic:timelogic;")
  (:patchable           )
  (:initial-status	:experimental)

  (:module defs1 ("tl-defs"))
  (:module defs2 ("tl-rlink-codes" "tl-dlink-codes"))
  (:module tlsys ("tl-main" "tl-contexts" "tl-rlinks" "tl-dlinks" "tl-trace"))
  (:module demos ("tl-demos"))

  (:compile-load defs1)
  (:compile-load defs2 (:fasload defs1))
  (:compile-load tlsys (:fasload defs1 defs2))
  (:compile-load demos (:fasload tlsys))
)

#+symbolics
(ZL:::SCL:defsystem timelogic
    (:pretty-name	"TimeLogic Temporal Reasoning System"
     :short-name	"TimeLogic"
     :default-pathname	"timelogic:timelogic;"
     :journal-directory	"timelogic:patch;"
     :patchable		t
     :initial-status	:released
     :bug-reports	("TimeLogic-Support"
			 "Report problems with the TimeLogic Temporal Reasoning System.")
     :advertised-in	(:herald :finger :disk-label)
     :maintaining-sites	(:cs-rochester)
     :distribute-binaries t
     :initializations	nil
    )
  (:module defs1 ("tl-defs"))
  (:module defs2 ("tl-rlink-codes" "tl-dlink-codes")
	   (:uses-definitions-from defs1))
  (:module tlsys ("tl-main" "tl-contexts" "tl-rlinks" "tl-dlinks" "tl-trace")
	   (:uses-definitions-from defs2))
  (:module demos ("tl-demos")
;	   (:type :lisp-example)
;	   (:in-order-to :compile (:load tlsys))
	   (:uses-definitions-from tlsys)
	   )
  (:serial defs1 defs2 tlsys demos)
)

#+Allegro-V4.0
(MK:DEFSYSTEM TIMELOGIC
    :SOURCE-PATHNAME "/s5/timelogic/"
    :SOURCE-EXTENSION "lisp"
    :BINARY-PATHNAME nil
    :BINARY-EXTENSION "ofasl"
    :components
         ((:MODULE DEFS1
                   :source-pathname ""
		   :PACKAGE TL
                   :components ("tl-defs"))
	  (:module defs2
	   :SOURCE-PATHNAME ""
	   :PACKAGE TL
	   :COMPONENTS ("tl-rlink-codes" "tl-dlink-codes")
	   :DEPENDS-ON (defs1))
	  (:module tlsys 
	   :SOURCE-PATHNAME ""
	   :PACKAGE TL
	   :COMPONENTS ("tl-main" "tl-contexts" "tl-rlinks" "tl-dlinks" "tl-trace")
	   :DEPENDS-ON (defs2))
	  (:MODULE DEMOS
	   :SOURCE-PATHNAME ""
	   :COMPONENTS ("tl-demos")
	   :DEPENDS-ON (TLSYS))))

#-(OR ALLEGRO-V4.0 SYMBOLICS EXPLORER)
(DEFSYSTEM timelogic
    (:pretty-name	"TimeLogic Temporal Reasoning System"
     :default-pathname	"/s5/timelogic/"
    )
  (:module defs1 ("tl-defs"))
  (:module defs2 ("tl-rlink-codes" "tl-dlink-codes")
	   (:uses-definitions-from defs1))
  (:module tlsys ("tl-main" "tl-contexts" "tl-rlinks" "tl-dlinks" "tl-trace")
	   (:uses-definitions-from defs2))
  (:module demos ("tl-demos")
;	   (:type :lisp-example)
;	   (:in-order-to :compile (:load tlsys))
	   (:uses-definitions-from tlsys)
	   )
  (:serial defs1 defs2 tlsys demos)
)
