;;; -*-	Package: Cl-user; Mode: Lisp; Syntax: Ansi-common-lisp; Base: 10. -*-
;;;	File:		Tempos.lisp
;;;	Purpose:	Defines the system
;;;	Last Edit:	2/25/89 15:27:36
;;;
;;;	Copyright (c) 1988, 1989 by Johannes A. G. M. Koomen.  All rights reserved.
;;;
;;;	The TEMPOS system provides a temporal reasoning facility for the logic
;;;	programming system RHETORICAL.  It supplies hooks into the TimeLogic
;;;	package, and defines primitives such as TT (True Throughout) etc. (cf. TR #???)

;;; Version info:
;;; 3.7 30Nov92 by miller - recompile due to rhet changes and some macro changes in cl-lib
;;; 3.8 07May93 by miller - make sure (reset-tempos :trace t) sets *tempos-tracing*
;;; 3.9 12May93 by miller - Time-Skolem should be capitalized before interning as a term (make-skolem-term).
;;; 3.10 12May93 by miller - when skolemizing, don't let rhet initialize the time term.
;;; 3.11 13May93 by miller - allow tracing of backtracking
;;; 3.12 21May93 by miller - make sure query-time uses the failure continuation.

(defparameter user::*tempos-version* "3.12 21May93 by miller")
(eval-when (compile load eval)
  (export '(user::*tempos-version*)))

#+SYMBOLICS
(ZL:::SCL:defsystem Tempos
    (:pretty-name "Tempos (Rhetorical-Embedded Temporal Reasoner)"
     :default-pathname "tempos:tempos;"
;     :default-package Tempos
     :journal-directory "tempos:patch;"
     :patchable t
     :initial-status :experimental
     :advertised-in (:herald :finger)
     :bug-reports ("Tempos Support <Koomen@CS.Rochester.edu>" "Report problems with TEMPOS.")
     :maintaining-sites (:cs-rochester)
     :distribute-sources t
     :distribute-binaries nil)
  (:module Time TimeLogic (:type :system))
  (:module Rhet Rhetorical (:type :system))
  (:module Code Tempos-Code (:type :system)
	   (:in-order-to (:load :compile) (:load Time Rhet)))
)

#+SYMBOLICS
(ZL:::SCL:defsubsystem Tempos-Code
    (:default-pathname "tempos:tempos;"
;     :default-package Tempos
     )
  (:MODULE PACKAGE ("Tempos-Package"))
  (:module Base ("Tempos-Base"))
  (:module Bltn ("Tempos-Builtins"))
  (:module Main ("Tempos-Main"))
  ;;  (:module Rhet ("Tempos-Rhet") (:type :lisp-example)) ; loaded in Main
  (:serial PACKAGE Base Bltn Main)
)
#+excl
(eval-when (load eval)
  (cl-lib:add-initialization "prepare for tempos" '(progn (tpl:setq-default *package* (find-package :rhet-user))
                                                    (tpl:setq-default tpl::*saved-package* (find-package :rhet-user))
                                                    (FORMAT *terminal-io* "~&Resetting Tempos~%")
                                                    (eval (list (intern "RESET-TEMPOS" 'tempos))))
                             '(:cold))
  (cl-lib:add-initialization "announce tempos" 
                             '(format *terminal-io* 
                               "~& Rhet(w/tempos ~A timelogic ~A) Version:~A~%" 
                               user::*tempos-version* user::*timelogic-version* user::*rhet-version*)
                             '(:warm))
  (cl-lib:add-initialization "prepare for tempos" '(progn (tpl:setq-default *package* (find-package :rhet-user))
                                                    (tpl:setq-default tpl::*saved-package* (find-package :rhet-user))
                                                    (FORMAT *terminal-io* "~&Resetting Tempos~%")
                                                    (eval (list (intern "RESET-TEMPOS" 'tempos))))
                             '(:before-cold))
  )

#-(OR SYMBOLICS EXPLORER ALLEGRO-V4.0)
(eval-when (compile load eval)
  (defclass lisp-example-module (defsys:lisp-module) ())
  
  (defmethod defsys:compile-module ((module lisp-example-module) &rest keys &key &allow-other-keys)
    nil)                                ; don't compile it.

  (defmethod defsys:product-pathname ((module lisp-example-module))
    (defsys:source-pathname module))
  
  (defsystem Examp (:default-module-class lisp-example-module
                       :default-pathname "/s5/tempos/")
    (:module Rhet1 ("tempos-rhet")))
  
  (defsystem Tempos
	     (:pretty-name "Tempos (Rhetorical-Embedded Temporal Reasoner)"
	      :default-pathname "/s5/tempos/")
						      ;  (:module Time TimeLogic (:type :system))
						      ;  (:module Rhet Rhetorical (:type :system))
    (:MODULE PACKAGE ("tempos-package")
						      ;	   (:in-order-to (:load :compile) (:load Time Rhet))
	     )
    (:module Base ("tempos-base"))
    (:module Bltn ("tempos-builtins"))
    (:module Main ("tempos-main"))
    ;;    (:module Rhet (Examp))
    (:serial PACKAGE Base Bltn Main)))
