;;; Author: Stephen P Spackman <spackman@dfki.uni-sb.de>
;;; load this file, after tempos-test1.lisp in this directory.

;;; some minor mods by miller to make this a loadable test for tempos & rhet.

(in-package :rhet-user)

(defun hours (x) (* x 3600))

(multiple-value-bind (second minute hour day month year)
    (decode-universal-time (get-universal-time))
  (defparameter midnight (encode-universal-time 0 0 0 day month year)))

(define-time [today])

(rassert (cons-rhet-form 'starts-at 'today midnight)
	 (cons-rhet-form 'length 'today (hours 24)))

(define-time [test-appointment-time-1])
(rassert [appointment-time test-appointment-time-1])

(rassert (cons-rhet-form 'starts-at 'test-appointment-time-1
			 (+ midnight (hours 16)))
	 (cons-rhet-form 'length 'test-appointment-time-1
			 (hours 3/4)))

(define-time [test-appointment-time-2])
(rassert [appointment-time test-appointment-time-2])

(rassert (cons-rhet-form 'starts-at 'test-appointment-time-2
			 (+ midnight (hours 34)))
	 (cons-rhet-form 'length 'test-appointment-time-2
			 (hours 5/4)))

(expect "([AND [OVERLAPS TODAY TEST-APPOINTMENT-TIME-1] [APPOINTMENT-TIME TEST-APPOINTMENT-TIME-1]])"
        (prove-all [and [overlaps today ?x*t-time] [appointment-time ?x]]))
