;;;  -*- Package: Rhet-user; Mode: Lisp; Syntax: Rhet; Base: 10. -*- 

;;;	File:		Tempos-Rhet-Test.lisp
;;;	Purpose:	Test file for Tempos-Rhet.lisp
;;;	Last Edit:	3/22/89 14:22:31
;;;
;;;	Copyright (c) 1988, 1989  Johannes A. G. M. Koomen
;;;	All rights reserved.
;;;
;;;	The TEMPOS system provides a temporal reasoning facility for the
;;;	logic system RHETORICAL.  It supplies hooks into the TimeLogic package,
;;;	and defines primitives such as TT (True Throughout) etc.

(defun tempos-rhet-test (&key
			 (ask t)
			 (trace-tempos :verbose)
			 (trace-reasoner :builtin))
  (tempos::rhet-tests
    :ask ask
    :tt-axioms-p t
    :trace-tempos trace-tempos
    :trace-reasoner trace-reasoner
    :tests '((";;; Test: Winter@JAN-89 --> Winter@18-JAN-89? "
	      "(define-time	[18-JAN-89] [JAN-89])"
	      "(assert-axioms	[[Time-During 18-JAN-89 JAN-89] <])"
	      "(assert-axioms	[[Time-Downward WINTER] <])"
	      "(assert-axioms	[[TT JAN-89 WINTER] <])"
	      "(prove		[TT 18-JAN-89 WINTER])"
	      "(prove-all	[TT ?i*T-Time WINTER])"
	      )
	     (";;; Test: Seq(Day,Night)@TESTTIME --> Day@sometime? "
	      ;; Disabling equality makes SEQ analysis a bit more readable
	      "(setf reasoner::*reasoner-disable-equality* t)"
	      "(define-time	[TESTTIME])"
	      "(assert-axioms	[[Time-Mutex DAY NIGHT] <])"
	      "(assert-axioms	[[MT TESTTIME [SEQ DAY NIGHT]] <])"
	      "(prove		[TT ?sometime*T-Time DAY])"
	      )
	     (";;; Test: Rpt(Dishes)@ALWAYS --> Dishes@sometime? "
	      "(define-time	[ALWAYS])"
	      "(assert-axioms	[[RT ALWAYS DISHES] <])"
	      "(prove		[TT ?sometime*T-Time DISHES])"
	      )
	     (";;; Test: Rpt(Seq(Day,Night))@ALWAYS --> Night@sometime? "
	      ;; Disabling equality makes SEQ analysis a bit more readable
	      "(setf reasoner::*reasoner-disable-equality* t)"
	      "(define-time	[ALWAYS])"
	      "(assert-axioms	[[Time-Mutex DAY NIGHT] <])"
	      "(assert-axioms	[[RT ALWAYS [SEQ DAY NIGHT]] <])"
	      "(prove		[MT ?sometime*T-Time NIGHT])"
	      )
	     (";;; Test: Rpt(Dishes)@ALWAYS & Dishes@{TESTTIME during ALWAYS} --> Dishes@{sometime after TESTTIME}? "
	      "(define-time	[TESTTIME] [ALWAYS])"
	      "(assert-axioms	[[RT ALWAYS DISHES] <])"
	      "(assert-axioms	[[Time-During TESTTIME ALWAYS] <])"
	      "(assert-axioms	[[MT TESTTIME DISHES] <])"

;	      "(define-time	[XXXTESTTIME])"
;	      "(assert-axioms	[[Time-During XXXTESTTIME ALWAYS] <])"
;	      "(assert-axioms	[[Time-Before XXXTESTTIME TESTTIME] <])"
;	      "(assert-axioms	[[MT XXXTESTTIME DISHES] <])"

	      "(prove		[AND [POST [Time-Reln TESTTIME (:B :M) ?sometime*T-Time]]
				     [TT ?sometime*T-Time DISHES] ])"
;	      "(prove		[AND [TT ?sometime*T-Time DISHES]
;				     [Time-Reln TESTTIME (:B :M) ?sometime*T-Time]])"
	      "(add-display t)"
	      )
	     (";;; Test: Rpt(Seq(Day,Night))@ALWAYS & Day@{TESTTIME during ALWAYS} --> Night@{sometime after TESTTIME}? "
	      ;; Disabling equality makes SEQ analysis a bit more readable
	      "(setf reasoner::*reasoner-disable-equality* t)"
	      "(define-time	[TESTTIME] [ALWAYS])"
	      "(assert-axioms	[[Time-Mutex DAY NIGHT] <])"
	      "(assert-axioms	[[RT ALWAYS [SEQ DAY NIGHT]] <])"
	      "(assert-axioms	[[Time-During TESTTIME ALWAYS] <])"
	      "(assert-axioms	[[MT TESTTIME DAY] <])"
	      "(prove		[AND [POST [Time-Reln TESTTIME (:B :M) ?sometime*T-Time]]
				     [MT ?sometime*T-Time NIGHT]])"
	      "(add-display t)"
	      )
	     (";;; Test: Rpt(Seq(Day,Night))@ALWAYS & Day@{TESTTIME during ALWAYS} --> Day@{sometime after TESTTIME}? "
	      ;; Disabling equality makes SEQ analysis a bit more readable
	      "(setf reasoner::*reasoner-disable-equality* t)"
	      "(define-time	[TESTTIME] [ALWAYS])"
	      "(assert-axioms	[[Time-Mutex DAY NIGHT] <])"
	      "(assert-axioms	[[RT ALWAYS [SEQ DAY NIGHT]] <])"
	      "(assert-axioms	[[Time-During TESTTIME ALWAYS] <])"
	      "(assert-axioms	[[MT TESTTIME DAY] <])"
	      "(prove		[AND [POST [Time-Reln TESTTIME (:B :M) ?sometime*T-Time]]
				     [MT ?sometime*T-Time DAY]])"
	      "(add-display t)"
	      )
	     (";;; Test repeated occurrence after other occurrence using ASSUME? "
	      "(define-time	[TESTTIME] [ALWAYS])"
	      "(assert-axioms	[[RT ALWAYS DISHES] <])"
	      "(prove		[ASSUME [AND [Time-During TESTTIME ALWAYS] [MT TESTTIME DISHES]]
					[POST [Time-Reln TESTTIME (:B :M) ?sometime*T-Time]]
					[TT ?sometime*T-Time DISHES]])"
	      )
	     (";;; Test (2) occurs after (1) occurs in (1,2) recurrence using ASSUME? "
	      ;; Disabling equality makes SEQ analysis a bit more readable
	      "(setf reasoner::*reasoner-disable-equality* t)"
	      "(define-time	[TESTTIME] [ALWAYS])"
	      "(assert-axioms	[[Time-Mutex DAY NIGHT] <])"
	      "(assert-axioms	[[RT ALWAYS [SEQ DAY NIGHT]] <])"
	      "(prove		[ASSUME [AND [Time-During TESTTIME ALWAYS] [MT TESTTIME DAY]]
					[POST [Time-Reln TESTTIME (:B :M) ?sometime*T-Time]]
					[MT ?sometime*T-Time NIGHT]])"
	      )
	     (";;; Test (2) occurs after (2) occurs in (1,2) recurrence using ASSUME? "
	      ;; Disabling equality makes SEQ analysis a bit more readable
	      "(setf reasoner::*reasoner-disable-equality* t)"
	      "(define-time	[TESTTIME] [ALWAYS])"
	      "(assert-axioms	[[Time-Mutex DAY NIGHT] <])"
	      "(assert-axioms	[[RT ALWAYS [SEQ DAY NIGHT]] <])"
	      "(prove		[ASSUME [AND [Time-During TESTTIME ALWAYS] [MT TESTTIME NIGHT]]
					[POST [Time-Reln TESTTIME (:B :M) ?sometime*T-Time]]
					[MT ?sometime*T-Time NIGHT]])"
	      )
	     )
    )
)


(defun add-display (&optional now-p)
  (tl:timelogic-prop :display :on)
  (tl:timelogic-prop :sort :on)
  (mapc #'tl:trace-interval (tl:defined-intervals))
  (tl:untrace-interval 'tempos::|Tempos-Root|)
  (if now-p (tl:display-intervals :ints t :clear nil))
  t
)