;;;  -*- Package: Rhet-User; Mode: Lisp; Syntax: Rhet; Base: 10. -*- 

;;;	File:		Tempos-Builtins-Test.lisp
;;;	Purpose:	Test file for Tempos-Builtins.lisp
;;;	Last Edit:	3/22/89 14:22:40
;;;
;;;	Copyright (c) 1988, 1989  Johannes A. G. M. Koomen
;;;	All rights reserved.
;;;
;;;	The TEMPOS system provides a temporal reasoning facility for the
;;;	logic system RHETORICAL.  It supplies hooks into the TimeLogic package,
;;;	and defines primitives such as TT (True Throughout) etc.


(defun tempos-builtins-test (&key
			     (ask t)
			     (trace-tempos :verbose)
			     (trace-reasoner :builtin))
  (tempos::rhet-tests
    :ask ask
    :tt-axioms-p nil
    :trace-tempos trace-tempos
    :trace-reasoner trace-reasoner
    :tests '((";;; Test simple inference: X meets Y meets Z -> X before Z? "
	      "(define-time	[SHOP] [COOK] [EAT] [WASH])"
	      "(assert-axioms	[[Time-Before SHOP COOK] <])"
	      "(assert-axioms	[[Time-Meets COOK EAT] <])"
	      "(assert-axioms	[[Time-Meets EAT WASH] <])"
	      "(prove		[Time-Before COOK WASH])"
	      "(prove		[Time-Before ?x WASH])"
	      "(prove-all	[Time-Before ?x WASH])"
	      )
	     (";;; Test sequential decomposition (cover)? "
	      "(define-time	[TM1] [TM2] [TM3] [TM4] [TM5] [TM6])"
	      "(assert-axioms	[[Time-Meets TM1 TM2] <])"
	      "(assert-axioms	[[Time-Starts TM1 TM3] <])"
	      "(assert-axioms	[[Time-Finishes TM2 TM3] <])"
	      "(prove		[Time-Cover! TM1 TM2 TM3])"
	      "(assert-axioms	[[Time-Cover! TM4 TM5 TM6] <])"
	      "(prove		[Time-Subint TM5 TM6])"
	      )
	     (";;; Test Skolems? "
	      "(define-time	[XXX] [YYY])"
	      "(prove		[AND [POST [Time-Before XXX ?sk*T-Time]]
				[Time-Skolem ?sk]])"
	      "(prove		[AND [POST [Time-Before XXX ?sk*T-Time]]
				[POST [Time-After XXX ?sk*T-Time]]
				[Time-Skolem ?sk]])"
	      "(assert-axioms	[Time-Meets XXX YYY])"
	      "(prove		[AND [POST [Time-Before YYY ?ska*T-Time]]
				[POST [Time-Before ?skb*T-Time XXX]]
				[POST [Time-Before ?ska*T-Time ?skb*T-Time]]
				[Time-Skolem ?ska]
				[Time-Skolem ?skb]])"
	      )
	     (";;; Test contextual reasoning? "
	      "(define-time	[COOK] [EAT] [COFFEE] [WASH])"
	      "(assert-axioms	[[Time-Before COOK EAT] <])"
	      "(assert-axioms	[[Time-Reln EAT (:b :m) COFFEE] <])"
	      "(assert-axioms	[[Time-Reln EAT (:b :m) WASH] <])"
	      "(assert-axioms	[[Time-Disjoint COFFEE WASH] <])"
	      "(prove		[Time-Before EAT WASH])"
	      "(prove		[ASSUME [Time-Meets EAT COFFEE] [Time-Before EAT WASH]])"
	      "(assert-axioms	[Time-Meets EAT COFFEE])"
	      "(prove		[Time-Before EAT WASH])"
	      )
	   )
  )
)



;;; End of file TEMPOS-BUILTINS-TEST
