/* ---------------------------------------------------------- 
%   (C)1993,1994 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <klic/basic.h>
#include <klic/struct.h>
#include <klic/primitives.h>
#include <klic/schedule.h>
#include <stdio.h>
#include <klic/gb.h>
#include <klic/gobj.h>
#include <klic/susp.h>

long higher_priority_goal = 0;
q *do_unify(), *do_unify_value();
extern struct predicate predicate_unify__term__dcode_xunify_2;
extern struct predicate predicate_unify__term__dcode_xunify__goal_2;

#define enqueue_unify_terms(x, y) \
{ \
  struct goalrec *gp = (struct goalrec *)allocp; \
  gp->next = (struct goalrec*)makeint(current_prio); \
  gp->pred = &predicate_unify__term__dcode_xunify_2; \
  gp->args[0] = x; \
  gp->args[1] = y; \
  allocp += 4; \
  resume_same_prio(gp); \
}

#define enqueue_unify_goal(x, y) \
{ \
  struct goalrec *gp = (struct goalrec *)allocp; \
  gp->next = (struct goalrec*)makeint(current_prio); \
  gp->pred = &predicate_unify__term__dcode_xunify__goal_2; \
  gp->args[0] = (x); \
  gp->args[1] = (y); \
  allocp += 4; \
  resume_same_prio(gp); \
}

/* Resume a goal with the same priority as current */

Inline void resume_same_prio(gp)
     struct goalrec *gp;
{
  declare_globals;
  if (resumed_goals == 0) {
    resumed_goals = gp;
    gp->next = gp;
  } else {
    gp->next = resumed_goals->next;
    resumed_goals->next = gp;
  }
  heaplimit = 0;
}

/*
  resume the goals which has been hooked to variable `x'.
  by the unification with `y'
*/

Inline q *resume_goals(allocp, x, y)
     q * allocp;
     q x;
     q y;
{
  declare_globals;

  /* Variable x with suspended goals is instantiated here */
  /* x points suspension record directly. */

  struct susprec *susprecord = suspp(x);

  if(is_generator_susp(susprecord->u)) {
    /* generator_object */
    struct generator_susp *gsusp = generator_suspp(susprecord);
    struct generator_object *gobj = untag_generator_susp(gsusp->u.o);
    q *tempallocp;
    q backpt = gsusp->backpt;

    if((tempallocp = method_table_of(gobj)->
	active_unify(gsusp->backpt, y, allocp))) {
      /* Unify method was succeeded */
      allocp = tempallocp;
      derefone(backpt) = y; 
    } else {
      /* failed */
      q tmp = generic_generate(gobj, allocp);
      allocp = heapp;

      if(tmp != (q)0) {
	derefone(gsusp->backpt) =  tmp;
	if(isref(tmp) && tmp == derefone(tmp)) {
	  derefone(tmp) = y;
	} else {
	  allocp = do_unify(allocp, tmp, y);
	}
      } else {
	enqueue_unify_goal(x, y);
      }
    }
  } else {
    struct hook *top = susprecord->u.first_hook.next;
    struct hook *loopp = top;
#ifdef UNIFYDEBUG
    void dump_suspension_structure();
    printf("\nResume with "); print(y); putchar('\n');
    dump_suspension_structure(top);
#endif
  
    derefone(susprecord->backpt) = y;
  
    do {
      union goal_or_consumer u = loopp->u;
      if (u.l != 0) {
	if (is_consumer_hook(u)) {
	  struct consumer_object *obj = untag_consumer_hook(u.o);
	  q tmpval;
	  loopp->u.l = 0;
	  generic_active_unify(obj, y, allocp);
	  switch ((long)method_result) {
	  case (long)GENERIC_FAILED:
	    fatal("Unification failure on a consumer object");
	  case (long)GENERIC_SUCCEEDED:
	    if(!rest_of_stream) goto consumer_terminate;
/*	    y = rest_of_stream;*/
	    tmpval = rest_of_stream;
	    break;
	  case (long)GENERIC_GCREQUEST:
	    break;
	  default:
/*	    y = suspension_reason;*/
	    tmpval = method_result;
	  }
	  {
	    struct susprec *susp;
	    q newvar;
	    makenewsusp(newvar,susp,allocp);
	    susp->u.first_hook.u.o = tag_consumer_hook(obj);
	    if (derefone(tmpval) == tmpval) {
	      derefone(tmpval) = newvar;
	    } else {
	      enqueue_unify_goal(tmpval, newvar);
	    }
	  }
	consumer_terminate:;
	} else if (isint(u.g->next)) {
	  long gp = intval(u.g->next);
	  if (gp != current_prio) {
	    (void) enqueue_goal(0, gp, u.g, glbl);
	  } else {
	    resume_same_prio(u.g);
	  }
#ifdef DEBUGLIB
	  {
	    extern int trace_flag;
	    if(trace_flag) trace_resumption(u.g);
	  }
#endif
	  resumes++;
	}
      }
      loopp = loopp->next;
    } while (loopp != top);
  }
  return allocp;
}

q *do_unify(allocp, x, y)
     q * allocp;
     q x, y;
{
#ifdef UNIFYDEBUG
  printf("Unify with ");
  print(x);
  printf(",");
  print(y);
  printf("\n");
#endif
  if (isref(x)) {
    q temp = derefone(x);
  deref_x:
    if (x != temp){
      if (isref(temp)) {
	q temp1 = derefone(temp);
	if (temp1 == x) {
	  while (isref(y)) {
	    q ytemp = derefone(y);
	    if (y == ytemp) {
	      /* Suspension records must be referenced through REF. */
	      /* Thus, doing "derefone(y) = temp;" here is buggy. */
	      derefone(y) = x;
	      return allocp;
	    } else {
	      if (isref(ytemp) && derefone(ytemp) == y) {
		y = ytemp;
		x =  temp;
		if (x != y) {
		  /* merge two hook chains */
		  struct susprec *sx = (struct susprec *)x;
		  struct susprec *sy = (struct susprec *)y;
		  if(is_generator_susp(sx->u)) {
		    declare_globals;
		    q *tmpallocp;

		    struct generator_susp *gsx =
		      generator_suspp(sx);
		    q backpt = gsx->backpt;
		    /* At first, try unify method */
		    if((tmpallocp =
			(method_table_of(untag_generator_susp(gsx->u.o))->
			 active_unify(gsx->backpt, sy->backpt,
				      allocp)))) {
		      /* succeeded */
		      allocp = tmpallocp;
		      derefone(backpt) = sy->backpt;
		    } else {
		      /* failed */
		      q tmpx =
			generic_generate(untag_generator_susp(gsx->u.o),
					 allocp);
		      allocp = heapp;
		      if(tmpx != (q)0) {
			derefone(gsx->backpt) =  tmpx;
			if(isref(tmpx) && tmpx == derefone(tmpx)) {
			  derefone(tmpx) = sy->backpt;
			} else {
			  if(is_generator_susp(sy->u)) {
			    struct generator_susp *gsy =
			      generator_suspp(sy);
			    q *tmpallocp;
			    if((tmpallocp =
				method_table_of(untag_generator_susp(gsy->u.o))->
				active_unify(gsy->backpt, tmpx, allocp))) {
			      /* OK !*/
			      allocp = tmpallocp;
			      derefone(gsy->backpt) = tmpx;
			    } else {
			      /* failed at active unify on y */
			      q tmpy = generic_generate(untag_generator_susp(gsy->u.o),
							allocp);
			      allocp = heapp;
			      if(tmpy != (q)0) {
				derefone(gsy->backpt) = tmpy;
				if(isref(tmpy) && tmpy == derefone(tmpy)) {
				  derefone(tmpy) = tmpx;
				} else {
				  allocp = do_unify(allocp, tmpx, tmpy);
				}
			      } else {
				enqueue_unify_goal(tmpx, sy->backpt);
			      }
			    }
			  } else { /* sy is hook and tmpx MAY be hook */
			    allocp = do_unify(allocp, tmpx, sy->backpt);
			  }
			}
		      } else {
			enqueue_unify_goal(sx->backpt, sy->backpt);
		      }
		    }
		  } else if(is_generator_susp(sy->u)) {
		    /* x is not generator */
		    declare_globals;
		    struct generator_susp *gsy =
		      generator_suspp(sy);
		    q *tmpallocp;
		    q backpt = gsy->backpt;
		    /* try unification */
		    if((tmpallocp =
			(method_table_of(untag_generator_susp(gsy->u.o))->
			 active_unify(gsy->backpt,
				      sx->backpt, allocp)))) {
		      /* OK ! */
		      allocp = tmpallocp;
		      derefone(backpt) = sx->backpt;
		    } else {
		      /* failed */
		      q tmpy = generic_generate(untag_generator_susp(gsy->u.o),
						allocp);
		      allocp = heapp;
		      if(tmpy != (q)0) {
			derefone(gsy->backpt) = tmpy;
			if(isref(tmpy) && tmpy == derefone(tmpy)) {
			  derefone(tmpy) = sx->backpt;
			} else {
			  allocp = do_unify(allocp, tmpy, sx->backpt); 
			}
		      } else {
			enqueue_unify_goal(sx->backpt, sy->backpt);
		      }
		    }
		  } else {
		    /* None of two is generator, then merge ... */
		    struct hook *second_of_x = sx->u.first_hook.next;
		    /* connect sx and topy */
		    sx->u.first_hook.next = sy->u.first_hook.next;
		    sy->u.first_hook.next = second_of_x;
		    derefone(sy->backpt) = sx->backpt;
		  }
		}
		return allocp;
	      }
	    }
	    y = ytemp;
	  }
	  /* x is hook variable and y points a real object */
	  return resume_goals(allocp, temp, y);
	} else {
	  x = temp;
	  temp = temp1;
	  goto deref_x;
	}
      } else {
	x = temp;
      }
    } else {
      /* dereference y */
      while (isref(y)) {
	temp = derefone(y);
	if (temp == y || (isref(temp) && derefone(temp) == y)) break;
	y = temp;
      }
      derefone(x) = y;		/* this also handles x==y cases */
      return allocp;
    }
  }

  /* x is bound */
  while (isref(y)) {
    q temp = derefone(y);
    if (temp == y) { /* y is undef cell */
      derefone(y) = x;
      return allocp;
    } else {
      if(isref(temp) && derefone(temp) == y) {
	return resume_goals(allocp, temp, x);
      }
    }
    y = temp;
  }

  /* Both x and y are bound */
  if (x != y) {
    declare_globals;
    enqueue_unify_terms(x, y);
  } 
  return allocp;
}

/*
  do_unify_value(allocp, x, y)
	"do_unify" for when "y" is known to be instantiated.
*/
q *do_unify_value(allocp, x, y)
     q * allocp;
     q x, y;
{
  if (isref(x)) {
    q temp = derefone(x);
    if (x == temp) {
      derefone(x) = y;
      return allocp;
    } else if (isref(temp)) {
      q temp1;
    again:
      temp1 = derefone(temp);
      if (isref(temp1)) {
	if (temp1 == temp) {
	  derefone(temp) = y;
	  return allocp;
	} else if (temp1 == x) {
	  return resume_goals(allocp, temp, y);
	} else {
	  x = temp;
	  temp = temp1;
	  goto again;
	}
      } else {
	return do_unify(allocp, temp1, y);
      }
    } else {
      return do_unify(allocp, temp, y);
    }
  }
  return do_unify(allocp, x, y);
}

#ifdef UNIFYDEBUG
#define dumpgoal(g) \
{ \
  if(g){ \
    printf("\tgoal:\t"); \
    printf("%x:%d/%d\n", g->pred->func, g->pred->pred, g->pred->arity); \
  } else { \
    printf("Illegal goal !: %x\n", g); \
  } \
}

void
dump_suspension_structure(x)
q *x;
{
  q *i = x;
  printf("Dump suspension structure : %x\n", x);
  do{
    switch(ptagof(*i)){
     case SSUSP:
      {
	struct shook *s = shookp(i);
	struct goalrec *g = s->goals;
	printf("Single suspension record : %x\n", s);
	dumpgoal(g);
      }
      break;
     case MSUSP:
      {
	struct mhook *m = mhookp(i);
	struct goalrec *g = m->goals;
	printf("Multiple suspension record : %x\n", m);
	dumpgoal(g);
	printf("back pointer:\t"); printf("%x\n", m->back);
	printf("related record:\t%x\n", m->next);
      }
      break;
     default:
      printf("Merger\n");
    }
    i = (q*)getnexthook(i);
  }while(getnexthook(i) != x);
}
#endif
