/* ----------------------------------------------------------
%   (C)1993,1994 Institute for New Generation Computer Technology
%       (Read COPYRIGHT for detailed information.)
----------------------------------------------------------- */

#include <stdio.h>
#include <klic/gcobject.h>
#include <klic/g_pointer.h>
#include <klic/g_string.h>
#include "atom.h"
#include "funct.h"

extern struct data_object_method_table
  byte__string_g_data_method_table,
  pointer_g_data_method_table;

struct file_io_object {
  struct consumer_object_method_table *method_table;
  char close_on_termination;
  char *name;
  q stream; /* saved input stream for suspension by some other reasons */
  FILE *file;
};

#define GC_CLASS_NAME() file__io
#define GC_OBJ_TYPE struct file_io_object
#define GC_OBJ_SIZE(obj)  G_SIZE_IN_Q(GC_OBJ_TYPE)

#include <klic/gc_macro.h>
#include <klic/gd_macro.h>

/* basic method definitions */

GCDEF_UNIFY()
{
  G_STD_DECL;
  q newvar;
  q reason;

  if (GC_SELF->stream != 0) GC_TERM = GC_SELF->stream;
 top:
  if (G_ISCONS(GC_TERM)) {
    q message = G_CAR_OF(GC_TERM);
    if (G_ISINT(message)) {
      long c = G_INTVAL(message);
      if (putc(c, GC_SELF->file) == EOF) {
	GC_FAIL("putc failed");
      }
    } else if (G_ISFUNCTOR(message)) {
      switch (G_SYMVAL(G_FUNCTOR_OF(message))) {
	/*** Input Messages ***/
      case functor_getc_1: {
	long c;
	c = getc(GC_SELF->file);
	GC_UNIFY_VALUE(G_ARG(message,0), G_MAKEINT(c));
	break;
      }
      case functor_ungetc_1: {
	long c;
	GCSET_MESSAGE_INT_ARG(c, message, 0);
	ungetc(c, GC_SELF->file);
	break;
      }
      case functor_fread_2: {
	extern char *malloc_check();
	extern q convert_binary_c_string_to_klic_string();
	long n;
	char *buf;
	q string;
	GCSET_MESSAGE_INT_ARG(n, message, 0);
	if (n<0) goto message_error;
	if ((char *)g_allocp+sizeof(struct byte_string_object)+
	    n+sizeof(long) >=
	    (char *)real_heaplimit) {
	  g_allocp = real_heaplimit;
	  goto gc_request;
	}
	buf = (char *)malloc_check(n);
	n = fread(buf, 1, n, GC_SELF->file);
	string = convert_binary_c_string_to_klic_string(buf, n, g_allocp);
	if (G_ISREF(string)) {
	  GC_FAIL("internal error: string allocation for fread");
	}
	g_allocp = heapp;
	free(buf);
	GC_UNIFY_VALUE(G_ARG(message,1), string);
	break;
      }
	/*** Output Messages ***/
      case functor_putc_1: {
	long c;
	GCSET_MESSAGE_INT_ARG(c, message, 0);
	if (putc(c, GC_SELF->file) == EOF) {
	  GC_FAIL("putc failed");
	}
	break;
      }
      case functor_fwrite_2: {
	extern unsigned char *generic_string_body();
	struct byte_string_object *str;
	int size;
	int written;
	GCSET_MESSAGE_STR_ARG(str, message, 0);
	size = generic_string_size(str);
	written = fwrite(generic_string_body(str), 1, size, GC_SELF->file);
	GC_UNIFY_VALUE(G_ARG(message,1), G_MAKEINT(written));
	break;
      }
	/*** Common Messages ***/
      case functor_feof_1: {
	long iseof = feof(GC_SELF->file);
	GC_UNIFY_VALUE(G_ARG(message,0), G_MAKEINT(iseof));
	break;
      }
      case functor_fseek_3: {
	long offset, whence, result;
	GCSET_MESSAGE_INT_ARG(offset, message, 0);
	GCSET_MESSAGE_INT_ARG(whence, message, 1);
	result = fseek(GC_SELF->file, offset, whence);
	GC_UNIFY_VALUE(G_ARG(message,2), G_MAKEINT(result));
	break;
      }
      case functor_ftell_1: {
	long result = ftell(GC_SELF->file);
	GC_UNIFY_VALUE(G_ARG(message,0), G_MAKEINT(result));
	break;
      }
      case functor_fflush_1: {
	long result = fflush(GC_SELF->file);
	GC_UNIFY_VALUE(G_ARG(message,0), G_MAKEINT(result));
	break;
      }
      case functor_fclose_1: {
	long result;
	if (GC_SELF->close_on_termination) {
	  result = fclose(GC_SELF->file);
	} else {
	  result = 0;
	}
	GC_UNIFY_VALUE(G_ARG(message,0), G_MAKEINT(result));
	break;
      }
      default: goto message_error;
      }
    } else {
      goto message_error;
    }
    GC_TERM = G_CDR_OF(GC_TERM);
    goto top;
  } else if (GC_TERM==NILATOM) {
    if (GC_SELF->close_on_termination) {
      fclose(GC_SELF->file);
    }
    GC_TERMINATE;
  } else if (G_ISREF(GC_TERM)) {
    q temp = GC_TERM;
    if (temp == GC_TERM || G_DEREFONE(temp) == GC_TERM) {
      reason = GC_TERM;
      GC_SELF->stream = 0;
      goto suspend;
    } else {
      GC_TERM = temp;
      goto top;
    }
  }

 message_error:
  GC_FAIL("Illegal message to Unix I/O stream");

 gc_request:
  G_MAKE_VAR(newvar);
  GC_KL1_UNIFY(GC_TERM,newvar);
  GC_RETURN_WITH_HOOK(newvar);

 suspend:
  GC_RETURN_WITH_HOOK(reason);
}

GCDEF_GC()
{
  G_STD_DECL;
  GC_OBJ_TYPE *newself;

  GCSET_NEWOBJ_IN_NEWGEN(newself);
  newself->file = GC_SELF->file;
  if (GC_SELF->stream != 0) {
    G_COPY_KL1_TERM_TO_NEWGEN(GC_SELF->stream,newself->stream);
  } else {
    newself->stream = 0;
  }
  GC_RETURN_FROM_GC(newself);
}

GCDEF_PRINT()
{
  G_STD_DECL;
  GC_PRINT("$$FILE I/O$");
  GC_RETURN_FROM_PRINT;
}

#define GCUSE_MY_UNIFY
#define GCUSE_MY_PRINT
#define GCUSE_MY_GC

/* define the method table structure of the merger */
#include <klic/gc_method_table.h>

GCDEF_NEW()
{
  GC_STD_DECL_FOR_NEW;
  GC_OBJ_TYPE *newobj;
  q file, pathname, var;
  struct pointer_object *ptr;

  if (GC_ARGC != 2) GC_ERROR_IN_NEW("Arity mismatch");
  file = GC_ARGV[0];
  GC_DEREF_FOR_NEW(file);
  if (!G_ISGOBJ(file) ||
      (struct data_object_method_table *)G_FUNCTOR_OF(file) !=
      &pointer_g_data_method_table) {
    GC_FAIL("argument not a pointer object");
  }
  pathname = GC_ARGV[1];
  GC_DEREF_FOR_NEW(pathname);

  ptr = (struct pointer_object *)G_FUNCTORP(file);
  GCSET_NEWOBJ_FOR_NEW(newobj,GC_OBJ_SIZE(newobj));
  newobj->file = (FILE *)ptr->pointer;
  newobj->close_on_termination = ( pathname != G_MAKEINT(0) );
  newobj->stream = 0;
  var = GC_MAKE_HOOK_VAR(newobj);
  GC_RETURN_FROM_NEW(var);
}
