/* ---------------------------------------------------------- 
%   (C)1993,1994 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */

#include <math.h>
#include <stdio.h>
#include <klic/basic.h>
#include <klic/gdobject.h>
#include "atom.h"
#include "funct.h"

#ifdef STRINGH
#include <string.h>
#else
#include <strings.h>
#endif

#ifdef USESTRCHR
#define Strchr strchr
#else
#define Strchr index
#endif

#define GD_CLASS_NAME() float
#define GD_OBJ_TYPE struct float_object
#define GD_OBJ_SIZE(obj) (G_SIZE_IN_Q(GD_OBJ_TYPE))

extern struct data_object_method_table
  byte__string_g_data_method_table;

GD_OBJ_TYPE {
  struct data_object_method_table *method_table;
  double value;
};

#include <klic/gd_macro.h>

#define ALIGN() \
if (sizeof(double) != sizeof(long)) { \
  g_allocp = (q*)((unsigned long)g_allocp + \
		  ((unsigned long)g_allocp & ((1<<sizeof(double))-1))); \
}

/* basic method definitions */

GDDEF_GUNIFY()
{
  G_STD_DECL;
  if (GD_SELF->method_table != GD_OTHER->method_table ||
      GD_SELF->value != GD_OTHER->value)
    GD_GUNIFY_FAIL;
  GD_GSUCCEED;
}

GDDEF_UNIFY()
{
  G_STD_DECL;

  if (GD_SELF->method_table != GD_OTHER->method_table ||
      GD_SELF->value != GD_OTHER->value)
    GD_UNIFY_FAIL;
  GD_RETURN;
}

GDDEF_GC()
{
  G_STD_DECL;
  GD_OBJ_TYPE *newself;

  ALIGN();
  GDSET_NEWOBJ_IN_NEWGEN(newself);
  newself->value = GD_SELF->value;
  GD_RETURN_FROM_GC(newself);
}

/* Generic method */

GDDEF_METHOD(print_1)
{
  G_STD_DECL;
  extern q convert_c_string_to_klic_string();
  double value = GD_SELF->value;
  q str;
  char buf[100];
  (void)sprintf(buf, "%1.16g", value);
  if (Strchr(buf, '.') == 0 &&
      strcmp(buf, "Infinity") && strcmp(buf, "-Infinity") &&
      strcmp(buf, "NaN")) {
    char *exponent = Strchr(buf, 'e');
    if (exponent != 0) {
      char save[100];
      (void)strcpy(save, exponent);
      (void)strcpy(exponent, ".0");
      (void)strcpy(exponent+2, save);
    } else {
      (void)strcat(buf, ".0");
    }
  }
  str = convert_c_string_to_klic_string(buf,g_allocp);
  g_allocp = heapp;
  GD_UNIFY_VALUE(GD_ARGV[0], str);
  GD_RETURN;
}

/*  Generic Method Table */
GDDEF_GENERIC()
{
  G_STD_DECL;
  double self, result;
  unsigned long result_index;
  GD_OBJ_TYPE *newobj;
  double (*func)();

  self = GD_SELF->value;
  GD_SWITCH_ON_METHOD {
    GD_METHOD_CASE(print_1);
  default:
    ALIGN();
    GDSET_NEWOBJ(newobj);
    GD_SWITCH_ON_ARITY {
    case 1: {
      result_index = 0;
      GD_SWITCH_ON_METHOD {
	GD_METHOD_CASE_DIRECT(sin_1):
	func = sin; goto apply_1;
	GD_METHOD_CASE_DIRECT(cos_1):
	func = cos; goto apply_1;
	GD_METHOD_CASE_DIRECT(tan_1):
	func = tan; goto apply_1;
	GD_METHOD_CASE_DIRECT(asin_1):
	func = asin; goto apply_1;
	GD_METHOD_CASE_DIRECT(acos_1):
	func = acos; goto apply_1;
	GD_METHOD_CASE_DIRECT(atan_1):
	func = atan; goto apply_1;
	GD_METHOD_CASE_DIRECT(sinh_1):
	func = sinh; goto apply_1;
	GD_METHOD_CASE_DIRECT(cosh_1):
	func = cosh; goto apply_1;
	GD_METHOD_CASE_DIRECT(tanh_1):
	func = tanh; goto apply_1;
	/*
	  GD_METHOD_CASE_DIRECT(asinh_1):
	  func = asinh; goto apply_1;
	  GD_METHOD_CASE_DIRECT(acosh_1):
	  func = acosh; goto apply_1;
	  GD_METHOD_CASE_DIRECT(atanh_1):
	  func = atanh; goto apply_1;
	  */
	GD_METHOD_CASE_DIRECT(exp_1):
	func = exp; goto apply_1;
	GD_METHOD_CASE_DIRECT(log_1):
	func = log; goto apply_1;
	GD_METHOD_CASE_DIRECT(sqrt_1):
	func = sqrt; goto apply_1;
	GD_METHOD_CASE_DIRECT(ceil_1):
	func = ceil; goto apply_1;
	GD_METHOD_CASE_DIRECT(floor_1):
	func = floor; goto apply_1;
	/*
	  GD_METHOD_CASE_DIRECT(round_1):
	  func = rint; goto apply_1;
	  */
	GD_METHOD_CASE_DEFAULT;
      }
    }
    case 2: {
      q another = GD_ARGV[0];
      double another_value;
      GD_DEREF(another);
      result_index = 1;
      if (!isfunctor(another) ||
	  ((GD_OBJ_TYPE*)functorp(another))->method_table !=
	  GD_SELF->method_table) {
	GD_FAIL("Illegal argument in floating point object method.");
      }
      another_value = ((GD_OBJ_TYPE *)functorp(another))->value;
      GD_SWITCH_ON_METHOD {
	GD_METHOD_CASE_DIRECT(add_2):
	result = self + another_value;
	goto apply_2;
	GD_METHOD_CASE_DIRECT(subtract_2):
	result = self - another_value;
	goto apply_2;
	GD_METHOD_CASE_DIRECT(multiply_2):
	result = self * another_value;
	goto apply_2;
	GD_METHOD_CASE_DIRECT(divide_2):
	result = self / another_value;
	goto apply_2;
	GD_METHOD_CASE_DIRECT(pow_2):
	result = pow(self, another_value);
	goto apply_2;
	GD_METHOD_CASE_DEFAULT;
      }
      break;
    }
      GD_METHOD_CASE_DEFAULT;
    }
  }
  GD_RETURN;

 apply_1:
  result = func(self);
 apply_2:
  newobj->value = result;
  GD_UNIFY(GD_ARGV[result_index], makefunctor(newobj));
  GD_RETURN;
}

/* guard generic methods */

GDDEF_GMETHOD(less__than_1)
{
  G_STD_DECL;
  q otherq = GD_ARGV[0];
  GD_OBJ_TYPE *other;
  double self, another;

  if (!G_ISGOBJ(otherq)) GD_GFAIL;
  other = (GD_OBJ_TYPE *)G_FUNCTORP(otherq);
  if (other->method_table != GD_SELF->method_table) GD_GFAIL;
  self = GD_SELF->value;
  another = other->value;
  if (self < another) GD_GSUCCEED;
  GD_GFAIL;
}

GDDEF_GMETHOD(float_0)
{
  G_STD_DECL;
  GD_GSUCCEED;
}

GDDEF_GGENERIC()
{
  G_STD_DECL;
  GD_SWITCH_ON_GMETHOD {
    GD_GMETHOD_CASE(less__than_1);
    GD_GMETHOD_CASE(float_0);
    GD_GMETHOD_CASE_DEFAULT;
  }
}

GDDEF_PRINT()
{
  G_STD_DECL;
  fprintf(g_fp, "%f", GD_SELF->value);
  GD_RETURN_FROM_PRINT;
}

#define GDUSE_MY_GUNIFY
#define GDUSE_MY_UNIFY
#define GDUSE_MY_PRINT
#define GDUSE_MY_GC
#define GDUSE_MY_GENERIC
#define GDUSE_MY_GGENERIC

/* define the method table structure of the vector */

#include <klic/gd_method_table.h>

/*  new_float function */
GDDEF_NEW()
{
  GD_STD_DECL_FOR_NEW;
  q init = GD_ARGV[0];
  GD_OBJ_TYPE *newobj;

  GD_DEREF_FOR_NEW(init);
  ALIGN();
  GDSET_NEWOBJ_FOR_NEW(newobj,G_SIZE_IN_Q(GD_OBJ_TYPE));
  if (G_ISINT(init)) {
    newobj->value = (double)G_INTVAL(init);
  } else if (G_ISGOBJ(init) &&
	     (struct data_object_method_table *)G_FUNCTOR_OF(init)
	     == &byte__string_g_data_method_table) {
    extern unsigned char *generic_string_body();
    double atof();
    newobj->value = atof((char *)generic_string_body(G_FUNCTORP(init)));
  }
  GD_RETURN_FROM_NEW(newobj);
}
