#include <klic/basic.h>
#include <klic/struct.h>
#include <klic/unify.h>
#ifdef USESIG
#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <signal.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdio.h>

#ifndef SIGIO
#define SIGIO SIGPOLL
#endif

extern void add_signal_handler();
extern void register_gc_hook();

static q *asyncio_streams;
static long fd_setsize;
static fd_set asyncfds;

static struct timeval zerotime = { 0, 0 };

#define SelectCheck(fd, fdset, array) \
{ \
  if (FD_ISSET((fd), &(fdset))) { \
    allocp = send_ready_message(allocp, fd, array); \
  } \
}

static q* send_ready_message(allocp, fd, array)
     q* allocp;
     long fd;
     q* array;
{
  if (array[fd] == 0) {
    fprintf(stderr, "Unexpected IO interrupt for fd %d ignored\n", fd);
  } else {
    q newcons = makecons(allocp);
    q newvar = allocp[0] = makeref(&allocp[0]);
    allocp[1] = makeint(fd);
    allocp += 2;
    allocp = do_unify_value(allocp, array[fd], newcons);
    array[fd] = newvar;
  }
  return allocp;
}

static q* asyncio_handler(allocp, sig)
     q* allocp;
     long sig;
{
  declare_globals;
  long fd;
  
  fd_set fdsr, fdsw;
  fdsr = asyncfds;
  fdsw = asyncfds;
  select(fd_setsize, &fdsr, &fdsw, 0, &zerotime);
  for (fd=0; fd<fd_setsize; fd++) {
    SelectCheck(fd, fdsr, asyncio_streams);
    SelectCheck(fd, fdsw, asyncio_streams);
  }
  heapp = allocp;
  return 0;
}

int poll_read_available(fd)
     int fd;
{
  fd_set fds;
  FD_ZERO(&fds);
  FD_SET(fd, &fds);
  return select(fd_setsize, &fds, 0, 0, &zerotime);
}

#define CopyIfNeeded(fd, array) \
{ \
  if ((array)[fd] != 0) { \
    allocp = copy_one_term(&array[fd], allocp, ntop, otop, nsize, osize); \
  } \
}

static q* gc_asyncio_streams(allocp, ntop, otop, nsize, osize)
     q *allocp, *ntop, *otop;
     unsigned long nsize, osize;
{
#ifdef ASYNCIO
  extern q *copy_one_term();
  long fd;
  for (fd=0; fd<fd_setsize; fd++) {
    CopyIfNeeded(fd, asyncio_streams);
  }
#endif
  return allocp;
}

void register_asynchronous_io_stream(fd, stream)
     long fd;
     q stream;
{
#ifdef ASYNCIO
  asyncio_streams[fd] = stream;
  FD_SET(fd, &asyncfds);
#endif
}

void close_asynchronous_io_stream(fd)
     long fd;
{
#ifdef ASYNCIO
  asyncio_streams[fd] = 0;
  FD_CLR(fd, &asyncfds);
#endif
}

void init_asynchronous_io()
{
#ifdef ASYNCIO
  static asyncio_initiated = 0;
  if (!asyncio_initiated) {
    extern char *malloc();
    int k;
    fd_setsize = ulimit(4, 0);
    asyncio_streams = (q*)malloc(sizeof(q)*fd_setsize);
    for (k=0; k<fd_setsize; k++) {
      asyncio_streams[k] = 0;
    }
    FD_ZERO(&asyncfds);
    add_signal_handler(SIGIO, asyncio_handler);
    register_gc_hook(gc_asyncio_streams);
    asyncio_initiated = 1;
  }
#endif
}
#endif
