/* ---------------------------------------------------------- 
%   (C)1993, 1994 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <klic/basic.h>
#include <klic/struct.h>
#include <klic/alloc.h>
#ifdef DEBUGLIB
#include <klic/trace.h>
#endif

extern void *malloc_check();

#define new_prioqrec(pqr)			\
{						\
  struct prioqrec *temp;			\
  while ((temp = prioqrec_free) == 0) {		\
    prioqrec_free = more_prioqrec();		\
  }						\
  prioqrec_free = temp->next;			\
  (pqr) = temp;					\
}

#define free_prioqrec(pqr)			\
{						\
  pqr->next = prioqrec_free;			\
  prioqrec_free = pqr;				\
}

struct prioqrec *prioqrec_free = 0;

struct prioqrec *more_prioqrec()
{
  unsigned long k;
  extern void *calloc();
  struct prioqrec *bulk =
    (struct prioqrec *)
      calloc(PRIOQRECBULK, sizeof(struct prioqrec));
  for (k = PRIOQRECBULK-1; k != 0; k--) {
    bulk[k-1].next = &bulk[k];
  }
  bulk[PRIOQRECBULK-1].next = 0;
  return bulk;
}

static void *queue_empty();
extern void *topsucceed();

Const struct predicate queue_empty_pred = { queue_empty, 0, 0 };
Const struct predicate topsucceed_pred = { topsucceed, 0, 0 };

struct goalrec
  goal_queue_tail = { 0, &queue_empty_pred, { 0 } };

static struct predicate wait_prio_preds[MAXSTDARGS+1];
void *wait_prio_routine();

q *reinitiate_prioq(allocp)
     q *allocp;
{
  declare_globals;
  static struct prioqrec
    *pq,
    tail_sentinel = { 0, -1, 0 };

  new_prioqrec(pq);
  /*
    The tail of the lowest priority level is top level succeed goal.
  */
  pq->next = &tail_sentinel;
  pq->prio = 0;
  allocp[0] = (q)&goal_queue_tail;
  allocp[1] = (q)&topsucceed_pred;
  pq->q = (struct goalrec *)allocp;
  allocp += 2;
  prioq.next = pq;

  return allocp;
}

q *initiate_prioq(allocp)
     q *allocp;
{
  int k;
  /* Prepare for creating goals that wait for priority value */
  for (k=0; k<=MAXSTDARGS; k++) {
    wait_prio_preds[k].func = wait_prio_routine;
    wait_prio_preds[k].pred = k;
    wait_prio_preds[k].arity = k+3;
  }
  return reinitiate_prioq(allocp);
}

struct goalrec *
enqueue_goal(qp, prio, gp, glbl)
     struct goalrec *qp;
     long prio;
     struct goalrec *gp;
     struct global_variables *glbl;
{
  if (prio<0) prio = 0;
  if (current_prio == prio) {
    gp->next = qp;
    qp = gp;
  } else {
#ifdef DEBUGLIB
    extern int trace_flag;
    extern struct enqueue_trace_rec *trace_enqueued_goals;
    if (trace_flag) {
      struct enqueue_trace_rec *tr;
      tr = (struct enqueue_trace_rec *)
	malloc_check(sizeof(struct enqueue_trace_rec));
      tr->next = trace_enqueued_goals;
      tr->g = gp;
      tr->prio = prio;
      trace_enqueued_goals = tr;
    } else {
#endif
      struct prioqrec *pq = &prioq;
      while (pq->next->prio > prio) {
	pq = pq->next;
      }
      if (pq->next->prio == prio) {
	/* there already are some active goals with the same priority */
	pq = pq->next;
	gp->next = pq->q;
	pq->q = gp;
      } else {
	/* there are no active goals with the same priority */
	/* must allocate a new prioqrec entry */
	struct prioqrec *newpq;
	new_prioqrec(newpq);
	newpq->next = pq->next;
	pq->next = newpq;
	newpq->prio = prio;
	newpq->q = gp;
	gp->next = &goal_queue_tail;
      }
      /* interrupt for higher priority goal */
      if (current_prio < prio){
	higher_priority_goal = 1;
	heaplimit = 0;
      }
#ifdef DEBUGLIB
    }
#endif
  }
  return qp;
}

static Volatile
priority_type_error(gp)
     struct goalrec *gp;
{
  fatal("Non-integer priority specified");
}

struct goalrec *
enqueue_after_waiting(qp, prio, gp, allocp, is_relative)
     struct goalrec *qp;
     q prio;
     struct goalrec *gp;
     q *allocp;
     int is_relative;
{
  declare_globals;
  struct goalrec *ng;
  int k;
 again:
  if (isint(prio)) {
    return
      enqueue_goal(qp,
		   (is_relative ? current_prio-intval(prio) : intval(prio)),
		   gp, glbl);
  }
  if (!isref(prio)) priority_type_error(qp);
  {
    q value = derefone(prio);
    if (value != prio && (!isref(value) || derefone(value) != prio)) {
      prio = value;
      goto again;
    }
  }
  heapalloc(ng, gp->pred->arity+(2+3), (struct goalrec *));
  for (k=0; k!=gp->pred->arity; k++) {
    ng->args[k] = gp->args[k];
  }
  ng->args[k] = makeatomic(gp->pred);
  ng->args[k+1] = prio;
  ng->args[k+2] = (is_relative ? makeint(1) : makeint(0));
  ng->pred = &wait_prio_preds[gp->pred->arity];
  suspend_goal(allocp, ng, prio, 1);
  return qp;
}

void *
wait_prio_routine(glbl, qp, allocp, toppred)
  struct global_variables *glbl;
  struct goalrec *qp;
  q *allocp;
  Const struct predicate *toppred;
{
  int arity = toppred->pred;
  q prio = qp->args[arity+1];
  int is_relative = intval(qp->args[arity+2]);

  qp->pred = predp(qp->args[arity]);
  qp = enqueue_after_waiting(qp->next, prio, qp, allocp, is_relative);
  heapp = allocp;
  current_queue = qp;
  return (void *)qp->pred->func;
}

struct goalrec *
get_top_priority_queue()
{
  declare_globals;
  struct goalrec *newqp;
  struct prioqrec *newprioq;

  newqp = prioq.next->q;
  current_prio = prioq.next->prio;
  newprioq = prioq.next->next;
  free_prioqrec(prioq.next);
  prioq.next = newprioq;
  return newqp;
}

void
put_priority_queue(qp, prio)
     struct goalrec *qp;
     long prio;
{
  declare_globals;
  struct prioqrec *pq = &prioq;

  while(pq->next->prio >= prio) {
    pq = pq->next;
  }
  if (pq->next->prio == prio) {
    /* there are some active goals with the same priority */
    pq = pq->next;
    qp->next = pq->q;
    pq->q = qp;
  } else {
    /* there a no goals with the same priority */
    struct prioqrec *newpq;
    new_prioqrec(newpq);
    newpq->next = pq->next;
    pq->next = newpq;
    newpq->prio = prio;
    newpq->q = qp;
  }
}

/*
  queue_empty:

  Dummy module to be called when the queue of the current priority
  becomes empty.  The call is automatic by having a dummy goal
  "goal_queue_tail" as the common tail of queues, instead of NULL.
*/

static void *
queue_empty(glbl, qp, allocp, fg, toppred)
     struct global_variables *glbl;
     struct goalrec *qp;
     struct goalrec *fg;
     q *allocp;
     Const struct predicate *toppred;
{
  qp = get_top_priority_queue();
  heapp = allocp;
  current_queue = qp;
  return (void *)qp->pred->func;
}
