makexref :-
	call_graph([kl1cmp,bb,extern,gb,gen,ins,l,loadup,macro,macro2,
		norm,obj,util,write], Graph),
	invert_graph(Graph, Igraph),
	tell(xref),
	print_graph(Igraph),
	told.

invert_graph([def-_,use-_|Rest], Merged) :-
	invert_all(Rest,All,[]),
	keysort(All,Sorted),
	merge_same(Sorted,Merged).

invert_all([],T,T).
invert_all([X-L|Rest],H,T) :-
	invert_one(L,X,H,T0),
	invert_all(Rest,T0,T).

invert_one([],_,T,T).
invert_one([X|L],Y,[X-Y|T0],T) :- invert_one(L,Y,T0,T).

merge_same([],[]).
merge_same([X-Y|T],[X-Yss|L]) :-
	merge_same(T,T1,X,Ys),
	sort([Y|Ys],Yss),
	merge_same(T1,L).

merge_same([],[],_,[]).
merge_same([X-Y|T0],T,X,[Y|L]) :- !, merge_same(T0,T,X,L).
merge_same(T,T,_,[]).

print_graph([]).
print_graph([X-L|T]) :-
	print_one(X),
	put(0':),
	print_list(L),
	print_graph(T).

print_one(user:X) :- print(X).

print_list([]) :- nl.
print_list([H|T]) :- tab(1), print_one(H), print_list(T).
