#include <string.h>
#include <klic/newatom.h>
#include <klic/basic.h>
#include <klic/struct.h>
#include <klic/primitives.h>
#include <klic/unify.h>
#include <klic/index.h>
#include <klic/atomstuffs.h>

static long hash_name(name)
     char *name;
{
  long value = 0L;
  char c;
  for (value = 0L;
       c = *name++;
       value = 3L*value + c)
    ;
  return value;
}

static void list2name(name,list)
char *name;
q list;
{ int i = 0; q x;

  while (isref(list)) { list = derefone(list); }

  while(list != NILATOM) {
/*   if (i >= 256)  ERROR;  */
    x = car_of(list);
    while (isref(x)) { x = derefone(x); }
    name[i++] = (char)(intval(x));
    list = cdr_of(list);
    while (isref(list)) { list = derefone(list); }
   }
  name[i] = NULL;
}

static void enter_old_atom(i,name)
unsigned int i; char *name;
{
  long index, index0;
  long hashvalue;

  hashvalue = hash_name(name) % (atomhtable.hashtablesize);
  
  if ((index = atomhtable.table[hashvalue]-1) >= 0) {
    while ((strcmp(atomname[index],name))) {
      if ((index0 = nextatom[index]) == -1) {
	nextatom[index] =   i;
	nextatom[i] = -1;
	goto finish;
      } else 
	index = index0;}
  } else {
      atomhtable.table[hashvalue] = i + 1;
      nextatom[i] = -1;
    }
 finish:;
}

static void enter_old_functor(i, a_no, arity)
unsigned int i;
unsigned long a_no, arity;
{
  long index, index0, hashvalue;

  hashvalue = ((long)(a_no - ATOMNUMBERBASE + arity)) % 
                                     functhtable.hashtablesize;
  
  if ((index = functhtable.table[hashvalue]-1) >= 0) {
    while ((functors[index] != a_no) || (arities[index] != arity)) {
      if ((index0 = nextfunctor[index]) == -1) {
	nextfunctor[index] =   i;
	nextfunctor[i] = -1;
	goto finish;
      } else index = index0;
    }} else {
      functhtable.table[hashvalue] = i + 1;
      nextfunctor[i] = -1;
    }
 finish:;
}

static void make_atom_table()
{
  unsigned int i;

  init_atom = DONE;
  
  atomhtable.atomid = numberOfAtoms-1;
  atomhtable.hashtablesize = Hashsize;
  atomhtable.table = (long *) malloc((unsigned)(sizeof(long) * Hashsize));
  namearea = (char *) malloc((unsigned ) Namesize);
  nameareap = namearea;
  if (numberOfAtoms) {
    atomhtable.nametablesize = numberOfAtoms;
    nextatom = (long *) malloc((unsigned )(sizeof(long) * numberOfAtoms));
  } else {
    atomhtable.nametablesize = 1;
    atomname = (char **) malloc(sizeof(char *));
    nextatom = (long *) malloc(sizeof(long));
  }

  for (i = 0; i < Hashsize; i++) { atomhtable.table[i] = 0; }
  for (i = 0; i < atomhtable.nametablesize; i++) { nextatom[i] = -1; }
  for (i = 0; i < numberOfAtoms; i++) {enter_old_atom(i,atomname[i]);}

}

static void make_functor_table()
{ unsigned int i;

  init_functor = DONE;
  
  functhtable.functorid = numberOfFunctors-1;
  functhtable.hashtablesize = Hashsize;
  functhtable.table = (long *) malloc((unsigned)(sizeof(long) * Hashsize));
  if (numberOfFunctors) {
    functhtable.functortablesize = numberOfFunctors;
    nextfunctor = (long *) malloc((unsigned )(sizeof(long)*numberOfFunctors));} else {
      functhtable.functortablesize = 1;
      functors = (unsigned long *)malloc(sizeof(q));
      arities  = (unsigned long *)malloc(sizeof(q));
      nextfunctor = (long *)malloc(sizeof(q));
    }
  for (i = 0; i < Hashsize; i++) { functhtable.table[i] = 0; }
  for (i = 0; i < functhtable.functortablesize; i++) {nextfunctor[i] = -1;}
  for (i = 0; i < numberOfFunctors; i++) 
    { enter_old_functor(i,functors[i],arities[i]); }
}

extern char *generic_string_body();
extern unsigned long generic_string_size();

static unsigned long enter_atom_body(name0, mode)
q name0;
int mode;
{
  long index, index0, namelen, hashvalue;
  char name[256];

  if (name0 == NILATOM) return(AtomError);

  if (mode) {
    list2name(name,name0);
    namelen = strlen((char *)name) + 1;
  } else {
    char *name1;
    q tmp = (q) ((unsigned long)name0 - FUNCTOR);
    name1 = generic_string_body(tmp);
    namelen = generic_string_size(tmp);
    if (namelen >= 256 ) { fatal("atom length is too long");}
    strncpy((char *)name,(char *)name1,namelen);
    name[namelen] = '\0';
    namelen = namelen + 1;
  }

  if (init_atom) make_atom_table();

  hashvalue = ((unsigned long) hash_name(name)) % atomhtable.hashtablesize;

 again:  
  if ((index = (atomhtable.table[hashvalue])-1) >= 0) {
    while ((strcmp((char *)atomname[index],name))) {
      if ((index0 = nextatom[index]) == -1) {
	if (atomhtable.atomid +1 == atomhtable.nametablesize ) goto expand;
	nextatom[index] =  (long)(++(atomhtable.atomid));
	if ((long)(nameareap-namearea) + namelen >= Namesize)
	  {  namearea = (char *) malloc((unsigned ) Namesize);
	     nameareap = namearea; }
        strcpy(nameareap,name);
	atomname[atomhtable.atomid] = nameareap;
        nameareap += namelen;
	nextatom[atomhtable.atomid] = -1;
	return(atomhtable.atomid + ATOMNUMBERBASE);
      } else 
	index = index0;}
    return(index + ATOMNUMBERBASE);
  }
  else {
    if (atomhtable.atomid +1 == atomhtable.nametablesize) goto expand;
    else {
      if ((long)(nameareap-namearea) + namelen >= Namesize)
	{  namearea = (char *) malloc((unsigned ) Namesize);
	   nameareap = namearea; }
      atomhtable.table[hashvalue] = ++(atomhtable.atomid) + 1;
      strcpy(nameareap,name);
      atomname[atomhtable.atomid] = nameareap;
      nameareap += strlen(name)+1;
      nextatom[atomhtable.atomid] = -1;
    }
    return(atomhtable.atomid + ATOMNUMBERBASE);
  }

 expand:
  { char **newatomname; long *newnextatom; int i;
    newatomname = (char **)malloc((atomhtable.nametablesize) * 
                                                sizeof(char *)*2);
    newnextatom = (long *) malloc((atomhtable.nametablesize) * 
                                                sizeof(long)*2);
    for (i = 0; i < atomhtable.nametablesize; i++) {
      newatomname[i] = atomname[i];
      newnextatom[i] = nextatom[i];
    }
    for (i = atomhtable.nametablesize; i < 2*atomhtable.nametablesize; i++) {
      newnextatom[i] = -1;
    }
    atomhtable.nametablesize = 2 *atomhtable.nametablesize;
    atomname = newatomname;
    nextatom = newnextatom;
  }
    goto again;
}

unsigned long intern(name0)
q name0;
{ return(enter_atom_body(name0,1)); }

unsigned long enter_atom_string(name0)
q name0;
{ return(enter_atom_body(name0,0)); }

unsigned long enter_functor(a_no,arity)
unsigned long a_no, arity;
{
  long index, index0, hashvalue;

  if (init_functor) make_functor_table();

  hashvalue = ((long)(a_no - ATOMNUMBERBASE + arity))  %
                                       functhtable.hashtablesize;

 again:  
  if ((index = functhtable.table[hashvalue]-1)>= 0) {
    while ((functors[index] != a_no) || (arities[index] != arity)) {
      if ((index0 = nextfunctor[index]) == -1) {
	if (functhtable.functorid +1 == functhtable.functortablesize ) goto expand;
	nextfunctor[index] =   (long) (++(functhtable.functorid));
	functors[functhtable.functorid] = a_no;
        arities[functhtable.functorid] = arity;
	nextfunctor[functhtable.functorid] = -1;
	return(functhtable.functorid + FUNCTORNUMBERBASE);
      } else index = index0;}
    return(index + FUNCTORNUMBERBASE);
  }
  else {
    if (functhtable.functorid +1 == functhtable.functortablesize) goto expand;
    else {
      functhtable.table[hashvalue] = ++(functhtable.functorid) + 1;
      functors[functhtable.functorid] = a_no;
      arities[functhtable.functorid] = arity;
      nextfunctor[functhtable.functorid] = -1;
    }
    return(functhtable.functorid + FUNCTORNUMBERBASE);
  }

 expand:
  { unsigned long *newfunctors;
    unsigned long *newarities;
    unsigned long *newnextfunctor;
    int i;
    newfunctors =
      (unsigned long *)
	malloc((functhtable.functortablesize) * sizeof(unsigned long)*2);
    newarities =
      (unsigned long *)
	malloc((functhtable.functortablesize) * sizeof(unsigned long)*2);
    newnextfunctor =
      (unsigned long *)
	malloc((functhtable.functortablesize) * sizeof(unsigned long)*2);
    for (i = 0; i < functhtable.functortablesize; i++) {
      newfunctors[i] = functors[i];
      newarities[i] = arities[i];
      newnextfunctor[i] = nextfunctor[i];
    }
    for (i = functhtable.functortablesize;
                i < 2*functhtable.functortablesize; i++) {
      newnextfunctor[i] = -1;
    }
    functhtable.functortablesize = 2 *functhtable.functortablesize;
    functors = newfunctors;
    arities  = newarities;
    nextfunctor = (long *)newnextfunctor;
  }
    goto again;
}

unsigned long new_atom()
{ atomname[atomhtable.atomid] = 0;
  return((atomhtable.atomid)++ + ATOMNUMBERBASE);}
