/* ---------------------------------------------------------- 
%   (C)1993 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <stdio.h>
#include <klic/basic.h>
#include <klic/struct.h>
#include <klic/alloc.h>
#include <klic/control.h>
#include <klic/susp.h>

static Volatile
do_fail(goal, reasonp)
     struct goalrec *goal;
     q *reasonp;
{
#ifdef TRACE
  trace_failure(goal);
#endif
  fatal("Reduction Failure");
}

suspend_goal(allocp, goal, reason)
     q *allocp;
     struct goalrec *goal;
     q reason;
{
  declare_globals;
  goal->next = (struct goalrec *)makeint(current_prio);
#ifdef CSUSPS
  suspensions++;
#endif
  if (derefone(reason) == reason) {
    /* no goals suspended yet on this variable */
    struct susprec *susp;
    q newvar;
    allocnewsusp(newvar,susp);
    susp->first_hook.u.g = goal;
    derefone(reason) = newvar;
  } else {
    /* some goals already has suspended */
    struct susprec *susp;
    struct hook *newhook;
    susp = suspp(derefone(reason));
    allochook(&susp->first_hook,newhook);
    newhook->u.g = goal;
  }
}

q *interrupt_goal(allocp, pred, reasonp)
     q *allocp;
     struct predicate *pred;
     q *reasonp;
{
  declare_globals;
  struct goalrec *goal = (struct goalrec *)allocp;
  allocp += pred->arity + 2;
  goal->pred = pred;

  if (reasonp == 0) {
    /* Interrupt by some external event, such as: */
    /*   - A higher priority goal got ready for execution */
    /*   - Garbage collection required */
    /* In such cases, the interrupted goal is pushed down to the queue. */
    struct goalrec *rsmg = resumed_goals;
    if (rsmg == 0) {
      goal->next = goal;
    } else {
      goal->next = rsmg->next;
      rsmg->next = goal;
    }
    resumed_goals = goal;
    return allocp;
  } else if (reasonp == reasons) {
    do_fail(goal, reasons[0]);
  } else {
    /* goal suspension */
#ifdef TRACE
    {
      extern int trace_flag;
      struct goalrec *trace_susp();
      if (trace_flag && (reasonp > reasons)) {
	goal = trace_susp(goal, reasonp);
      }
    }
#endif

    goal->next = (struct goalrec *)makeint(current_prio);
#ifdef CSUSPS
    suspensions++;
#endif
    /* Dereference is not needed for the first suspension reason */
    {
      q tmp, tmp1;
      tmp = *(--reasonp);
      tmp1 = derefone(tmp);
      while (1) {
	if (tmp == tmp1) {
	  /* no goals suspended yet on this variable */
	  struct susprec *susp;
	  q newvar;
	  makenewsusp(newvar,susp,allocp);
	  susp->first_hook.u.g = goal;
	  derefone(tmp) = newvar;
	} else {
	  /* some goals already has suspended */
	  struct susprec *susp = suspp(tmp1);
	  if (susp->first_hook.next->u.g == goal) {
	    /* If the second hook is for the same goal, do nothing.
	       This includes the case where there's only one hook,
	       because of the loop structure of the hook chain. */
	  } else {
	    struct hook *newhook;
	    addhook(&susp->first_hook,newhook,allocp);
	    newhook->u.g = goal;
	  }
	}
	if (reasonp == reasons) break;
	/* Dereference IS needed for the second reason and on, */
	/* as suspension inserts a new variable cell */
	for (tmp = *(--reasonp), tmp1 = derefone(tmp);
	     derefone(tmp1) != tmp;
	     tmp = tmp1, tmp1 = derefone(tmp))
	  ;
      }
    }
    return allocp;
  }
}
