/* ---------------------------------------------------------- 
%   (C)1994 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */

/******************************
  Suspension Structures
*******************************/

/*
  Variables _with_ suspended goals are represented as
    a two-word pointer loop,
    the second word being the suspension record structure.
*/

struct hook {
  struct hook *next;		/* next suspension structure */
  union goal_or_consumer {
    long l;			/* long integer for tag manipulation */
    struct goalrec *g;		/* pointer to a goal record */
    struct consumer_object *o;	/* pointer to a consumer object */
  } u;
};

#define CONSUMER_HOOK_TAG 1

#define is_consumer_hook(u) \
  ((u.l&CONSUMER_HOOK_TAG) == 1)

#define tag_consumer_hook(obj) \
  ((struct consumer_object *)((long)(obj)+CONSUMER_HOOK_TAG))

#define untag_consumer_hook(obj) \
  ((struct consumer_object *)((long)(obj)-CONSUMER_HOOK_TAG))

struct susprec {
  q backpt;
  struct hook first_hook;
};

#define suspp(x)	((struct susprec *)((unsigned long)(x) - VARREF))

#define allocnewsusp(var,srec)						\
{									\
  q *temp;								\
  heapalloc(temp, (sizeof(struct susprec))/sizeof(q)+1, (q *));		\
  initnewsusp(temp,var,srec);						\
}

#define makenewsusp(var,srec,allocp)					\
{									\
  initnewsusp(allocp,var,srec);						\
  allocp += sizeof(struct susprec)/sizeof(q)+1;				\
}

#define initnewsusp(temp,var,srec)					\
{									\
  var = makeref(temp);							\
  srec = (struct susprec *) (temp+1);					\
  derefone(var) = (q)srec;						\
  srec->backpt = var;							\
  srec->first_hook.next = &srec->first_hook;				\
}

#define allochook(oldhook,newhook)					\
{									\
  heapalloc(newhook, sizeof(struct hook)/sizeof(q), (struct hook *));	\
  initnewhook(oldhook,newhook);						\
}

#define addhook(oldhook,newhook,allocp)					\
{									\
  newhook = (struct hook *) allocp;					\
  initnewhook(oldhook,newhook);						\
  allocp += sizeof(struct hook)/sizeof(q);				\
}

#define initnewhook(oldhook,newhook)					\
{									\
  newhook->next= (oldhook)->next;					\
  (oldhook)->next = newhook;						\
}
