#define GENERIC_SUCCEEDED (q)0
#define GENERIC_FAILED    (q)1
#define GENERIC_GCREQUEST (q)2

/*
  Data Object
*/

struct data_object {
  struct data_object_method_table *method_table;
};

struct data_object_method_table {
  q (*passive_unify)( /* struct data_object *one,
			 struct data_object *another */ );
  q *(*active_unify)( /* struct data_object *one,
              with method_result      struct data_object *another,
                                      q * allocp */ );
  long (*print)( /* struct iimutable_object * obj,
		    FILE *out_stream,
		    unsigned long depth,
		    unsigned long length */ );
  q *(*gc)( /* struct data_object *obj, q *allocp , q **sp */ );
  long (*regist)( /* struct data_object *obj */ );
  long (*deallocate)( /* struct data_object *obj */ );
  q *(*close)( /* struct data_object *obj, */ );
  q *(*body_generic)( /* struct data_object *obj,
				      q method_functor,
				      q *argv,
				      q *allocp */ );
  q (*g_generic)( /* struct data_object *obj,
		     q method_functor,
		     q *args */ );
};

#define data_objectp(obj) \
     ((struct data_object *)(((unsigned long)(obj)) - FUNCTOR))


/*
  Consumer Object
*/

struct consumer_object {
  struct consumer_object_method_table *method_table;
};

struct consumer_object_method_table {
  q *(*active_unify)(/* struct consumer_object *self,
		with method_result   q other,
				     q *allocp */ );
  long (*print)(/* struct consumer_object *obj,
		  FILE *out_stream,
		  unsigned long max_depth,
		  unsigned long max_length */);
  q *(*gc)(/* struct consumer_object *obj, q *allocp, q **sp */);
  long (*regist)(/* struct consumer_object *obj */ );
  long (*deallocate)( /* struct consumer_object *obj */ );
  q *(*close)( /* struct consumer_object *obj */ );
};
