#include <klic/gdobject.h>

struct termp_object {
  struct data_object_method_table *method_table;
  unsigned long nterm;
  q terms[1];
};

#define GD_CLASS_NAME() termp
#define GD_OBJ_TYPE struct termp_object
#define GD_OBJ_SIZE(obj) (G_SIZE_IN_Q(GD_OBJ_TYPE)+obj->nterm-1)

#include <klic/gd_macro.h>

GDDEF_GUNIFY()
{
  G_STD_DECL;

  if (GD_SELF->method_table != GD_OTHER->method_table) GD_GUNIFY_FAIL;
  if (GD_SELF->terms != GD_OTHER->terms) GD_GUNIFY_FAIL;
  if (GD_SELF->nterm != GD_OTHER->nterm) GD_GUNIFY_FAIL;
  GD_GSUCCEED;
}

GDDEF_UNIFY()
{
  G_STD_DECL;

  if (GD_SELF->method_table != GD_OTHER->method_table) GD_UNIFY_FAIL;
  if (GD_SELF->terms != GD_OTHER->terms) GD_UNIFY_FAIL;
  if (GD_SELF->nterm != GD_OTHER->nterm) GD_UNIFY_FAIL;
  GD_RETURN;
}

GDDEF_GC()
{
  G_STD_DECL;
  unsigned long size = GD_SELF->nterm;
  GD_OBJ_TYPE *newself;
  unsigned long i;

  GDSET_NEWOBJ_IN_NEWGEN(newself);
  newself->nterm = size;
  for (i=0; i < size; i++) {
    G_COPY_KL1_TERM_TO_NEWGEN(GD_SELF->terms[i],newself->terms[i]);
  }
  GD_RETURN_FROM_GC(newself);
}

#define GDUSE_STD_PRINT
#define GDUSE_STD_GENERIC
#define GDUSE_STD_GGENERIC
#define GDUSE_STD_REGIST
#define GDUSE_STD_DEALLOCATE
#define GDUSE_STD_CLOSE

#include <klic/gd_method_table.h>

GDDEF_NEW()
{
  GD_STD_DECL_FOR_NEW;
  unsigned long size = GD_ARGC;
  GD_OBJ_TYPE *newobj;
  int i;

  G_HEAPALLOC(newobj,G_SIZE_IN_Q(GD_OBJ_TYPE)+size-1,(GD_OBJ_TYPE *));
  newobj->method_table = &GD_method_table;
  newobj->nterm = size;
  for (i=0; i<size; i++) {
    newobj->terms[i] = GD_ARGV[i];
  }
  GD_RETURN_FROM_NEW(newobj);
}

q gd_new_termp(argc,argv,g_allocp)
     unsigned long argc;
     q argv[];
     q *g_allocp;
{
 return termp_g_new(argc,argv,g_allocp);
}
