#include <stdio.h>
#include <klic/gdobject.h>
#include "atom.h"
#include "funct.h"

struct string_object {
  struct data_object_method_table *method_table;
  unsigned long size;
  unsigned long esize;
  unsigned char body[1];
};

#define GD_CLASS_NAME() string
#define GD_OBJ_TYPE struct string_object
#define GD_OBJ_SIZE(obj) \
   ((sizeof(GD_OBJ_TYPE)-1+(obj->size)+sizeof(q)-1)/sizeof(q))

#include <klic/gd_macro.h>

/* basic method definitions */

GDDEF_GUNIFY()
{
  G_STD_DECL;
  if (GD_SELF->method_table != GD_OTHER->method_table) GD_GUNIFY_FAIL;
  if (GD_SELF->size != GD_OTHER->size)  GD_GUNIFY_FAIL;
  if (GD_SELF->esize != GD_OTHER->esize)  GD_GUNIFY_FAIL;
  {
    long i, size = GD_SELF->size;
    q retval;

    for(i=0; i<size; i++){
      if (GD_SELF->body[i] != GD_OTHER->body[i]) GD_GUNIFY_FAIL;
    }
    GD_GSUCCEED;
  }
}


GDDEF_UNIFY()
{
  G_STD_DECL;

  if (GD_SELF->method_table != GD_OTHER->method_table)
    GD_UNIFY_FAIL;
  if (GD_SELF->size != GD_OTHER->size)
    GD_UNIFY_FAIL;
  if (GD_SELF->esize != GD_OTHER->esize)
    GD_UNIFY_FAIL;
  {
    long i, size = GD_SELF->size;
    
    for(i=0; i<size; ++i){
      if (GD_SELF->body[i] != GD_OTHER->body[i]) 
	GD_UNIFY_FAIL;
    }
    GD_RETURN;
  }
}

GDDEF_GC()
{
  G_STD_DECL;
  long csize = (((GD_SELF->size)*sizeof(q)+sizeof(q)-1)/sizeof(q))*sizeof(q);
  GD_OBJ_TYPE *newself;
  int i;

  GDSET_NEWOBJ_IN_NEWGEN(newself);
  newself->size = GD_SELF->size;
  newself->esize = GD_SELF->esize;
  for (i = 0; i < csize; i++) {
    newself->body[i] = GD_SELF->body[i];
  }
  GD_RETURN_FROM_GC(newself);
}

/* Generic method */

GDDEF_METHOD(string_2)
{
  G_STD_DECL;
  long position;
  GD_UNIFY( GD_ARGV[0],G_MAKEINT(GD_SELF->size));
  GD_UNIFY( GD_ARGV[1],G_MAKEINT(GD_SELF->esize));
  GD_RETURN;
}

GDDEF_METHOD(element_2)
{
  G_STD_DECL;
  long position;
  GDSET_INTARG_WITHIN_RANGE(position,GD_ARGV[0],0,GD_SELF->size);
  GD_UNIFY( GD_ARGV[1],G_MAKEINT((unsigned long)(GD_SELF->body[position])));
  GD_RETURN;
}

GDDEF_METHOD(set__element_3)
{
  G_STD_DECL;
  long position, newelement;
  int i;

  GDSET_INTARG_WITHIN_RANGE(position,GD_ARGV[0],0,GD_SELF->size);
  GDSET_INTARG(newelement,GD_ARGV[1]);
  if (newelement < 0) GD_FAIL("Out of bounds in string:set_element");

/*  don't checked the upper bound of GD_ARGV[1] yet*/
  {
    GD_OBJ_TYPE *newstrg;
    long csize = (((GD_SELF->size)+sizeof(q)-1)/sizeof(q))*sizeof(q);
    GDSET_NEWOBJ(newstrg);
    newstrg->size = GD_SELF->size;
    newstrg->esize = GD_SELF->esize;
    for (i=0; i < csize; i++) {
      newstrg->body[i] = GD_SELF->body[i];
    }
    newstrg->body[position] = (unsigned char) newelement;
    GD_UNIFY(GD_ARGV[2],GD_OBJ(newstrg));
  }
  GD_RETURN;
}

GDDEF_METHOD(search__character_4)
{
  G_STD_DECL;
  unsigned long start, end, code;
  int i;
  GDSET_INTARG_WITHIN_RANGE(start,GD_ARGV[0],0,GD_SELF->size);
  GDSET_INTARG_WITHIN_RANGE(end,GD_ARGV[1],0,GD_SELF->size);
  GDSET_INTARG_WITHIN_RANGE(code,GD_ARGV[2],0,256);
  if (start <= end) {
    for (i=start; i<=end; i++) {
      if (((unsigned long) GD_SELF->body[i]) == code) goto done;
    }
  } else {
    for (i=start; i>=end; i--) {
      if (((unsigned long) GD_SELF->body[i]) == code) goto done;
    }
  }
  GD_UNIFY(GD_ARGV[3],G_MAKEINT(-1L));
  GD_RETURN;

  done:
    GD_UNIFY(GD_ARGV[3],G_MAKEINT((unsigned long) i));
  GD_RETURN;
}


/*  Generic Method Table */
GDDEF_GENERIC()
{
  G_STD_DECL;

  GD_SWITCH_ON_METHOD{
    GD_METHOD_CASE(string_2);
    GD_METHOD_CASE(element_2);
    GD_METHOD_CASE(set__element_3);
    GD_METHOD_CASE(search__character_4);
    GD_METHOD_CASE_DEFAULT;
  }
  GD_RETURN;
}

/* guard generic methods */

GDDEF_GMETHOD(element_2)
{
  G_STD_DECL;
  unsigned long position;

  GDSET_GINTARG_WITHIN_RANGE(position,GD_ARGV[0],0,GD_SELF->size);
  GD_ARGV[1] = G_MAKEINT((long)(GD_SELF->body[position]));
  GD_GSUCCEED;
}

GDDEF_GMETHOD(string_2)
{
  G_STD_DECL;
  unsigned long position;
  GD_ARGV[0] = G_MAKEINT(GD_SELF->size);
  GD_ARGV[1] = G_MAKEINT(GD_SELF->esize);
  GD_GSUCCEED;
}

GDDEF_GMETHOD(string__less__than_2)
{
  G_STD_DECL;
  unsigned long position;
  GD_OBJ_TYPE *other = (GD_OBJ_TYPE *) GD_ARGV[0];

  if (GD_SELF->size < other->size) GD_GSUCCEED;
  if (GD_SELF->size > other->size) GD_GFAIL;
  { int i;
    for (i = 0; i < GD_SELF->size; i++) {
      if (((unsigned char) GD_SELF->body[i]) <
	            ((unsigned char) other->body[i])) GD_GSUCCEED;
      if (((unsigned char) GD_SELF->body[i]) >
	            ((unsigned char) other->body[i])) GD_GFAIL;
    }
    GD_GFAIL;
  }
}

GDDEF_GMETHOD(string__not__less__than_2)
{
  G_STD_DECL;
  unsigned long position;
  GD_OBJ_TYPE *other = (GD_OBJ_TYPE *) GD_ARGV[0];

  if (GD_SELF->size > other->size) GD_GSUCCEED;
  if (GD_SELF->size < other->size) GD_GFAIL;
  { int i;
    for (i = 0; i < GD_SELF->size; i++) {
      if (((unsigned char) GD_SELF->body[i]) >
	            ((unsigned char) other->body[i])) GD_GSUCCEED;
      if (((unsigned char) GD_SELF->body[i]) <
	            ((unsigned char) other->body[i])) GD_GFAIL;
    }
    GD_GSUCCEED;
  }
}

GDDEF_GMETHOD(estring_3)
{
  G_STD_DECL;
  if (G_INTVAL(GD_ARGV[0])!= GD_SELF->size) GD_GFAIL;
  if (G_INTVAL(GD_ARGV[1])!= GD_SELF->esize) GD_GFAIL;
  { int i;
    q   tmp;
    tmp = GD_ARGV[2];
    for(i=0; i < GD_SELF->size; i++, tmp = G_CDR_OF(tmp)) {
      if(G_INTVAL(G_CAR_OF(tmp))!= (unsigned long)GD_SELF->body[i]) GD_GFAIL;
    }
  }
  GD_GSUCCEED;
}

GDDEF_GGENERIC()
{
  G_STD_DECL;

  GD_SWITCH_ON_GMETHOD {
    GD_GMETHOD_CASE(element_2);
    GD_GMETHOD_CASE(string_2);
    GD_GMETHOD_CASE(string__less__than_2);
    GD_GMETHOD_CASE(string__not__less__than_2);
    GD_GMETHOD_CASE(estring_3);
    GD_GMETHOD_CASE_DEFAULT;
  }
}

GDDEF_PRINT()
{
  G_STD_DECL;
  long size = GD_SELF->size;
  int i;
  GD_PUTC('"');
  for (i = 0; i < size; i++) { GD_PUTC(GD_SELF->body[i]); }
  GD_PUTC('"');
  GD_RETURN_FROM_PRINT;
}

#define GDUSE_STD_REGIST
#define GDUSE_STD_DEALLOCATE
#define GDUSE_STD_CLOSE

/* define the method table structure of the vector */
#include <klic/gd_method_table.h>

/*  new_vector function */
GDDEF_NEW()
{
  GD_STD_DECL_FOR_NEW;
  long size, esize;
  q argv0;
  char *name0;

  GD_DEREF_FOR_NEW(GD_ARGV[0]);
  argv0 = GD_ARGV[0];
  if (G_ISINT(argv0)) {
    size = G_INTVAL(argv0);
  } else if (G_ISSYM(argv0)) {
    if (argv0 == NILATOM) GD_FAIL("parameter error");
    name0 = atomname[G_SYMVAL(argv0)-ATOMNUMBERBASE];
    size = strlen(name0);
  } else GD_FAIL("parameter error");

  GDSET_INTARG_FOR_NEW(esize,GD_ARGV[1]);
  if (size < 0)  GD_FAIL("2nd argument is out of range in new_string.");
  if (esize != 8)  GD_FAIL("3rd argument is out of range in new_string.");
  {
    GD_OBJ_TYPE *newstrg;
    long vsize = sizeof(GD_OBJ_TYPE) + (size-1);
    long rsize = (vsize+sizeof(q)-1)/sizeof(q);

    GDSET_NEWOBJ_FOR_NEW(newstrg,rsize);
    newstrg->size = size;
    newstrg->esize = esize;
    { int i;
      if (GD_ARGC == 2 ) {
	if (G_ISINT(argv0)) {
	  for(i=0; i<size+(rsize*sizeof(q)-vsize); i++){
	    newstrg->body[i] = (unsigned char) 0;
	  }
	} else {
	  for(i=0; i<size; i++) {
	    newstrg->body[i] = name0[i];
	  }
	  for(i=size; i<size+(rsize*sizeof(q)-vsize); i++){
	    newstrg->body[i] = (unsigned char) 0;
	  }
	}
      } else {
	q tmp = GD_ARGV[2];
        for(i=0; i<size; i++, tmp = G_CDR_OF(tmp)){
          newstrg->body[i] = (unsigned char)(G_INTVAL(G_CAR_OF(tmp)));
        }
        for(i=size; i<size+(rsize*sizeof(q)-vsize); i++){
          newstrg->body[i] = (unsigned char) 0;
        }
      }
    }
    GD_RETURN_FROM_NEW(newstrg);
  }
}


unsigned char *generic_string_body(str)
GD_OBJ_TYPE *str;
{
  return (str->body);
}

unsigned long generic_string_size(str)
GD_OBJ_TYPE *str;
{
  return (str->size);
}

