/* ---------------------------------------------------------- 
%   (C)1993 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <klic/basic.h>
#include <klic/struct.h>
#include <klic/primitives.h>

extern void *malloc();
void inithooks();

void initheap()
{
  struct global_variables *glbl = &globals;
  unsigned long hsize;

  if(heapsize > 0  && incrementsize > 0) {
    hsize = (heapsize + incrementsize) * sizeof(q) * 2;
  } else {
    char buf[255];
    sprintf(buf,
	    "Illegal memory size specification: heap = %d, incremental = %d",
	    heapsize, incrementsize);
    fatal(buf);
  }
  if(!(heaptop = (q *)malloc(hsize))) fatal("Memory shortage\n");
  heapp = heaptop;
  heaplimit = real_heaplimit = heapp + heapsize;
  heapend = heapbottom = heaplimit+incrementsize;
  totalheapsize = hsize;
  halfheapsize = hsize / 2;
}

void initalloc()
{
  struct global_variables *glbl = &globals;
  initheap();
/* and the other special allocation stuffs */
  inithooks();
}

/*
  stuffs for suspension
*/

#define makelistofhooks(p, max, size) {\
  int i; \
  int rsize = size/sizeof(q); \
  q *ptr=(q*)p; \
  for(i=0; i<max-2; ++i){ \
    *ptr = (q)(ptr+rsize); \
    ptr += rsize; \
  } \
  *(long *)ptr = 0; \
}
				       
void
inithooks()
{
  struct shook *s;
  struct mhook *m;
  s = more_shook_record();
  m = more_mhook_record();
  shookreclist = s;
  mhookreclist = m;
}

struct shook *
more_shook_record(){
  struct shook *s;
  if(s=(struct shook *)malloc(MAXSUSPRECORD *
				sizeof(struct shook))){
    makelistofhooks(s, MAXSUSPRECORD, sizeof(struct shook));
    return(s);
  }else{
    fatal("Can't allocate suspension record");
    return(0);
  }
}

struct mhook *
more_mhook_record(){
  struct mhook *m;
  if(m=(struct mhook *)malloc(MAXMHOOKRECORD *
			      sizeof(struct mhook))){
    makelistofhooks(m, MAXMHOOKRECORD, sizeof(struct mhook));
    return(m);
  }else{
    fatal("Can't allocate single hook record");
  }
}
