extern q eq_terms_body();

#define GD_rappend(pref) G_rappend0(GD_CLASS_NAME(),pref)
#define GD_guard(fa) G_guard0(GD_CLASS_NAME(),fa)
#define GD_body(fa) G_body0(GD_CLASS_NAME(),fa)

#define GD_OBJ(x) G_MAKEFUNCTOR(x)

#ifdef __STDC__
#define GD_method_table1(class) class##_data_method_table
#else
#define GD_method_table1(class) class/**/_data_method_table
#endif

#define GD_method_table0(class)  GD_method_table1(class)
#define GD_method_table GD_method_table0(GD_CLASS_NAME())

/* temporary */
#define GD_UNIFY_FAIL GD_FAIL("unification failure in GD_CLASS_NAME()")
#define GD_FAIL(errmsg)  fatal(errmsg)
#define GD_RETURN return(g_qp) 
#define GD_GCREQUEST GENERIC_GCREQUEST

#define GD_GSUCCESS (long)GENERIC_SUCCEEDED
#define GD_GFAILURE (long)GENERIC_FAILED

#define GD_GRETURN(x) return((q) x)

#define GD_GUNIFY_FAIL GD_GFAIL
#define GD_GFAIL return((q) GD_GFAILURE)
#define GD_GSUCCEED return((q) GD_GSUCCESS)

/**************************************************/
#define GD_ALLOC_AREA(new,type,size) \
{ \
  q res; \
  G_HEAPALLOC_WITH_CHECK(new,size,type,g_allocp,res); \
  if(GD_GCREQUEST == res){ \
    struct goalrec *goal; \
    GD_MAKE_GENERIC_GOAL(&goal,new,g_method_functor,GD_ARGV,g_allocp); \
    G_PUSH_GOAL(goal); \
    GD_RETURN; \
  } \
}

/***************************************************************************/

#define GDSET_NEWOBJ_FOR_NEW(newgobj,size) \
  { \
    q res; \
    G_HEAPALLOC_WITH_CHECK((newgobj),(size),(GD_OBJ_TYPE *),g_allocp,res); \
     if(GENERIC_GCREQUEST == res){ \
     q var; \
     struct goalrec *goal; \
     G_MAKE_THE_NEW_GOAL(&var,&goal,g_myself,GD_ARGC,GD_ARGV,g_allocp); \
     G_PUSH_GOAL_TO_SPECIAL_QUEUE(goal); \
     return(var); \
   } \
  newgobj->method_table = &GD_method_table; \
 }

#define GDSET_NEWOBJ(newgobj) \
  { \
    GD_ALLOC_AREA((newgobj),(GD_OBJ_TYPE *),GD_OBJ_SIZE(GD_SELF)); \
    newgobj->method_table = GD_SELF->method_table; \
  }

#define GDSET_NEWOBJ_IN_NEWGEN(newobj) \
  { \
    unsigned long size = GD_OBJ_SIZE(GD_SELF); \
    if((g_allocp+size) > heaplimit) fatal("not enough space collected"); \
    newobj = (GD_OBJ_TYPE *) g_allocp; \
    newobj->method_table = GD_SELF->method_table; \
    g_allocp += size; \
  }

/***************************************************************************/
#define GD_GDEREF(x) \
{ \
  while (1) { \
    if (!isstruct(x)) { \
      if (atomicnotref(x)) { \
	break; \
      } else { \
	q temp0 = derefone(x); \
	if(isref(temp0) && (x) == derefone(temp0)) { \
          return(x); \
	} else { \
	  (x) = temp0; \
	} \
      } \
    } else { \
      break; \
    } \
  } \
}

#define GD_DEREF_AND_HOOK(obj,method_functor,argv) \
{ \
  while (1) { \
    if (!isstruct(obj)) { \
      if (atomicnotref(obj)) { \
	break; \
      } else { \
	q temp0 = derefone(obj); \
	if(isref(temp0) && (obj) == derefone(temp0)) { \
          struct goalrec *goal; \
          GD_MAKE_GENERIC_GOAL(&goal,(obj),method_functor,argv,g_allocp); \
          G_SUSPEND((obj),goal); \
          GD_RETURN; \
	} else { \
	  (obj) = temp0; \
	} \
      } \
    } else { \
      break; \
    } \
  } \
}

#define GD_DEREF(x) \
{ \
  while (1) { \
    if (!isstruct(x)) { \
      if (atomicnotref(x)) { \
	break; \
      } else { \
	q temp0 = derefone(x); \
	if(isref(temp0) && (x) == derefone(temp0)) { \
          struct goalrec *goal; \
          GD_MAKE_GENERIC_GOAL(&goal,makefunctor(GD_SELF), \
                        g_method_functor,GD_ARGV,g_allocp); \
          G_SUSPEND((x),goal); \
          GD_RETURN; \
	} else { \
	  (x) = temp0; \
	} \
      } \
    } else { \
      break; \
    } \
  } \
}



#define GD_DEREF_FOR_NEW(x) \
{ \
  while (1) { \
    if (!isstruct(x)) { \
      if (atomicnotref(x)) { \
	break; \
      } else { \
	q temp0 = derefone(x); \
	if(isref(temp0) && (x) == derefone(temp0)) { \
          q var; \
          struct goalrec *goal; \
       	  G_MAKE_THE_NEW_GOAL(&var,&goal,g_myself,GD_ARGC,GD_ARGV,g_allocp); \
          G_SUSPEND((x),goal); \
          return(var); \
	} else { \
	  (x) = temp0; \
	} \
      } \
    } else { \
      break; \
    } \
  } \
}


/**************************************************************************/
#define GDDEF_NEW() \
  q \
  GD_rappend(new) (GD_ARGC,GD_ARGV,g_allocp) \
    long GD_ARGC; \
    q GD_ARGV[]; \
    q *g_allocp;

#define GD_RETURN_FROM_NEW(x) return(makefunctor(x));

#define GD_STD_DECL_FOR_NEW \
  G_STD_DECL; \
  GDset_myself_for_new

#define GDset_myself_for_new \
  q (*g_myself)() = GD_rappend(new)

/**************************************************************************/
#define GD_GUNIFY(x,y) eq_terms_body(x,y)

#define GD_UNIFY(x,y)  g_qp = (struct goalrec *)do_unify(g_qp,x,y,g_allocp)

/****************************************************/
#define GD_SWITCH_ON_METHOD switch(g_method_functor)

#define GD_METHOD_CASE(fa) \
  case (long) G_functor(fa): \
  g_qp = (struct goalrec *) GD_body(fa) (GD_SELF,g_method_functor,GD_ARGV,g_qp,g_allocp); \
  break

#define GD_METHOD_CASE_DEFAULT \
  default: fatal("undefined method")

#define GDDEF_METHOD(fa) \
  static \
  struct goalrec * \
  GD_body(fa) (GD_SELF,g_method_functor,GD_ARGV,g_qp,g_allocp) \
    GD_OBJ_TYPE * GD_SELF; \
    long g_method_functor; \
    q GD_ARGV[]; \
    struct goalrec *g_qp; \
    q *g_allocp;

/**********************************************************************/
#define GDDEF_GUNIFY() \
static \
  q \
  GD_rappend(passive_unify) (GD_SELF, GD_OTHER) \
    GD_OBJ_TYPE * GD_SELF; \
    GD_OBJ_TYPE * GD_OTHER;

#define GDDEF_UNIFY() \
  static \
  struct goalrec *\
  GD_rappend(active_unify) (GD_SELF,GD_OTHER,g_qp,g_allocp) \
    GD_OBJ_TYPE * GD_SELF; \
    GD_OBJ_TYPE * GD_OTHER; \
    struct goalrec *g_qp; \
    q *g_allocp;

#ifdef  __STDC__
#define GD_PRINT(x) fprintf(g_fp,##x##)
#else
#define GD_PRINT(x) fprintf(g_fp,/**/x/**/)
#endif

#define GD_PUTC(x) fputc(x,g_fp)

#define GD_RETURN_FROM_PRINT return(1L)

#define GDDEF_PRINT() \
  static \
  long \
  GD_rappend(print) (GD_SELF,g_fp,g_depth,g_length) \
    GD_OBJ_TYPE * GD_SELF; \
    FILE *g_fp; \
    unsigned long g_depth; \
    unsigned long g_length;

#define GD_PRINT_KL1_TERMS(x,b,s) \
{ \
  int i; \
  general_print((((q *)(x))+(b)),g_fp,g_depth,g_length); \
  for(i=(b)+1; i<(b)+(s); i++){ \
    fprintf(g_fp,","); \
    general_print((((q *)(x))+i),g_fp,g_depth,g_length); \
  } \
}

/******************************************************************/

#define GDDEF_GC() \
 static \
  q * \
  GD_rappend(gc) (GD_SELF,g_allocp,g_sp) \
    GD_OBJ_TYPE * GD_SELF; \
    q *g_allocp; \
    q **g_sp;

#define GD_RETURN_FROM_GC(newgobj) \
{ \
  gcsp = g_sp; \
  heapp = g_allocp; \
  return(((q *)(newgobj))); \
}

#define GD_COPY_KL1_TERM_TO_NEWGEN(from,to) G_COPY_KL1_TERM_TO_NEWGEN(from,to) 

#define GDDEF_REGIST() \
  static \
  long \
  GD_rappend(regist) (GD_SELF,g_allocp) \
    GD_OBJ_TYPE * GD_SELF; \
    q *g_allocp;

#define GDDEF_DEALLOCATE() \
  static \
  long \
  GD_rappend(deallocate) (GD_SELF) \
    GD_OBJ_TYPE * GD_SELF;

#define GDDEF_CLOSE() \
  static \
  struct goalrec * \
  GD_rappend(close) (GD_SELF,g_qp) \
    GD_OBJ_TYPE * GD_SELF; \
    struct goalrec *g_qp;

#define GDDEF_GENERIC() \
static \
struct goalrec * \
 GD_rappend(generic) (GD_SELF,g_method_functor,GD_ARGV,g_qp,g_allocp) \
    GD_OBJ_TYPE * GD_SELF; \
    long g_method_functor; \
    q GD_ARGV[]; \
    struct goalrec *g_qp; \
    q *g_allocp;

/**********************************************************************/
/*  guard utility */
#define GDDEF_GGENERIC() \
static \
 q \
 GD_rappend(guard_generic) (GD_SELF,g_method_functor,GD_ARGV) \
    GD_OBJ_TYPE * GD_SELF; \
    long g_method_functor; \
    q GD_ARGV[];

#define GD_SWITCH_ON_GMETHOD switch(g_method_functor)
#define GD_GMETHOD_CASE(fa) \
  case (long) G_functor(fa): \
  { \
    q retval = (q) GD_guard(fa) (GD_SELF,g_method_functor,GD_ARGV); \
    GD_GRETURN(retval); \
  } \
  break

#define GDDEF_GMETHOD(fa) \
  static \
  q \
  GD_guard(fa) (GD_SELF,g_method_functor,GD_ARGV) \
    GD_OBJ_TYPE * GD_SELF; \
    long g_method_functor; \
    q GD_ARGV[];

#define GD_GMETHOD_CASE_DEFAULT \
  default: \
  GD_GFAIL

/*******************************************/
/* utility */
#define GDSET_INTARG_FOR_NEW(var,argv_i) \
{ \
  GD_DEREF_FOR_NEW(argv_i); \
  if(!G_ISINT(argv_i)) GD_FAIL("not integer"); \
  (var) = G_INTVAL(argv_i); \
}

#define GDSET_INTARG(var,argv_i) \
{ \
  GD_DEREF(argv_i); \
  if(!G_ISINT(argv_i)) GD_FAIL("not integer"); \
  (var) = G_INTVAL(argv_i); \
}


#define GDSET_INTARG_WITHIN_RANGE(var,argv_i,llim,ulim) \
{ \
  GD_DEREF(argv_i); \
  if(!G_ISINT(argv_i)) GD_FAIL("not integer"); \
  (var) = G_INTVAL(argv_i); \
  if( (llim>(var)) || ((var)>=ulim) ) GD_FAIL("out of range"); \
}

#define GDSET_GINTARG_WITHIN_RANGE(var,x,from,to) \
{ \
  GD_GDEREF(x); \
  if(!G_ISINT(x)) GD_GFAIL; \
  var = G_INTVAL(x); \
  if( ((from)>var) || (var>=(to)) ) GD_GFAIL; \
}

/*******************************************/
#define GD_IS_CLASS(class,obj) \
   ((struct data_object_method_table *)(&(GD_method_table0(class))) == ((struct data_object_method_table *)functor_of(obj)))

#define GD_CALL_GMETHOD(obj,method,argv) \
     (q)((((struct data_object *)functorp(obj))->method_table)->g_generic) \
             ((struct data_object *)functorp(obj), G_functor(method),argv)
	 
#define GD_CALL_METHOD(obj,method,argv) \
     g_qp = (struct goalrec *) \
         ((((struct data_object *)functorp(obj))-> \
                method_table)->body_generic) \
                ((struct data_object *)functorp(obj), \
                        G_functor(method),argv,g_qp,g_allocp)

#define GD_NEW(class,argc,argv) \
     (q) GD_rappend(class,new) (argc,argv,g_allocp)
