/* ---------------------------------------------------------- 
%   (C)1993 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
macro(otherwise,otherwise) :- !.
macro(alternatively,alternatively) :- !.
macro((H:-G|B),Clause):- !, exp_one_clause(H,G,B,Clause).
macro((H:-B),Clause):- !, exp_one_clause(H,true,B,Clause).
macro(H,Clause):- !, exp_one_clause(H,true,true,Clause).

exp_one_clause(H,G,B,clause(NewH,NewG,NewB,Exp)) :-
    numbervars([H,G,B],0,V0),
    countvars([H,G,B],Table),
    norm_head(H,NewH,V0,V1,NewG0,G1),
    linearize_guard(G,G1,[]),
    exp_guard(NewG0,V1,V,NewG,[]),
    exp_body(B,V,_,Table,Exp,[],NewB,[]).

norm_head(H,NewH,V0,V1,G,NewG) :-
    H =..[F|Args],
    norm_head_and_guard_top(Args,V0,V1,NewArgs,G,NewG),
    NewH =..[F|NewArgs].

norm_head_and_guard_top([],V0,V0,[]) --> !.
norm_head_and_guard_top([A|Args],V0,V1,['$VAR'(V0)|NewArgs]) -->
    [A='$VAR'(V0)],
    { V is V0+1 },
    norm_head_and_guard_top(Args,V,V1,NewArgs).

linearize_guard(true) --> !, [].
linearize_guard((X,Y)) --> !, linearize_guard(X), linearize_guard(Y).
linearize_guard(G) --> [G].

exp_guard([],V,V) --> [].
exp_guard([(X0;Y0)|T],V0,V) --> !,
    [(X;Y)],
    { linearize_guard(X0,X1,T), exp_guard(X1,V0,V1,X,[]),
      linearize_guard(Y0,Y1,T), exp_guard(Y1,V1,V,Y,[]) }.
exp_guard([G|T],V0,V) -->
    macro_goal(G,V0,V1,g,After,[]),
    macro_out(After),
    exp_guard(T,V1,V).

exp_body(true,V,V,_,M,M) --> !.
exp_body((X,Y),V0,V,T,M0,M) --> !,
    exp_body(X,V0,V1,T,M0,M1), exp_body(Y,V1,V,T,M1,M).
exp_body((X;Y),V,V,T,[expanded(OR,ID)|M],M) --> !,
    { exp_body_or((X;Y),Goal,ID,V,T,OR) }, [Goal].
exp_body(G,V0,V,_,M,M) --> macro_goal(G,V0,V,b,After,[]),
    macro_out(After).

exp_body_or(X,G,ID,V,T,OR) :-
    countvars(X,T1),
    find_interface_vars(T1,T,IV),
    G=..['$macroexpanded',ID,IV],
    G1=..['$macroexpanded',ID|IV],
    body_or_clauses(X,G1,V,T1,OR,[]).

body_or_clauses((X;Rest),H,V,T) --> !,
    body_or_one(X,H,V,T),
    body_or_clauses(Rest,H,V,T).
body_or_clauses(Last,H,V,T) -->
    body_or_one(Last,H,V,T).

body_or_one(otherwise,_,_,_) --> !, [otherwise].
body_or_one(alternatively,_,_,_) --> !, [alternatively].
body_or_one((G->B),H,V,T) -->
    [clause(H,NewG,NewB,Exp)],
    { linearize_guard(G,G1,[]),
      exp_guard(G1,V,V1,NewG,[]),
      exp_body(B,V1,_,T,Exp,[],NewB,[]) }.

countvars(X,Table) :- findvars(X,Vars,[]), countvars(Vars,Table,[]).

countvars([]) --> [].
countvars([K|T0]) --> { countsame(T0,T,K,1,N) }, [K=N], countvars(T).

countsame([],[],_,N,N).
countsame([K|T0],T,K,N0,N) :- !, N1 is N0+1, countsame(T0,T,K,N1,N).
countsame([J|T0],[J|T],K,N0,N) :- countsame(T0,T,K,N0,N).

findvars('$VAR'(K)) --> !, [K].
findvars(A) --> { atomic(A) }, !.
findvars([H|T]) --> !, findvars(H), findvars(T).
findvars(X) --> { X=..[_|Args] }, findvars(Args).

find_interface_vars([],_,[]).
find_interface_vars([K=N|T0],T1,V) :- assoc(T1,K,N), !,
    find_interface_vars(T0,T1,V).
find_interface_vars([K=_|T0],T1,['$VAR'(K)|V]) :-
    find_interface_vars(T0,T1,V).

macro_args([],[],V,V,_GB,After,AfterN) --> [], {After=AfterN}.
macro_args([A|T0],[X|T],V0,V,GB,After,AfterN) -->
    macro_arg(A,X,V0,V1,GB,After,After1),
    macro_args(T0,T,V1,V,GB,After1,AfterN).

macro_arg('$VAR'(N),'$VAR'(N),V,V,_GB,After,After) --> !.
macro_arg({},A,V,VN,GB,After,AfterN) --> !,
    { VN is V+1, A='$VAR'(V) },
    ( { GB=g } -> {After = [generic:vector(A):0|AfterN] }
    ; [generic:new(vector,A,0)], { After=AfterN }).
macro_arg({Vec},A,V,VN,GB,After,AfterN) --> !,
    { V1 is V+1, A='$VAR'(V) },
    macro_vector(Vec,Body,N,V1,VN,GB,After0,After1),
    ( { GB=g } -> { After = [generic:vector(A):N|After2] },
                  macro_vec_elems(0,N,A,Body,After2,After0),
                  { After1 = AfterN }
    ;  [generic:new(vector,A,N,Body)], { After= After0, AfterN=After1 }).
macro_arg(A,A,V,V,_GB,After,After) --> { atomic(A) }, !.
macro_arg(#[A],A,V,V,_GB,After,After) --> { integer(A) }, !.
macro_arg(c#[A],A,V,V,_GB,After,After) --> { integer(A) },!.
macro_arg(key#lf,10,V,V,_GB,After,After) --> !.
macro_arg(key#cr,13,V,V,_GB,After,After) --> !.
macro_arg(N#List,A,V,V,_GB,After,After) --> { integer(N) }, !,
      { macro_N_10(List,N,0,A) }.
macro_arg(~(Exp0),X,V0,V,GB,After,AfterN) --> !,
    macro_arg(Exp0,Exp,V0,V1,GB,After,AfterN),
    macro_exp(Exp,X,V1,V).
macro_arg(`(Q),X,V0,V,GB,After,AfterN) --> !,
    { Q=..[F|Args] },
    macro_args(Args,XArgs,V0,V,GB,After,AfterN),
    { X=..[F|XArgs] }.
macro_arg(``(Q),Q,V,V,_GB,After,After) --> !.
macro_arg([CAR|CDR],[XCAR|XCDR],V0,V,GB,After,AfterN) --> !,
    macro_arg(CAR,XCAR,V0,V1,GB,After,After1),
    macro_arg(CDR,XCDR,V1,V,GB,After1,AfterN).
macro_arg(string#Str,A,V,VN,GB,After,AfterN) -->
    { is_string_list(Str) },!,
    { VN is V+1, length(Str,N), A = '$VAR'(V) },
    ( { GB=g } -> { After=[generic:estring(A,N,8,Str)|AfterN] }
    ; [generic:new(string,A,N,8,Str)], { After=AfterN }).
macro_arg(A,X,V0,V,GB,After,AfterN) -->
    { A =..[F|Arg] },
     macro_args(Arg,XArg,V0,V,GB,After,AfterN),
    { X =..[F|XArg] }.

macro_vec_elems(N,N,_A,_Body,After,After) --> [].
macro_vec_elems(K,N,A,[H|T],After,AfterN) -->
    { After=[generic:element(A,K):H|After1] },
    { K1 is K+1 },
    macro_vec_elems(K1,N,A,T,After1,AfterN).

macro_goal(LHS0:=RHS0,V0,V,GB,After,AfterN) --> !,
    macro_arg(LHS0,LHS,V0,V1,GB,After,After1),
    macro_arg(RHS0,RHS,V1,V2,GB,After1,AfterN),
    macro_exp(RHS,X,V2,V),
    [LHS=X].
macro_goal(G,V0,V,GB,After,AfterN) --> { compar_macro(G,LHS0,RHS0,Op) },!,
    macro_arg(LHS0,LHS1,V0,V1,GB,After,After1),
    macro_exp(LHS1,LHS,V1,V2),
    macro_arg(RHS0,RHS1,V2,V3,GB,After1,AfterN),
    macro_exp(RHS1,RHS,V3,V),
    { Goal=..[Op,LHS,RHS] }, [Goal].
macro_goal(X0==Y0,V0,V,g,After,AfterN) --> !,
    macro_arg(X0,X,V0,V1,g,After,After1),
    macro_arg(Y0,Y,V1,V,g,After1,AfterN),
    [eq(X,Y)].
macro_goal(X0\=Y0,V0,V,g,After,AfterN) --> !,
    macro_arg(X0,X,V0,V1,g,After,After1),
    macro_arg(Y0,Y,V1,V,g,After1,AfterN),
    [diff(X,Y)].
%macro_goal(merge(X,Y),V0,V,b,After,AfterN) --> !,
%    macro_goal(generic:new(merge,X,Y),V0,V,b,After,AfterN).
macro_goal(vector(X),V0,V,g,After,AfterN) --> !,
    { V1 is V0+1 },
    macro_goal(generic:vector(X):'$VAR'(V0),V1,V,g,After,AfterN).
macro_goal(vector(X,L),V0,V,g,After,AfterN) --> !,
    macro_goal(generic:vector(X):L,V0,V,g,After,AfterN).
macro_goal(string(X),V0,V,g,After,AfterN) --> !,
    { V1 is V0+1,
      V2 is V1+1 },
    macro_goal(generic:string(X):'$VAR'(V0):'$VAR'(V1),V2,V,g,After,AfterN).
macro_goal(string(X,Y),V0,V,g,After,AfterN) --> !,
    { V1 is V0+1 },
    macro_goal(generic:string(X):Y:'$VAR'(V0),V1,V,g,After,AfterN).
macro_goal(string(X,L,EL),V0,V,g,After,AfterN) --> !,
    macro_goal(generic:string(X):L:EL,V0,V,g,After,AfterN).
macro_goal(vector_element(X,I,E),V0,V,g,After,AfterN) --> !,
    macro_goal(generic:element(X,I):E,V0,V,g,After,AfterN).
macro_goal(set_vector_element(X,I,NE,NX),V0,V,b,After,AfterN) --> !,
    macro_goal(generic:set_element(X,I,NE,NX),V0,V,b,After,AfterN).
macro_goal(set_vector_element(X,I,OE,NE,NX),V0,V,b,After,AfterN) --> !,
    macro_goal(generic:set_element(X,I,OE,NE,NX),V0,V,b,After,AfterN).
macro_goal(current_node(X,Y),V0,V,b,After,AfterN) --> !,
    macro_goal(X=0,V0,V1,b,After,After1),
    macro_goal(Y=1,V1,V, b,After1,AfterN).
macro_goal(new_functor(F,P,A),V0,V,b,After,AfterN) --> !,
    macro_goal(functor_table:new_functor(F,P,A),V0,V,b,After,AfterN).
macro_goal(functor(F,P,A),V0,V,b,After,AfterN) --> !,
    macro_goal(functor_table:functor(F,P,A),V0,V,b,After,AfterN).
macro_goal(functor(F,P,A,NF),V0,V,b,After,AfterN) --> !,
    macro_goal(functor_table:functor(F,P,A,NF),V0,V,b,After,AfterN).
macro_goal(set_arg(I,F,E,NF),V0,V,b,After,AfterN) --> !,
    macro_goal(functor_table:set_arg(I,F,E,NF),V0,V,b,After,AfterN).
macro_goal(arg(I,F,E),V0,V,b,After,AfterN) --> !,
    macro_goal(functor_table:arg(I,F,E),V0,V,b,After,AfterN).
macro_goal(arg(I,F,E,NF),V0,V,b,After,AfterN) --> !,
    macro_goal(functor_table:arg(I,F,E,NF),V0,V,b,After,AfterN).
macro_goal(set_arg(I,F,E,NF),V0,V,b,After,AfterN) --> !,
    macro_goal(functor_table:set_arg(I,F,E,NF),V0,V,b,After,AfterN).
macro_goal(string(S,L,EL,NS),V0,V,b,After,AfterN) --> !,
    macro_goal(S=NS,V0,V1,b,After,After1),
    macro_goal(generic:string(S,L,EL),V1,V,b,After1,AfterN).
macro_goal(string_element(S,L,EL,NS),V0,V,b,After,AfterN) --> !,
    macro_goal(S=NS,V0,V1,b,After,After1),
    macro_goal(generic:element(S,L,EL),V1,V,b,After1,AfterN).
macro_goal(string_element(S,L,EL),V0,V,b,After,AfterN) --> !,
    macro_goal(generic:element(S,L):EL,V0,V,b,After,AfterN).
macro_goal(string_element(S,L,EL),V0,V,g,After,AfterN) --> !,
    macro_goal(generic:element(S,L,EL),V0,V,g,After,AfterN).
macro_goal(set_string_element(S,L,EL,NS),V0,V,b,After,AfterN) --> !,
    macro_goal(generic:set_element(S,L,EL,NS),V0,V,b,After,AfterN).
%macro_goal(vector(S,L,NS),V0,V,b,After,AfterN) --> !,
%    macro_goal(S=NS,V0,V1,b,After,After1),
%    macro_goal(generic:vector(S,L),V1,V,b,After1,AfterN).
%macro_goal(vector(S,L),V0,V,b,After,AfterN) --> !,
%    macro_goal(generic:vector(S,L),V0,V,b,After,AfterN).
macro_goal(vector_element(S,L,E,NS),V0,V,b,After,AfterN) --> !,
    macro_goal(S=NS,V0,V1,b,After,After1),
    macro_goal(generic:element(S,L,E),V1,V,b,After1,AfterN).
macro_goal(vector_element(S,L,E),V0,V,b,After,AfterN) --> !,
    macro_goal(generic:element(S,L,E),V0,V,b,After,AfterN).
macro_goal(new_string(S,L,EL),V0,V,b,After,AfterN) --> !,
    macro_goal(generic:new(string,S,L,EL),V0,V,b,After,AfterN).
macro_goal(new_vector(S,L),V0,V,b,After,AfterN) --> !,
    macro_goal(generic:new(vector,S,L),V0,V,b,After,AfterN).
macro_goal(builtin#Pred,V0,V,b,After,AfterN) --> !,
    macro_goal(body_builtin:Pred,V0,V,b,After,AfterN).
macro_goal(G0,V0,V,GB,After,AfterN) -->
    { G0=..[F|Args] },
    macro_args(Args,XArgs,V0,V,GB,After,AfterN),
    { G=..[F|XArgs] }, [G].

macro_exp('$VAR'(N),'$VAR'(N),V,V) --> !.
macro_exp(N,N,V,V) --> { integer(N) }, !.
macro_exp(Exp0,'$VAR'(V1),V0,V) -->
	{ functor(Exp0,F,A), macro_arith_op(F,A,Op) }, !,
    { Exp0=..[_|Args] },
    macro_exp_args(Args,XArgs,V0,V1),
    { append(XArgs,['$VAR'(V1)],AllArgs),
      Goal=..[Op|AllArgs],
      V is V1+1 },
    [Goal].
macro_exp(X,X,V,V) -->
    { warning("Unknown term in integer expression: ~w", [X]) }.

macro_exp_args([],[],V,V) --> [].
macro_exp_args([A|T0],[X|T],V0,V) -->
    macro_exp(A,X,V0,V1), macro_exp_args(T0,T,V1,V).

macro_arith_op((+),2,add).
macro_arith_op((-),2,subtract).
macro_arith_op((*),2,multiply).
macro_arith_op((/),2,divide).
macro_arith_op((mod),2,modulo).
macro_arith_op((/\),2,and).
macro_arith_op((\/),2,or).
macro_arith_op((xor),2,exclusive_or).
macro_arith_op((>>),2,shift_right).
macro_arith_op((<<),2,shift_left).
macro_arith_op((+),1,plus).
macro_arith_op((-),1,minus).
macro_arith_op((\),1,complement).

compar_macro(X<Y,X,Y,less_than).
compar_macro(X=<Y,Y,X,not_less_than).
compar_macro(X>=Y,X,Y,not_less_than).
compar_macro(X>Y,Y,X,less_than).
compar_macro(X=:=Y,X,Y,equal).
compar_macro(X=\=Y,X,Y,not_equal).

is_string_list([]).
is_string_list([C|Next]):- C >= 0, C < 256, !, is_string_list(Next).

macro_vector(Vec,E,N,V,VN,GB,After,AfterN) -->
   macro_vector(Vec,E,1,N,V,VN,GB,After,AfterN).

macro_vector((E0,EN),[NewE0|NewEN],M,N,V,VN,GB,After,AfterN) --> !,
   { M1 is M + 1 } ,
   macro_arg(E0,NewE0,V,V1,GB,After,After1),
   macro_vector(EN,NewEN,M1,N,V1,VN,GB,After1,AfterN).
macro_vector(E,[NewE],M,M,V,VN,GB,After,AfterN) -->
   macro_arg(E,NewE,V,VN,GB,After,AfterN).

macro_out([]) --> !,[].
macro_out([A|N]) --> [A], macro_out(N).

macro_N_10([C|N],B,T,A):- C >= 0'a, !, T1 is T*B + C - 0'a + 10,
  macro_N_10(N,B,T1,A).
macro_N_10([C|N],B,T,A):- C >= 0'A, !, T1 is T*B + C - 0'A + 10,
  macro_N_10(N,B,T1,A).
macro_N_10([C|N],B,T,A):- T1 is T*B + C - 0'0,
  macro_N_10(N,B,T1,A).
macro_N_10([],_B,T,A) :- A = T.

