/* ---------------------------------------------------------- 
%   (C)1993 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
:- op(1150, fx, (public)).
:- op(1150, fx, (implicit)).
:- op(1150, fx, (local_implicit)).
:- op(1150, fx, (with_macro)).
:- op(1090,xfx, (=>)).
:- op(800, xfy, (:)).
:- op(700, xfx, (\=)).
:- op(700, xfx, (:=)).
:- op(700, xfx, (<=)).
:- op(700, xfx, (<<=)).
:- op(700, xfx, ($:=)).
:- op(700, xfx, ($=:=)).
:- op(700, xfx, ($=\=)).
:- op(700, xfx, ($<)).
:- op(700, xfx, ($>)).
:- op(700, xfx, ($=<)).
:- op(700, xfx, ($>=)).
:- op(700, xfx, ($<=)).
:- op(700, xfx, ($$:=)).
:- op(700, xfx, ($$=:=)).
:- op(700, xfx, ($$=\=)).
:- op(700, xfx, ($$<)).
:- op(700, xfx, ($$>)).
:- op(700, xfx, ($$=<)).
:- op(700, xfx, ($$>=)).
:- op(700, xfx, ($$<=)).
:- op(700, xfx, (&<)).
:- op(700, xfx, (&>)).
:- op(700, xfx, (&=<)).
:- op(700, xfx, (&>=)).
:- op(700, xfx, (&<=)).
:- op(700, xfy, (@)).
:- op(500, yfx, (xor)).
:- op(300, xfy, (**)).
:- op(200, fx,  (&)).
:- op(150, xf,  (++)).
:- op(150, xf,  (--)).
:- op(100, fx, (#)).
:- op(100, xfx,(#)).
:- op(90, xfx, (::)).
:- op(80, fx, (module)).

kl1cmp :-
    unix(argv(List)),
    kl1cmps(List),
    unix(exit(0)).

kl1cmps([]):- !.
kl1cmps([File|Next]):-
    klcmp(File), !,
    kl1cmps(Next).
kl1cmps([F|_]) :-
    told,seen,
    report_error("Compilation failed for file ~w~n",[F]).

klcmp(InFile) :-
    name(InFile,InCharList),
    append(CharList, ".kl1", InCharList),
    append(CharList,".c",OutCharList),
    name(OutFile,OutCharList),
    append(CharList,".ext",HdrCharList),
    name(HdrFile,HdrCharList),
    compile(InFile,OutFile,HdrFile).

compile(InFile,OutFile,HdrFile) :-
    read_in(InFile,Modules,Inline),
    tell(OutFile),
    write_file_header,
    write_inline_header(Inline),
    klicformat("~n",[]),
    compile_modules(Modules,OutFile,HdrFile),
    close(OutFile),
    close(HdrFile).

write_file_header :-
    compiler_version(Version),
    compiler_date(Date),
    klicformat("/* Compiled by KLIC compiler ~w (~w) */~n", [Version,Date]),
    klicformat("#include <klic/basic.h>~n",[]),
    klicformat("#include <klic/struct.h>~n",[]),
    klicformat("#include <klic/primitives.h>~n",[]),
    klicformat("#include <klic/unify.h>~n",[]),
    klicformat("#include <klic/index.h>~n",[]),
    klicformat("#include <klic/gb.h>~n",[]),
    klicformat("#include <klic/bb.h>~n",[]),
    klicformat("#include <klic/generic.h>~n",[]),
    klicformat("#include ""atom.h""~n",[]),
    klicformat("#include ""funct.h""~n",[]).

write_inline_header([]).
write_inline_header([String|Rest]) :-
    write_inline(String,[],[],[]),
    write_inline_header(Rest).

compile_modules([],_,_).
compile_modules([One|Rest],OutFile,HdrFile) :-
    analyze(One,Module),
    tell(OutFile),
    write_out(Module),
    tell(HdrFile),
    write_header_file(Module),
    compile_modules(Rest,OutFile,HdrFile).

read_in(InFile,Terms,Inline) :-
    nofileerrors,
    see(InFile), !,
    fileerrors,
    read(Term),
    read_inline(Term,Inline,Terms),
    seen.
read_in(InFile,_) :-
    fileerrors,
    klicformat("~w does Not exist !!~n",[InFile]),
    seen,
    fail.

read_inline((:-inline:X),[X|Rest],Terms) :- !,
    read(More),
    read_inline(More,Rest,Terms).
read_inline(X,[],Terms) :-
    read_all(X,Terms).

read_all(end_of_file,Tail) :- !, Tail = [].
read_all((:- module(X)),[module(X,One)|Tail]) :- !,
    read(More),
    read_one_module(More,One,Next),
    read_all(Next,Tail).
read_all(_,_) :-
    report_error("Module declaration is not found", []).

read_one_module(end_of_file,[],Next) :- !,
    Next = end_of_file.
read_one_module((:- module(X)),[],Next) :- !,
    Next = (:- module(X)).
read_one_module((:- _),Tail,Next) :- !,
    read(X),
    read_one_module(X,Tail,Next).
read_one_module(One0,[One|Tail],Next) :-
    macro(One0,One),
    read(X),
    read_one_module(X,Tail,Next).

analyze(module(Name,Module),module(Name,Predicates,Ex)) :-
    ( recorded(compiling_module,_,Ref), erase(Ref), fail; true ),
    recorda(compiling_module,Name,_),
    analyze_preds(Module,0,Predicates,Ex,[]).

analyze_preds([],_,[],Ex,Ex).
analyze_preds([clause(Head,Guard,Body,Exp0)|Rest0],Seq0,
	  [pred(Name,Arity,Seq0,Works,Object)|OtherPreds],
	  Ex0,Ex) :-
    ( recorded(compiling_predicate,_,Ref), erase(Ref), fail; true ),
    functor(Head,Name,Arity),
    recorda(compiling_predicate,Name/Arity,_),
    Clauses = [clause(Name/Arity/0,Head,Guard,Body)|OtherClauses],
    collect_same(Rest0,Rest1,Name,Arity,1,OtherClauses,Exp0,Exp),
    name(Name,NameS),
    inttostring(Arity,ArityS,[]),
    append(NameS,[0'/|ArityS],Prefix),
    rename_macro_preds(Exp,Prefix,0,Rest1,Rest),
    generate(Name/Arity,Clauses,Works,Exx,[],Object),
    remove(Exx,exec(Name/Arity),Ex0,Ex1),
    Seq1 is Seq0+1,
    analyze_preds(Rest,Seq1,OtherPreds,Ex1,Ex).

rename_macro_preds([],_,_,Rest,Rest).
rename_macro_preds([expanded(OR,NewName)|Exp],Prefix,K,Rest0,Rest) :-
    inttostring(K,KS,[]),
    append(Prefix,[0'$|KS],NewNameS),
    name(NewName,NewNameS),
    rename_macro_clauses(OR,Rest1,Rest0),
    K1 is K+1,
    rename_macro_preds(Exp,Prefix,K1,Rest1,Rest).

rename_macro_clauses([],Rest,Rest).
rename_macro_clauses([otherwise|T],[otherwise|Rest0],Rest) :-
    rename_macro_clauses(T,Rest0,Rest).
rename_macro_clauses([alternatively|T],[alternatively|Rest0],Rest) :-
    rename_macro_clauses(T,Rest0,Rest).
rename_macro_clauses([clause(H0,G,B,Exp)|T],[clause(H,G,B,Exp)|Rest0],Rest) :-
    H0=..[_,NewName|Args], H=..[NewName|Args],
    rename_macro_clauses(T,Rest0,Rest).

collect_same([clause(Head,Guard,Body,Exp1)|Rest0],Rest,Name,Arity,K,
    [clause(Name/Arity/K,Head,Guard,Body)|OtherClauses],Exp0,Exp) :-
    functor(Head,Name,Arity), !,	
    K1 is K+1,
    append(Exp1,Exp0,Exp2),
    collect_same(Rest0,Rest,Name,Arity,K1,OtherClauses,Exp2,Exp).
collect_same([otherwise|Rest0],Rest,Name,Arity,K,
    [otherwise|OtherClauses],Exp0,Exp) :- !,
    collect_same(Rest0,Rest,Name,Arity,K,OtherClauses,Exp0,Exp).
collect_same([alternatively|Rest0],Rest,Name,Arity,K,
    [alternatively|OtherClauses],Exp0,Exp) :- !,
    collect_same(Rest0,Rest,Name,Arity,K,OtherClauses,Exp0,Exp).
collect_same(Rest,Rest,_,_,_,[],Exp,Exp).

report_error(Format,Args) :-
    write_message(Format,Args),
    compilation_error.

warning(Format,Args) :-
    write_message(Format,Args).

write_message(Format,Args) :-
    (
	recorded(compiling_module,Module,_) ->
	klicformat(user_error,"In ~w:", [Module])
    ;
	true
    ),
    (
	recorded(compiling_predicate,Pred,_) ->
	klicformat(user_error,"~w: ",[Pred])
    ;
	true
    ),
    klicformat(user_error,Format,Args),
    nl(user_error).

compilation_error :-
    unix(exit(-1)).
