%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% (C)1992 Institute for New Generation Computer Technology %
% $BG[I[$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F2<$5$$(B          %
% ( Read COPYRIGHT for detailed information. )             %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%% version 1.0
%%% Oct 18. 1991

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%                                                  %%%
%%%               Parser Main Routine                %%%
%%%                                                  %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%% parse$B$OBg$-$/(B4 Parts $B$+$i@.$k(B		     %%%
%%% 1. $B<-=q0z$-(B(dic_table)			     %%%
%%%    $BJ8@aNs$N<-=q0z$-$r9T$&(B			     %%% 
%%% 2. $B2r@O%F!<%V%k$N:n@.(B(make_talbe)		     %%%
%%%    n$BJ8@a$KBP$7$F(B Len: n-1, Rank: $BJ8@aNs(B,         %%%
%%%    Table: T(i,j) (1 =< i < j =< n)		     %%%
%%%    Table$B$O9=B$E*$J@)Ls$N%A%'%C%/$K;HMQ(B           %%%
%%% 3. parse$BK\BN(B(parse_loop)			     %%%
%%%    $BJ8@aF1;N$K%"!<%/$,D%$i$l$k$+$I$&$+%A%'%C%/(B    %%%
%%% 4. $BF@$i$l$?7k2L$N@07A(B(trans_syn, trans_rel,      %%%
%%%                                    peel,append)  %%%

parse(S,Result2) :-
    dic_table(S,Dic_out),!,
    make_table(Dic_out,Len,Rank,Table),
    parse_loop(0,Len,Rank,Table),
    trans_syn(0,Len,Rank,Result1),
    trans_rel(0,Len,Rank,Result2tmp),
    peel(Result2tmp,Result2),
    append(Result1,Result2,Result).

parse_b(S,Result) :-
    dic_table(S,Dic_out),!,
    make_table(Dic_out,Len,Rank,Table),
    parse_loop(0,Len,Rank,Table),
    trans_syn(0,Len,Rank,Result1),
    trans_rel(0,Len,Rank,Result2tmp),
    peel(Result2tmp,Result2),
    append(Result1,Result2,Result).

%%% parse$BK\BN(B                                        %%%
%%% n$BJ8@a$N2r@O%F!<%V%k(BT(i,j)$B$KBP$7$F(B1$B$D$:$D=g$KE,MQ(B %%%
%%% topic$B$N%i%s%/$r7hDj$9$k=hM}(B(flooting_rank)       %%%
%%% topic$B$N>l9g(BTable$B$NE,MQ=g=x$rJQ$($k$?$a(Bflag x$B$r(B   %%%
%%% $BIUM?$9$k(B(check_topic)			     %%%
%%% $B%"!<%/$,D%$l$k$+$I$&$+$r%A%'%C%/$9$k(B(span_arc)   %%%
%%% $BJ8K!$N$&$A$N8@8lE*@)Ls$,5-=R$5$l$?$b$N(B	     %%%

parse_loop(P,P,_,_) :- !.
parse_loop(P,PP,Rank,Table) :-
    P1 is P + 1,
    arg(P1,Table,Row),
    arg(P1,Rank,Rtemp),
    get_last_element(Rtemp,A),
    arg(1,A,R1),
    arg(2,A,R1f),
    floating_rank(R1,R1f,R1ff),
    check_topic(R1,Topic),
    span_arc(P1,P,PP,Topic-R1ff,Rank,Row,P,Table,[],Md,0),
    Md \== [],
    parse_loop(P1,PP,Rank,Table).
     

check_topic([],_) :- !.
check_topic(R1,P) :- 
       search(R1,gr([Gmer1])),
       arg(1,Gmer1,T1),
       T1 == $B$O(B,
       P = x.
check_topic(R1,R1).

%%% $BJ8@aF1;N$K%"!<%/$,D%$l$k$+$I$&$+$r%A%'%C%/$9$k(Broutine %%%
%%% $BJ8@aF1;N$,NY$j9g$&$b$N$+(B(adj_ph)$BN%$l$?$b$N$+(B(ph)      %%%
%%% $B78$j$NJ8@a$,(Btopic$B$G$"$k$+$=$&$G$J$$$+$r$3$3$GH=CG$9$k(B %%%
%%% topic$B$N>l9g(B(rank_test_and_go_t)			  %%%
%%% $B$=$l0J30$N>l9g(B(rank_test_and_go)			  %%%

span_arc(PPP,X,X,_,_,_,_,_,Md,Md,T) :- !.
span_arc(PPP,X,XX,R1-R1f,Rank,Row,P,Table,Md,Md1,T) :-
% In Case --> topic1 & adj_ph
    R1 == x,
    T == 0,
    T1 is T + 1,
    X1 is X + 1,
    rank_test_and_go_t(PPP,X,x-R1f,Rank,Row,P,Table,adj_ph),
    span_arc(PPP,X1,XX,x-R1f,Rank,Row,P,Table,[X1|Md],Md1,T1).
span_arc(PPP,X,XX,R1-R1f,Rank,Row,P,Table,Md,Md1,T) :-
% In Case --> topic1 & ph
    R1 == x,
    T \== 0,
    T1 is T + 1,
    X1 is X + 1,
    rank_test_and_go_t(PPP,X,x-R1f,Rank,Row,P,Table,ph),
    span_arc(PPP,X1,XX,x-R1f,Rank,Row,P,Table,[X1|Md],Md1,T1).
span_arc(PPP,X,XX,R1-R1f,Rank,Row,P,Table,Md,[X1|Md],T) :- 
% In Case --> not topic adj_ph
    R1 \== x,
    Ptemp is PPP - X,
    Ptemp == 1, 
    X1 is X + 1,
    rank_test_and_go(PPP,X,R1-R1f,Rank,Row,P,Table,adj_ph).
span_arc(PPP,X,XX,R1-R1f,Rank,Row,P,Table,Md,[X1|Md],T) :- 
% In Case --> not topic ph
    R1 \== x,
    Ptemp is PPP - X,
    Ptemp \== 1,
    X1 is X + 1,
    rank_test_and_go(PPP,X,R1-R1f,Rank,Row,P,Table,ph).
span_arc(PPP,X,XX,R1-R1f,Rank,Row,P,Table,Md,Md1,T) :-
    T1 is T + 1,
    X1 is X + 1,!,
    span_arc(PPP,X1,XX,R1-R1f,Rank,Row,P,Table,Md,Md1,T1).


%%% $BJ8K!(BMain routine$B$X$N0z$-EO$7(B                   %%%
%%% topic$B0J30$N>l9g(B(rank_test_and_go)	           %%%
%%% topic$B$N>l9g(B(rank_test_and_go_t)	           %%%
%%% $BJ8@aNs$+$i:#%A%'%C%/$7$h$&$H$9$kG$0U$NJ8@a$N(B   %%%
%%% $B9=J8>pJs$r$H$jJ8K!(BMain routine$B$X0z$-EO$9(B       %%%
%%% $BJ8K!(BMain routine(check_main)		   %%%
%%% $BJ8K!$N=PNO$r$b$i$$J8@aNs$KKd$a9~$`(B(subst_sim)  %%%
%%% table$B$KBP$7$F:#F@$i$l$?%"!<%/$N9=B$E*$J@)Ls$N(B  %%%
%%% $B%A%'%C%/(B(put_constraints, check_arc)	   %%%

rank_test_and_go(PPP,X,R1s-R1fs,Rank,Row,P,Table,D) :-
    XP  is X - P,
    XP1 is X - P + 1,
    X2  is X + 2,
    arg(XP1,Row,arc(Ra)),
    var(Ra),
    arg(X2,Rank,Rtemp),
    get_last_element(Rtemp,A),
    arg(1,A,R2),
    arg(2,A,R2f),
    check_main(R1fs,R2,R1fout,R2ffout,Arcout,D),
    subst_sim(X2,Rank,phrase(R2,R2ffout,Arcout)),
    subst_sim(PPP,Rank,phrase(R1fs,R1fout,_)),
    functor(Arcout,ARC,4),
    arg(XP1,Row,arc(ARC)),
    put_constraints(P,XP,ARC,Table),
    check_arc(1,P,0,ARC,Table).

rank_test_and_go_t(PPP,X,R1s-R1fs,Rank,Row,P,Table,D) :-
    XP  is X - P,
    XP1 is X - P + 1,
    X2  is X + 2,
    arg(XP1,Row,arc(Ra)),
    var(Ra),
    arg(X2,Rank,Rtemp),
    get_last_element(Rtemp,A),
    arg(1,A,R2),
    arg(2,A,R2f),
    check_topic_main(R1fs,R2,R1fout,R2ffout,Arcout,D),
    subst_sim(X2,Rank,phrase(R2,R2ffout,Arcout)),
    subst_sim(PPP,Rank,phrase(R1fs,R1fout,_)),
    functor(Arcout,ARC,4),
    arg(XP1,Row,arc(ARC)),
    put_constraints(P,XP,ARC,Table),
    check_arc(1,P,0,ARC,Table).

          

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%                                                 %%%
%%%  Putting Constraints Caused by Newly Found Arc  %%%
%%%                                                 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%% table$B$KBP$7$F:#F@$i$l$?%"!<%/$N9=B$E*$J@)Ls$N(B  %%%
%%% $B%A%'%C%/(B(put_constraints, check_arc)	   %%%
%%% arc(Pi,Pj)$B$,D%$l$?$i2<?^$N(B4$B<oN`$N@)Ls$r#5<oN`$N(B%%%
%%% $B@)Ls$r%A%'%C%/$9$k(B				   %%%

put_constraints(P,Q,R,Table) :-
    suppress_in_lower(P,P,Q,R,Table), !,
    suppress_out_upper(0,P,Q,R,Table), !.

suppress_in_lower(0,_,_,_,_) :- !.
suppress_in_lower(I,P,Q,R,Table) :-
    arg(I,Table,Row),
    functor(Row,_,Len),
    I1 is I - 1,
    PI1 is P - I1,
    QPI1 is Q + PI1,
    suppress_in_arc(0,Q,PI1,Row),
    set_lower_bound(QPI1,Len,R,Row), !,
    suppress_in_lower(I1,P,Q,R,Table).

suppress_in_arc(X,X,_,_) :- !.
suppress_in_arc(X,XX,D,Row) :-
    XD1 is X + D + 1,
    X1 is X + 1,
    arg(XD1,Row,arc(0)), !,
    suppress_in_arc(X1,XX,D,Row).

set_lower_bound(X,XX,_,_) :- X >= XX, !.
set_lower_bound(X,XX,R,Row) :-
    X1 is X + 1,
    arg(X1,Row,arc(Ra)), !,
    freeze(Ra,rank_le_or_0(R,Ra)), !,
    set_lower_bound(X1,XX,R,Row).

suppress_out_upper(Q,_,Q,_,_) :- !.
suppress_out_upper(I,P,Q,R,Table) :-
    I1 is I + 1,
    PI2 is P + I + 2,
    QI is Q - I,
    arg(PI2,Table,Row),
    functor(Row,_,Len),
    suppress_out_arc(QI,Len,Row),
    set_upper_bound(0,QI,R,Row), !,
    suppress_out_upper(I1,P,Q,R,Table).

suppress_out_arc(X,XX,_) :- X >= XX, !.
suppress_out_arc(X,XX,Row) :-
    X1 is X + 1,
    arg(X1,Row,arc(0)), !,
    suppress_out_arc(X1,XX,Row).

set_upper_bound(X,X,_,_) :- !.
set_upper_bound(X,XX,R,Row) :-
    X1 is X + 1,
    arg(X1,Row,arc(Ra)), !,
    freeze(Ra,rank_le_or_0(Ra,R)), !,
    set_upper_bound(X1,XX,R,Row).

check_arc(PP,XP,XP,ARC,Table) :- !.
check_arc(PP,XP,Len,ARC,Table) :- 
	arg(XP,Table,Row),
	check_arc1(PP,ARC,Row),
	X1 is XP - 1,
        PPP is PP + 1,
        check_arc(PPP,X1,Len,ARC,Table).

check_arc1(Len,ARC,Row) :-
	arg(Len,Row,arc(A)),
      ( var(A),!;
        integer(A),!;
        check_arc2(A,ARC) ).

check_arc2(a,a) :- !.
check_arc2(a,b) :- !.
check_arc2(a,c) :- !.
check_arc2(a,d) :- !.
check_arc2(b,b) :- !.
check_arc2(b,c) :- !.
check_arc2(b,d) :- !.
check_arc2(c,c) :- !.
check_arc2(c,d) :- !.
check_arc2(d,d) :- !.

	
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%                                                 %%%
%%%             Make Talbe & Rank Routines          %%%
%%%                                                 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%% $B@)Ls$r%A%'%C%/$9$k$?$a$N(BTable$B$N:n@.(B             %%%
%%% $B$*$h$SJ8@aNs$r(BRank$B$K(Bset$B$9$k=hM}(B		    %%%

make_table(S,Len,Rank,Table) :-
    length(S,Len1),
    functor(Rank,seq,Len1),
    make_table_1(0,Len1,S,Rank),
    Len is Len1 - 1,
    functor(Table,table,Len),
    make_table_2(0,Len,Table).

make_table_1(P,P,_,_) :- !.
make_table_1(P,PP,[R|S],Rank) :-
    P1 is P + 1,
    arg(P1,Rank,[R|_]), !,
    make_table_1(P1,PP,S,Rank).

make_table_2(P,P,_) :- !.
make_table_2(P,PP,Table) :-
    P1 is P + 1,
    D is PP - P,
    arg(P1,Table,Row),
    functor(Row,row,D),
    make_table_3(0,D,Row), !,
    make_table_2(P1,PP,Table).

make_table_3(P,P,_) :- !.
make_table_3(P,PP,Row) :-
    P1 is P + 1,
    arg(P1,Row,arc(_)), !,
    make_table_3(P1,PP,Row).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%                                                 %%%
%%%             Format of Output  Routines          %%%
%%%                                                 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%% $B=PNO$N@07A=hM}(B                                  %%%
%%% $BJ8@aNs$N=PNO>pJs(B(SYN)$B$N@07A=hM}(B(trans_syn)	    %%%
%%% $BJ8@aF1;N$r7k$V%"!<%/(B(REL)$B$N@07A=hM}(B(trans_rel,  %%%
%%%					      peel) %%%


trans_syn(P,P,Rank,SYNout) :- !,
	P1 is P + 1,
	arg(P1,Rank,R),
	get_last_element(R,SYNtemp),
	arg(2,SYNtemp,SYNout).
trans_syn(P,PP,Rank,[SYNout,SYN]) :-
	P1 is P + 1,
	arg(P1,Rank,R),
	get_last_element(R,SYNtemp),
	arg(2,SYNtemp,SYNout),
	trans_syn(P1,PP,Rank,SYN).

trans_rel(P,P,Rank,[REL]) :- !,
	P1 is P + 1,
	arg(P1,Rank,R),
	get_element(3,R,AA,REL).
trans_rel(P,PP,Rank,[Rel,REL]) :- 
	P1 is P + 1,
	arg(P1,Rank,R),
	get_element(3,R,AA,Rel),
	trans_rel(P1,PP,Rank,REL).

peel([],[]) :-!.
peel([X|T],R) :- (var(X), !; atom(X) ),!, peel(T,R).
peel([a(A,B,C,D) |T],[a(A,B,C,D)|R]) :- peel(T,R),!.
peel([b(A,B,C,D) |T],[b(A,B,C,D)|R]) :- peel(T,R),!.
peel([c(A,B,C,D) |T],[c(A,B,C,D)|R]) :- peel(T,R),!.
peel([d(A,B,C,D) |T],[d(A,B,C,D)|R]) :- peel(T,R),!.
peel([H|T],R) :- peel(H,HR), peel(T,TR) ,!, append(HR,TR,R).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%			Etc		            %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

subst_sim(X2,[],phrase(R2,R2ffout,Arcout)).
subst_sim(X2,Rank,A) :-
	set(X2,Rank,A).

floating_rank(X,Y,YYY) :-
	search(X,gr,mer,[T]),
	T == topic1(T1),
	search(Y,rank,mcand,YY),
	subst(rank(XX,mer(P)),X,rank(X,mer(YY)),YYY).
floating_rank(X,Y,YYY) :-
		var(Y),
		YYY = X.	
floating_rank(X,Y,YYY) :-
		nonvar(Y),
		YYY = Y.	

rank_lt(a,b) :- !.  rank_lt(a,c) :- !.  rank_lt(b,c) :- !.

rank_le(a,a) :- !.  rank_le(a,b) :- !.  rank_le(a,c) :- !.  rank_le(a,d) :- !.
rank_le(b,b) :- !.  rank_le(b,c) :- !.  rank_le(b,d) :- !.
rank_le(c,c) :- !.  rank_le(c,d) :- !.
rank_le(d,d) :- !.

rank_le_or_0(0,_) :- !.  rank_le_or_0(_,0) :- !.
rank_le_or_0(a,a) :- !.  rank_le_or_0(a,b) :- !.  rank_le_or_0(a,c) :- !. rank_le_or_0(a,d) :- !.

rank_le_or_0(b,b) :- !.  rank_le_or_0(b,c) :- !.  rank_le_or_0(b,d) :- !.
rank_le_or_0(c,c) :- !.  rank_le_or_0(c,d) :- !.
rank_le_or_0(d,d) :- !.

set(X2,[],_) :-!.
set(X2,Rank,Dat) :-
	arg(X2,Rank,PP),
	tail(PP,Dat).
