%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% (C)1992 Institute for New Generation Computer Technology %
% $BG[I[$=$NB>$O(B COPYRIGHT $B%U%!%$%k$r;2>H$7$F2<$5$$(B          %
% ( Read COPYRIGHT for detailed information. )             %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%% version 1.0
%%% Apr 23. 1992

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%                                                 %%%
%%%                 Control Routine                 %%%
%%%                                                 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%% $BJ8>O%U%!%$%kF~NO$K$h$k0l3g=hM}$HJ8F~NO$K$h$k=hM}$,$"$k(B   %%%
%%% (1) $BJ8F~NO$K$h$k=hM}(B                                     %%%
%%%     (a) Nemacs$B%(%G%#%?$NF~NO$r(BEUC$B%3!<%I$KJQ49(B            %%%
%%%     (b) $B%W%m%0%i%`5/F0J}K!(B			 	     %%%
%%%         solve([$BJ8@a(B1,$BJ8@a(B2,...]) 		             %%%
%%%         $B=R8l(B solve $B$O(B	 	 	 	     %%%
%%%         $B7W;~3+;O(B 1$B$D$N2r$r5a$a%U%j!<%:$7$FG[Ns$KC_@Q$9$k(B %%%
%%%         $B%P%C%/%H%i%C%/$GJL2r$r5a$a$k(B		     %%%
%%%         $BA42r$,5a$^$C$?$i(B, $B;~4V$r7W$j(B		     %%%
%%%         $B<B9T;~4V(B, $B2r$N?t(B, $B2r@O7k2L$N=g$K=PNO(B             %%%
%%% (2) $BJ8>O%U%!%$%kF~NO$K$h$k0l3g=hM}(B		             %%%    	
%%%     (a) $BF~NO%U%!%$%k$N7A<0(B                               %%%
%%%         ---------------------------------------------    %%%
%%%         [$BBh(B1$BF~NOJ8$NJ8@aNs(B ($BJ8@a$4$H$K%+%s%^$G6h@Z$k(B)].  %%%
%%%         [$BBh(B2$BF~NOJ8$NJ8@aNs(B ($BJ8@a$4$H$K%+%s%^$G6h@Z$k(B)].  %%%
%%%         ......                                           %%%
%%%         [$BBh(Bn$BF~NOJ8$NJ8@aNs(B ($BJ8@a$4$H$K%+%s%^$G6h@Z$k(B)].  %%%
%%%         ---------------------------------------------    %%%
%%%     (b) $BF~NO%U%!%$%k$r(BEUC$B%3!<%I$KJQ49(B                    %%%
%%%         nkf -a $BF~NO%U%!%$%kL>#1(B > $BF~NO%U%!%$%kL>#2(B       %%%
%%%     (c) $B0l3g=hM}%W%m%0%i%`5/F0J}K!(B                       %%%
%%%         ana('$BF~NO%U%!%$%kL>#2(B','$B=PNO%U%!%$%kL>(B').        %%%
%%%         $B=R8l(B ana $B$OF~NO%U%!%$%k$+$i0lJ8FI$_(B, solve $B$X(B    %%%
%%%         $BEO$9(B $B$3$N:n6H$r(B end_of_file $B$^$G7+$jJV$9(B         %%%


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%    One Sentence Process    %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

solve(S) :-
    time(bagof(R,parse(S,R),Result)),
    length(Result,Num),
    write('results = '),
    write(Num), nl,
    write_result(Result).

write_result([]) :- !.
write_result([H|Res]) :-
    write(H), nl, !,
    write_result(Res).

    
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%    Batch Process           %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

ana(InputFile,OutputFile) :-  !,
  open(InputFile,read,InS),
  open(OutputFile,write,OutS),
  ana2(InS,OutS),
  close(OutS),
  close(InS).

ana2(InS,OutS) :- !,
  read(InS,S),
  format("~n",[]),
  (S \== end_of_file ->
    (S @>= '%' ->
     write('input sentence ---> '),
     write(S),
     time_batch(bagof(R,parse_b(S,R),Result),Time),
     length(Result,Num),
     write(OutS,S),
     write(OutS,'.'),
     format(OutS,"~n",[]),
     length(S,Ph),
     write(OutS,'the number of phrase = '),
     write(OutS,Ph),
     write(OutS,'.'),
     write('the number of phrase = '),
     write(Ph),
     format("~n",[]),
     format(OutS,"~n",[]),
     write(OutS,'the number of solution = '),
     write(OutS,Num),
     write(OutS,'.'),
     format(OutS,"~n",[]),
     write('the number of solution = '),
     write(Num),
     format("~n",[]),
     write(OutS,'execution time = '),
     write(OutS,Time),
     write(OutS,'.'),
     format(OutS,"~n",[]),
     write_result_file(OutS,Result)
    ;
     !),
     ana2(InS,OutS)
    ;
     !).

write_result_file(Out,[]) :- !,
  format(Out,"~n",[]).
write_result_file(Out,[H|Res]) :-
  write(Out,H),
  write(Out,'.'),
  format(Out,"~n",[]),
  write_result_file(Out,Res).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%    Time Count              %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%    Time Count (One Sentence Process)    %%%
time(Proc) :-
    statistics(garbage_collection,GCt1),
    statistics(stack_shifts,[_,_,SF_base]),
    statistics(runtime,_),
   ( call(Proc) ; nl, write(Proc), write(' failed!') ),
    statistics(runtime,[_,Time]),
    statistics(stack_shifts,[_,_,SF_end]),
    statistics(garbage_collection,GCt2),
    GCt1 = [_,_,Gc_base],
    GCt2 = [_,_,Gc_end],
    Gc_time is Gc_end - Gc_base,
    SF_time is SF_end - SF_base,
    Ex_time is Time - Gc_time - SF_time,
    nl,write('execution time = '),
    write(Ex_time),
    write(msec),nl,!.

%%%    Time Count (Batch Process)          %%%
%%% Ex_time $B$O0l3g=hM}MQ(B 
time_batch(Proc,Ex_time) :-
    statistics(garbage_collection,GCt1),
    statistics(stack_shifts,[_,_,SF_base]),
    statistics(runtime,_),
   ( call(Proc) ; nl, write(Proc), write(' failed!') ),
    statistics(runtime,[_,Time]),
    statistics(stack_shifts,[_,_,SF_end]),
    statistics(garbage_collection,GCt2),
    GCt1 = [_,_,Gc_base],
    GCt2 = [_,_,Gc_end],
    Gc_time is Gc_end - Gc_base,
    SF_time is SF_end - SF_base,
    Ex_time is Time - Gc_time - SF_time,
    nl,write('execution time = '),
    write(Ex_time),
    write(msec),nl,!.


