% (C) 1992 Institute for New Generation Computer Technology
% (Read COPYRIGHT for detailed information)

%
% file name :   tst.spec
%
% (01) 89. 7.18 by T.A. created from pratial.syn
% (02) 89. 7.18 by T.A. add external public
% (03) 89. 7.24 by T.A. bring $is_TST$ and rename is_TST
% (04) 89. 7.24 by T.A. bring $cil_ROOT_label_pos$ from type.syn
% (05) 89. 8.21 by T.A. change all for changing tst format
% (06) 89. 9.11 by T.A. amend bug merge, glue, t_merge, d_merge
% (07) 89. 9.30 by T.A. amend bug same type checking
% (08) 89. 9.30 by T.A. amend getRole L,V unbound check
% (09) 89.10. 2 by T.A. amend setOfkeys
% (10) 89.10. 2 by T.A. amend buffer
% (11) 89.10. 2 by T.A. amend delete
% (12) 89.10. 2 by T.A. amend t_subpat
% (13) 89.10. 2 by T.A. amend extend
% (14) 91. 1.30 by T.A. change to spec module tst
% (15) 91. 2.14 by T.A. add tst_to_pst
% (16) 91. 2.14 by S.K. define package
% (17) 91. 2.14 by S.K. ; --> .
% (18) 91. 2.21 by T.A. amend partial
% (19) 91. 2.21 by T.A. change environment for bind_hook
% (20) 91. 2.21 by T.A. add pst_call module
% (21) 91. 2.25 by S.K. change suppressor from $ to `
% (22) 91. 2.28 by S.K. merge syntax module
%   syntax log start
% (01) 89. 1. 8 by T.O. created inherit4.dcl
% (02) 89. 5.19 by T.S. PARTIAL.SYN for css
% (03) 89. 7.14 by T.A. amend bug put_d_subtype
% (04) 89. 7.14 by T.A. change value flag 1 to label 
% (05) 89. 7.18 by T.A. devide into two_file(type.syn and type.cil)
% (06) 89. 7.24 by T.A. bring $is_TST$ and $cil_ROOT_label_pos$ to type.cil
% (07) 89. 7.24 by T.A. amend role_expand for bound label
% (08) 89. 7.25 by T.A. amend role_expand unbound TST is default_type constraint
% (09) 89. 8. 3 by T.A. add dynamic predicate for public off compile
% (10) 89. 8. 3 by T.A. add public subtype for public off compile
% (11) 89. 8.23 by T.A. stop type information for runtime
% (12) 89. 8.23 by T.A. change tst format tst(Root, Group, A/V pares)
% (13) 89. 8.28 by T.A. stop role_TST if role_expand fail
% (14) 89. 8.29 by T.A. add syntax error check
% (15) 89. 9. 8 by T.A. change begin_definition to begin(tst) also end
% (16) 89. 9.11 by T.A. add syntax_error type_mismatch
% (17) 89.10. 2 by T.A. amend {a/{A,B,C}} to A is @@
% (18) 89.10. 2 by T.A. amend same typed variable in a clause
% (19) 89.10. 2 by T.A. change error message illegal label access
% (20) 89.10. 2 by T.A. add error at mismatch typed variable in a clause
% (21) 89.10. 2 by T.A. add tst constant type check
% (22) 89.10.28 by T.A. merge label_position and label_value
% (23) 90. 2.14 by T.A. add error check for {L/v}
% (24) 91. 1.30 by T.A. change to spec module tst
% (25) 91. 2. 5 by T.S. add view for syntax definition
% (26) 91. 2.21 by T.A. add portray module
% (27) 91. 2.22 by T.A. change error_message to syntax_error
% (28) 91. 2.25 by S.K. change suppressor from $ to `
%   syntax log end


%
% tst builtin definition
%
:-define tst.
%:-use source(">sys>spec>source>cil_v4").
%:-use diagnose(">sys>spec>aval>tst").

%
%
:-define tst/builtin.
:-environment meta_esp_call.

%
% TST check for common
%
is_TST(TST, Label_part):-
    unify(TST, tst(_,_,Label_part)).


same_type_tst(P1,P2, N, LP1, LP2):-
    unify(P1, tst(R, HP, LP1)),
    unify(P2, tst(R, HP, LP2)),
    stack_vector(LP1,N), 
    (   bound(LP2), !,
        stack_vector(LP2,N)
    ;   new_stack_vector(LP2, N)).

%
% same/2
%
:-public same/2.

same(X,Y) :- X == Y, !.
same(X,Y) :- (unbound(X);unbound(Y)), !, fail.
same([X|X1],[Y|Y1]) :-
    same(X,Y), !,
    same(X1,Y1).
same(X,Y) :-
    is_TST(X, LPX),
    is_TST(Y, LPY), !,
    stack_vector(X,N), !,
    same_tst(N-1,LPX,LPY).
same(X, Y) :-
    stack_vector(X, N),
    stack_vector(Y, N), !,
    same_vector(N-1, X, Y).

same_vector(-1,_,_) :- !.
same_vector(N,X,Y) :-
    vector_element(X,N,A),
    vector_element(Y,N,B),
    same(A,B), !,
    same_vector(N-1,X,Y).

same_tst(-1,_,_) :- !.
same_tst(N,X,Y) :-
    vector_element(X,N,{XF,XV}),
    vector_element(Y,N,{YF,YV}),
    ( unbound(XF), unbound(YF)   % (_,_)
     ; XF == YF, !,
       same(XV,YV) ), !,    % (1,1)
    same_tst(N-1,X,Y).

%
% fullCopy/2
%
:-public fullCopy/2.

fullCopy(X,Y) :-
    stack_to_heap_vector(X,Z), !,
    heap_to_stack_vector(Z,Y).

%
% partial/1
%
:-public partial/1.

partial(P) :- 
    is_TST(P,_).

%
% role/3    currently dummy
%
:-public role/3.

role(L,P,V) :-
    unbound(P), !,
    bind_hook(P, role(L,P,V)).
role(L,P,V) :-
    unbound(L), !,
    bind_hook(L, role(L,P,V)).
role(_,_,_) :-!.

%
% locate/3
%
:-public locate/3.

locate(P,L,V) :-
    bound(L),
    is_TST(P, LP),
    stack_vector(LP, Size),
    locate1(0, Size, LP, L, V).

locate1(N, N, _, _, _):-
    !, fail.
locate1(N, _, LP, L, V):-
    vector_element(LP, N, {EL, EV}),
    EL == L, !,
    unify(EV, V).
locate1(N, E, LP, L, V):-
    locate1(N+1, E, LP, L, V).

%
% getRole/3
%
:-public getRole/3.

getRole(P,L,V) :-
    is_TST(P, LP),
    stack_vector(LP, Size),
    getRole1(0, Size, LP, L, V).

getRole1(N, N, _, _, _):-
    !, fail.
getRole1(N, _, LP, L, V):-
    vector_element(LP, N, {EL, EV}),
    bound(EL),
    unify({L,V},{EL, EV}).
getRole1(N, E, LP, L, V):-
    getRole1(N+1, E, LP, L,V).

%
% setOfKeys/2
%
:-public setOfKeys/2.

setOfKeys(P,Set) :-
    is_TST(P,LP),
    stack_vector(LP,N), !,
    setOfKeys1(0, N, LP, Set).

setOfKeys1(N,N, _,[]) :- !.
setOfKeys1(N,E,LP,[L|Set]) :-
    vector_element(LP,N,{L,_}),
    bound(L), !,
    setOfKeys1(N+1,E,LP,Set).
setOfKeys1(N,E,LP,Set) :-
    setOfKeys1(N+1,E,LP,Set).

%
% record/2
%
:-public record/2.

record(P,Record) :-
    is_TST(P,LP),
    stack_vector(LP,N), !,
    record1(0, N, LP,Record).

record1(N,N, _,[]) :- !.
record1(N,E,LP,[(L,V)|Record]) :-
    vector_element(LP,N,{L,V}),  % mode
    bound(L) , !,
    record1(N+1,E,LP,Record).
record1(N,E,LP,Record) :-
    record1(N+1,E,LP,Record).
%
% buffer/2   -- ??
%
:-public buffer/2.

buffer(P, [end|_]):-
    unbound(P), !.
buffer(P, Buffer):-
    unbound(Buffer), !,
    bind_hook(Buffer, buffer(P, Buffer)).
buffer(P, Buffer) :-
    is_TST(P,LP),
    stack_vector(LP,N), !,
    buffer1(Buffer, LP, 0, N).

buffer1(Buffer, LP, I, N) :-
    unbound(Buffer), !,
    bind_hook(Buffer, buffer1(Buffer, LP, I, N)).
buffer1([], _, _, _) :- !.
buffer1([end|_], _, N, N):-!.
buffer1([B|Buffer], LP, I, N) :-
    vector_element(LP,I,{L,V}),
    bound(L), !, B = (L,V),
    buffer1(Buffer, LP, I+1, N).
buffer1(Buffer, LP, I, N) :-
    buffer1(Buffer, LP, I+1, N).


%
% glue/2
%
:-public glue/2.

glue(P1,P2) :-
    same_type_tst(P1,P2, N, LP1, LP2),
    glue1(0, N,LP1,LP2).

glue1(A,A,_,_) :- !.
glue1(N,A,LP1,LP2) :-
    vector_element(LP1,N,{L1,V1}),  % mode
    vector_element(LP2,N,{L2,V2}),  % mode
    ( bound(L1), bound(L2), !,
      unify({L1,V1},{L2,V2})
    ; true ), !,
    glue1(N+1,A,LP1,LP2).

%
% merge/2
%
:-public merge/2.

merge(P1,P2) :-
    same_type_tst(P1,P2, N, LP1, LP2),
    merge1(0, N,LP1,LP2).

merge1(A,A,_,_) :- !.
merge1(N,A,LP1,LP2) :-
    vector_element(LP1,N,{L1,V1}),  % mode
    vector_element(LP2,N,{L2,V2}),  % mode
    ( bound(L1), !,
      unify({L1,V1},{L2,V2})
    ; true ), !,
    merge1(N+1,A,LP1,LP2).


%
% t_merge/2
%
:-public t_merge/2.

t_merge(X,_) :-
    unbound(X), !.
t_merge([X|A],[Y|B]):-!,
    t_merge(X,Y), !,
    t_merge(A,B).
t_merge(P1,P2) :-
    same_type_tst(P1,P2, N, LP1, LP2),!,
    t_merge1(0,N,LP1,LP2).
t_merge(X,Y):-
    stack_vector(X,N),  !,
    new_stack_vector(U,N),
    t_merge_stack(0,N,X,U),
    unify(Y,U).
t_merge(X,Y):-
    unify(X,Y).

t_merge_stack(N,N,_,_) :- !.
t_merge_stack(N,E,X,Y) :-
    vector_element(X,N,A),
    vector_element(Y,N,B),
    t_merge(A,B), !,
    t_merge_stack(N+1,E,X,Y).

t_merge1(A,A,_,_) :- !.
t_merge1(N,A,LP1,LP2) :-
    vector_element(LP1,N,{L1,V1}),
    bound(L1), !,
    vector_element(LP2,N,{L1,V2}),
    t_merge(V1,V2),
    t_merge1(N+1,A,LP1,LP2).
t_merge1(N,A,LP1,LP2) :-
    t_merge1(N+1,A,LP1,LP2).

%
% d_merge/2
%
:-public d_merge/2.

d_merge(P1,P2) :-
    same_type_tst(P1,P2, N, LP1, LP2),
    d_merge1(0,N,LP1,LP2).

d_merge1(A,A,_,_) :- !.
d_merge1(N,A,LP1,LP2) :-
    vector_element(LP1,N,{L,V1}),
    bound(L),                  % NO CUT!!
    vector_element(LP2,N,{L,V2}),   % mode
    unify(V1, V2), !,
    d_merge1(N+1,A,LP1,LP2).
d_merge1(N,A,LP1,LP2) :-
    d_merge1(N+1,A,LP1,LP2).

%
% delete/3
%
:-public delete/3.

delete(L,P1,P2) :-
    same_type_tst(P1,P2, N, LP1, LP2),
    delete1(0,N,L,LP1,LP2).

delete1(N,N,_,_,_) :- !.
delete1(N,A,L,LP1,LP2) :-
    vector_element(LP1,N,{L1,_}),
    L1 == L, !,
    delete1(N+1,A,L,LP1,LP2).
delete1(N,A,L,LP1,LP2) :-
    vector_element(LP1,N,{L1,V}),
    bound(L1), !,
    vector_element(LP2,N,{L1,V}),
    delete1(N+1,A,L,LP1,LP2).
delete1(N,A,L,LP1,LP2) :-
    delete1(N+1,A,L,LP1,LP2).

%
% masked_merge/3
%
:-public masked_merge/3.

masked_merge(P1,P2,P3) :-
    same_type_tst(P1,P2, N, LP1, LP2),
    same_type_tst(P1,P3, _, _, LP3),
    masked_merge1(0,N,LP1,LP2,LP3).

masked_merge1(A,A,_,_,_) :- !.
masked_merge1(N,A,P1,P2,P3) :-
    vector_element(P1,N,{L1,V1}),       % mode
    vector_element(P2,N,{L2,_}),        % mode
    bound(L1), unbound(L2), !, 
    vector_element(P3,N,{L1,V1}),
    masked_merge1(N+1,A,P1,P2,P3).
masked_merge1(N,A,P1,P2,P3) :-
    masked_merge1(N+1,A,P1,P2,P3).

%
% subpat/3
%
:-public subpat/3.

subpat(P1,P2,`(D-DD)) :-
    same_type_tst(P1,P2, N, LP1, LP2),
    subpat1(0,N,LP1,LP2,D,DD).

subpat1(A,A,_,_,D,D) :- !.
subpat1(N,A,P1,P2,D,DDD) :-
    vector_element(P1,N,{L1,V1}),  % mode
    bound(L1), !,
    vector_element(P2,N,{L2,V2}),  % mode
    bound(L2) ,
    D = [(L1,V1,V2)|DD],
    subpat1(N+1,A,P1,P2,DD,DDD).
subpat1(N,A,P1,P2,D,DD) :-
    subpat1(N+1,A,P1,P2,D,DD).

%
% t_subpat/2
%
:-public t_subpat/2.

t_subpat(X,_) :-
    unbound(X), !.
t_subpat([X|A],[Y|B]):-!,
    t_subpat(X,Y),
    t_subpat(A,B).
t_subpat(P1,P2) :-
    same_type_tst(P1,P2, N, LP1, LP2), !,
    t_subpat1(0, N,LP1,LP2).
t_subpat(X,Y):- unbound(Y),
    stack_vector(X, N), !,
    new_stack_vector(U, N),
    t_subpat_stack(0,N,X,U),
    unify(Y,U).
t_subpat(X,Y):-
    unify(X,Y).

t_subpat_stack(N,N,_,_) :- !.
t_subpat_stack(N,E,X,Y) :-
    vector_element(X,N,A),
    vector_element(Y,N,B),
    t_subpat(A,B), !,
    t_subpat_stack(N+1,E,X,Y).

t_subpat1(A,A,_,_) :- !.
t_subpat1(N,A,P1,P2) :-
    vector_element(P1,N,{L1,V1}),  % mode
    bound(L1), !,                  % (1,_) -> fail
    vector_element(P2,N,{L2,V2}),  % mode
    bound(L2),
    t_subpat(V1,V2),
    t_subpat1(N+1,A,P1,P2). 
t_subpat1(N,A,P1,P2) :-
    t_subpat1(N+1,A,P1,P2). 

%
% extend/3
%
:-public extend/3.

extend(P1,P2,`(D-DD)) :-
    same_type_tst(P1,P2, N, LP1, LP2),
    extend1(0,N,LP1,LP2,D,DD).

extend1(A,A,_,_,D,D) :- !.
extend1(N,A,P1,P2,D,DDD) :-
    vector_element(P1,N,{L,V1}),  % mode
    bound(L), !,
    vector_element(P2,N,{L,V2}),  % mode
    D = [(L,V1,V2)|DD],
    extend1(N+1,A,P1,P2,DD,DDD).
extend1(N,A,P1,P2,D,DD) :-
    extend1(N+1,A,P1,P2,D,DD).
%
% meet/3
%
:-public meet/3.

meet(P1,P2,`(D-DD)) :-
    same_type_tst(P1,P2, N, LP1, LP2),
    meet1(0,N,LP1,LP2,D,DD).

meet1(A,A,_,_,D,D) :- !.
meet1(N,A,P1,P2,D,DDD) :-
    vector_element(P1,N,{L1,V1}),  % mode
    vector_element(P2,N,{L2,V2}),  % mode
    bound(L1), bound(L2), !,
    D = [(L1,V1,V2)|DD],
    meet1(N+1,A,P1,P2,DD,DDD).
meet1(N,A,P1,P2,D,DD) :-
    meet1(N+1,A,P1,P2,D,DD).

%
% :-mode(tst_to_pst(in:(all type term), out))
%
:-view tst_to_pst/2.

tst_to_pst(TST,TST):-
    unbound(TST), !.
tst_to_pst([H|T],[HPST|TPST]):-!,
    tst_to_pst(H, HPST),
    tst_to_pst(T, TPST).
tst_to_pst(TST,PST):-
    TST = tst(_, _, Label_part), !,
    stack_vector(Label_part, N),
    collect_tst_av(0, N, Label_part, AV_list),
    PST = x(_, T_term),
    make_pst(AV_list,T_term).
tst_to_pst(TST,PST):-
    stack_vector(TST, N), !,
    new_stack_vector(PST, N),
    tst_to_pst_vector(0, N, TST, PST).
tst_to_pst(TST, TST).           % other Kl0 data types


tst_to_pst_vector(N, N, _, _):-!.
tst_to_pst_vector(N, E, TST, PST):-
    vector_element(TST, N, TST_element),
    vector_element(PST, N, PST_element),
    tst_to_pst(TST_element, PST_element), !,
    tst_to_pst_vector(N+1, E, TST, PST).

collect_tst_av(N, N, _, []):-!.
collect_tst_av(N, E, Label_part, [{L,PST}|AV_pares]):-
    vector_element(Label_part, N, {L,TST}),
    bound(L),!,
    tst_to_pst(TST, PST),
    collect_tst_av(N+1, E, Label_part, AV_pares).
collect_tst_av(N, E, Label_part, AV_pares):-
    collect_tst_av(N+1, E, Label_part, AV_pares).

:-use tst/pst_call.
make_pst([],_):-!.
make_pst([{L,V}|AVs], T_term):-
    pst_assoc(T_term, L, V), !,
    make_pst(AVs, T_term).

%
% assoc call
%
:-define tst/pst_call.
:-environment pst.
:-view pst_assoc/3.

pst_assoc(T,L,V):-
    assoc(T,L,V).


%
% syntax definition
%
:-define tst/syntax.
:-environment cil.
:-use spec_ms/message_tool.
:-view subtype/2.

% term syntax
:-view syntax/3.
syntax(@@(Type), Tst, true):-!,
    pst_expand(_, Type, Tst).
syntax(@@(Pst,Type), Tst, true):- !,
    pst_expand(Pst, Type, Tst).
syntax(Pst, Tst, true):-
    is_pst_vector(Pst), !,
    get_default_type(Type),
    pst_expand(Pst, Type, Tst).
syntax(`(Tst!Label), Value, Before):-!,
    role_expand(`(Tst!Label), Value, _, Before, true).
syntax(role(Label,Tst,Value), Role, Before):-!,
    role_expand(`(Tst!Label), Value1, _, Before, true),
    Role = unify(Value,Value1).
syntax(`(X#Y)     , X, unify(X,Y)     ):- !.

% predicate syntax
:-view predicate_syntax/2.
predicate_syntax(`(X=Y)     , unify(X,Y)  ):- !.
predicate_syntax(unify_cil(X,Y), unify(X,Y)  ):- !.

% clause syntax
:-view clause_syntax/2.
clause_syntax(begin(tst), ('$void_cil$':-'$void_cil$')) :- !,
    initialize.
clause_syntax(type_definition(Type, PstVector), (<=(Type, PstVector))) :- !.
clause_syntax(<=(Type,PstVector), ('$void_cil$':-fail)) :- !,
    save_type_definition(Type, PstVector).
clause_syntax(`(<(Sub,Super)), ('$void_cil$':-fail)) :- !,
    put_declaration(Sub, Super).
clause_syntax(`(>(Super, Sub)), ('$void_cil$':-fail)) :- !,
    put_declaration(Sub, Super).
clause_syntax(default_type(Type), ('$void_cil$':-fail)) :- !,
    set_default_type(Type).
clause_syntax(end(tst),  ('$void_cil$':-fail)) :- !,
    compose_type.

%
% begin(tst) cause reset dynamic predicate
%
:-dynamic(type_definition/2).
:-dynamic(type_name/1).
:-dynamic(root_name/1).
:-dynamic(d_subtype/2).
:-dynamic(inherit_position/3).
:-dynamic(inherit_size/3).
:-dynamic(type_skelton/2).
:-dynamic(label_size/3).
:-dynamic(label_info/4).
:-dynamic(default_type/1).

initialize :-
    abolish(type_definition,2),
    abolish(type_name,      1),
    abolish(root_name,      1),
    abolish(d_subtype,      2),
    abolish(inherit_position,  3),
    abolish(inherit_size,3),
    abolish(type_skelton,   2),
    abolish(label_size,      3),
    abolish(label_info,    4),
    abolish(default_type,   1),
    !.

%
% default type conservation
%
set_default_type(Type) :-
    (  retract(default_type(Type))
    ;
       true
    ), !,
    assertz(default_type(Type)).

get_default_type(Type) :-
    default_type(Type), !.
get_default_type(_) :-
    syntax_error(require_type_specification, [], tst).

%
% type definition
%
save_type_definition(Type, @@(PstVector, Super)) :- !,
    assertz(type_definition(Type,`(PstVector))),
    put_declaration(Type, Super).
save_type_definition(Type, PstVector) :-
    assertz(type_definition(Type,`(PstVector))),
    put_type_name(Type, root).

% get_inherit_position(Type, Root, Pos, _)
put_inherit_position(Type, Root, N) :-
    assertz(inherit_position(Type, Root, N)).

get_inherit_position(Type, Root, N) :-
    inherit_position(Type, Root, N).

% root_name
get_root_name(Roots) :-
    setof(X, root_name(X), Roots), !.
get_root_name([]).

% label_size
put_label_size(Root, Arity, Labels) :- !,
    assertz(label_size(Root, Arity, Labels)).    % + 1 for type functor

get_label_size(Root, Arity, Labels) :- !,
    label_size(Root, Arity, Labels).

% label_info
put_label_info(Label, Type, Pos, Value) :- 
    assertz(label_info(Label, Type, Pos, Value)).

retrieve_label_info(Label,_,_,_):-
    unbound(Label), !,
    syntax_error(no_label_definition, [Label], tst).
retrieve_label_info(Label, Type, Pos, Value) :- 
    get_inherit_position(Type, Root, _),
    label_info(Label, Root, Pos, Value), !.
retrieve_label_info(Label,_,_,_):-
    syntax_error(no_label_definition, [Label], tst).

% group
put_inherit_size(Root, Group, GroupArity) :-
    assert(inherit_size(Root, Group, GroupArity)).

get_inherit_size(Root, Group, GroupArity) :-
    inherit_size(Root, Group, GroupArity).

% get_type_skelton
put_type_skelton(Type, Tst) :-
    assert(type_skelton(Type, Tst)).

get_type_skelton(Type, Tst) :-
    type_skelton(Type, Tst).

%
% put declaration
%
put_declaration([], _) :- !.
put_declaration(_, []) :- !.
put_declaration([X|Y], Z) :- !,
    put_declaration(X, Z), !,
    put_declaration(Y, Z).
put_declaration(X, [Y|Z]) :- !,
    put_declaration(X, Y), !,
    put_declaration(X, Z).
put_declaration(Inf, Sup) :-
    put_type_name(Inf, not_root),
    put_type_name(Sup, root),
    put_d_subtype(Inf, Sup).

% PUT_TYPE_name
put_type_name(Type, root) :- !,
    (
        retract(type_name(Type))
    ;
        put_root_name(Type)
    ),
    !,
    assertz(type_name(Type)).

put_root_name(Type) :-
    (
        retract(root_name(Type))
    ;
        true
    ),
    !,
    assertz(root_name(Type)).

put_type_name(Type, not_root) :-
    (
        retract(type_name(Type))
    ;
        true
    ), !,
    assertz(type_name(Type)),
    (
        retract(root_name(Type))
    ;
        true
    ), !.

% PUT_D_SUBTYPE
put_d_subtype(Sup, Inf) :-
    assertz(d_subtype(Sup, Inf)),
    fail.
put_d_subtype(_,_).

%
% end definition
%
compose_type:-
    compose_definition(TVInf),
    get_root_name(Roots),
    compose_inheritance(Roots, TVInf),
    compose_label(Roots, TVInf),
    compose_type_skelton(Roots, TVInf).

%
% collect type definition
%
compose_definition(Inf) :-
    (setof({Type,Definition}, type_definition(Type,Definition), DefList)
    ; DefList=[]),!,
    melt_type_vector(DefList, TypeStr, [], Inf),
    !,
    unify_type_definition(TypeStr).

melt_type_vector([], T, T, _) :- !.
melt_type_vector([Ground|DefList], TypeStr1, TypeStr, Inf) :-
    ground_to_variable_type_define(Ground, TypeStr1, TypeStr2, Inf),
    !,
    melt_type_vector(DefList, TypeStr2, TypeStr, Inf).

%
ground_to_variable_type_define({Gtype,GpstVector}, [{Vtype,VpstVector}|DL1], DL, Inf):-
    stack_vector(GpstVector, N), new_stack_vector(VpstVector, N),
    ground_to_variable(Gtype, Vtype, _, DL1, DL2, Inf), !,
    ground_to_variable_pst_vector(N, GpstVector, VpstVector, DL2, DL, Inf).

%
ground_to_variable(Ground, TypeVar, NewGround, DL1, DL, Inf)   :-
    atomic(Ground), is_type_name(Ground), !,
    NewGround = Ground, DL1 = DL,
    new_variable(Ground, TypeVar, Inf).
ground_to_variable(Ground, _, NewGround, DL1, DL, Inf)   :-
    is_pst_vector_with_super(Ground,Define, _),!, % PST as value -> newsubtype
    genSym(newsubtype, NewSubType),
    save_type_definition(NewSubType, Ground),
    NewGround = NewSubType, !,
    ground_to_variable_type_define({NewSubType, Define}, DL1, DL, Inf).
ground_to_variable(Ground, _, _, _, _, _)   :-
    is_pst_vector(Ground), !,
    fail.                             % 88;11;8 Inhibit pst without supertype
ground_to_variable(Ground, TypeVar, NewGround, DL1, DL, Inf)   :-
    stack_vector(Ground, N), !,       % 88;10;23 unnecessary
    NewGround = Ground,
    new_stack_vector(TypeVar, N), !,
    ground_to_variable_vector(N, Ground, TypeVar, DL1, DL, Inf).
ground_to_variable(Ground, TypeVar, NewGround, DL1, DL, Inf)   :-
    list(Ground), !,                  % 88;10;23 unnecessary
    NewGround = Ground,
    ground_to_variable_list(Ground, TypeVar, DL1, DL, Inf).
ground_to_variable(Ground, Ground, Ground, DL, DL, _).
                              % 88;10;23 for only unbound and label (ex; atom)

ground_to_variable_list([], _, DL, DL, _) :- !.
ground_to_variable_list([Define|Dr], [TypeVar|Vr], DL1, DL, Inf) :-
    ground_to_variable(Define, TypeVar, _, DL1, DL2, Inf),
    !,
    ground_to_variable_list(Dr, Vr, DL2, DL, Inf).

% D := unbound | type_name | pstvector@@super (| term);
% ND := unbound | type_name (|term);
% D, ND are frozen definitions,
% in order to save label_value later (in making type skleton);
% ND is a newsubtype when D is pstvector@@super;
% V is melted definition (may be a typevariable) of ND,
% in order to unify(i;e merge) all type_definitions;
ground_to_variable_pst_vector(0, _, _, DL, DL, _) :- !.
ground_to_variable_pst_vector(N, Define, Var, DL1, DL, Inf) :-
    M is N - 1,
    vector_element(Define, M, `(L/D)),
    vector_element(Var, M, `(L/ vOIDvALUE(V,ND))),
    ground_to_variable(D, V, ND, DL1, DL2, Inf),
    !,
    ground_to_variable_pst_vector(M, Define, Var, DL2, DL, Inf).
    
ground_to_variable_vector(0, _, _, DL, DL, _) :- !.
ground_to_variable_vector(N, Define, Var, DL1, DL, Inf) :-
    M is N - 1,
    vector_element(Define, M, D),
    vector_element(Var, M, V),
    ground_to_variable(D, V, _, DL1, DL2, Inf),
    !,
    ground_to_variable_vector(M, Define, Var, DL2, DL, Inf).

%
unify_type_definition([]) :- !.
unify_type_definition([{Type, PstVector}|Z]) :-
    vector_to_btree(PstVector, Pst, MkAssoc, true),
    solve(MkAssoc),
    unify_cil(Type, Pst), !,
    unify_type_definition(Z).


%
vector_to_btree(V, V, G, G) :- unbound(V), !.
vector_to_btree(vOIDvALUE(V,Value), vOIDvALUE(V,Pst), G1, G) :- !,
    vector_to_btree(Value, Pst, G1, G).
vector_to_btree(Vector, P, (mk_assoc(Pst, P), G1), G) :-
    is_pst_vector(Vector), !,
    stack_vector(Vector, L),
    vector_to_btree(L, Vector, Pst, G1, G).
vector_to_btree(Else, Else, G, G).

%
vector_to_btree(0, _, _, G, G) :- !.
vector_to_btree(1, Vector, `(L/P), G1, G) :- !,
    vector_element(Vector, 0, `(L/V)),
    vector_to_btree(V, P, G1, G).
vector_to_btree(I, Vector, ((`(L/P),Pst)), G1, G) :-
    J is I - 1,
    vector_element(Vector, J, `(L/V)),
    vector_to_btree(V, P, G1, G2), !,
    vector_to_btree(J, Vector, Pst, G2, G).

%
% make inheritance information per top_type
%  inherit_size(Top_type:atom, subtypes:list, Group_size:int)
%  inherit_position(Subtype:atom, top_type:atom, Subtype_ID:int)
%
compose_inheritance(Roots, Inf):-
    classify_type(Roots, Groups, Inf),
    numbering_type(Groups).

%
classify_type([], [], _) :- !.
classify_type([Root|Roots], [Group|Groups], Inf):-
    collect_group(Root, Group, GroupArity),
    put_inherit_size(Root, Group, GroupArity), !,
    new_variable(Root, _, Inf),
    classify_type(Roots, Groups, Inf).

% Group = [Root|Sons]
collect_group(Root, [Root|Sons], M) :-
    (setof(S, subtype(S, Root), Sons);Sons=[]),!,
    length(Sons, N),
    M is N + 1.

%
numbering_type([]) :- !.
numbering_type([[Root|Sons]|G]) :-
    numbering_type_1([Root|Sons], Root, 0), !, % ROOT ID is 0
    numbering_type(G).

numbering_type_1([], _,_) :- !.
numbering_type_1([Son|Sons], Root, N) :-
    put_inherit_position(Son, Root, N), !,
    numbering_type_1(Sons, Root, N+1).

%
% make label/value information per type
%  label_info(Label, Top_type, Position_in_TST, Value)
%  label_size(Top_type, Label_Size, Labels),
% 
compose_label([], _) :- !.
compose_label([Root|R], Inf):-
    get_inherit_size(Root, Types, _),
    get_AVs(Types, AVs, Labels, Inf),
    length(AVs, LabelArity),
    put_label_size(Root, LabelArity, Labels),
    save_label_info(AVs, 0, Root),
    !,
    compose_label(R, Inf).

%
get_AVs(Types, AVs, Labels, Inf):-
    merge_AVs(Types, Pst, Inf),
    record(Pst, Pairs),
    av_pairs(Pairs, Labels, AVs).

merge_AVs([],_,_):-!.
merge_AVs([Type|Types], Pst, Inf):-
    new_variable(Type, TPst, Inf),
    merge(TPst, Pst), !,
    merge_AVs(Types, Pst,Inf).
merge_AVs([Type|_], _, _):-
    syntax_error(value_mismatch, [Type], tst).

av_pairs([],[], []) :- !.
av_pairs([(L,vOIDvALUE(_,V))|Pairs], [L|Ls], [(L,V)|AVs]) :-!,
    av_pairs(Pairs, Ls, AVs).

%
save_label_info([],_,_) :- !.
save_label_info([(L,V)|AVs], Arg, Root):-
    put_label_info(L, Root, Arg, V), !,
    save_label_info(AVs, Arg + 1, Root).

%
% make TST format per type
%
%  type_skelton(Type, Tst)
%
compose_type_skelton([], _) :- !.
compose_type_skelton([Root|R], Inf) :-
    get_inherit_size(Root, Types, Inherit_size),
    get_label_size(Root, Label_size, Labels),
    compose_type_skelton_1(Types,[], Label_size,Root,Inherit_size,Inf,Labels),
    !,
    compose_type_skelton(R, Inf).

compose_type_skelton_1([], _, _, _, _, _, _) :- !.
compose_type_skelton_1([Type|T], Exists, LS, Root, IS, Inf, Labels):-
    compose_type_skelton_2(Type, _, Exists,NewExists,LS,Root,IS,Inf,Labels),
    !,
    compose_type_skelton_1(T, NewExists, LS, Root, IS, Inf, Labels).


compose_type_skelton_2(Type, Tst, Exists, [{Type,N}|Exists], _, _, _, _, _) :-
    get_type_skelton(Type, Tst), !,
    get_inherit_position(Type, _, N).
compose_type_skelton_2(Type, Tst, Exists, [{Type,N}|Exists], LS, Root, IS, Inf, Labels) :-
    new_stack_vector(Label_part, LS),
    new_stack_vector(Inherit_part, IS),
    get_inherit_position(Type, _, N),
    vector_element(Inherit_part, N, Type),
    assign_label_information(Labels, 0,Type, Label_part, Root, Inf),
    assign_inheritance_information(Exists, Type, Inherit_part),
    Tst = tst(Root, Inherit_part, Label_part),
    put_type_skelton(Type, Tst),
    !.

assign_label_information([], _, _, _, _, _) :- !.
assign_label_information([Label|Labels], N, Type, LP, Root, Inf) :-
    search_argument_value(Type, Inf, Label, Value, Root),
    assign_argument_information(Label,Value, Str, Inf),
    vector_element(LP, N, Str),
    !,
    assign_label_information(Labels, N+1, Type, LP, Root, Inf).

%
search_argument_value(Type, Inf, Label, Value, _) :-
    new_variable(Type, Pst, Inf),
    locate(Pst, Label, vOIDvALUE(_,Value)),
    !.
search_argument_value(Type, Inf, Label, Value, Root) :-
    Type \== Root, !,
    search_argument_value(Root, Inf, Label, Value, Root).
search_argument_value(_, _, _, _, _).

assign_argument_information(Label, Value, Str, Inf) :-
    is_newsubtype_name(Value), !,           % only newsubtype is expanded
    get_inherit_position(Value, ValueRoot, _),
    get_inherit_size(ValueRoot, _, TypesArity),
    get_label_size(ValueRoot, Size, Labels),
    compose_type_skelton_2(Value, ValueTst, [], _, Size, ValueRoot, TypesArity+1, Inf, Labels),
    Str = {Label, ValueTst}.    % ROOT, No ID
assign_argument_information(_, Value, Str, _) :-
    is_type_name(Value),
    !,
    new_stack_vector(Str, 2).
assign_argument_information(_,Value, Str, _) :-
    unbound(Value),
    !,
    Str = {_, Value}.
assign_argument_information(L,Value, {L, Value}, _).

assign_inheritance_information([], _, _) :- !.
assign_inheritance_information([{Type1, Num}|Exists], Type, Str) :-
    get_relation(Type, Type1, Rel),
    vector_element(Str, Num, Rel), !,
    assign_inheritance_information(Exists, Type, Str).

get_relation(Type, Type1, _) :-
    inheritance(Type, Type1), ! . 
get_relation(_, _, *).

%
% expand role
%
role_expand(Pst, Tst, Type, B1, B) :- 
    unbound(Pst), !,
    get_default_type(Type),
    role_expand(@@(Pst, Type), Tst, Type, B1, B).
role_expand(`(Tst!Label), Value, ValueType, B1, B) :-
    !,
    role_expand(Tst, TstV, TstVType, B1, B),
    (   ground(Label), bound(TstV), bound(TstVType), !
    ; 
        syntax_error(illegal_label_access, [Label], tst)
     ),
    get_inherit_position(TstVType, TstVTypeRoot, _),
    retrieve_label_info(Label, TstVTypeRoot, Arg, ValueType),
    (
        is_type_name(ValueType), !,
        retrieve_type_skelton(ValueType, Value)
    ;
        Value = ValueType
    ),
    TstV = tst(_,_,LP),
    vector_element(LP, Arg, {Label, Value}).

role_expand(@@(Pst, Type), Tst, Type, B, B) :- !,
    pst_expand(Pst, Type, Tst).
role_expand(@@(Type), Tst, Type, B, B) :- !,
    pst_expand(_, Type, Tst).
role_expand(Pst, Tst, Type, B, B) :-
    is_pst_vector(Pst), !,
    get_default_type(Type), !,
    pst_expand(Pst, Type, Tst).
role_expand(Tst, Tst, Type, B, B) :-
    type_infer(Tst, Type),                 % type_infer
    !.

%
% expand pst
%
pst_expand(PstVector, Type, Tst) :-
    unbound(Type), !,
    get_default_type(Type),
    pst_expand(PstVector, Type, Tst).
pst_expand(Pst, Type, Pst) :-
    unbound(Pst), !,
    retrieve_type_skelton(Type, Tst),
    Pst = Tst.
pst_expand(PstVector, Type, Tst) :-
    is_pst_vector(PstVector), !,
    stack_vector(PstVector, CurrentSize),
    retrieve_type_skelton(Type, Tst), !,
    Tst = tst(_, _,LP),
    (
        assign_tst_arguments(0, CurrentSize, PstVector, LP, Type),!
    ;
        syntax_error(type_mismatch, [PstVector, Type], tst)).
pst_expand(PstVector, Type, Tst) :-
    is_tst(PstVector, PstVectorType), !,
    (
        inheritance(PstVectorType, Type), !,
        Tst = PstVector
    ;
        syntax_error(type_mismatch, [PstVector, Type], tst)).

%
assign_tst_arguments(N, N, _, _,_) :- !.
assign_tst_arguments(I, N, PstVector, LP, Type) :-
    vector_element(PstVector, I, `(Label/Value)),
    get_inherit_position(Type, Root, _),
    retrieve_label_info(Label, Root, Pos, ValueType),
    assign_tst_argument(ValueType, Value, SettingValue),
    vector_element(LP, Pos, {Label, SettingValue}),
    assign_tst_arguments(I+1,N, PstVector, LP, Type).

assign_tst_argument(ValueType, Value, SettingValue):-
    is_type_name(ValueType), !,                 % Value must be tst
    tst_constant_value(Value, PST, Type),
    inheritance_check(ValueType, Type),
    pst_expand(PST, ValueType, SettingValue).
assign_tst_argument(ValueType, Value, Value):-
    unbound(Value),!,
    ValueType = Value.    
assign_tst_argument(ValueType, Value, SettingValue):-
    tst_constant_value(Value, PST, Type), !,
    unbound(ValueType),
    pst_expand(PST, Type, SettingValue).
assign_tst_argument(ValueType, Value, Value):-
    ValueType = Value.

tst_constant_value(Value, Value,_):-
    unbound(Value),!.
tst_constant_value(Value, _,_):-
    stack_vector(Value,_), first(Value, F), 
    unbound(F),!, fail.
tst_constant_value(@@(PST, Type), PST, Type):-
    unbound(PST), !.
tst_constant_value(@@(PST, Type), PST, Type):-
    is_pst_vector(PST), !.
tst_constant_value(PST, PST,_):-
    is_pst_vector(PST), !.
tst_constant_value(PST, PST,Type):-
    is_tst(PST, Type).

inheritance_check(_, T):-
    unbound(T), !.
inheritance_check(VT, T):-
    inheritance(VT, T).

%
% utility
%
% type_skelton
retrieve_type_skelton(Type, _) :-
    unbound(Type),  !.
retrieve_type_skelton(Type, Tst) :-
    get_type_skelton(Type, Tst), !.
retrieve_type_skelton(Type, _) :-
    syntax_error(no_type_definition, [Type], tst).

% type_infer
type_infer(Term, Type) :-
    bound(Term),
    Term = tst(Root, IP,_),
    get_inherit_size(Root, _, TypeNum),
    !,
    type_infer(0, TypeNum, IP, Type).  % ROOT, No ID
 
type_infer(N, N, _, '*** OUT OF TYPE ***') :- !.
type_infer(I, N, Str, Type) :-
    vector_element(Str, I, V),
    not_type_expression(V), !,
    type_infer(I + 1, N, Str, Type).
type_infer(I, _, Str, Type) :-
    vector_element(Str, I, V), !,
    lower_type(V, Str, Type).

lower_type(V, _, _) :- not_type_expression(V), !, fail.
lower_type(V, _, Type) :- is_leaf(V), !, Type = V.
lower_type(V, Str, Type) :-
    subtype(Son, V),
    get_inherit_position(Son, _, K),
    vector_element(Str, K, Val),
    lower_type(Val, Str, Type).
lower_type(V, Str, Type) :-
    multiple_inheritance(V, Other, Type),
    get_inherit_position(Other, _, K),
    vector_element(Str, K, Val),
    Val == Other, !.
lower_type(Type, _, Type).

not_type_expression(V) :- unbound(V), !.
not_type_expression(*).

% inheritance(+,+)
inheritance(Inf, Sup) :- Inf == Sup, !.
inheritance(Inf, Sup) :- subtype(Inf, Sup), !.
inheritance(Sup, Inf) :- subtype(Inf, Sup), !.
inheritance(Sup1, Sup2) :- multiple_inheritance(Sup1, Sup2, _), !.

% subtype(^,^)
subtype(Inf, Sup) :- d_subtype(Inf, Sup).
subtype(Inf, Sup) :- d_subtype(Inf, X), subtype(X, Sup).

% supertype(^,^)
supertype(Inf, Sup) :- d_subtype(Inf, Sup).
supertype(Inf, Sup) :- d_subtype(Inf, X), supertype(X, Sup).

% multiple_inheritance(+,+,-)
multiple_inheritance(Sup1, Sup2, Inf) :-
    d_subtype(Inf, Sup1), 
    d_subtype(Inf, Sup2),
    Sup1 \== Sup2, !.

%
new_variable(Type, TypeVar, Inf) :-
    unbound(Inf), !,
    Inf = ({Type, TypeVar},_).
new_variable(Type, TypeVar, ({Type1, TypeVar1},_)) :- 
    Type = Type1, !,    % newsubtypeX(_,;;;,_)
    TypeVar = TypeVar1.
new_variable(Type, TypeVar, (_, Inf)) :- !,
    new_variable(Type, TypeVar, Inf).

%
is_leaf(T) :- d_subtype(_, T), !, fail.
is_leaf(T) :- is_type_name(T).

%
is_type_name(Type) :-
    bound(Type),
    type_name(Type),
    !.

%
is_newsubtype_name(Value) :-
    :get_atom_string(#simpos##symbolizer, Value, String),
    string(String,L,_), L >= 10,
    substring(String, 0, 10, NewSubType),
    equal_string("newsubtype", NewSubType).

%
ground(X) :- unbound(X), !, fail.
ground(X) :- stack_vector(X, L), !, ground_stack(L, X).
ground(X) :- list(X), !, ground_list(X).
ground(_).

ground_stack(0, _) :- !.
ground_stack(L, X) :-
    L1 is L - 1,
    vector_element(X, L1, Y),
    ground(Y), !,
    ground_stack(L1, X).
        
ground_list([]) :- !.
ground_list([X|L]) :-
    ground(X), !,
    ground(L).
ground_list(X) :- !,
    ground(X).

%

is_tst(Tst, Type) :-
    bound(Tst),
    Tst = tst(_,_,_),
    type_infer(Tst, Type).

% 
is_pst_vector_with_super(@@(P, S), P, S) :-
    is_pst_vector(P), !.

% 
is_pst_vector(P) :-
    stack_vector(P, N), !,
    is_pst_vector(N, P).

is_pst_vector(0, _) :- !.
is_pst_vector(N, P) :-
    M is N - 1,
    vector_element(P, M, E),
    stack_vector(E, 3),
    first(E, F),
    F == ('/'), !,
    is_pst_vector(M, P).

%
unique([],[], 0) :- !.
unique([X|Y], Z, N) :-
    member(Y, X), !,
    unique(Y, Z, N).
unique([X|Y], [X|Z], M) :- !,
    unique(Y, Z, N),
    M is N  + 1.

%
member([X|_],X) :- !.
member([_|L],X) :- !, member(L, X).

%
length([], 0) :- !.
length([_|L], M) :-length(L, N), M is N + 1.

%
% operator
%
:-define tst/operator.
:-view op/3.

op(  80, xfx, @@).
op(  80, fx,  @@).
op(1182, xfx, <=).
op( 700, xfx, <).
op( 700, xfx, >).

op(  90,  yfx, #).
op( 200,  yfx, !).

%
% tst messages
%
:-define tst/message.
:-view message/2.

message(no_type_definition,
    {   "no type definition (\q)",
        "   (\q)          "}):-!.
message(no_label_definition,
    {   "label(\q) does not define",
        "   (\q)          "}):-!.
message(require_type_specification,
    {   "require type specification or default type",
        "           ,                  "}):-!.
message(illegal_label_access,
    {   "illegal label(\q) access",
        "          (\q)     "}):-!.
message(type_mismatch,
    {   "TST(\q) mismatches a type(\q)",
        "TST(\q)  (\q)                "}):-!.
message(value_mismatch,
    {   "value mismatches in a inherit type(\q)",
        "   (\q)                   "}):-!.
    
:-define tst/portray.
:-environment esp_call.
:-use pst/builtin.
:-use pst/portray.

transform(Term,New_term):-
    tst_form(Term, New_term).
%
% transform TST in for display
%
%
tst_form(TST,TST):-
    unbound(TST), !.
tst_form([H|T],[HPST|TPST]):-!,
    tst_form(H, HPST),
    tst_form(T, TPST).
tst_form({F,_,_,Label_part},PST):-
    F== tst, 
    stack_vector(Label_part, N), !,
    collect_tst_av(0, N, Label_part, AV_list),
    PST = tst(T_term),
    list_to_vector(AV_list, T_term, []).
tst_form(PST,PST):-                 % return identical variable
    PST= {F,_, _},
    F== x, !.
tst_form(TST,PST):-
    stack_vector(TST, N), !,
    new_stack_vector(PST, N),
    tst_form_vector(0, N, TST, PST).
tst_form(TST, TST).           % other Kl0 data types

tst_form_vector(N, N, _, _):-!.
tst_form_vector(N, E, TST, PST):-
    vector_element(TST, N, TST_element),
    vector_element(PST, N, PST_element),
    tst_form(TST_element, PST_element), !,
    tst_form_vector(N+1, E, TST, PST).

collect_tst_av(N, N, _, []):-!.
collect_tst_av(N, E, Label_part, [`(L/PST)|AV_pares]):-
    vector_element(Label_part, N, {L,TST}),
    bound(L),!,
    tst_form(TST, PST),
    collect_tst_av(N+1, E, Label_part, AV_pares).
collect_tst_av(N, E, Label_part, AV_pares):-
    collect_tst_av(N+1, E, Label_part, AV_pares).

