/*
 *	(C)1993 Institute for New Generation Computer Technology
 *	Read COPYRIGHT for detailed information.
 *
 *
 *	typedef.h	---	Various type definitions.
 *
 */

#include	"vnode.h"


typedef int Boolean;


/* ########## Definitions for Literals ########## */

typedef struct _aformrec {	/* ======== Atomic formula ======== */
  char                 *name;	/* name of this atomic formula      */
  int                  arity;	/* # of arguments                   */
  union _argument_cell *arg;	/* pointer to array of arguments    */
} aformrec;


typedef	struct _argument {
  struct _jointrec *val;	/* value of this argument           */
  int              mark;	/* used for loop-detection          */
  struct {
    int  embedded;		/* TRUE if arg. is embedded         */
    char *varname;		/* variable name for printing       */
  } print;
} argument;


typedef	struct _fspecrec {	/* ==== Feature specification ===== */
  char             *name;	/* name of this feature             */
  struct _jointrec *val;	/* value of this feature            */
  struct _litrlrec *root;	/* pointer to the root of features  */
  struct _litrlrec *prv;	/* pointer to the prev feature      */
  struct _litrlrec *nxt;	/* pointer to the next feature      */
  int              mark;        /* used for loop-detection          */
  struct {
    int  embedded;		/* TRUE if arg. is embedded         */
    char *varname;		/* variable name fot printing       */
  } print;
} fspecrec;


typedef	struct _litrlrec {	/* =========== Literal ============ */
  int               tag;	/* type of this atomic constraint   */
  int               pol;	/* polarity of this literal         */
  double            rel;	/* relevance coefficient            */
  struct {
    double omegaN;              /* omega^N (N = # of literals)      */
    double nOmega;              /* N*omega (N = # of literals)      */
    double disj;		/* disjunction coefficient          */
    double excl;		/* exclusion coefficient            */
    double cmpl;		/* coefficient of completion E      */
    double assm;		/* coefficient of assimulation E    */
  } coeff;
  double            dfrc;	/* force of dependency E            */
  struct _press     *path;	/* ptr to path of the pressure      */
  struct _press     *press;	/* ptr to list of pressure          */
  double            act;	/* activation value                 */
  double            z;		/* temporary starage for backprop.  */
  double	    imp;	/* importance of this atomic constr.*/
  union {
    int              num;	/* number                           */
    char             *sym;	/* symbol                           */
    struct _fspecrec pst;	/* partially specified term         */
    struct _aformrec afm;	/* atomic formula                   */
  } body;
  struct _jointrec  *lefth;	/* left-hand of binding             */
  struct {
    char *varname;		/* variable name fot printing       */
  } print;
  struct _jointrec  *joint;	/* joint of inference link          */
  struct _handlerec *handle;	/* ptr to handle                    */
  struct _pphandle  *pphndl;	/* ptr to pretty print handle       */
  int               lid;	/* literal ID number                */
  int               mark;	/* used for marking                 */
  Boolean           sbsm;       /* TRUE if connected to top-clause  */
  int               misc;	/* for Speech Recignition           */
  struct {			/* used for global control          */
    struct _litrlrec *prv;	/* ptr to the prev literal          */
    struct _litrlrec *nxt;	/* ptr to the next literal          */
  } ctrl;
  VNodeRec          *vnode;	/* used for visualization           */
  struct {
    int              mark;
    struct _litrlrec *nxt;
  } mm;				/* used for memory management       */
} litrlrec;


typedef	struct _pphandle {	/* === Handle for pretty print ==== */
  Boolean           top;	/* TRUE if this is a top clause     */
  struct _litrlrec *body;	/* ptr to body of literal           */
  struct _pphandle *begin;	/* ptr to the beginning of clause   */
  struct _pphandle *next;	/* ptr to the next pprint           */
  struct _pphandle *aux;	/* used for copy clause             */
  VNodeRec         *vnode;	/* used for visualization           */
  struct {
    int              mark;
    struct _pphandle *nxt;
  } mm;				/* used for memory management       */
} pphandle;



/* ########## Definitions for Dependency-links ########## */

typedef	struct _linkrec {	/* ======= Dependency link ======== */
  int                 tag;	/* type of this link                */
  int                 n;	/* # of embedded equations          */
  int                 mark;	/* used for copying/cycle-detection */
  Boolean             explct;   /* TRUE if explicit-display needed  */
  union _linkact_cell *coeff;	/* activation value and temp. str.  */
  double              sub;	/* subsumption coefficient          */
  double              dsub;	/* diff. by subsumption coefficient */
  double              confuse;  /* used for Speech Recognition      */
  struct _dependrec   *ptr[2];	/* pointer to dependency            */
  struct _probe       *probe[2];/* pointer to list of probes        */
  struct _press       *press[2];/* pointer to list of pressure      */
  struct _handlerec   *handle;	/* pointer to handle                */
  struct {			/* used for global control          */
    struct _linkrec *prv;	/* ptr to the prev link             */
    struct _linkrec *nxt;	/* ptr to the next link             */
  } ctrl;
  VNodeRec            *vnode;	/* used for visualization           */
  struct {
    int             mark;
    struct _linkrec *nxt;
  } mm;				/* used for memory management       */
} linkrec;


/*  Structure of literals and inference-link
 *
 *                                               NIL
 *                                                ^
 *         v---\      v---\     v---\     v---\   |  v---\      v---\
 *  litrlrec   jointrec  dependrec  linkrec  dependrec   jointrec   litrlrec
 *     |   \---^      \---^     \---^     \---^  |   \---^ | ^  \---^ ^ ^
 *     V                                         V         V |        | |
 *   arguments (array of *jointrec)             NIL      jointrec-----/ |
 *   features  (list of fspecrec)                          | ^          |
 *                                                         V |          |
 *                                                NIL      ...          |
 *                                                 ^       | ^          |
 *                                                 | v---\ V |          |
 *                                           dependrec   jointrec-------/  
 *                                               | ^ \---^ ^ ^ |
 *                                               V |       | | \->NIL
 *                                           dependrec-----/ |
 *                                               | ^         |
 *                                               V |         |
 *                                               ...         |
 *                                               | ^         |
 *                                               V |         |
 *                                           dependrec-------/
 *                                               |
 *                                               V
 *                                              NIL
 */

typedef	struct _jointrec {	/* ============ Joint ============= */
  Boolean           total;	/* TRUE if this joint is total      */
  int               nth;	/* argument number                  */
  char              *ftr;	/* feature name                     */
  struct _litrlrec  *ltrl;	/* pointer to literal               */
  struct _dependrec *depend;	/* pointer to inference-link        */
  struct _foldrec   *folder;	/* list of joints folding to        */
  struct _foldrec   *foldee;	/* list of joints being folded from */
  struct _jointrec  *prv;	/* ptr to the prev joint            */
  struct _jointrec  *nxt;	/* ptr to the next joint            */
  struct _jointrec  *aux;	/* used when copying                */
  struct {
    int              mark;
    struct _jointrec *nxt;
  } mm;				/* used for memory management       */
} jointrec;



typedef	struct _dependrec {	/* ========== Dependency ========== */
  int               dir;	/* direction (0 or 1)               */
  struct _jointrec  *joint;	/* pointer to joint                 */
  struct _linkrec   *link;	/* pointer to link                  */
  struct _dependrec *prv;	/* pointer to the prev dependrec    */
  struct _dependrec *nxt;	/* pointer to the next dependrec    */
  struct {
    int               mark;
    struct _dependrec *nxt;
  } mm;				/* used for memory management       */
} dependrec;



/*  Structure of literals and equations in arguments
 *
 *  litrlrec -> arg[0] arg[1]  ...  arg[arity-1]
 *               |      |            |
 *               |      |      ...   |
 *               |      V            V    /---v      /---v     /---v       /---v
 *               |     NIL   NIL<-dependrec   jointrec   linkrec   dependrec   litrlrec
 *               |                   |    ^---/      ^---/     ^---/       ^---/
 *               |                   V
 *               |                  NIL
 *               |
 *               V    /---v      /---v     /---v       /---v
 *       NIL<-dependrec   jointrec   linkrec   dependrec   litrlrec
 *               | ^  ^---/      ^---/     ^---/       ^---/
 *               | |
 *               V |  /---v     /---v      /---v       /---v
 *            dependrec   jointrec   linkrec   dependrec   litrlrec
 *               |    ^---/     ^---/      ^---/       ^---/
 *               V
 *              NIL
 */

/*  Structure of literals and equations in features
 *
 *         /--v      /--v      /- ... -v
 *  litrlrec  fspecrec  fspecrec  ...  fspecrec-->NIL
 *             |  |  ^--/   |  ^- ... -/   |  
 *             V  |         |              V /---v      /---v     /---v       /---v
 *            NIL |         V   NIL<-dependrec  jointrec   linkrec   dependrec   litrlrec
 *                |        NIL             | ^---/     ^---/      ^---/       ^---/
 *                |                        V
 *                |                       NIL
 *                |
 *                V    /---v     /---v      /---v       /---v
 *        NIL<-dependrec   jointrec   linkrec   dependrec   litrlrec
 *               | ^   ^---/     ^---/      ^---/       ^---/
 *               | |
 *               V |   /---v     /---v      /---v       /---v
 *             dependrec   jointrec   linkrec   dependrec   litrlrec
 *               |     ^---/     ^---/      ^---/       ^---/
 *               V
 *              NIL
 */



typedef	struct _handlerec {	/* ============ Handle ============ */
  int mark;			/* mark field                       */
  union {
    struct _litrlrec *ltrl;	/* pointer to body of literal       */
    struct _linkrec  *link;	/* pointer to body of link          */
  } body;
  struct {
    int               mark;
    struct _handlerec *nxt;
  } mm;				/* used for memory management       */
} handlerec;


/* ########## Definitions for Subsumption ########## */

typedef	struct _probe {		/* ============ Probe ============= */
  int              dir;		/* direction (0 or 1)               */
  struct _linkrec  *link;	/* pointer to link                  */
  int              nth;		/* argument number                  */
  char             *ftr;	/* feature name                     */
  struct _litrllst *orgns;	/* pointer to origins               */
  struct _probe    *prv;	/* ptr to the prev probe (link)     */
  struct _probe    *nxt;	/* ptr to the next probe (link)     */
  struct {
    struct _probe	*prv;	/* ptr to the prev probe (ctrl)     */
    struct _probe	*nxt;	/* ptr to the next probe (ctrl)     */
  }	ctrl;
  struct {
    int           mark;
    struct _probe *nxt;
  } mm;				/* used for memory management       */
} probe;


typedef	struct _press {		/* =========== Pressure =========== */
  int              dir;		/* direction (0 or 1)               */
  struct _linkrec  *link;	/* pointer to link                  */
  struct _litrlrec *orgn;	/* pointer to origin                */
  int              nth;		/* argument number                  */
  char             *ftr;	/* feature name                     */
  double           strng;	/* strength                         */
  int              dump;	/* dumping degree                   */
  int              dist;	/* distance                         */
  struct _press    *prv;	/* ptr to the prev press (link)     */
  struct _press    *nxt;	/* ptr to the next press (link)     */
  struct {
    struct _press *prv;		/* ptr to the prev press (ctrl)     */
    struct _press *nxt;		/* ptr to the next press (ctrl)     */
  } ctrl;
  struct {
    struct _press *prv;		/* ptr to the prev press (path)     */
    struct _press *nxt;		/* ptr to the next press (path)     */
  } path;
  struct {
    int           mark;
    struct _press *nxt;
  } mm;				/* used for memory management       */
} press;


/*  Structure of detected loops
 *
 *  Gcontrol.loops
 *        |
 *        V
 *      index -> index -> ... -> index -> NULL  (first loop)
 *        |
 *        V
 *      index -> index -> NULL                  (second loop)
 *        |
 *        V
 *       ...                                    (i-th loop)
 *        |
 *        V
 *       NULL
 */

typedef struct _index {
  int              nth;         /* argument number                  */
  struct _litrlrec *node;	/* ptr to the node of the loop      */
  struct _linkrec *link;	/* ptr to the link of the loop      */
  struct _index    *next;	/* ptr to the next index            */
  struct _index    *others;     /* ptr to the next loop             */
  struct {
    int           mark;
    struct _index *nxt;
  } mm;				/* used for memory management       */
} index;



/*  Structure of links and probes
 *
 *         /---v       /---v     /---v      /---v       /---v
 *  litrlrec   dependrec   jointrec   linkrec   dependrec   litrlrec
 *         ^---/       ^---/     ^---/   |  ^---/       ^---/ ^ |
 *                                       |                    | V
 *                             /---------/                 handlerec
 *                             |                              ^
 *                             |                              |
 *                          NIL|        /---------------------/
 *                           ^ |        |
 *                           | V        |   /---v      /---...---v
 *                          probe -> litrllst   litrllst   ...   litrllst -> NIL
 *                           ^ |            ^---/  |   ^---...---/
 *                           | V                   V
 *                           ...                  NIL
 *                           ^ |
 *                           | V            /---v      /---...---v
 *                          probe -> litrllst   litrllst   ...   litrllst -> NIL
 *                             |        |   ^---/      ^---...---/
 *                             V        V
 *                            NIL      NIL
 */

typedef	struct _litrllst {	/* ========= Literal list ========== */
  struct _handlerec *handle;	/* pointer to handle                 */
  struct _litrllst  *prv;	/* pointer to the prev litrllst      */
  struct _litrllst  *nxt;	/* pointer to the next litrllst      */
  struct {
    int              mark;
    struct _litrllst *nxt;
  } mm;				/* used for memory management        */
} litrllst;


/* ########## Definitions for Fold/Unfold transformation ########## */

/*  Structure of inference links and folder record
 *
 *            /----v 
 *     litrlrec    infrcrec.folder <------------------------------\
 *            ^----/          |                                   |
 *                            |                                   |
 *                            V                                   |
 *                  NIL <- foldrec.orgns -> (list of origins)     |
 *                           ^ |  .joint ------------------------------\
 *                           | V                                  |    |
 *                           ...                                  |    |
 *                             |                                  |    |
 *                             V                                  |    |
 *                            NIL                                 |    |
 *                                                                |    |
 *                          NIL                                   |    |
 *                           ^                                    |    |
 *                           |                                    |    |
 *                           ...                                  |    |
 *                           ^ |                                  |    |
 *                           | V                                  |    |
 *                  NIL <- foldrec.orgns -> (list of origins)     |    |
 *                           ^    .joint -------------------------/    |
 *                           |                                         |
 *            /----v         |                                         |
 *     litrlrec    infrcrec.foldee <-----------------------------------/
 *            ^----/
 */

typedef	struct _foldrec {	/* ========== Fold/Unfold ========== */
  int              tag;		/* used for memory manager           */
  struct _litrllst *orgns;	/* pointer to list of origins        */
  struct _jointrec *joint;	/* pointer to inference joint        */
  struct _foldrec  *prv;	/* pointer to the prev foldrec       */
  struct _foldrec  *nxt;	/* pointer to the next foldrec       */
  struct {
    int             mark;
    struct _foldrec *nxt;
  } mm;				/* used for memory management        */
} foldrec;


/* ########## Definition of temporal-use variable (for parsing) ########## */

/*  Structure of variable-records and binding-records
 *
 *    Example: parsing for 'f(X,Y,Z)  X=3;'
 *    ( ["str",nth,ftr] stands for varblrec.name="str"    )
 *    (                                    .nth = nth     )
 *    (                                    .ftr = ftr     )
 *
 *  Gbuf.cnst->["",CONSTANT,NIL]->"abc"      Gbuf.vars->["Y",1,NIL]->f(X,Y,Z)
 *                    |                                      |         ^  ^
 *                    V                                      V         |  |
 *       /--->["",CONSTANT,NIL]->3                          ...        |  |
 *       |            |                                      |         |  |
 *       |            V                                      V         |  |
 *       |           ...                         /----> ["X",0,NIL]----/  |
 *       |            |                          |           |            |
 *       |            V                          |           V            |
 *       |           NIL                         |          ...           |
 *       |                                       |           |            |
 *       |            /-------v      /-------v   |           V            |
 *       \---- bndngrec       conctrec       bndngrec   ["Z",2,NIL]-------/
 *                    ^-------/      ^-------/               |
 *                                                           V
 *                                                          ...
 *                                                           |
 *                                                           V
 *                                                          NIL
 */

typedef	struct _varblrec {	/* ======== Variable record ======== */
  char             *name;	/* variable name                     */
  int              nth;		/* Every variable is regarded as     */
  char             *ftr;	/*        an argument or a feature.  */
  struct _litrlrec *paren;	/* pointer to literal                */
  struct _bndngrec *brecs;	/* pointer to binding record list    */
  struct _varblrec *nxt;	/* pointer to the next varblrec      */
} varblrec;


typedef	struct _bndngrec {	/* ======== Binding record ========= */
  struct _varblrec *var;	/* pointer to variable               */
  struct _conctrec *link;	/* pointer to link                   */
  int              dir;		/* direction (0 or 1)                */
  struct _bndngrec *nxt;	/* pointer to the next bndngrec      */
} bndngrec;


typedef	struct _conctrec {	/* ======= Connection record ======= */
  struct _bndngrec *ptr[2];
  Boolean          explct;	/* TRUE if explicit-display is needed*/
  double           sub;		/* subsumption coefficient           */
} conctrec;


/*
 * Following arglst is used to point arguments until they are reduced
 * into a literal.
 */

typedef	struct _arglst {	/* ========= Argument list ========= */
  struct _varblrec *var;	/* pointer to variable record        */
  struct _arglst   *nxt;	/* pointer to the next arglst       */
} arglst;



/* ########## Memory Management ########## */

typedef	struct _litrlrec_chunk {
  struct _litrlrec_chunk *nxt;
  struct _litrlrec       cell[NUM_OF_LITRLREC];
} litrlrec_chunk;

typedef	struct _linkrec_chunk {
  struct _linkrec_chunk	*nxt;
  struct _linkrec       cell[NUM_OF_LINKREC];
} linkrec_chunk;

typedef	struct _jointrec_chunk {
  struct _jointrec_chunk *nxt;
  struct _jointrec       cell[NUM_OF_JOINTREC];
} jointrec_chunk;

typedef	struct _dependrec_chunk {
  struct _dependrec_chunk *nxt;
  struct _dependrec       cell[NUM_OF_DEPENDREC];
} dependrec_chunk;

typedef	struct _handlerec_chunk {
  struct _handlerec_chunk *nxt;
  struct _handlerec       cell[NUM_OF_HANDLEREC];
} handlerec_chunk;

typedef	struct _probe_chunk {
  struct _probe_chunk *nxt;
  struct _probe       cell[NUM_OF_PROBE];
} probe_chunk;

typedef	struct _press_chunk {
  struct _press_chunk *nxt;
  struct _press       cell[NUM_OF_PRESS];
} press_chunk;

typedef	struct _index_chunk {
  struct _index_chunk *nxt;
  struct _index       cell[NUM_OF_INDEX];
} index_chunk;

typedef	struct _litrllst_chunk {
  struct _litrllst_chunk *nxt;
  struct _litrllst       cell[NUM_OF_LITRLLST];
} litrllst_chunk;

typedef	struct _foldrec_chunk {
  struct _foldrec_chunk *nxt;
  struct _foldrec       cell[NUM_OF_FOLDREC];
} foldrec_chunk;

typedef	struct _pphandle_chunk {
  struct _pphandle_chunk *nxt;
  struct _pphandle       cell[NUM_OF_PPHANDLE];
} pphandle_chunk;



/*
 *  We suppose that
 *       sizeof(struct _argument) > sizeof(struct mm).
 */
typedef	union _argument_cell {
  union _argument_cell *c_nxt;
  struct _argument     body;
  struct {
    int                  mark;
    union _argument_cell *nxt;
  } mm;
} argument_cell;

/*
 *  We suppose that
 *	sizeof(double) > sizeof(struct mm).
 */
typedef	union _linkact_cell {
  union _linkact_cell *c_nxt;
  struct {
    double act;
    double z;
    int mark;
  } body;
  struct {
    int                 mark;
    union _linkact_cell *nxt;
  } mm;
} linkact_cell;

typedef	struct _argument_chunk {
  int                    cell_size;	/* cell size                 */
  int                    chunk_size;	/* chunk size                */
  union _argument_cell   *argument_c;	/* ptr to chunk (cells)      */
  struct _argument_chunk *nxt;		/* ptr to another size chunk */
} argument_chunk;

typedef	struct _linkact_chunk {
  int                 cell_size;	/* cell size                 */
  int                 chunk_size;	/* chunk size                */
  union _linkact_cell *linkact_c;	/* ptr to chunk (cells)      */
  struct _linkact_chunk	*nxt;		/* ptr to another size chunk */
} linkact_chunk;


typedef	struct _argument_root {
  int                   n;		/* cell size                 */
  union _argument_cell  *argument_r;	/* root pointer              */
  struct _argument_root *nxt;		/* ptr to another size root  */
} argument_root;

typedef	struct _linkact_root {
  int                  n;		/* cell size                 */
  union _linkact_cell  *linkact_r;	/* root pointer              */
  struct _linkact_root *nxt;		/* ptr to another size root  */
} linkact_root;



typedef	struct	_varblrec_chunk {
  struct _varblrec_chunk *nxt;
  struct _varblrec       cell[NUM_OF_VARBLREC];
} varblrec_chunk;

typedef	struct	_bndngrec_chunk {
  struct _bndngrec_chunk *nxt;
  struct _bndngrec       cell[NUM_OF_BNDNGREC];
} bndngrec_chunk;

typedef	struct	_conctrec_chunk {
  struct _conctrec_chunk *nxt;
  struct _conctrec       cell[NUM_OF_CONCTREC];
} conctrec_chunk;

typedef	struct	_arglst_chunk {
  struct _arglst_chunk *nxt;
  struct _arglst       cell[NUM_OF_ARGLST];
} arglst_chunk;
