/*
 *	(C)1993 Institute for New Generation Computer Technology
 *	Read COPYRIGHT for detailed information.
 *
 *
 *	delete.c	---	Literal-deletion handling routines.
 *
 */

#include	<stdio.h>

#define	PROTO_DELETE_C
#include	"define.h"
#include	"typedef.h"
#include	"global.h"
#include	"proto.h"
#include	"debug.h"
#undef	PROTO_DELETE_C

#pragma segment	subsume


void disconnect_dependency(depend)
     dependrec *depend;
{
  jointrec *joint;

  joint = depend->joint;
  depend->joint = NULL;
  if (joint == NULL)
    return;
  if (depend->prv != NULL)
    depend->prv->nxt = depend->nxt;
  else
    joint->depend = depend->nxt;
  if (depend->nxt != NULL)
    depend->nxt->prv = depend->prv;
  if (depend->prv == NULL && depend->nxt == NULL && joint->total)
    delete_joint(joint);
  depend->prv = NULL;
  depend->nxt = NULL;
}


void delete_joint(joint)
     jointrec *joint;
{
  litrlrec *ltrl;
  foldrec *fd1, *fd2, *fd3, *fd4;

  if (joint == NULL)
    return;
  ltrl = joint->ltrl;
  disconnect_joint(joint);
  for (fd1 = joint->folder; fd1 != NULL; fd1 = fd2) {
    fd2 = fd1->nxt;
    if (fd1->joint != NULL) {
      for (fd3 = fd1->joint->foldee; fd3 != NULL; fd3 = fd4)
	if (fd3->joint == joint) {
	  dispose_llist(fd3->orgns);
	  if (fd3->prv != NULL)
	    fd3->prv->nxt = fd3->nxt;
	  else	
	    fd1->joint->foldee = fd3->nxt;
	  if (fd3->nxt != NULL)
	    fd3->nxt->prv = fd3->prv;
	  fd4 = fd3->nxt;
	  FREE_foldrec(fd3);
	} else
	  fd4 = fd3->nxt;
    }
    dispose_llist(fd1->orgns);
    FREE_foldrec(fd1);
  }
  for (fd1 = joint->foldee; fd1 != NULL; fd1 = fd2) {
    fd2 = fd1->nxt;
    if (fd1->joint != NULL) {
      for (fd3 = fd1->joint->folder; fd3 != NULL; fd3 = fd3->nxt)
	if (fd3->joint == joint)
	  fd3->joint = NULL;
    }
    dispose_llist(fd1->orgns);
    FREE_foldrec(fd1);
  }
  if (joint->prv == NULL && joint->nxt == NULL)
    delete_literal(ltrl);
  FREE_jointrec(joint);
}


void disconnect_joint(joint)
     jointrec *joint;
{
  litrlrec *literal;

  literal = joint->ltrl;
  joint->ltrl = NULL;
  if (literal == NULL)
    return;
  if (joint->prv != NULL)
    joint->prv->nxt = joint->nxt;
  else
    switch (joint->nth) {
    case UNKNOWN:
      panic("nth == UNKNOWN (`disconnect_joint')", 0);
      break;
    case INFERENCE:
      literal->joint = joint->nxt;
      break;
    case LEFTHAND:
      literal->lefth = joint->nxt;
      break;
    case PSTENTRY:
      literal->body.pst.val = joint->nxt;
      break;
    default:
      literal->body.afm.arg[joint->nth].body.val = joint->nxt;
      break;
    }
  if (joint->nxt != NULL)
    joint->nxt->prv = joint->prv;
}


void delete_literal(literal)
     litrlrec *literal;
{
  int i, tmp;
  dependrec *dpnd0, *dpnd1;
  pphandle *start, *pp0, *pp1;

  if (literal->pol == MARKED)
    return;
  if (Gparams.delete) {
    printf("delete literal: ");
    show_literal(literal);
  }
  Gparams.deletedp = TRUE;
  DisposeLiteralVNode(literal);
  tmp = literal->pol;
  literal->pol = MARKED;
  while (literal->joint != NULL)
    if (literal->joint->depend == NULL)
      delete_joint(literal->joint);
    else
      do {
	literal->joint->total = TRUE;
	dpnd0 = literal->joint->depend;
	dpnd1 = dpnd0->link->ptr[dpnd0->dir];
	literal->joint->depend = dpnd0->nxt;
	if (dpnd0->nxt != NULL)
	  dpnd0->nxt->prv = NULL;
	disconnect_dependency(dpnd1);
	dispose_link(dpnd0->link);
      } while (literal->joint != NULL && literal->joint->depend != NULL);
  switch (literal->tag) {
  case NUMBER:
  case SYMBOL:
    printf("Warning: trying to delete 0-ary predicate(%d).\n", literal->tag);
    break;
  case FUNCTION:
    while (literal->lefth != NULL)
      if (literal->lefth->depend == NULL)
	delete_joint(literal->lefth);
      else
	do {
	  dpnd0 = literal->lefth->depend;
	  dpnd1 = dpnd0->link->ptr[dpnd0->dir];
	  literal->lefth->depend = dpnd0->nxt;
	  if (dpnd0->nxt != NULL)
	    dpnd0->nxt->prv = NULL;
	  disconnect_dependency(dpnd1);
	  dispose_link(dpnd0->link);
	} while (literal->lefth != NULL &&
		 literal->lefth->depend != NULL);
  case CONSTRAINT:		/* `case FUNCTION' also needs following process. */
    if (literal->body.afm.arity > 0 && literal->body.afm.arg != NULL) {
      for (i = 0; i < literal->body.afm.arity; i++)
	while (literal->body.afm.arg[i].body.val != NULL) {
	  if (literal->body.afm.arg[i].body.val->depend == NULL)
	    delete_joint(literal->body.afm.arg[i].body.val);
	  else
	    do {
	      dpnd0 = literal->body.afm.arg[i].body.val->depend;
	      dpnd1 = dpnd0->link->ptr[dpnd0->dir];
	      literal->body.afm.arg[i].body.val->depend = dpnd0->nxt;
	      if (dpnd0->nxt != NULL)
		dpnd0->nxt->prv = NULL;
	      disconnect_dependency(dpnd1);
	      dispose_link(dpnd0->link);
	    } while (literal->body.afm.arg[i].body.val != NULL &&
		     literal->body.afm.arg[i].body.val->depend != NULL);
	}
      FREE_argument(literal->body.afm.arg);
    }
    break;
  case PSTERM:
    while (literal->lefth != NULL) {
      if (literal->lefth->depend == NULL)
	delete_joint(literal->lefth);
      else
	do {
	  dpnd0 = literal->lefth->depend;
	  dpnd1 = dpnd0->link->ptr[dpnd0->dir];
	  literal->lefth->depend = dpnd0->nxt;
	  if (dpnd0->nxt != NULL)
	    dpnd0->nxt->prv = NULL;
	  disconnect_dependency(dpnd1);
	  dispose_link(dpnd0->link);
	} while (literal->lefth != NULL &&
		 literal->lefth->depend != NULL);
    }
    while (literal->body.pst.nxt != NULL)
      delete_literal(literal->body.pst.nxt);
    break;
  case FEATURE:
    if (literal->body.pst.prv != NULL)
      literal->body.pst.prv->body.pst.nxt = literal->body.pst.nxt;
    else
      literal->body.pst.root->body.pst.nxt = literal->body.pst.nxt;
    if (literal->body.pst.nxt != NULL)
      literal->body.pst.nxt->body.pst.prv = literal->body.pst.prv;
    delete_literal(literal->body.pst.root);
    while (literal->body.pst.val != NULL)
      if (literal->body.pst.val->depend == NULL)
	delete_joint(literal->body.pst.val);
      else
	do {
	  dpnd0 = literal->body.pst.val->depend;
	  dpnd1 = dpnd0->link->ptr[dpnd0->dir];
	  literal->body.pst.val->depend = dpnd0->nxt;
	  if (dpnd0->nxt != NULL)
	    dpnd0->nxt->prv = NULL;
	  disconnect_dependency(dpnd1);
	  dispose_link(dpnd0->link);
	} while (literal->body.pst.val != NULL &&
		 literal->body.pst.val->depend != NULL);
    break;
  default:
    panic("unknown type of literal (%d) (`delete_literal')",
	  literal->tag);
    break;
  }
  /* remove ALL pretty print handle if any pp-handle remains */
  /***** THIS STRATEGY IS SPECIFIC TO CLAUSE-DELETION !! *****/
  if (literal->pphndl != NULL) {
    /*
     * clear all dereference pointer in order for another deletion
     * not to remove this pp-handle list.
     */
    start = literal->pphndl->begin;
    for (pp0 = literal->pphndl->begin; pp0 != NULL; pp0 = pp0->next)
      pp0->body->pphndl = NULL;
    for (pp0 = start; pp0 != NULL; pp0 = pp1) {
      pp1 =  pp0->next;
      pp0->body->pphndl = NULL;
      if (pp0->body != literal &&
	  pp0->body->tag != SYMBOL && pp0->body->tag != NUMBER)
	delete_literal(pp0->body);
      DisposePPHandleVNode(pp0);
      FREE_pphandle(pp0);
    }
  }
  if (literal->ctrl.prv != NULL)
    literal->ctrl.prv->ctrl.nxt = literal->ctrl.nxt;
  else {
    if (tmp == UNSIGNED)
      Gcontrol.unsigned_preds = literal->ctrl.nxt;
    else
      Gcontrol.signed_preds = literal->ctrl.nxt;
  }
  if (literal->ctrl.nxt != NULL)
    literal->ctrl.nxt->ctrl.prv = literal->ctrl.prv;
  if (literal->handle != NULL)
    literal->handle->body.ltrl = NULL;
  dispose_pressure_list(literal->press);
  FREE_litrlrec(literal);
}


void delete_link(link)
     linkrec *link;
{
  handlerec *handle;

  handle = get_link_handle(link);
  disconnect_dependency(link->ptr[1]);
  if (handle->body.link != NULL) {
    disconnect_dependency(link->ptr[0]);
    dispose_link(link);
  }
}


void dispose_link(link)
     linkrec *link;
{
  press *prss1, *prss2;
  probe *prb1, *prb2;

  FREE_dependrec(link->ptr[0]);
  FREE_dependrec(link->ptr[1]);
  for (prss1 = link->press[0]; prss1 != NULL; prss1 = prss2) {
    prss2 = prss1->nxt;
    dispose_pressure(prss1);
  }
  for (prss1 = link->press[1]; prss1 != NULL; prss1 = prss2) {
    prss2 = prss1->nxt;
    dispose_pressure(prss1);
  }
  for (prb1 = link->probe[0]; prb1 != NULL; prb1 = prb2) {
    prb2 = prb1->nxt;
    dispose_llist(prb1->orgns);
    detach_probe(prb1);
    FREE_probe(prb1);
  }
  for (prb1 = link->probe[1]; prb1 != NULL; prb1 = prb2) {
    prb2 = prb1->nxt;
    dispose_llist(prb1->orgns);
    detach_probe(prb1);
    FREE_probe(prb1);
  }
  if (link->handle != NULL)
    link->handle->body.link = NULL;
  if (link->ctrl.nxt != NULL)
    link->ctrl.nxt->ctrl.prv = link->ctrl.prv;
  if (link->ctrl.prv != NULL)
    link->ctrl.prv->ctrl.nxt = link->ctrl.nxt;
  else
    Gcontrol.links = link->ctrl.nxt;
  DisposeLinkVNode(link);
  FREE_linkact(link->coeff);
  FREE_linkrec(link);
}
