/*
 *	(C)1993 Institute for New Generation Computer Technology
 *	Read COPYRIGHT for detailed information.
 *
 *
 *	define.h	---	Definitions of constants and macros.
 *
 */


/* name of `cons'-function and `nil'*/
#define	CONS_NAME	"cons"
#define	NIL_NAME	"nil"

/* max of ID number */
#define	MAXIDNUM	10000
#define	MAXIDEXP	6

/* to avoid error in real arithmetics */
#define	ZERO	0
#define	NONZERO	1

/* types of polarity */
#define	UNSIGNED	0
#define	POSITIVE	1
#define COST_POSITIVE	2
#define	NEGATIVE	-1
#define COST_NEGATIVE	-2
#define	MARKED		-3		/* used for deletion */

/* relation between atomic constraint */
#define UNSUBSUMABLE 0
#define SUBSUMABLE 1
#define SUBSUMED 2

/* marker for memory management */
#define	FREED		-99999
#define	USED		99999

/* types of atomic constraint */
#define	SYMBOL		1
#define	NUMBER		2
#define	FUNCTION	3
#define	PSTERM		4
#define	FEATURE		5
#define	CONSTRAINT	6

/* types of joint / link / pressure */
#define	INFERENCE	-100	/* type of joint / link    */
#define	EQUATION	-200	/* type of link / pressure */
#define	PSTENTRY	-300	/* type of joint           */
#define	LEFTHAND	-400	/* type of joint           */
#define	PSEUDO		-500	/* type of pressure        */
#define	UNKNOWN		-999

/* initial values for spreading activation */
#define EQUAL_INIT	1.0
#define LINK_INIT	0.5
#define	LITERAL_INIT	0.5

/* default values of coefficients */
#define OMEGA		0.8
#define	REL_DEFAULT	1.0
#define	CMPL_DEFAULT	1.0
#define	DISJ_DEFAULT	1.0
#define	EXCL_DEFAULT	1.0
#define	ASSM_DEFAULT	1.0

#define	EQUAL_SUBS_DEFAULT	1.0
#define	STRNG_SUBS_DEFAULT	0.9
#define WEAK_SUBS_DEFAULT	0.1

/*
 * (used only in simulation of speech-recognition)
 * default coefficients of the following clause:
 *     SPEECH_i(X0,Y0) -#phon(X0)=X1
 *     -SOUND_i(Y0,Y1) -SPEECH_j(X1,Y1) :D/C.
 */
#define S_FRAME_REL_DEFAULT	1.0
#define E_FRAME_REL_DEFAULT	0.9
#define TIME_REL_DEFAULT	0.9
#define PHONEME_REL_DEFAULT	0.9
#define FRAME_DISJ_DEFAULT	0.8
#define FRAME_EXCL_DEFAULT	1.2

/* upper bound of ctmp (= 1/(2-log4)) */
#define MAX_CTMP 1.6294457

/* types of subsumption */
#define NEED_NOT                0
#define BETWEEN_ACONSTRAINT	1
#define BETWEEN_ARGUMENTS	2

/* status of DCP-system */
#define	PREPARING	1
#define	STOPPED		2
#define	FINISHED	3
#define	UNCONVERGED	4
#define	QUIT		5
#define	ERROR		-999

/* trace levels */
#define	NOT_BREAK	0
#define	DELETION	1
#define	COPYING		2
#define	UNCONVRG	4
#define	EACH_STEP	8

/* optional functions */
#define NONE		0
#define SPEECH_RECOG	1
#define JOINT_UTTER	2

/* Size of the text-buffer */
#define	ROWS		70
#define	COLUMNS		50
#define	BUFFSIZE	80


#define	TRUE		1
#define	FALSE		0


/* ########## Macros for Command processing ########## */
#ifdef	UNIX
#define	prompt(fmt, msg)	printf((fmt), (msg))
#else
#define	prompt(fmt, msg)	{ printf((fmt), (msg)); putchar('\n');	}
#endif	UNIX


#include	<math.h>

/* ########## Macros for Parsing ########## */

#define new_equation_joint(ltrl, nth, ftr)\
  (new_joint((ltrl), TRUE, (nth), (ftr)))

#define	new_inference_joint(ltrl, total)\
  (new_joint((ltrl), (total), INFERENCE, ""))

#define	new_equation_link(d0, d1, explct)\
  (new_link(EQUATION, 1, (explct), (d0), (d1)))

#define	new_inference_link(i0, i1, n)\
  (new_link(INFERENCE, (n), TRUE, (i0), (i1)))

#define	BREAKP\
{ fprintf(stderr, "b+'enter':break\n");\
    if (getchar() == 'b') exit(1);	}


/* ########## Macros for Subsumption ########## */

#define	dominate(j)\
  ((j)->total && (j)->depend != NULL &&\
   (j)->depend->prv == NULL && (j)->depend->nxt == NULL)

#define	injection(l)\
  ((l)->tag == EQUATION ||\
   (l)->ptr[0]->joint->total || (l)->ptr[1]->joint->total)

#define	coupled(nth1,ftr1,nth2,ftr2)\
  (((nth1) == PSTENTRY && (nth2) == PSTENTRY && strcmp((ftr1), (ftr2)) == 0) ||\
   (nth1) == (nth2))

#define DIRECT(dir, link)\
  (((dir) == 0 || (dir) == 1) ? (dir) :\
   (fabs((link)->ptr[0]->joint->ltrl->imp) >\
    fabs((link)->ptr[1]->joint->ltrl->imp) ? 1 : 0))

/* ########## Macros for Spreading Activation ########## */

#define negP(x)\
  (1.0/(1.0+exp((x)/Gparams.stmp)))
/*  ((x) < 0.0 ? 1.0 : 0.0) */

#define nAct(x)\
  (((x) < Gparams.epsilon || 1.0-Gparams.epsilon < (x)) ?\
   (x) : (x) - Gparams.atmp*((x)*log(x) - (1.0-(x))*log(1.0-(x))))

#define nActV(ltrl)\
  ((ltrl)->pol == NEGATIVE || (ltrl)->pol == COST_NEGATIVE ?\
   1.0 - nAct((ltrl)->act) : nAct((ltrl)->act))

#define nDXDx(x)\
  (((x) < Gparams.epsilon) ? 1.0 + Gparams.atmp*1000.0 :\
   (((x) > 1.0-Gparams.epsilon) ? 1.0 - Gparams.atmp*1000.0 :\
    (1.0 - Gparams.atmp*(log(x) + log(1.0-(x)) + 2.0))))

#define nD2XDx2(x)\
  (((x) < Gparams.epsilon) ? - Gparams.atmp*1000.0 :\
   (((x) > 1.0-Gparams.epsilon) ? Gparams.atmp*1000.0 :\
     (-Gparams.atmp*(1.0-2.0*(x))/((x)*(1.0-(x))))))


/*=== for SPEECH RECOGNITION ===*/
#define N_PHONE 43
#define N_BEST 100


/* the # of units which memory manager gets from system */
#ifdef	UNIX

#define	NUM_OF_LITRLREC		1000
#define	NUM_OF_LINKREC		3000
#define	NUM_OF_JOINTREC		4000
#define	NUM_OF_DEPENDREC	4000
#define	NUM_OF_HANDLEREC	1000
#define	NUM_OF_PROBE		3000
#define	NUM_OF_PRESS		4000
#define NUM_OF_INDEX		4000
#define	NUM_OF_TRANS		4000
#define	NUM_OF_LITRLLST		3000
#define	NUM_OF_FOLDREC		3000
#define	NUM_OF_PPHANDLE		3000
#define	NUM_OF_VNODEREC		3000

#define	NUM_OF_ARGUMENT		400
#define	NUM_OF_LINKACT		400

#define	NUM_OF_VARBLREC		2000
#define	NUM_OF_BNDNGREC		4000
#define	NUM_OF_CONCTREC		2000
#define	NUM_OF_ARGLST		2000

#else	/* for smaller computers ... */

#define	NUM_OF_LITRLREC		100
#define	NUM_OF_LINKREC		300
#define	NUM_OF_JOINTREC		400
#define	NUM_OF_DEPENDREC	400
#define	NUM_OF_HANDLEREC	100
#define	NUM_OF_PROBE		300
#define	NUM_OF_PRESS		400
#define NUM_OF_INDEX		400
#define	NUM_OF_TRANS		400
#define	NUM_OF_LITRLLST		300
#define	NUM_OF_FOLDREC		300
#define	NUM_OF_PPHANDLE		300
#define	NUM_OF_VNODEREC		300

#define	NUM_OF_ARGUMENT		40
#define	NUM_OF_LINKACT		40

#define	NUM_OF_VARBLREC		100
#define	NUM_OF_BNDNGREC		200
#define	NUM_OF_CONCTREC		100
#define	NUM_OF_ARGLST		100

#endif	UNIX
