/*
 *	(C)1993 Institute for New Generation Computer Technology
 *	Read COPYRIGHT for detailed information.
 *
 *
 *	control.c	---	Probe-control routines.
 *
 */

#include	<stdio.h>

#define	PROTO_CONTROL_C
#include	"define.h"
#include	"typedef.h"
#include	"global.h"
#include	"proto.h"
#include	"debug.h"
#undef	PROTO_CONTROL_C

#pragma segment	command


void generate_probes()
{
  litrlrec *l;
  jointrec *j, *jj, *fromjoint;
  dependrec *d, *dd;
  litrllst *orgns;

  if (Gparams.option == SPEECH_RECOG) {
    hmm_score(0);
    printf("Read top phonemes ");
    new_phonemes(0, NULL);
    printf(" done\n");
  }
  printf("Generating probes ");
  for (l = Gcontrol.signed_preds; l != NULL; l = l->ctrl.nxt) {
    if (l->tag == PSTERM)
      continue;
    if (l->tag == FEATURE)
      fromjoint = l->body.pst.root->lefth;
    else
      fromjoint = l->lefth;
    for (j = fromjoint; j != NULL; j = j->nxt)
      for (d = j->depend; d != NULL; d = d->nxt) {
	dd = d->link->ptr[d->dir];
	jj = dd->joint;
	orgns = addto_llist(NULL, l);
	put_probe(d->link, orgns, d->dir, jj->nth, jj->ftr);
	putchar('.');
      }
  }
  printf(" done\n");
}


probe *choose_probe(nocopy, mpriority)
     Boolean *nocopy;
     double *mpriority;
{
  probe *prb, *mprb, *temp;

  mprb = NULL;
  *nocopy = FALSE;
  *mpriority = 0.0;
  for (prb = Gcontrol.probes; prb != NULL; prb = temp) {
    temp = prb->ctrl.nxt;
    gc_probe(prb);
    if (prb->orgns == NULL) {
      detach_probe(prb);
      FREE_probe(prb);
      continue;
    } else if (subsumable_probe(prb)) {
      mprb = prefer_probe(nocopy, mpriority, prb, mprb);
      if (*nocopy)
	break;
    }
  }
  return mprb;
}


Boolean subsumable_probe(prb)
     probe *prb;
{
  litrllst *orgn;
  press *prss;
  int s, subs, usubs;

  /*
   * If the probe is on the weak equation, this probe cannot
   * be advanced.
   */
  if (!prb->link->ptr[0]->joint->total &&
      !prb->link->ptr[1]->joint->total)
    return FALSE;
  /*
   * If the probe is on the intra equation in the top clause,
   * this probe should be advanced.
   */
  if (prb->link->tag == EQUATION &&
      prb->link->ptr[prb->dir]->joint->ltrl->sbsm)
    return TRUE;
  /*
   * If the probe does not direct from literal which is connected to
   * literal the top clause subsumes, this probe should not
   * be advanced. (except for trivial subsumption)
   */
  if (!prb->link->ptr[1-prb->dir]->joint->ltrl->sbsm)
    return FALSE;
  /*
   * If the prove devides the top clause, this prove should not be
   * advanced.
   */
  if (prb->link->ptr[prb->dir]->joint->ltrl->pphndl == NULL ||
      prb->link->ptr[prb->dir]->joint->ltrl->pphndl->top)
    return FALSE;
  /*
   * If there are any pressures whose origin has greater
   * importance value than the origins of the probe,
   * this probe cannot be advanced.
   */
  subs = usubs = 0;
  for (orgn = prb->orgns; orgn != NULL; orgn = orgn->nxt)
    if (orgn->handle->body.ltrl != NULL) {
      if (Gparams.option == SPEECH_RECOG) {
	if (orgn->handle->body.ltrl->tag == FEATURE &&
	    orgn->handle->body.ltrl->body.pst.name[0] == '!')
	  return FALSE;
      }
      for (prss = prb->link->press[1-prb->dir];
	   prss != NULL; prss = prss->nxt)
	if (prb->link->tag == EQUATION ||
	    coupled(prss->nth, prss->ftr, prb->nth, prb->ftr)) {
	  if (fabs(prss->orgn->imp) > fabs(orgn->handle->body.ltrl->imp))
	    return FALSE;
	  s = subsumable(orgn->handle->body.ltrl, prss->orgn);
	  if (s == SUBSUMABLE)
	    subs++;
	  else
	    usubs++;
	}
    }
  /*
   * If no origins of pressures are strongly unifiable to
   * the probe's origins, this probe cannot be advanced.
   */
  if (subs == 0)
    return FALSE;
  else
    return TRUE;
}


int subsumable(literal1, literal2)
     litrlrec *literal1;
     litrlrec *literal2;
{
  jointrec *jnt;
  dependrec *dpnd;
  Boolean found;

  if (literal1 == literal2)
    return SUBSUMABLE;
  found = FALSE;
  for (jnt = literal1->joint; jnt != NULL; jnt = jnt->nxt)
    for (dpnd = jnt->depend; dpnd != NULL; dpnd = dpnd->nxt)
      if (dpnd->link->ptr[dpnd->dir]->joint->ltrl == literal2) {
	if (jnt->total)
	  return SUBSUMED;
	else
	  found = TRUE;
      }
  if (found)
    return SUBSUMABLE;
  else
    return UNSUBSUMABLE;
}


probe *prefer_probe(nocopy, mpriority, prb, mprb)
     int *nocopy;
     double *mpriority;
     probe *prb;
     probe *mprb;
{
  double priority;

  priority = fabs(prb->link->dsub);
  if (mprb == NULL) {
    *nocopy = dominate(prb->link->ptr[prb->dir]->joint);
    *mpriority = priority;
    return prb;
  }
  /*
   * If this subsumption is trivial (i.e. without copying),
   * this probe should be advanced.
   */
  if (dominate(prb->link->ptr[prb->dir]->joint)) {
    *nocopy = TRUE;
    *mpriority = priority;
    return prb;
  }
  /*
   * the probe which has greater priority (= dP/ds) is
   * preferable.
   */
  if (*mpriority < priority) {
    *mpriority = priority;
    return prb;
  } else if (*mpriority > priority)
    return mprb;
  /*
   * the probe whose origin belongs to top clause is
   * preferable.
   */
  if (mprb->orgns->handle->body.ltrl->pphndl != NULL &&
      prb->orgns->handle->body.ltrl->pphndl != NULL) {
    if (!mprb->orgns->handle->body.ltrl->pphndl->top &&
	prb->orgns->handle->body.ltrl->pphndl->top) {
      *mpriority = priority;
      return prb;
    }
    if (mprb->orgns->handle->body.ltrl->pphndl->top &&
	!prb->orgns->handle->body.ltrl->pphndl->top)
      return mprb;
  }
  return mprb;
}
