/*
 *	(C)1993 Institute for New Generation Computer Technology
 *	Read COPYRIGHT for detailed information.
 *
 *
 *	command.c	---	Command processing routines.
 *
 */

#include	<stdio.h>

#define	PROTO_COMMAND_C
#include	"config.h"
#include	"define.h"
#include	"typedef.h"
#include	"global.h"
#include	"proto.h"
#include	"command.h"
#include	"debug.h"
#undef	PROTO_COMMAND_C

#pragma segment	command

#define	EQ(a,b)	(strcmp((a),(b)) == 0)


Boolean ProcessCommand(buffer, dont_spread)
     char *buffer;
     Boolean dont_spread;
{
  int i;
  char *ptr, *word;

  ptr = buffer;
  word = get_word(&ptr);
  if (word[0] == '\0')
    /* subsumption command */
    switch (Gparams.state) {
    case PREPARING:
      printf("Please load program first.\n");
      return TRUE;
      break;
    case FINISHED:
      printf("Process has already finished.\n");
      return TRUE;
      break;
    case ERROR:
      printf("Please reset first.\n");
      return TRUE;
      break;
    default:
      if (dont_spread)
	return TRUE;
      for (;;) {
	/* ----- Spreading Activations ----- */
	Gparams.cnvrgdp = FALSE;
	SpreadingActivation();
	if (!Gparams.cnvrgdp &&
	    (Gparams.trace == EACH_STEP || (Gparams.trace & UNCONVRG))) {
	  Gparams.state = UNCONVERGED;
	  return TRUE;
	}
	/* ----- Choosing a Candidate of Subsumption ----- */
	Backpropagation();
	/* ----- Subsumption ----- */
	Gparams.copiedp = FALSE;
	Gparams.deletedp = FALSE;
	if (! check_special_literal())
	  Subsumption();
	if (Gparams.state == FINISHED)
	  return TRUE;
	if (Gparams.trace == EACH_STEP ||
	    ((Gparams.trace & DELETION) && Gparams.deletedp) ||
	    ((Gparams.trace & COPYING) && Gparams.copiedp)) {
	  Gparams.state = STOPPED;
	  return TRUE;
	}
      }
      break;
    }
  /* other commands */
  for (i = 0; ctable[i].name != NULL; i++)
    if (EQ(word, ctable[i].name) ||
	(ctable[i].abbrev != NULL && EQ(word, ctable[i].abbrev)))
      return (ctable[i].func)(ptr);
  printf("Unknown command. (`help' or `?' for help)\n");
  return TRUE;
}


void SpreadingActivation()
{
  Gparams.cnvrgdp = FALSE;
  calc_dependency_energy();
  check_combinatorial_contradiction();
  calc_dependency_energy();
  check_binding_contradiction();
  spread_activation(Gparams.itrmax);
  if (!Gparams.cnvrgdp)
    Gparams.state = UNCONVERGED;
  else
    Gparams.state = STOPPED;
}


void Backpropagation()
{
  int dir, nocopy;
  probe *prb;
  linkrec *link;
  double priority1, priority2;

  Gparams.cnvrgdp = FALSE;
  nocopy = FALSE;
  link = choose_link(&dir, &priority1);
  prb = choose_probe(&nocopy, &priority2);
  if (!Gparams.cnvrgdp)
    Gparams.state = UNCONVERGED;
  else
    Gparams.state = STOPPED;
/*### TEMPORAL ###*/
  printf("priority1=%.16lf, link=%x,\npriority2=%.16lf, prb=%x\n",
	 priority1, link, priority2, prb);
  SetCandidate(link, dir, priority1, prb, nocopy, priority2);
}


void SetCandidate(link, dir, priority1, prb, nocopy, priority2)
     linkrec *link;
     int dir;
     double priority1;
     probe *prb;
     int nocopy;
     double priority2;
{
  if (prb == NULL) {
    /* exception: no probe is available */
    if (link == NULL || priority1 <= Gparams.subsTH) {
      Gparams.state = FINISHED;
      Gcontrol.candidate.c = NEED_NOT;
      Gcontrol.candidate.link = NULL;
      Gcontrol.candidate.dir = -1;
      Gcontrol.candidate.probe = NULL;
    } else {
      Gcontrol.candidate.c = BETWEEN_ACONSTRAINT;
      Gcontrol.candidate.link = link;
      Gcontrol.candidate.dir = DIRECT(dir, link);
      Gcontrol.candidate.probe = NULL;
    }
  } else if (nocopy) {
    /* exception: trivial subsumption */
    Gcontrol.candidate.c = BETWEEN_ARGUMENTS;
    Gcontrol.candidate.link = prb->link;
    Gcontrol.candidate.dir = prb->dir;
    Gcontrol.candidate.probe = prb;
  } else {
    /* comparison of the priorities (= dP/ds) */
    if (priority1 > priority2) {
      /* `between atomic constraint' is chosen... */
      if (priority1 <= Gparams.subsTH) {
	Gparams.state = FINISHED;
	Gcontrol.candidate.c = NEED_NOT;
	Gcontrol.candidate.link = NULL;
	Gcontrol.candidate.dir = -1;
	Gcontrol.candidate.probe = NULL;
      } else {
	Gcontrol.candidate.c = BETWEEN_ACONSTRAINT;
	Gcontrol.candidate.link = link;
	Gcontrol.candidate.dir = DIRECT(dir, link);
	Gcontrol.candidate.probe = NULL;
      }
    } else {
      /* `between argument' is chosen... */
      if (priority2 <= Gparams.subsTH) {
	Gparams.state = FINISHED;
	Gcontrol.candidate.c = NEED_NOT;
	Gcontrol.candidate.link = NULL;
	Gcontrol.candidate.dir = -1;
	Gcontrol.candidate.probe = NULL;
      } else {
	Gcontrol.candidate.c = BETWEEN_ARGUMENTS;
	Gcontrol.candidate.link = prb->link;
	Gcontrol.candidate.dir = prb->dir;
	Gcontrol.candidate.probe = prb;
      }
    }
  }
}


void Subsumption()
{
  switch (Gcontrol.candidate.c) {
  case BETWEEN_ACONSTRAINT:
    inter_clausal_subsumption(Gcontrol.candidate.link,
			      Gcontrol.candidate.dir);
    break;
  case BETWEEN_ARGUMENTS:
    subsume(Gcontrol.candidate.probe);
    break;
  case NEED_NOT:
  default:
    /* need not process */
    break;
  }
}


Boolean print_help(s)
     char *s;
{
  int i;

  printf("   Command      Abbrev     Arguments       : Instruction\n");
  printf("   ----------------------------------------+----------------------------\n");
  for (i = 0; ctable[i].name != NULL; i++) {
  printf("   %-8s     ", ctable[i].name);
    if (ctable[i].abbrev != NULL)
      printf("%-4s       ", ctable[i].abbrev);
    else
      printf("           ");
    printf("%s\n", ctable[i].help);
  }
  return TRUE;
}


Boolean backprop(s)
     char *s;
{
  linkrec *link;

  if (Gparams.state == PREPARING) {
    printf("Please load program first.\n");
    return TRUE;
  }
  Backpropagation();
  if (Gcontrol.candidate.link != NULL) {
    link = Gcontrol.candidate.link;
    printf("\nCandidate of next subsumption is...");
    printf("\n  From: ");
    print_literal(link->ptr[1-Gcontrol.candidate.dir]->joint->ltrl);
    printf("\n    To: ");
    print_literal(link->ptr[Gcontrol.candidate.dir]->joint->ltrl);
    if (Gcontrol.candidate.c == BETWEEN_ACONSTRAINT)
      printf("\n  (Between atomic constraint.)\n");
    else
      printf("\n  (Between arguments.)\n");
  }
  return TRUE;
}


Boolean list_forceA(argv)
     char *argv;
{
  printf("### Atomic Constraints\n");
  print_aconstr_forces();
  return TRUE;
}


Boolean list_forceS(argv)
     char *argv;
{
  printf("### Strong links\n");
  print_link_forces(TRUE);
  return TRUE;
}


Boolean list_forceW(argv)
     char *argv;
{
  printf("### Weak links\n");
  print_link_forces(FALSE);
  return TRUE;
}


Boolean info_links(argv)
     char *argv;
{
  int i, lines, num;
  char text[COLUMNS][ROWS];
  litrlrec *ltrl;
  jointrec *jnt0;
  dependrec *dpnd0;

  num = 0;
  sscanf(argv, "%d", &num);
  for (ltrl = Gcontrol.signed_preds; ltrl != NULL; ltrl = ltrl->ctrl.nxt)
    if (ltrl->lid == num)
      break;
  if (ltrl == NULL)
    for (ltrl = Gcontrol.unsigned_preds; ltrl != NULL; ltrl = ltrl->ctrl.nxt)
      if (ltrl->lid == num)
	break;
  if (ltrl == NULL) {
    printf("Can't find the literal whose ID=%d\n", num);
    return TRUE;
  }
  printf("Inference-links from `");
  print_literal(ltrl);
  printf("' are ...\n\n");
  for (jnt0 = ltrl->joint; jnt0 != NULL; jnt0 = jnt0->nxt)
    for (dpnd0 = jnt0->depend; dpnd0 != NULL; dpnd0 = dpnd0->nxt) {
      lines = SetLinkInformation(text, dpnd0->link, dpnd0->dir);
      for (i = 0; i < lines; i++)
	printf("%s\n", text[i]);
      printf("\n---\n");
    }
  return TRUE;
}


Boolean list_prog(argv)
     char *argv;
{
  litrlrec *t;

  if (Gparams.state == PREPARING) {
    printf("Please load program first.\n");
    return TRUE;
  } else {
    if (Gparams.state == ERROR && risky_alart("list"))
      return TRUE;
    for (t = Gcontrol.unsigned_preds; t != NULL; t = t->ctrl.nxt)
      t->mark = FALSE;
    for (t = Gcontrol.signed_preds; t != NULL; t = t->ctrl.nxt)
      t->mark = FALSE;
    print_clauses();
  }
  return TRUE;
}


Boolean list_probes(argv)
     char *argv;
{
  Boolean sw;
  char *word;
  probe *prb;

  word = get_word(&argv);
  sw = EQ(word, "all");
  if (Gparams.state == ERROR && risky_alart("list"))
    return TRUE;
  for (prb = Gcontrol.probes; prb != NULL; prb = prb->ctrl.nxt)
    print_probe(prb, sw);
  return TRUE;
}


Boolean load_prog(argv)
     char *argv;
{
  char *word;

  if (Gparams.state != PREPARING) {
    if (confirm("Do you want to reset current state ?"))
      reset_state();
    else
      return TRUE;
  }
  word = get_word(&argv);
  strcpy(Gparams.fname, word);
  if (load_program(FALSE))
    generate_probes();
  return TRUE;
}


Boolean load_prog_e(argv)
     char *argv;
{
  char *word;

  if (Gparams.state != PREPARING) {
    if (confirm("Do you want to reset current state ?"))
      reset_state();
    else
      return TRUE;
  }
  word = get_word(&argv);
  strcpy(Gparams.fname, word);
  if (load_program(TRUE))
    generate_probes();
  return TRUE;
}


Boolean list_loops(s)
     char *s;
{
  index *loop, *indx;

  for (loop = Gcontrol.loops; loop != NULL; loop = loop->others) {
    putchar('\n');
    for (indx = loop; indx != NULL; indx = indx->next) {
      if (indx->nth == LEFTHAND)
	printf(" nth=LH, ");
      else if (indx->nth == PSTENTRY)
	printf(" nth=PST, ");
      else
	printf(" nth=%d, ", indx->nth);
      print_literal(indx->node);
      putchar('\n');
    }
  }
  printf("\n\n");
  return TRUE;
}


Boolean switch_on(argv)
     char *argv;
{
  set_options(TRUE, argv);
  return TRUE;
}


Boolean switch_off(argv)
     char *argv;
{
  set_options(FALSE, argv);
  return TRUE;
}


Boolean quit(s)
     char *s;
{
  if (Gparams.state != FINISHED && Gparams.state != PREPARING) {
    if (!confirm("Do you really want to quit?"))
      return TRUE;
  }
  return FALSE;
}


Boolean set_param(argv)
     char *argv;
{
  char *word;

  word = get_word(&argv);
  set_parameter(word, argv);
  return TRUE;
}


Boolean spreading(s)
     char *s;
{
  if (Gparams.state == PREPARING) {
    printf("Please load program first.\n");
    return TRUE;
  }
  SpreadingActivation();
  return TRUE;
}


Boolean reset_system(s)
     char *s;
{
  if (Gparams.state != ERROR) {
    if (!confirm("Do you really want to reset?"))
      return TRUE;
  }
  reset_state();
  return TRUE;
}


Boolean print_status(s)
     char *s;
{
  int i, lines;
  char text[COLUMNS][ROWS];

  lines = SetStatus(text);
  for (i = 0; i < lines; i++)
    printf("%s\n", text[i]);
  return TRUE;
}


Boolean set_options(sw, buffer)
     Boolean sw;
     char *buffer;
{
  char *ptr, *word;

  for (ptr = buffer; *ptr != '\0'; ) {
    word = get_word(&ptr);
    if (EQ(word, "subsume"))
      Gparams.subsume = sw;
    else if (EQ(word, "delete"))
      Gparams.delete = sw;
    else if (EQ(word, "copy"))
      Gparams.copy = sw;
    else if (EQ(word, "disj"))
      Gparams.disjSW = sw;
    else if (EQ(word, "excl"))
      Gparams.exclSW = sw;
    else if (EQ(word, "cmpl"))
      Gparams.cmplSW = sw;
    else if (EQ(word, "assm"))
      Gparams.assmSW = sw;
    else if (EQ(word, "eqlz"))
      Gparams.eqlzSW = sw;
    else if (EQ(word, "trns"))
      Gparams.trnsSW = sw;
    else if (EQ(word, "fixact"))
      Gparams.fixact = sw;
    else
      printf("unknown option `%s' (ignored)\n", word);
  }
}


char *get_word(strt)
     char **strt;
{
  char *word;

  /* skip white-space */
  for ( ; (**strt == ' ' || **strt == '\t') && **strt != '\0'; (*strt)++)
    ;
  word = *strt;
  /* forward one word */
  for ( ; **strt != ' ' && **strt != '\t' && **strt != '\0'; (*strt)++)
    ;
  if (**strt != '\0') {
    **strt = '\0';
    (*strt)++;
  }
  return word;
}


Boolean confirm(mess)
     char *mess;
{
  int c;

  prompt("%s (y or n) ", mess);
  while ((c=getchar()) != 'y' && c != 'n')
    printf("Please answer `y' or `n'\n");
  getchar();
  return (c == 'y');
}


Boolean risky_alart(com)
     char *com;
{
  printf("Current status is abort-by-ERROR!\n");
  printf("Performing %s command is somewhat risky.\n", com);
  return (!confirm("Do you want to continue?"));
}


Boolean load_program(listing)
     int listing;
{
  int clause, c1, c2;
  extern int yynerrs;
  litrlrec *t;

  printf("Reading the program ");
  Gparams.infile = fopen(Gparams.fname, "r");
  if (Gparams.infile == NULL) {
    printf("Can't open file %s.\n", Gparams.fname);
    Gparams.state = PREPARING;
    return FALSE;
  }
  putchar('.');
  /* Check embedded arguments */
  c1 = fgetc(Gparams.infile);
  c2 = fgetc(Gparams.infile);
  if (c1 == '%' && c2 == '!') {
    char *comline = 0;
    int  c, i, length = 15;

    /* Initially make the buffer long enough for a 40-char. */
    comline = (char *) malloc(length+1);

    for (i = 0, c = fgetc(Gparams.infile);
	 c != EOF && c != '\n';
	 c = fgetc(Gparams.infile)) {
      /* If buffer is full, make it bigger.	*/
      if (i == length) {
	length *= 2;
	comline = (char *) realloc(comline, length+1);
      }
      /* Add this character to the buffer.	*/
      comline[i++] = c;
    }
    comline[i] = '\0';
    embedded_arg(comline);
  } else {
    ungetc(c2, Gparams.infile);
    ungetc(c1, Gparams.infile);
  }
  putchar('.');
  for (clause = 1; !feof(Gparams.infile); clause++) {
    printf("[%d", clause);
    Gbuffer.top = FALSE;
    Gbuffer.literals = NULL;
    Gbuffer.variables = NULL;
    if (yyparse() > 0)
      break;
    putchar(']');
  }
  fclose(Gparams.infile);
  if (yynerrs > 0) {
    printf("\n\n%d error%s occured.\n",
	   yynerrs, (yynerrs == 1 ? "" : "s"));
    Gparams.state = ERROR;
    return FALSE;
  }
  printf(" done\n");
  printf("Checking dependency-links ");
  check_defined_pred_dependency();
  putchar('.');
  check_free_pred_dependency();
  putchar('.');
  printf(" done\n");
  FREE_parser_mem();
  if (listing) {
    printf("The program is ...\n");
    for (t = Gcontrol.unsigned_preds; t != NULL; t = t->ctrl.nxt)
      t->mark = FALSE;
    for (t = Gcontrol.signed_preds; t != NULL; t = t->ctrl.nxt)
      t->mark = FALSE;
    print_clauses();
    putchar('\n');
  }
  Gparams.state = STOPPED;
  return TRUE;
}


Boolean set_parameter(param, nxt)
     char *param;
     char *nxt;
{
  int itemp;
  double ftemp;

  if (EQ(param, "trace")) {
    sscanf(nxt, "%d", &itemp);
    if (NOT_BREAK <= itemp && itemp <=EACH_STEP) {
      Gparams.trace = itemp;
      return TRUE;
    } else {
      printf("Out of range. (%d <= trace <= %d)\n",
	     NOT_BREAK, EACH_STEP);
      return FALSE;
    }
  } else if (EQ(param, "itrmax")) {
    sscanf(nxt, "%d", &itemp);
    if (0 < itemp) {
      Gparams.itrmax = itemp;
      return TRUE;
    } else {
      printf("Out of range. (0 < iteration)\n");
      return FALSE;
    }
  } else if (EQ(param, "disj")) {
    sscanf(nxt, "%lf", &ftemp);
    Gparams.disjWT = ftemp;
    return TRUE;
  } else if (EQ(param, "excl")) {
    sscanf(nxt, "%lf", &ftemp);
    Gparams.exclWT = ftemp;
    return TRUE;
  } else if (EQ(param, "cmpl")) {
    sscanf(nxt, "%lf", &ftemp);
    Gparams.cmplWT = ftemp;
    return TRUE;
  } else if (EQ(param, "assm")) {
    sscanf(nxt, "%lf", &ftemp);
    Gparams.assmWT = ftemp;
    return TRUE;
  } else if (EQ(param, "eqlz")) {
    sscanf(nxt, "%lf", &ftemp);
    Gparams.eqlzWT = ftemp;
    return TRUE;
  } else if (EQ(param, "trns")) {
    sscanf(nxt, "%lf", &ftemp);
    Gparams.trnsWT = ftemp;
    return TRUE;
  } else if (EQ(param, "dpnd")) {
    sscanf(nxt, "%lf", &ftemp);
    Gparams.psdoWT = ftemp;
    return TRUE;
  } else if (EQ(param, "tmprtr")) {
    sscanf(nxt, "%lf", &ftemp);
    if (0.0 < ftemp) {
      Gparams.tmprtr = ftemp;
      return TRUE;
    } else {
      printf("Out of range. (0.0 < tempereture)\n");
      return FALSE;
    }
  } else if (EQ(param, "atmp")) {
    sscanf(nxt, "%lf", &ftemp);
    if (0.0 <= ftemp && ftemp < MAX_CTMP) {
      Gparams.atmp = ftemp;
      return TRUE;
    } else {
      printf("Out of range. ( 0.0 <= atmp < 1.6294457 = 1/(2-log4) )\n");
      return FALSE;
    }
  } else if (EQ(param, "stmp")) {
    sscanf(nxt, "%lf", &ftemp);
    if (0.0 < ftemp) {
      Gparams.stmp = ftemp;
      return TRUE;
    } else {
      printf("Out of range. (0.0 < stmp)\n");
      return FALSE;
    }
  } else if (EQ(param, "theta")) {
    sscanf(nxt, "%lf", &ftemp);
    if (0.0 < ftemp && ftemp < 1.0) {
      Gparams.theta = ftemp;
      return TRUE;
    } else {
      printf("Out of range. (0.0 < theta < 1.0)\n");
      return FALSE;
    }
  } else if (EQ(param, "subsTH")) {
    sscanf(nxt, "%le", &ftemp);
    if (0.0 < ftemp) {
      Gparams.subsTH = ftemp;
      return TRUE;
    } else {
      printf("Out of range. (0.0 < subsTH)\n");
      return FALSE;
    }
  } else if (EQ(param, "actTH")) {
    sscanf(nxt, "%le", &ftemp);
    if (0.0 < ftemp && ftemp < 1.0) {
      Gparams.actTH = ftemp;
      return TRUE;
    } else {
      printf("Out of range. (0.0 < actTH < 1.0)\n");
      return FALSE;
    }
  } else if (EQ(param, "epsilon")) {
    sscanf(nxt, "%le", &ftemp);
    if (0.0 < ftemp && ftemp < 1.0) {
      Gparams.epsilon = ftemp;
      return TRUE;
    } else {
      printf("Out of range. (0.0 < epsilon < 1.0)\n");
      return FALSE;
    }
  } else if (param[0] == '\0') {
    print_status("");
    return TRUE;
  }
  printf("Unknown parameter `%s'.\n", param);
  return FALSE;
}


void embedded_arg(buff)
     char *buff;
{
  int argc;
  char *p, *argv[30];

  argv[0] = Gparams.appname;
  argc = 1;
  p = buff;
  for (;;) {
    while (*p == ' ' || *p == '\t') p++;
    argv[argc++] = p;
    while (*p != ' ' && *p != '\t' && *p != '\0') p++;
    if (*p == '\0')
      break;
    else
      *p++ = '\0';
  }
  argv[argc] = NULL;
  CheckArguments(argc, argv);
}


Boolean reset_state()
{
  return TRUE;
}
