/*
/*	(C)1992 Institute for New Generation Computer Technology
/*		$BG[I[$=$NB>$O(BCOPYRIGHT$B%U%!%$%k$r;2>H$7$F2<$5$$(B
/*		(Read COPYRIGHT for detailed information.)
 */
/*****************************
   Kappa RPC Client libraly

 *****************************/

#include <stdio.h>
#include "kappa_rpc1.h"

int  c;

/****************************************************************************
 KapMSOpen - begin Kappa DBMS

    [$BJV5QCM(B]
	null			$B0[>o=*N;(B
	!null			KPS$B9=B$BN$X$N%]%$%s%?(B
    [$B%(%i!<%3!<%I(B]
	KPSERR_NO_HOST		$B%[%9%H$H@\B3$G$-$J$$(B
	KPSERR_NO_KAPPA		Kappa_Manager$B$,5/F0$7$F$$$J$$(B
 ****************************************************************************/
KPS * KappaMSOpen(hostname, ret)
char *	hostname;		/* host WS name */
int *	ret;			/* error code */
{
  struct hostent *hp;
  struct timeval pertry_timeout;
  struct timeval total_timeout;
  struct sockaddr_in server_addr;
  int addrlen;
  int sock;
  enum clnt_stat clnt_stat;
  int  tcp_ret;

  KPS * p;

  /* get host WS hostent */
  if ((hp = gethostbyname(hostname)) == NULL) {
      perror ("gethost failed\n");
      *ret = KPSERR_NO_HOST;
      return(NULL);
  }      

  /* tcp paramaters initialize */
  pertry_timeout.tv_sec = 30;
  pertry_timeout.tv_usec = 0;
  addrlen = sizeof(struct sockaddr_in);
  bcopy(hp->h_addr,(caddr_t)&(server_addr.sin_addr),hp->h_length);
  server_addr.sin_family = AF_INET;
  server_addr.sin_port = 0;
  sock = RPC_ANYSOCK;

  /* KPS struct initialize */
  p = (KPS *)malloc(sizeof(KPS));
  if (p == NULL) {
      perror ("Create failed (memory)\n");
      *ret = KPSERR_NO_HOST;
      return(NULL);
  }

  /* TCP entry */
  if ((Kclient(p) = clnttcp_create(&server_addr, KAP_RPC_PROGNUM,
                                   KAP_RPC_VERSION, &sock, 0,
			       0)) == NULL) {
      perror ("Create failed\n");
      free((char *)p);
      *ret = KPSERR_NO_HOST;
      return(NULL);
  }      
  Ksocket(p) = sock;
  Ktotal_timeout(p).tv_sec = 600;
  Ktotal_timeout(p).tv_usec = 0;

  /* Open Kappa */
  clnt_stat = clnt_call(Kclient(p), KAP_RPC_MS_OPEN, xdr_void, 0,
                        xdr_int, &tcp_ret, Ktotal_timeout(p));

  if (clnt_stat != RPC_SUCCESS) {
      free((char *)p);
      perror ("RPC fail\n");
      *ret = clnt_stat;
      return(NULL);
  }      
  if (tcp_ret != 0) {
      free((char *)p);
      perror ("RPC/tcp fail\n");
      *ret = tcp_ret;
      return(NULL);
  }      

  *ret = 0;
  return (p);
}


/****************************************************************************
 KappaOpen - begin search Kappa

    [$BJV5QCM(B]
	null			$B0[>o=*N;(B
	!null			KPS$B9=B$BN$X$N%]%$%s%?(B
    [$B%(%i!<%3!<%I(B]
	KPSERR_NO_HOST		$B%[%9%H$H@\B3$G$-$J$$(B
	KPSERR_NO_KAPPA		Kappa_Manager$B$,5/F0$7$F$$$J$$(B
	KPSERR_TABLE_ACCESS	$BBP1~$9$k%F!<%V%k$,B8:_$7$J$$(B or	$BB><T$,%F!<%V%k(B
				$B$r@lM-$7$F$$$k(B or $B%F!<%V%k$N%"%/%;%98"$,$J$$(B
 ****************************************************************************/
int KappaOpen(kps, db_name)
KPS *	kps;			/* KPS$B9=B$BN$X$N%]%$%s%?(B */
char * 	db_name;		/* Kappa table name */
{
  enum clnt_stat clnt_stat;
  char db_name_buf[MAX_TABLE_NAME + 1];
  char *bp = db_name_buf;
  int  tcp_ret;

  /* Open Kappa */
  strncpy(bp,db_name,MAX_TABLE_NAME);
  clnt_stat = clnt_call(Kclient(kps), KAP_RPC_OPEN, xdr_wrapstring, &bp, 
                        xdr_int, &tcp_ret,Ktotal_timeout(kps));

  if (clnt_stat != RPC_SUCCESS) {
      return(KPSERR_NO_HOST);
  }      
  if (tcp_ret != 0) {
      perror ("RPC/tcp fail\n");
      return tcp_ret;
  }      

  strncpy(Kdb_name(kps),db_name,MAX_TABLE_NAME);
  return 0;
}


/****************************************************************************
 KappaSearch - $B%G!<%?8!:w(B 

    [$BJV5QCM(B]
	0			$B@5>o=*N;(B
	KPSERR_NOT_OPEN		$B8!:w$,3+;O$5$l$F$$$J$$(B
	KPSERR_NO_HOST		$B%[%9%H$H@\B3$G$-$J$$(B
	KPSERR_COND_SYNTAX	$B8!:w>r7o$K8m$j$,$"$k(B
	KPSERR_FORM_SYNTAX	$B=PNO=q<0$K8m$j$,$"$k(B
 ****************************************************************************/
int KappaSearch(kps, condition, search_type, format, access_type, cardinality)
KPS *	kps;			/* KPS$B9=B$BN$X$N%]%$%s%?(B */
char *	condition;		/* $B8!:w>r7o(B */
int	search_type;		/* $B8!:w%?%$%W(B (KPS_IDX:$B%$%s%G%C%/%98!:w(B
					       KPS_DAT:$BD>@\8!:w(B) */
char *	format;			/* $B7k2L=PNO=q<0(B */
char *	access_type;		/* $B7k2L=PNO=g(B */
int *	cardinality;		/* $B8!:w7k2L?t(B */
{
  enum clnt_stat clnt_stat;
  int  tcp_ret;
  KAP_RPCS rpcs, *p = &rpcs;
  int  xdr_kap_rpcs();

  /* initialize */
  *cardinality = 0;

  /* Kappa search paramaters set */
  strncpy(KScondition(p),condition,MAX_CONDITION);
  strncpy(KSformat(p),format,MAX_FORMAT);
  strncpy(KSaccess_type(p),access_type,MAX_ACCESS_TYPE);
  strncpy(KSfilter_name(p),"dummy",MAX_FILTER_NAME);

  /* search Kappa */
  clnt_stat = clnt_call(Kclient(kps), KAP_RPC_IDXSEARCH, xdr_kap_rpcs, &rpcs, 
                        xdr_int, &tcp_ret, Ktotal_timeout(kps));

  if (clnt_stat != RPC_SUCCESS) {
      return(KPSERR_NO_HOST);
  }      
  if (tcp_ret < 0) {
      return(-(tcp_ret));
  }      

  *cardinality = tcp_ret;
  return (0);
}

/****************************************************************************
 KappaMotifSearch - $B%G!<%?8!:w!J%b%A!<%U8!:w!K(B

    [$BJV5QCM(B]
	0			$B@5>o=*N;(B
	KPSERR_NOT_OPEN		$B8!:w$,3+;O$5$l$F$$$J$$(B
	KPSERR_NO_HOST		$B%[%9%H$H@\B3$G$-$J$$(B
	KPSERR_COND_SYNTAX	$B8!:w>r7o$K8m$j$,$"$k(B
	KPSERR_FORM_SYNTAX	$B=PNO=q<0$K8m$j$,$"$k(B
 ****************************************************************************/
int KappaMotifSearch(kps,condition,search_type,format,access_type,
		     cardinality,filter_name)
KPS *	kps;			/* KPS$B9=B$BN$X$N%]%$%s%?(B */
char *	condition;		/* $B8!:w>r7o(B */
int	search_type;		/* $B8!:w%?%$%W(B (KPS_IDX:$B%$%s%G%C%/%98!:w(B
					       KPS_DAT:$BD>@\8!:w(B) */
char *	format;			/* $B7k2L=PNO=q<0(B */
char *	access_type;		/* $B7k2L=PNO=g(B */
int *	cardinality;		/* $B8!:w7k2L?t(B */
char *  filter_name;            /* $B%b%A!<%U8!:w%U%#%k%?!<L>(B */
{
  enum clnt_stat clnt_stat;
  int  tcp_ret;
  KAP_RPCS rpcs, *p = &rpcs;
  int  xdr_kap_rpcs();

  /* initialize */
  *cardinality = 0;

  /* Kappa search paramaters set */
  strncpy(KScondition(p),condition,MAX_CONDITION);
  strncpy(KSformat(p),format,MAX_FORMAT);
  strncpy(KSaccess_type(p),access_type,MAX_ACCESS_TYPE);
  strncpy(KSfilter_name(p),filter_name,MAX_FILTER_NAME);

  /* search Kappa */
  clnt_stat = clnt_call(Kclient(kps),KAP_RPC_MOTIFSEARCH, xdr_kap_rpcs, &rpcs, 
                        xdr_int, &tcp_ret, Ktotal_timeout(kps));

  if (clnt_stat != RPC_SUCCESS) {
      return(KPSERR_NO_HOST);
  }      
  if (tcp_ret < 0) {
      return(-(tcp_ret));
  }      

  *cardinality = tcp_ret;
  return (0);
}

/****************************************************************************
 KappaRead - $B8!:w7k2LFI$_9~$_(B

    [$BJV5QCM(B]
	0			$B@5>o=*N;(B
	KPSERR_NOT_OPEN		$B8!:w$,3+;O$5$l$F$$$J$$(B
	KPSERR_NO_HOST		$B%[%9%H$H@\B3$G$-$J$$(B
	KPSERR_FORM_SYNTAX	$B=PNO=q<0$K8m$j$,$"$k(B
	KPSERR_NO_MORE_TERM	$BFI$_9~$`9`$,$J$$(B($B4{$KA4ItFI$_9~$s$G$$$k(B)
	KPSERR_BUFFER_FLOW	$BFI$_9~$_%P%C%U%!D9$,B-$j$J$$(B
 ****************************************************************************/
int KappaRead(kps, format, buffer, length)
KPS *	kps;			/* KPS$B9=B$BN$X$N%]%$%s%?(B */
char *	format;			/* $B0l;~7k2L=PNO=q<0(B */
char *	buffer;			/* $B7k2LFI$_9~$_%P%C%U%!(B */
int	length;			/* $BFI$_9~$_%P%C%U%!D9(B */
{
  char buf[MAX_FORMAT + 1], *bp = buf;
  enum clnt_stat clnt_stat;
  KAP_RPCR rpcr, *p = &rpcr;
  int xdr_kap_rpcr();

  /* Kappa read paramaters set */
  strncpy(buf,format,MAX_FORMAT);

  /* read Kappa */
  clnt_stat = clnt_call(Kclient(kps), KAP_RPC_READ, xdr_wrapstring, &bp, 
                        xdr_kap_rpcr, &rpcr, Ktotal_timeout(kps));

  if (clnt_stat != RPC_SUCCESS) {
      return(KPSERR_NO_HOST);
  }      
  if (KRerror_ret(p) != 0) {
      return(KRerror_ret(p));
  }      
  if (strlen(KRread_ret(p)) >= length) {
      return(KPSERR_BUFFER_FLOW);
  }

  strncpy(buffer,KRread_ret(p),length - 1);
  return (0);
}


/****************************************************************************
 KappaReadALL - $B8!:w7k2LFI$_9~$_(B(all)

    [$BJV5QCM(B]
	0			$B@5>o=*N;(B
	KPSERR_NOT_OPEN		$B8!:w$,3+;O$5$l$F$$$J$$(B
	KPSERR_NO_HOST		$B%[%9%H$H@\B3$G$-$J$$(B
	KPSERR_FORM_SYNTAX	$B=PNO=q<0$K8m$j$,$"$k(B
	KPSERR_NO_MORE_TERM	$BFI$_9~$`9`$,$J$$(B($B4{$KA4ItFI$_9~$s$G$$$k(B)
	KPSERR_BUFFER_FLOW	$BFI$_9~$_%P%C%U%!D9$,B-$j$J$$(B
 ****************************************************************************/
int KappaReadAll(kps, format, buffer, length)
KPS *	kps;			/* KPS$B9=B$BN$X$N%]%$%s%?(B */
char *	format;			/* $B0l;~7k2L=PNO=q<0(B */
char *	buffer;			/* $B7k2LFI$_9~$_%P%C%U%!(B */
int	length;			/* $BFI$_9~$_%P%C%U%!D9(B */
{
  char buf[MAX_FORMAT + 1], *bp = buf;
  enum clnt_stat clnt_stat;
  KAP_RPCR rpcr, *p = &rpcr;
  int xdr_kap_rpcr();

  /* Kappa read paramaters set */
  strncpy(buf,format,MAX_FORMAT);

  /* read Kappa */
  clnt_stat = clnt_call(Kclient(kps), KAP_RPC_READ_ALL, xdr_wrapstring, &bp, 
                        xdr_kap_rpcr, &rpcr, Ktotal_timeout(kps));

  if (clnt_stat != RPC_SUCCESS) {
      return(KPSERR_NO_HOST);
  }      
  if (KRerror_ret(p) != 0) {
      return(KRerror_ret(p));
  }      
  if (strlen(KRread_ret(p)) >= length) {
      return(KPSERR_BUFFER_FLOW);
  }

  strncpy(buffer,KRread_ret(p),length - 1);
  return (0);
}


/****************************************************************************
 KappaClose - $B8!:w=*N;(B

   [$BJV5QCM(B]
	0			$B@5>o=*N;(B
	KPSERR_NOT_OPEN		$B8!:w$,3+;O$5$l$F$$$J$$(B
	KPSERR_NO_HOST		$B%[%9%H$H@\B3$G$-$J$$(B
 ****************************************************************************/
int KappaClose(kps)
KPS *	kps;			/* KPS$B9=B$BN$X$N%]%$%s%?(B */
{
  enum clnt_stat clnt_stat;
  int  tcp_ret;

  /* close Kappa */
  clnt_stat = clnt_call(Kclient(kps), KAP_RPC_CLOSE, xdr_void, 0, 
                        xdr_int, &tcp_ret, Ktotal_timeout(kps));

  if (clnt_stat != RPC_SUCCESS) {
      return(KPSERR_NO_HOST);
  }      
  if (tcp_ret != 0) {
      return(tcp_ret);
  }      

  return (0);
}

/****************************************************************************
 KappaMSClose - end Kappa DBMS

   [$BJV5QCM(B]
	0			$B@5>o=*N;(B
	KPSERR_NOT_OPEN		$B8!:w$,3+;O$5$l$F$$$J$$(B
	KPSERR_NO_HOST		$B%[%9%H$H@\B3$G$-$J$$(B
 ****************************************************************************/
int KappaMSClose(kps)
KPS *	kps;			/* KPS$B9=B$BN$X$N%]%$%s%?(B */
{
  enum clnt_stat clnt_stat;
  int  tcp_ret;

  /* close Kappa */
  clnt_stat = clnt_call(Kclient(kps), KAP_RPC_MS_CLOSE, xdr_void, 0, 
                        xdr_int, &tcp_ret, Ktotal_timeout(kps));

  if (clnt_stat != RPC_SUCCESS) {
      return(KPSERR_NO_HOST);
  }      
  if (tcp_ret != 0) {
      return(tcp_ret);
  }      

  clnt_destroy(Kclient(kps));
  shutdown(Ksocket(kps),2);
  close(Ksocket(kps));
  free((char *)kps);
  return (0);
}


/**************
  $B%G!<%?JQ49(B
 **************/
xdr_kap_rpcs(xdrsp,params)
XDR *xdrsp;
KAP_RPCS *params;
{
    char *pc, *pf, *pa, *pl;

    pc = &(params->condition);
    if (!xdr_wrapstring(xdrsp, &pc)) {
	return(FALSE);
    }
    pf = &(params->format);
    if (!xdr_wrapstring(xdrsp, &pf)) {
	return(FALSE);
    }
    pa = &(params->access_type);
    if (!xdr_wrapstring(xdrsp, &pa)) {
	return(FALSE);
    }
    pl = &(params->filter_name);
    return(xdr_wrapstring(xdrsp, &pl));
}

xdr_kap_rpcr(xdrsp,ret)
XDR *xdrsp;
KAP_RPCR *ret;
{
    char *pr;

    pr = &(ret->read_ret);
    if (!xdr_wrapstring(xdrsp, &pr)) {
	return(FALSE);
    }
    return(xdr_int(xdrsp, &(ret->error_ret)));
}
