/*
/*	(C)1992 Institute for New Generation Computer Technology
/*		$BG[I[$=$NB>$O(BCOPYRIGHT$B%U%!%$%k$r;2>H$7$F2<$5$$(B
/*		(Read COPYRIGHT for detailed information.)
 */
#include <stdio.h>
#include <string.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include <X11/Shell.h>
#include <Xm/PanedW.h>
#include <Xm/Form.h>
#include <Xm/ScrolledW.h>
#include <Xm/RowColumn.h>
#include <Xm/Label.h>
#include <Xm/LabelG.h>
#include <Xm/Text.h>
#include <Xm/TextF.h>
#include <Xm/PushB.h>
#include <Xm/List.h>

#include "Fig.h"
#include "FigLine.h"
#include "FigText.h"
#include "FigArrow.h"

#include "DataBaseP.h"
#include "ObjectsP.h"
#include "PirP.h"
#include "SearchP.h"
#include "DispWinP.h"
#include "app_res.h"

#include "kappa_rpc1.h"

#include "misc.h"
#include "AttribP.h"

static void getInfo ();
static void getTitle ();
static void printInfo ();
static void freeInfo ();
static void makeSearchInput ();
static void freeSearchInfo ();
static void makeDataWindow ();
static void makeFig ();
static void makeFeatureStringList ();
static void makeAttributeWindow ();

extern void Attr ();
extern Display *display;

static void makeMotifSearchInput ();

static DataBaseRec PIR_databaseRec =
{
  "pir_gen",
  getInfo,
  getTitle,
  printInfo,
  freeInfo,
  makeSearchInput,
  freeSearchInfo,
  makeDataWindow,
  makeFig,
  makeFeatureStringList,
  makeAttributeWindow,
};

DataBase PIR_database = &PIR_databaseRec;

static void getList (swd)
     SearchWinData swd;
{
  extern KPS *Kappa;
  XmStringTable str_table;
  char *term;
  char *temp0, *temp1, *result;
  char database_gen[30]; /* I guess this is enough... */
  char output_format[50]; /* I guess this is enough... */
  DataBase database = app_resources.database;

  int i;
  int ret;

  strcpy (database_gen, "pir_gen");
  strcpy (database_gen + sizeof ("pir_gen") -1, app_resources.database_no);

  if (swd->string_list)
    {
      freeStringList (swd->string_list);
      swd->string_list = NULL;
    }

  {
    char *string;
    PirSearch ps;
    SearchInfo s;

    s = swd->s;
    ps = s->info;

    temp0 = NULL;
    XtVaGetValues(ps->id_code, XmNvalue, &string, NULL);
    term = makeTerm (string, "id_code");
    temp1 = makeExp (temp0, term);
    XtFree (term);

    temp0 = temp1;
    XtVaGetValues(ps->molec_name, XmNvalue, &string, NULL);
    term = makeTerm (string, "molec_name");
    temp1 = makeExp (temp0, term);
    XtFree (term);
    XtFree (temp0);

    temp0 = temp1;
    XtVaGetValues(ps->life_name, XmNvalue, &string, NULL);
    term = makeTerm (string, "life_name");
    temp1 = makeExp (temp0, term);
    XtFree (term);
    XtFree (temp0);

    temp0 = temp1;
    XtVaGetValues(ps->keywords, XmNvalue, &string, NULL);
    term = makeTerm (string, "keywords");
    temp1 = makeExp (temp0, term);
    XtFree (term);
    XtFree (temp0);
  }

  result = temp1;
  printf ("Q: %s\n", result);

  if (result == NULL)
    /* do nothing */
    return;

  if ((ret = KappaOpen (Kappa,
			database_gen)))

    {
      XtFree (result);
      fprintf (stderr, "KappaOpen Error : %d\n",ret);
      return;
    }

  sprintf (output_format, "(pir_gen%s(id_code))", app_resources.database_no);
  if (KappaSearch (Kappa, result, 1, output_format,"_",
		   &(swd->number_of_hits)) != 0)
    {
      fprintf (stderr, "Kappa Search Failed : %d\n",ret);
      swd->number_of_hits = 0;
    }
  XtFree (result);

  swd->string_list = NULL;
  if (swd->number_of_hits > 0)
    {
      if (ret = KappaReadAll (Kappa,"_", data, BUF_LEN))
        {
          fprintf (stderr, "KappaRead Error : %d\n",ret);
          swd->string_list = NULL;
	  swd->number_of_hits = 0;
        }
      else
        {
	  int len;
	  StringList sl;

          /* parse the contents */
          point = 0;
          advance (0);
          swd->string_list = parseStringSetList ();
	  for (len=0, sl=swd->string_list; sl; len++,sl=sl->next);
	  swd->number_of_hits = len;
        }
    }
  if (swd->string_list)
    {
      char num[10];
      XmString str;

      str_table = (XmStringTable)
        XtMalloc (sizeof (XmString *) * swd->number_of_hits);
      {
        StringList sl;

        for (i=0, sl = swd->string_list; sl; i++,sl = sl->next)
          str_table[i] = XmStringCreateSimple (sl->string);
      }

      XtVaSetValues (swd->list,
                     XmNitems, str_table,
                     XmNitemCount, swd->number_of_hits,
                     NULL);

      for (i = 0; i < swd->number_of_hits; i++)
        XmStringFree (str_table[i]);
      XtFree (str_table);

      sprintf (num, "%d", swd->number_of_hits);
      str = XmStringCreateSimple (num);
      XtVaSetValues (swd->total_hits,
                     XmNlabelString, str,
                     NULL);
      XmStringFree (str);
    }
  else
    {
      XmString str;

      XtVaSetValues (swd->list,
                     XmNitems, NULL,
                     XmNitemCount, 0,
                     NULL);

      str = XmStringCreateSimple ("0");
      XtVaSetValues (swd->total_hits,
		     XmNlabelString, str,
		     NULL);
      XmStringFree (str);
    }

  if ((ret = KappaClose(Kappa)))
    {
      fprintf (stderr, "KappaClose Error : %d\n",ret);
    }
}

static Feature parseFeature ()
{
  Feature f;
  PositionList pl;

  f =  (Feature)XtMalloc (sizeof (FeatureRec));
  advance ('{');
  parsePositionOrRegionList (&f->position_list, &f->region_list);

  advance (',');

  f->id_func = parseSTRINGorWORD ();

  advance (',');

  f->name_func = parseSTRINGorWORD ();

  advance (',');
  advance (0);
  advance ('}');

  return f;
}

static FeatureList parseFetureListSUB ()
{
  FeatureList fl, fl_current;
  FeatureList fl_top;
  Feature f;

  fl_top = NULL;

  if (token == ']')
    {
      advance (']');
      return NULL;
    }
  f  = parseFeature ();
  fl  = (FeatureList)XtMalloc (sizeof (FeatureListRec));
  fl->feature = f;
  fl_current = fl_top = fl;

  while (token == ',')
    {
      advance (',');
      f = parseFeature ();
      fl  = (FeatureList)XtMalloc (sizeof (FeatureListRec));
      fl->feature = f;
      fl_current->next = fl;
      fl_current = fl;
    }
  fl_current->next = NULL;

  return fl_top;
}

static FeatureList parseFeatureList ()
{
  FeatureList fl;
#ifdef P
  advance ('{');
#endif
  advance ('{');
  if (token != STRING)
    parseError ("??featurelist");
  advance (STRING);  /* skip ID code */
  advance (',');
  advance ('[');
  fl = parseFetureListSUB ();
  advance (']');
  advance ('}');
#ifdef P
  advance ('}');
#endif

  return fl;
}

static General parseGeneralSUB ()
{
  General g;

  g =  (General)XtMalloc (sizeof (GeneralRec));

  g->id_code = parseSTRINGorWORD ();
  advance (',');
#ifdef P
  g->seq_type = parseSTRINGorWORD ();
#else
  g->seq_type = parseATOM ();
#endif
  advance (',');
#ifdef P
  advance ('{');
#endif
  g->molec_name = parseSTRINGorWORD ();
  advance (',');
  g->life_name = parseSTRINGorWORD ();
#ifdef P
  advance ('}');
#endif
  advance (',');
  g->alternative_names = parseStringList ();
  advance (',');
  g->includes = parseStringList ();
  advance (',');
#ifdef P
  advance ('{');
#endif
  g->entry_date = parseSTRINGorWORD ();
  advance (',');
  g->seq_date = parseSTRINGorWORD ();
  advance (',');
  g->text_date = parseSTRINGorWORD ();
#ifdef P
  advance ('}');
#endif
  advance (',');
  g->comments = parseStringList ();
  advance (',');
  g->keywords = parseStringList ();
  advance (',');
#ifdef P
  advance ('{');
#endif
  g->weight = parseINTEGERorWORD (); /* it can be NIL */
  advance (',');
  g->length = parseINTEGERorWORD (); /* it can be NIL */
#ifdef P
  advance ('}');
#endif
  advance (',');
  g->sequence = parseSTRINGorWORD ();

  return g;
}

static General parseGeneral ()
{
  General g;

#ifdef P
  advance ('{');
#endif
  advance ('{');
  g = parseGeneralSUB ();
  advance ('}');
#ifdef P
  advance ('}');
#endif

  return g;
}

static Pattern parsePattern ()
{
  Pattern p;
  char *string;
  extern int yylval;
  extern int yylex ();

  p = (Pattern) XtMalloc (sizeof (PatternRec));
  advance ('{');
  p->description = parseSTRINGorWORD ();
  advance (',');
  if (token == WORD)
    {
      if (data[yylval] == 'n')
	{
	  /* assume nil */
	  advance (WORD);
	  p->pattern = XtNewString ("");
	}
      else
	{
	  /* assume double_bytes# */
	  while (data[point++] != '}');
	  string = XtMalloc (point - yylval+1);
	  strncpy (string, data+yylval, point - yylval);
	  string[point-yylval] = '\0';
	  p->pattern = string;
	  token = yylex ();
	}
    }
  else
    { /* it's string */
      string = parseSTRINGorWORD ();
#if 0
      p->pattern = XtMalloc (strlen (string)+2);
      sprintf (p->pattern, "\"%s\"", string);
      XtFree (string);
#else
      p->pattern = string;
#endif
    }
  advance ('}');

  return p;
}

static PatternList parsePatternList ()
{
  PatternList l, l_current, l_top;
  Pattern p;

  advance ('[');
  if (token == ']')
    {
      advance (']');
      return NULL;
    }
  p = parsePattern ();
  l = (PatternList) XtMalloc (sizeof (PatternListRec));
  l->pattern = p;
  l_top = l_current = l;

  while (token != ']')
    {
      advance (',');
      p = parsePattern ();
      l = (PatternList) XtMalloc (sizeof (PatternListRec));
      l->pattern = p;
      l_current->next = l;
      l_current = l;
    }

  l_current->next = NULL;
  advance (']');

  return l_top;
}

static FeatureList  getFeatureList (hostname, database_no, id_code)
     char *hostname;
     char *database_no;
     char *id_code;
{
  extern KPS *Kappa;
  char query[100];
  int hits;
  int ret;
  char database_fea[20]; /* I guess this is enough... */
  char output_format[50]; /* I guess this is enough... */

  strcpy (database_fea, "pir_fea");
  strcpy (database_fea+sizeof ("pir_fea")-1, database_no);

  sprintf (query, "id_code=\"%s\"", id_code);
  printf ("Q: %s\n", query);

  if (ret = KappaOpen (Kappa,
		       database_fea))
    {
      fprintf (stderr, "KappaOpen Error : %d\n",ret);
      return NULL;
    }

#ifdef P
  sprintf (output_format, "(pir_fea%s({id_code, feature}))",
	   database_no);
#else
  sprintf (output_format, "(pir_fea%s(id_code, feature))",
	   database_no);
#endif
  if (KappaSearch (Kappa, query, 1, output_format,"_",
		   &hits) != 0)
    {
      fprintf (stderr, "Kappa Search Failed : %d\n",ret);
      hits = 0;
    }

  if (hits > 0)
    {
      if (ret = KappaRead (Kappa,"_", data, BUF_LEN))
	{
	  fprintf (stderr, "KappaRead Error : %d\n",ret);
	}

      if ((ret = KappaClose(Kappa)))
	{
	  fprintf (stderr, "KappaClose Error : %d\n",ret);
	}
      /* parse the contents */
      point = 0;
      advance (0);
      return parseFeatureList ();
    }
  else
    {
      if ((ret = KappaClose(Kappa)))
	{
	  fprintf (stderr, "KappaClose Error : %d\n",ret);
	}
      return NULL;
    }
}

static General  getGeneral (hostname, database_no, id_code)
     char *hostname;
     char *database_no; 
     char *id_code;
{
  extern KPS *Kappa;
  char query[100];
  int hits;
  int ret;
  char database_gen[20]; /* I guess this is enough... */
  char output_format[250]; /* I guess this is enough... */

  strcpy (database_gen, "pir_gen");
  strcpy (database_gen+sizeof ("pir_gen")-1, database_no);

  sprintf (query, "id_code=\"%s\"", id_code);
  printf ("Q: %s\n", query);

  if ((ret= KappaOpen (Kappa,
		       database_gen)))
    {
      fprintf (stderr, "KappaOpen Error : %d\n",ret);
      return NULL;
    }

#ifdef P
  sprintf (output_format, "(pir_gen%s({id_code,type_seq,{molec_name,life_name},alter_name,includes,{entry_date,seq_date,text_date},comment,keywords,{weight,length},sequence}))",
	   database_no);
#else
  sprintf (output_format, "(pir_gen%s(id_code,type_seq,molec_name,life_name,alter_name,includes,entry_date,seq_date,text_date,comment,keywords,weight,length,sequence))",
	   database_no);
#endif
  if (KappaSearch (Kappa, query, 1,
		   output_format,
		   "_",
		   &hits) != 0)
    {
      fprintf (stderr, "Kappa Search Failed : %d\n",ret);
      hits = 0;
    }

  if (hits > 0)
    {
      if (ret = KappaRead (Kappa,"_", data, BUF_LEN))
	{
	  fprintf (stderr, "KappaRead Error : %d\n",ret);
	}

      if ((ret = KappaClose(Kappa)))
	{
	  fprintf (stderr, "KappaClose Error : %d\n",ret);
	}
      /* parse the contents */
      point = 0;
      advance (0);
      return parseGeneral ();
    }
  else
    {
      if ((ret = KappaClose(Kappa)))
	{
	  fprintf (stderr, "KappaClose Error : %d\n",ret);
	}
      return NULL;
    }
}

static void getInfo (dwd)
     DispWinData dwd;
{
  General g;
  FeatureList fl;
  char *hostname    = dwd->hostname;
  char *database_no = dwd->database_no;
  char *id_code     = dwd->candidate_list[dwd->current];

  g = getGeneral (hostname, database_no, id_code);
  g->feature_list = getFeatureList (hostname, database_no, id_code);

  dwd->g = g;
  return;
}

static void getTitle (dwd, buffer)
     DispWinData dwd;
     char *buffer;
{
  General g = dwd->g;

  sprintf (buffer, "%s:pir_kappa", g->id_code);
}

static void printFeature (f)
     Feature f;
{
  printf ("id_func %s\n", f->id_func);
  printf ("name_func %s\n", f->name_func);
  printPositionList (f->position_list);
  printRegionList (f->region_list);
}

static void printFeatureList (fl)
     FeatureList fl;
{
  Feature f;
  FeatureList fl1;

  printf ("Feature List:\n");
  for (fl1 = fl; fl1; fl1 = fl1->next)
    printFeature (fl1->feature);
}

static void printInfo (g)
     General g;
{
  printf ("id_code %s\n", g->id_code);
  printf ("seq_type %s\n", g->seq_type);
  printf ("molec_name %s\n", g->molec_name);
  printf ("life_name %s\n", g->life_name);
  printStringList ("alternative_names", g->alternative_names);
  printStringList ("include", g->includes);
  printf ("entry_date %s\n", g->entry_date);
  printf ("seq_date %s\n", g->seq_date);
  printf ("text_date %s\n", g->text_date);
  printStringList ("comments", g->comments);
  printStringList ("keywords", g->keywords);
  printf ("sequence %s\n", g->sequence);
  printf ("weight %d\n", g->weight);
  printf ("length %d\n", g->length);
  printFeatureList (g->feature_list);
}

static void freeFeature (f)
     Feature f;
{
  XtFree (f->id_func);
  XtFree (f->name_func);
  freePositionList (f->position_list);
  freeRegionList (f->region_list);

  XtFree ((char *)f);
}

static void freeFeatureList (fl)
     FeatureList fl;
{
  FeatureList fl1, fl2;

  for (fl1 = fl; fl1; fl1 = fl2)
    {
      fl2 = fl1->next;
      freeFeature (fl1->feature);
      XtFree ((char *)fl1);
    }
}

static void freeInfo (g)
     General g;
{
  XtFree (g->id_code);
  XtFree (g->seq_type);
  XtFree (g->molec_name);
  XtFree (g->life_name);
  freeStringList (g->alternative_names);
  freeStringList (g->includes);
  XtFree (g->entry_date);
  XtFree (g->seq_date);
  XtFree (g->text_date);
  freeStringList (g->comments);
  freeStringList (g->keywords);
  XtFree (g->sequence);
  freeFeatureList (g->feature_list);

  XtFree ((char *)g);
}

static void freePattern (p)
     Pattern p;
{
  XtFree (p->description);
  XtFree (p->pattern);
  XtFree (p);
}

static void freePatternList (l)
     PatternList l;
{
  PatternList l1, l2;

  for (l1 = l; l1; l1 = l2)
    {
      l2 = l1->next;
      freePattern (l1->pattern);
      XtFree (l1);
    }
}


static void SearchByMotif (widget, clientData, callData)
     Widget widget;
     XtPointer clientData, callData;
{
  SearchWinData swd = (SearchWinData) clientData;
  extern KPS *Kappa;
  XmStringTable str_table;
  char *result;
  char database_gen[30]; /* I guess this is enough... */
  char output_format[50]; /* I guess this is enough... */
  DataBase database = app_resources.database;
  int selected;
  int *pos_list;
  int count;
  int i;
  int ret;
  char *string;
  PirSearchByMotif psbm;
  SearchInfo s;
  PatternList pl;

  s = swd->s;
  psbm = s->info;

  if (XmListGetSelectedPos (psbm->listbox, &pos_list, &count))
    {
      selected = pos_list[0] -1;
      XtFree (pos_list);
    }
  else
    return;

  strcpy (database_gen, "pir_gen");
  strcpy (database_gen + sizeof ("pir_gen") -1, app_resources.database_no);

  if (swd->string_list)
    {
      freeStringList (swd->string_list);
      swd->string_list = NULL;
    }

  pl = psbm->pattern_list;
  for (i=0; i < selected; i++)
    pl = pl->next;

  result = pl->pattern->pattern;
  printf ("Q: %s\n", result);

  if (result == NULL)
    /* do nothing */
    return;

  if ((ret = KappaOpen (Kappa,
			database_gen)))
    {
      XtFree (result);
      fprintf (stderr, "KappaOpen Error : %d\n",ret);
      return;
    }

  sprintf (output_format, "(pir_gen%s(id_code))", app_resources.database_no);
  if (KappaMotifSearch (Kappa, result, 1, output_format,"_",
		   &(swd->number_of_hits), app_resources.filter) != 0)
    {
      fprintf (stderr, "Kappa Search Failed : %d\n",ret);
      swd->number_of_hits = 0;
    }
  XtFree (result);

  swd->string_list = NULL;
  if (swd->number_of_hits > 0)
    {
      if (ret = KappaReadAll (Kappa,"_", data, BUF_LEN))
        {
          fprintf (stderr, "KappaRead Error : %d\n",ret);
          swd->string_list = NULL;
	  swd->number_of_hits = 0;
        }
      else
        {
	  int len;
	  StringList sl;

          /* parse the contents */
          point = 0;
          advance (0);
          swd->string_list = parseStringSetList ();
	  for (len=0, sl=swd->string_list; sl; len++,sl=sl->next);
	  swd->number_of_hits = len;
        }
    }
  if (swd->string_list)
    {
      char num[10];
      XmString str;

      str_table = (XmStringTable)
        XtMalloc (sizeof (XmString *) * swd->number_of_hits);
      {
        StringList sl;

        for (i=0, sl = swd->string_list; sl; i++,sl = sl->next)
          str_table[i] = XmStringCreateSimple (sl->string);
      }

      XtVaSetValues (swd->list,
                     XmNitems, str_table,
                     XmNitemCount, swd->number_of_hits,
                     NULL);

      for (i = 0; i < swd->number_of_hits; i++)
        XmStringFree (str_table[i]);
      XtFree (str_table);

      sprintf (num, "%d", swd->number_of_hits);
      str = XmStringCreateSimple (num);
      XtVaSetValues (swd->total_hits,
                     XmNlabelString, str,
                     NULL);
      XmStringFree (str);
    }
  else
    {
      XmString str;

      XtVaSetValues (swd->list,
                     XmNitems, NULL,
                     XmNitemCount, 0,
                     NULL);

      str = XmStringCreateSimple ("0");
      XtVaSetValues (swd->total_hits,
		     XmNlabelString, str,
		     NULL);
      XmStringFree (str);
    }

  if ((ret = KappaClose(Kappa)))
    {
      fprintf (stderr, "KappaClose Error : %d\n",ret);
    }

  return;
}

static void SwitchMotifSearch (widget, clientData, callData)
     Widget widget;
     XtPointer clientData, callData;
{
  SearchWinData swd = (SearchWinData) clientData;
  SearchInfo s;
  PirSearchByMotif psbm;

  s = swd->s;
  psbm = s->info;
  freePatternList (psbm->pattern_list);
  XtDestroyWidget (swd->inputs);
  XtFree (s->info);
  XtFree (s);
  makeMotifSearchInput (swd);
}

static void MotifSearchInfo (widget, clientData, callData)
     Widget widget;
     XtPointer clientData, callData;
{
  SearchWinData swd = (SearchWinData) clientData;
  extern KPS *Kappa;
  XmStringTable str_table;
  char *term;
  char *temp0, *temp1, *result;
#ifdef P
  char *database = "prosite_dat";
  char *output_format = "prosite_dat(description,pattern)";
#else
  char *database = "prosite";
  char *output_format = "prosite(description,pattern)";
#endif
  int i;
  int ret;
  int number_of_hits;
  PatternList pattern_list;

  {
    char *string;
    MotifSearch ms;
    SearchInfo s;

    s = swd->s;
    ms = s->info;

    temp0 = NULL;
    XtVaGetValues(ms->name_id, XmNvalue, &string, NULL);
    term = makeTerm (string, "name_id");
    temp1 = makeExp (temp0, term);
    XtFree (term);

    temp0 = temp1;
    XtVaGetValues(ms->description, XmNvalue, &string, NULL);
    term = makeTerm (string, "description");
    temp1 = makeExp (temp0, term);
    XtFree (term);
  }

  result = temp1;
  printf ("Q: %s\n", result);

  if (result == NULL)
    /* do nothing */
    return;

  if ((ret = KappaOpen (Kappa, database)))
    {
      XtFree (result);
      fprintf (stderr, "KappaOpen Error : %d\n",ret);
      return;
    }

  if (KappaSearch (Kappa, result, 1, output_format,"_",
		   &number_of_hits) != 0)
    {
      fprintf (stderr, "Kappa Search Failed : %d\n",ret);
      number_of_hits = 0;
    }
  XtFree (result);

  pattern_list = NULL;
  if (number_of_hits > 0)
    {
      if (ret = KappaReadAll (Kappa,"_", data, BUF_LEN))
        {
          fprintf (stderr, "KappaRead Error : %d\n",ret);
          pattern_list = NULL;
	  number_of_hits = 0;
        }
      else
        {
	  int len;
	  PatternList l;

          /* parse the contents */
          point = 0;
          advance (0);
          pattern_list = parsePatternList ();
	  for (len=0, l=pattern_list; l; len++,l=l->next);
	  number_of_hits = len;
        }
    }

  if ((ret = KappaClose(Kappa)))
    {
      fprintf (stderr, "KappaClose Error : %d\n",ret);
    }

  if (pattern_list)
    {
      char num[10];
      XmString str;
      PirSearchByMotif psbm;
      Widget input;
      Widget form;
      Widget command_motif_search;
      Widget listbox;
      Widget i_title;
      Widget total_hits;
      XmStringTable str_table;
      SearchInfo s;

      psbm = (PirSearchByMotif) XtMalloc (sizeof (PirSearchByMotifRec));
      psbm->pattern_list = pattern_list;
      psbm->number_of_hits = number_of_hits;

      XtDestroyWidget (swd->inputs);
      s = swd->s;
      XtFree (s->info);

      s->id = PIR_SEARCH_BY_MOTIF;
      s->info = psbm;
      str_table = (XmStringTable)
        XtMalloc (sizeof (XmString *) * number_of_hits);
      {
        PatternList l;

        for (i=0, l = pattern_list; l; i++,l = l->next)
          str_table[i] = XmStringCreateSimple (l->pattern->description);
      }

      swd->inputs = input =
	XtVaCreateWidget ("input", xmRowColumnWidgetClass, swd->form, NULL);

      /* command box ReturnToMotifSearch */
      form = XtVaCreateWidget ("form", xmFormWidgetClass, input,
			       XmNfractionBase, 10,
			       NULL);
      command_motif_search =
	XtVaCreateManagedWidget ("to_motif_search", xmPushButtonWidgetClass, form,
				 XmNtopAttachment,    XmATTACH_FORM,
				 XmNbottomAttachment, XmATTACH_FORM,
				 XmNleftAttachment,   XmATTACH_POSITION,
				 XmNleftPosition,    8,
				 XmNrightAttachment,  XmATTACH_FORM,
				 NULL);
      XtManageChild (form);
      XtAddCallback (command_motif_search,
		     XmNactivateCallback, SwitchMotifSearch, swd);

      i_title = XtVaCreateManagedWidget("hits", xmLabelGadgetClass, input,
					XmNalignment, XmALIGNMENT_BEGINNING,
					XmNtopAttachment,    XmATTACH_FORM,
					XmNbottomAttachment, XmATTACH_POSITION,
					XmNbottomPosition,   1,
					XmNleftAttachment,   XmATTACH_FORM,
					XmNrightAttachment,  XmATTACH_POSITION,
					XmNrightPosition,    2,
					NULL);

      sprintf (num, "%d", number_of_hits);
      str = XmStringCreateSimple (num);
      total_hits =
	XtVaCreateManagedWidget("num_of_hits", xmLabelGadgetClass, input, 
				XmNlabelString, str,
				XmNtopAttachment,    XmATTACH_FORM,
				XmNbottomAttachment, XmATTACH_POSITION,
				XmNbottomPosition,   1,
				XmNleftAttachment,   XmATTACH_POSITION,
				XmNleftPosition,     3,
				XmNrightAttachment,  XmATTACH_POSITION,
				XmNrightPosition,    4,
				NULL);
      XmStringFree (str);

      psbm->listbox = listbox =
	XmCreateScrolledList (input, "scrolledList", NULL, 0);
      XtVaSetValues (listbox,
                     XmNitems, str_table,
                     XmNitemCount, number_of_hits,
		     XmNvisibleItemCount, 8,
		     NULL);
      XtVaSetValues (XtParent (listbox),
		     XmNtopAttachment,    XmATTACH_POSITION,
		     XmNtopPosition,      2,
		     XmNbottomAttachment, XmATTACH_FORM,
		     XmNleftAttachment,   XmATTACH_FORM,
		     XmNrightAttachment,  XmATTACH_POSITION,
		     XmNrightPosition,    7,
		     NULL);
      XtManageChild (listbox);
      XtAddCallback (listbox, XmNdefaultActionCallback, SearchByMotif, swd);

      for (i = 0; i < number_of_hits; i++)
        XmStringFree (str_table[i]);
      XtFree (str_table);

      XtManageChild (input);
    }
}

static void SwitchPir (widget, clientData, callData)
     Widget widget;
     XtPointer clientData, callData;
{
  SearchWinData swd = (SearchWinData) clientData;
  SearchInfo s;

  s = swd->s;
  XtDestroyWidget (swd->inputs);
  XtFree (s->info);
  XtFree (s);
  makeSearchInput (swd);
}

static void makeMotifSearchInput (swd)
     SearchWinData swd;
{
  Widget i_title;
  Widget input;
  Widget command_search;
  Widget command_pir;
  Widget form;

  swd->inputs = input =
    XtVaCreateWidget ("input", xmRowColumnWidgetClass, swd->form, NULL);

  /* command box PIR */
  form = XtVaCreateWidget ("form", xmFormWidgetClass, input,
                           XmNfractionBase, 10,
                           NULL);
  command_pir =
    XtVaCreateManagedWidget ("to_pir", xmPushButtonWidgetClass, form,
                             XmNtopAttachment,    XmATTACH_FORM,
                             XmNbottomAttachment, XmATTACH_FORM,
                             XmNleftAttachment,   XmATTACH_POSITION,
                             XmNleftPosition,    8,
                             XmNrightAttachment,  XmATTACH_FORM,
                             NULL);
  XtManageChild (form);
  XtAddCallback (command_pir, XmNactivateCallback, SwitchPir, swd);

  /* Make Input */
  i_title = XtVaCreateManagedWidget ("motif_search", xmLabelGadgetClass, input,
                                     XmNalignment, XmALIGNMENT_BEGINNING,
				     NULL);

  {
    char name[20];
    SearchInfo s;
    MotifSearch ms;

    s = (SearchInfo) XtMalloc (sizeof (SearchInfoRec));
    swd->s = s;
    s->id = MOTIF_SEARCH;
    ms = (MotifSearch) XtMalloc (sizeof (MotifSearchRec));
    s->info = ms;

    form = XtVaCreateWidget ("form", xmFormWidgetClass, input,
			     XmNfractionBase, 10,
			     NULL);
    XtVaCreateManagedWidget ("name_id", xmLabelWidgetClass, form,
			     XmNtopAttachment,    XmATTACH_FORM,
			     XmNbottomAttachment, XmATTACH_FORM,
			     XmNleftAttachment,   XmATTACH_FORM,
			     XmNrightAttachment,  XmATTACH_POSITION,
			     XmNrightPosition,    2,
			     XmNalignment,        XmALIGNMENT_END,
			     NULL);
    ms->name_id =
      XtVaCreateManagedWidget ("name_id_value", xmTextFieldWidgetClass, form,
			       XmNtraversalOn,     True,
			       XmNrightAttachment, XmATTACH_FORM,
			       XmNleftAttachment,  XmATTACH_POSITION,
			       XmNleftPosition,    3,
			       NULL);
    XtAddCallback (ms->name_id, XmNactivateCallback,
		   XmProcessTraversal, XmTRAVERSE_NEXT_TAB_GROUP);
    XtManageChild (form);

    form = XtVaCreateWidget ("form", xmFormWidgetClass, input,
			     XmNfractionBase, 10,
			     NULL);
    XtVaCreateManagedWidget ("description", xmLabelWidgetClass, form,
			     XmNtopAttachment,    XmATTACH_FORM,
			     XmNbottomAttachment, XmATTACH_FORM,
			     XmNleftAttachment,   XmATTACH_FORM,
			     XmNrightAttachment,  XmATTACH_POSITION,
			     XmNrightPosition,    2,
			     XmNalignment,        XmALIGNMENT_END,
			     NULL);
    ms->description =
      XtVaCreateManagedWidget ("description_value",
			       xmTextFieldWidgetClass, form,
			       XmNtraversalOn,     True,
			       XmNrightAttachment, XmATTACH_FORM,
			       XmNleftAttachment,  XmATTACH_POSITION,
			       XmNleftPosition,    3,
			       NULL);
    XtAddCallback (ms->description, XmNactivateCallback,
		   XmProcessTraversal, XmTRAVERSE_NEXT_TAB_GROUP);
    XtManageChild (form);
  }

  /* command box SEARCH */
  form = XtVaCreateWidget ("form", xmFormWidgetClass, input,
                           XmNfractionBase, 10,
                           NULL);
  command_search =
    XtVaCreateManagedWidget ("command_search", xmPushButtonWidgetClass, form,
                             XmNtopAttachment,    XmATTACH_FORM,
                             XmNbottomAttachment, XmATTACH_FORM,
                             XmNleftAttachment,   XmATTACH_POSITION,
                             XmNleftPosition,    8,
                             XmNrightAttachment,  XmATTACH_FORM,
                             NULL);
  XtManageChild (form);
  XtAddCallback (command_search, XmNactivateCallback, MotifSearchInfo, swd);

  XtManageChild (input);
  /* end of Input */
}

static void SwitchMotif (widget, clientData, callData)
     Widget widget;
     XtPointer clientData, callData;
{
  SearchWinData swd = (SearchWinData) clientData;
  SearchInfo s;

  s = swd->s;
  XtDestroyWidget (swd->inputs);
  XtFree (s->info);
  XtFree (s);
  makeMotifSearchInput (swd);
}

static void Search (widget, clientData, callData)
     Widget widget;
     XtPointer clientData, callData;
{
  SearchWinData swd = (SearchWinData) clientData;

  getList (swd);
}

static void makeSearchInput (swd)
     SearchWinData swd;
{
  Widget i_title;
  Widget input;
  Widget command_search;
  Widget command_motif;
  Widget form;

  swd->inputs = input =
    XtVaCreateWidget ("input", xmRowColumnWidgetClass, swd->form, NULL);

  /* command box Motif */
  form = XtVaCreateWidget ("form", xmFormWidgetClass, input,
                           XmNfractionBase, 10,
                           NULL);
  command_motif =
    XtVaCreateManagedWidget ("to_motif", xmPushButtonWidgetClass, form,
                             XmNtopAttachment,    XmATTACH_FORM,
                             XmNbottomAttachment, XmATTACH_FORM,
                             XmNleftAttachment,   XmATTACH_POSITION,
                             XmNleftPosition,    8,
                             XmNrightAttachment,  XmATTACH_FORM,
                             NULL);
  XtManageChild (form);
  XtAddCallback (command_motif, XmNactivateCallback, SwitchMotif, swd);

  /* Make Input */
  i_title = XtVaCreateManagedWidget ("search", xmLabelGadgetClass, input,
                                     XmNalignment, XmALIGNMENT_BEGINNING,
				     NULL);

  {
    char name[20];
    SearchInfo s;
    PirSearch ps;

    s = (SearchInfo) XtMalloc (sizeof (SearchInfoRec));
    swd->s = s;
    s->id = PIR_SEARCH;
    ps = (PirSearch) XtMalloc (sizeof (PirSearchRec));
    s->info = ps;

    form = XtVaCreateWidget ("form", xmFormWidgetClass, input,
			     XmNfractionBase, 10,
			     NULL);
    XtVaCreateManagedWidget ("id_code", xmLabelWidgetClass, form,
			     XmNtopAttachment,    XmATTACH_FORM,
			     XmNbottomAttachment, XmATTACH_FORM,
			     XmNleftAttachment,   XmATTACH_FORM,
			     XmNrightAttachment,  XmATTACH_POSITION,
			     XmNrightPosition,    2,
			     XmNalignment,        XmALIGNMENT_END,
			     NULL);
    ps->id_code =
      XtVaCreateManagedWidget ("id_code_value", xmTextFieldWidgetClass, form,
			       XmNtraversalOn,     True,
			       XmNrightAttachment, XmATTACH_FORM,
			       XmNleftAttachment,  XmATTACH_POSITION,
			       XmNleftPosition,    3,
			       NULL);
    XtAddCallback (ps->id_code, XmNactivateCallback,
		   XmProcessTraversal, XmTRAVERSE_NEXT_TAB_GROUP);
    XtManageChild (form);


    form = XtVaCreateWidget ("form", xmFormWidgetClass, input,
			     XmNfractionBase, 10,
			     NULL);
    XtVaCreateManagedWidget ("molec_name", xmLabelWidgetClass, form,
			     XmNtopAttachment,    XmATTACH_FORM,
			     XmNbottomAttachment, XmATTACH_FORM,
			     XmNleftAttachment,   XmATTACH_FORM,
			     XmNrightAttachment,  XmATTACH_POSITION,
			     XmNrightPosition,    2,
			     XmNalignment,        XmALIGNMENT_END,
			     NULL);
    ps->molec_name =
      XtVaCreateManagedWidget ("melec_name_value",
			       xmTextFieldWidgetClass, form,
			       XmNtraversalOn,     True,
			       XmNrightAttachment, XmATTACH_FORM,
			       XmNleftAttachment,  XmATTACH_POSITION,
			       XmNleftPosition,    3,
			       NULL);
    XtAddCallback (ps->molec_name, XmNactivateCallback,
		   XmProcessTraversal, XmTRAVERSE_NEXT_TAB_GROUP);
    XtManageChild (form);


    form = XtVaCreateWidget ("form", xmFormWidgetClass, input,
			     XmNfractionBase, 10,
			     NULL);
    XtVaCreateManagedWidget ("life_name", xmLabelWidgetClass, form,
			     XmNtopAttachment,    XmATTACH_FORM,
			     XmNbottomAttachment, XmATTACH_FORM,
			     XmNleftAttachment,   XmATTACH_FORM,
			     XmNrightAttachment,  XmATTACH_POSITION,
			     XmNrightPosition,    2,
			     XmNalignment,        XmALIGNMENT_END,
			     NULL);
    ps->life_name =
      XtVaCreateManagedWidget ("life_name_value", xmTextFieldWidgetClass, form,
			       XmNtraversalOn,     True,
			       XmNrightAttachment, XmATTACH_FORM,
			       XmNleftAttachment,  XmATTACH_POSITION,
			       XmNleftPosition,    3,
			       NULL);
    XtAddCallback (ps->life_name, XmNactivateCallback,
		   XmProcessTraversal, XmTRAVERSE_NEXT_TAB_GROUP);
    XtManageChild (form);

    form = XtVaCreateWidget ("form", xmFormWidgetClass, input,
			     XmNfractionBase, 10,
			     NULL);
    XtVaCreateManagedWidget ("keywords", xmLabelWidgetClass, form,
			     XmNtopAttachment,    XmATTACH_FORM,
			     XmNbottomAttachment, XmATTACH_FORM,
			     XmNleftAttachment,   XmATTACH_FORM,
			     XmNrightAttachment,  XmATTACH_POSITION,
			     XmNrightPosition,    2,
			     XmNalignment,        XmALIGNMENT_END,
			     NULL);
    ps->keywords =
      XtVaCreateManagedWidget ("keywords_value", xmTextFieldWidgetClass, form,
			       XmNtraversalOn,     True,
			       XmNrightAttachment, XmATTACH_FORM,
			       XmNleftAttachment,  XmATTACH_POSITION,
			       XmNleftPosition,    3,
			       NULL);
    XtAddCallback (ps->keywords, XmNactivateCallback,
		   XmProcessTraversal, XmTRAVERSE_NEXT_TAB_GROUP);
    XtManageChild (form);
  }

  /* command box SEARCH */
  form = XtVaCreateWidget ("form", xmFormWidgetClass, input,
                           XmNfractionBase, 10,
                           NULL);
  command_search =
    XtVaCreateManagedWidget ("command_search", xmPushButtonWidgetClass, form,
                             XmNtopAttachment,    XmATTACH_FORM,
                             XmNbottomAttachment, XmATTACH_FORM,
                             XmNleftAttachment,   XmATTACH_POSITION,
                             XmNleftPosition,    8,
                             XmNrightAttachment,  XmATTACH_FORM,
                             NULL);
  XtManageChild (form);
  XtAddCallback (command_search, XmNactivateCallback, Search, swd);

  XtManageChild (input);
  /* end of Input */
}

static void freeSearchInfo (s)
     SearchInfo s;
{
  PirSearchByMotif psbm;
  switch (s->id)
    {
    case PIR_SEARCH:
    case MOTIF_SEARCH:
      XtFree (s->info);
      break;
    case PIR_SEARCH_BY_MOTIF:
      psbm = s->info;
      freePatternList (psbm->pattern_list);
      XtFree (s->info);
      break;
    }
  XtFree (s);
}

static void makeDataWindow (dwd)
     DispWinData dwd;
{
  char ttl[50];
  XmString str;
  General g = (General) dwd->g;
  Widget data_window;
  Widget length;
  Widget molecname, lifename, sequencetype;
  Widget molecname_value, attribute;
  Widget glue;

  data_window =
    XtVaCreateWidget ("dataWindow", xmFormWidgetClass, dwd->frame0,
                      NULL);
  sprintf (ttl, "Length: %d", g->length);
  str = XmStringCreateSimple (ttl);
  length =
    XtVaCreateManagedWidget ("length", xmLabelGadgetClass, data_window,
                             XmNlabelString, str,
                             XmNtopAttachment,  XmATTACH_FORM,
                             XmNleftAttachment, XmATTACH_FORM,
                             NULL);
  XmStringFree (str);
  sprintf (ttl, "Weight: %d", g->weight);
  str = XmStringCreateSimple (ttl);
  XtVaCreateManagedWidget ("weight", xmLabelGadgetClass, data_window,
                           XmNlabelString, str,
                           XmNtopAttachment,  XmATTACH_FORM,
                           XmNleftAttachment, XmATTACH_WIDGET,
                           XmNleftWidget,     length,
                           NULL);
  XmStringFree (str);
  molecname =
    XtVaCreateManagedWidget ("molecname", xmLabelGadgetClass, data_window,
                             XmNalignment,      XmALIGNMENT_END,
                             XmNtopAttachment,  XmATTACH_WIDGET,
                             XmNtopWidget,      length,
                             XmNleftAttachment, XmATTACH_FORM,
                             NULL);
  molecname_value = 
    XtVaCreateManagedWidget ("molecnameValue",
                             xmTextFieldWidgetClass, data_window,
                             XmNvalue,           g->molec_name,
                             XmNtopAttachment,   XmATTACH_OPPOSITE_WIDGET,
                             XmNtopWidget,       molecname,
                             XmNtopOffset,       0,
                             XmNleftAttachment,  XmATTACH_WIDGET,
                             XmNleftWidget,      molecname,
                             XmNrightAttachment, XmATTACH_FORM,
                             XmNeditable,        False,
                             NULL);
  lifename =
    XtVaCreateManagedWidget ("lifename", xmLabelGadgetClass, data_window,
                             XmNalignment,       XmALIGNMENT_END,
                             XmNtopAttachment,   XmATTACH_WIDGET,
                             XmNtopWidget,       molecname,
                             XmNrightOffset,     0,
                             XmNleftAttachment,  XmATTACH_FORM,
                             XmNrightAttachment, XmATTACH_OPPOSITE_WIDGET,
                             XmNrightWidget,     molecname,
                             NULL);
  XtVaCreateManagedWidget ("lifenameValue", xmTextFieldWidgetClass,
                           data_window,
                           XmNvalue, g->life_name,
                           XmNtopOffset,       0,
                           XmNleftOffset,      0,
                           XmNtopAttachment,   XmATTACH_OPPOSITE_WIDGET,
                           XmNtopWidget,       lifename,
                           XmNleftAttachment,  XmATTACH_OPPOSITE_WIDGET,
                           XmNleftWidget,      molecname_value,
                           XmNrightAttachment, XmATTACH_FORM,
                           XmNeditable,        False,
                           NULL);
  sequencetype =
    XtVaCreateManagedWidget ("sequencetype", xmLabelGadgetClass, data_window,
                             XmNalignment,       XmALIGNMENT_END,
                             XmNrightOffset,     0,
                             XmNtopAttachment,   XmATTACH_WIDGET,
                             XmNtopWidget,       lifename,
                             XmNleftAttachment,  XmATTACH_FORM,
                             XmNrightAttachment, XmATTACH_OPPOSITE_WIDGET,
                             XmNrightWidget,     molecname,
                             NULL);
  XtVaCreateManagedWidget ("sequencetypeValue",
			   xmTextFieldWidgetClass, data_window,
                           XmNvalue,           g->seq_type,
                           XmNtopOffset,       0,
                           XmNleftOffset,      0,
                           XmNtopAttachment,   XmATTACH_OPPOSITE_WIDGET,
                           XmNtopWidget,       sequencetype,
                           XmNleftAttachment,  XmATTACH_OPPOSITE_WIDGET,
                           XmNleftWidget,      molecname_value,
                           XmNrightAttachment, XmATTACH_FORM,
                           XmNeditable,        False,
                           NULL);
  attribute =
    XtVaCreateManagedWidget ("attribute",
                             xmPushButtonWidgetClass, data_window,
                             XmNtopAttachment,   XmATTACH_WIDGET,
                             XmNtopWidget,       sequencetype,
                             XmNleftAttachment,  XmATTACH_FORM,
                             NULL);
  XtAddCallback (attribute,
                 XmNactivateCallback, Attr, (XtPointer)dwd);
  glue =
    XtVaCreateManagedWidget ("", xmLabelGadgetClass, data_window,
                             XmNtopAttachment,    XmATTACH_WIDGET,
                             XmNtopWidget,        attribute,
                             XmNbottomAttachment, XmATTACH_FORM,
                             NULL);
  XtManageChild (data_window);
}

static void makeFeatureStringList (dwd)
     DispWinData dwd;
{
  int i;
  int num_of_features;
  FeatureList fl;
  Feature f;
  General g = dwd->g;

  /* count number of features */
  num_of_features = 0;
  for (fl = g->feature_list; fl; fl = fl->next)
    num_of_features++;
  dwd->num_of_features = num_of_features;

  dwd->feature_string_list =
    (String *) XtMalloc (sizeof (String) * (num_of_features+1));
  dwd->feature_string_list[num_of_features] = NULL;

  for (i=0, fl = g->feature_list; fl; i++, fl = fl->next)
    /* for each feature */
    {
      f = fl->feature;
      dwd->feature_string_list[i] = (String) XtMalloc (safe_strlen (f->id_func)
                                                       + safe_strlen (f->name_func)
                                                       + 3);
      sprintf (dwd->feature_string_list[i],
               "%s  %s", f->id_func, f->name_func);
    }
}

static void makeFig (dwd)
     DispWinData dwd;
{
  int i, j, k;
  int length;
  char name[256];
  int font_height;
  int font_width;
  General g = dwd->g;
  FeatureList fl;
  Feature f;
  Boolean state;
  int x, y;
  int x1, y1;
  int x2, y2;
  int num_of_features = dwd->num_of_features;

  dwd->fig =
    XtVaCreateWidget ("fig", figWidgetClass, dwd->scrolled_window,
		      NULL);

  length = safe_strlen (g->sequence);

  font_height = app_resources.font_a[dwd->cur_mag]->ascent
    + app_resources.font_a[dwd->cur_mag]->descent;

  font_width = app_resources.font_a[dwd->cur_mag]->max_bounds.width;

  /* make sequence */
  for (i=0; i < length; i++)
    {
      char text[2];
      sprintf (name, "seq%c", g->sequence[i]);
      text[0] = g->sequence[i];
      text[1] = '\0';
      XtVaCreateManagedWidget (name, figTextClass, dwd->fig,
                               XtNlabel, text,
                               XtNfont, app_resources.font_a[dwd->cur_mag],
                               XtNy1, 
			       font_height * 2
			       + app_resources.font_a[dwd->cur_mag]->ascent,
                               XtNx1, (i + 1) * font_width,
                               NULL);
    }

  dwd->features = 
    (Widget **) XtMalloc (sizeof (Widget *) * (num_of_features+1));
  dwd->features[num_of_features] = NULL;

  for (i=0, fl = g->feature_list; fl; i++, fl = fl->next)
    /* for each feature */
    {
      PositionList pl;
      RegionList rl;
      int number_of_widgets =0;

      f = fl->feature;
      /* compute number of widget for this feature  */
      for (pl = f->position_list; pl; pl = pl->next)
        number_of_widgets++;

      for (rl = f->region_list; rl; rl = rl->next)
        number_of_widgets += 3;

      if (number_of_widgets == 0)
	{
	  dwd->features[i] = NULL;
	  continue;
	}

      dwd->features[i] =
	(Widget *) XtMalloc (sizeof (Widget) * (number_of_widgets +1));
      dwd->features[i][number_of_widgets] = NULL;

      j = 0;

      sprintf (name, "arrow_%s", f->id_func);

      y = font_height * 3 +2;

      /* make arrow for position feature */
      for (pl = f->position_list; pl; pl = pl->next)
        {
          x = font_width * pl->position + font_width/2;

          dwd->features[i][j++] =
            XtVaCreateWidget (name, figArrowClass, dwd->fig,
                              XtNx1, x,
                              XtNy1, y,
                              XtNlength,
                              font_height,
                              NULL);
        }

      sprintf (name, "line_%s", f->id_func);

      y1 = font_height * 2 -2;

      y2 = font_height
	  - font_height * i / num_of_features + 2;

      /* make horizontal and vertical lines for region feature */
      for (rl = f->region_list; rl; rl = rl->next)
        {
          x1 = font_width * rl->region->start + font_width/2;
          x2 = font_width * rl->region->end + font_width/2;

          dwd->features[i][j++] =
            XtVaCreateWidget (name, figLineClass, dwd->fig,
                              XtNx1, x1,
                              XtNy1, y1,
                              XtNx2, x1,
                              XtNy2, y2,
                              NULL);
          dwd->features[i][j++] =
            XtVaCreateWidget (name, figLineClass, dwd->fig,
                              XtNx1, x2,
                              XtNy1, y1,
                              XtNx2, x2,
                              XtNy2, y2,
                              NULL);
          dwd->features[i][j++] =
            XtVaCreateWidget (name, figLineClass, dwd->fig,
                              XtNx1, x1,
                              XtNy1, y2,
                              XtNx2, x2,
                              XtNy2, y2,
                              NULL);
        }
    }
  {
    int selected_item_count;
    int *selected_item_positions;

    if (XmListGetSelectedPos (dwd->listbox,
                              &selected_item_positions,
                              &selected_item_count))
      {
        RefreshSelection (dwd, selected_item_count, selected_item_positions);
        XtFree (selected_item_positions);
      }
  }
 
  XtManageChild (dwd->fig);
}

static void makeAttributeWindow (dwd)
     DispWinData dwd;
{
  char name[50];
  AttrWinData awd;
  char *strings;
  int i;
  Widget form;
  Widget alternativename, includes, entrydate, sequencedate, textdate;
  Widget keywords, comments;
  Widget alternativename_value;
  Widget comments_value;
  Widget ok;

  General g;

  g = dwd->g;

  awd = dwd->attr_win_data =
    (AttrWinData) XtMalloc (sizeof (struct _AttrWinDataRec));
  awd->dwd = dwd;
  sprintf (name, "%s:attrib:pir_kappa", g->id_code);
  awd->top = 
    XtVaAppCreateShell (name, "KappaAttr",
			applicationShellWidgetClass, display,
			/* XtNtransient, True,*/
			NULL);
  form =
    XtVaCreateWidget ("form", xmFormWidgetClass, awd->top,
		      NULL);
  
  alternativename =
    XtVaCreateManagedWidget ("alternativename", xmLabelGadgetClass, form,
                             XmNtopAttachment,  XmATTACH_FORM,
                             XmNleftAttachment, XmATTACH_FORM,
                             NULL);
  strings =  sl2ss (g->alternative_names);
  alternativename_value =
    XtVaCreateManagedWidget ("alternativenameValue", xmTextWidgetClass, form,
                             XmNvalue, strings,
                             XmNeditMode, XmMULTI_LINE_EDIT,
                             XmNtopAttachment,  XmATTACH_FORM,
                             XmNleftAttachment, XmATTACH_WIDGET,
                             XmNleftWidget,     alternativename,
                             XmNrightAttachment, XmATTACH_FORM,
                             XmNeditable,        False,
                             NULL);
  XtFree (strings);

  includes =
    XtVaCreateManagedWidget ("includes", xmLabelGadgetClass, form,
                             XmNalignment,       XmALIGNMENT_END,
                             XmNtopAttachment,   XmATTACH_WIDGET,
                             XmNtopWidget,       alternativename,
                             XmNrightOffset,     0,
                             XmNleftAttachment,  XmATTACH_FORM,
                             XmNrightAttachment, XmATTACH_OPPOSITE_WIDGET,
                             XmNrightWidget,     alternativename,
                             NULL);
  strings =  sl2ss (g->includes);
  XtVaCreateManagedWidget ("includesValue", xmTextWidgetClass, form,
			   XmNvalue, strings,
                           XmNeditMode, XmMULTI_LINE_EDIT,
                           XmNtopOffset,       0,
                           XmNleftOffset,      0,
                           XmNtopAttachment,   XmATTACH_OPPOSITE_WIDGET,
                           XmNtopWidget,       includes,
                           XmNleftAttachment,  XmATTACH_OPPOSITE_WIDGET,
                           XmNleftWidget,      alternativename_value,
                           XmNrightAttachment, XmATTACH_FORM,
                           XmNeditable,        False,
			   NULL);
  XtFree (strings);

  entrydate =
    XtVaCreateManagedWidget ("entrydate", xmLabelGadgetClass, form,
                             XmNalignment,       XmALIGNMENT_END,
                             XmNtopAttachment,   XmATTACH_WIDGET,
                             XmNtopWidget,       includes,
                             XmNrightOffset,     0,
                             XmNleftAttachment,  XmATTACH_FORM,
                             XmNrightAttachment, XmATTACH_OPPOSITE_WIDGET,
                             XmNrightWidget,     alternativename,
                             NULL);
  XtVaCreateManagedWidget ("entrydateValue", xmTextFieldWidgetClass, form,
			   XmNvalue, g->entry_date,
                           XmNtopOffset,       0,
                           XmNleftOffset,      0,
                           XmNtopAttachment,   XmATTACH_OPPOSITE_WIDGET,
                           XmNtopWidget,       entrydate,
                           XmNleftAttachment,  XmATTACH_OPPOSITE_WIDGET,
                           XmNleftWidget,      alternativename_value,
                           XmNrightAttachment, XmATTACH_FORM,
                           XmNeditable,        False,
			   NULL);

  sequencedate =
    XtVaCreateManagedWidget ("sequencedate", xmLabelGadgetClass, form,
                             XmNalignment,       XmALIGNMENT_END,
                             XmNtopAttachment,   XmATTACH_WIDGET,
                             XmNtopWidget,       entrydate,
                             XmNrightOffset,     0,
                             XmNleftAttachment,  XmATTACH_FORM,
                             XmNrightAttachment, XmATTACH_OPPOSITE_WIDGET,
                             XmNrightWidget,     alternativename,
                             NULL);
  XtVaCreateManagedWidget ("sequencedateValue", xmTextFieldWidgetClass, form,
			   XmNvalue, g->seq_date,
                           XmNtopOffset,       0,
                           XmNleftOffset,      0,
                           XmNtopAttachment,   XmATTACH_OPPOSITE_WIDGET,
                           XmNtopWidget,       sequencedate,
                           XmNleftAttachment,  XmATTACH_OPPOSITE_WIDGET,
                           XmNleftWidget,      alternativename_value,
                           XmNrightAttachment, XmATTACH_FORM,
                           XmNeditable,        False,
			   NULL);

  textdate =
    XtVaCreateManagedWidget ("textdate", xmLabelGadgetClass, form,
                             XmNalignment,       XmALIGNMENT_END,
                             XmNtopAttachment,   XmATTACH_WIDGET,
                             XmNtopWidget,       sequencedate,
                             XmNrightOffset,     0,
                             XmNleftAttachment,  XmATTACH_FORM,
                             XmNrightAttachment, XmATTACH_OPPOSITE_WIDGET,
                             XmNrightWidget,     alternativename,
                             NULL);
  XtVaCreateManagedWidget ("textdateValue", xmTextFieldWidgetClass, form,
			   XmNvalue, g->text_date,
                           XmNtopOffset,       0,
                           XmNleftOffset,      0,
                           XmNtopAttachment,   XmATTACH_OPPOSITE_WIDGET,
                           XmNtopWidget,       textdate,
                           XmNleftAttachment,  XmATTACH_OPPOSITE_WIDGET,
                           XmNleftWidget,      alternativename_value,
                           XmNrightAttachment, XmATTACH_FORM,
                           XmNeditable,        False,
			   NULL);

  keywords =
    XtVaCreateManagedWidget ("keywords", xmLabelGadgetClass, form,
                             XmNalignment,       XmALIGNMENT_END,
                             XmNtopAttachment,   XmATTACH_WIDGET,
                             XmNtopWidget,       textdate,
                             XmNrightOffset,     0,
                             XmNleftAttachment,  XmATTACH_FORM,
                             XmNrightAttachment, XmATTACH_OPPOSITE_WIDGET,
                             XmNrightWidget,     alternativename,
                             NULL);
  strings =  sl2ss (g->keywords);
  XtVaCreateManagedWidget ("keywordsValue", xmTextWidgetClass, form,
			   XmNvalue, strings,
                           XmNeditMode, XmMULTI_LINE_EDIT,
                           XmNtopOffset,       0,
                           XmNleftOffset,      0,
                           XmNtopAttachment,   XmATTACH_OPPOSITE_WIDGET,
                           XmNtopWidget,       keywords,
                           XmNleftAttachment,  XmATTACH_OPPOSITE_WIDGET,
                           XmNleftWidget,      alternativename_value,
                           XmNrightAttachment, XmATTACH_FORM,
                           XmNeditable,        False,
			   NULL);
  XtFree (strings);

  comments =
    XtVaCreateManagedWidget ("comments", xmLabelGadgetClass, form,
                             XmNalignment,       XmALIGNMENT_END,
                             XmNtopAttachment,   XmATTACH_WIDGET,
                             XmNtopWidget,       keywords,
                             XmNrightOffset,     0,
                             XmNleftAttachment,  XmATTACH_FORM,
                             XmNrightAttachment, XmATTACH_OPPOSITE_WIDGET,
                             XmNrightWidget,     alternativename,
                             NULL);

  strings =  sl2ss (g->comments);
  {
    Arg args[20];
    int argc=0;

    XtSetArg (args[argc], XmNrows, 5); argc++;
    XtSetArg (args[argc], XmNcolumns, 25); argc++;
    XtSetArg (args[argc], XmNeditable, False); argc++;
    XtSetArg (args[argc], XmNvalue, strings); argc++;
    XtSetArg (args[argc], XmNeditMode, XmMULTI_LINE_EDIT); argc++;
    comments_value =
      XmCreateScrolledText (form, "commentsValue", args, argc);

    XtVaSetValues (XtParent (comments_value),
                   XmNtopAttachment,   XmATTACH_WIDGET,
                   XmNtopWidget,       comments,
                   XmNleftAttachment,  XmATTACH_FORM,
                   XmNrightAttachment, XmATTACH_FORM,
                   NULL);

    XtManageChild (comments_value);
  }
  XtFree (strings);

  ok =
    XtVaCreateManagedWidget ("ok", xmPushButtonWidgetClass, form,
                             XmNbottomAttachment, XmATTACH_FORM,
                             XmNleftAttachment,   XmATTACH_FORM,
			     NULL);
  XtAddCallback (ok, XmNactivateCallback, AttrOK, (XtPointer)awd);

  XtVaSetValues (XtParent (comments_value),
                 XmNbottomAttachment,   XmATTACH_WIDGET,
                 XmNbottomWidget,       ok,
                 NULL);

  XtManageChild (form);

  XtRealizeWidget (awd->top);
}
