/*
/*	(C)1992 Institute for New Generation Computer Technology
/*		$BG[I[$=$NB>$O(BCOPYRIGHT$B%U%!%$%k$r;2>H$7$F2<$5$$(B
/*		(Read COPYRIGHT for detailed information.)
 */
#include "Pdb.h"
typedef struct _DateEntryRec *DateEntry;
typedef struct _DateListRec *DateList;
typedef struct _SequenceRec *Sequence;
typedef struct _HelixRec *Helix;
typedef struct _HelixListRec *HelixList;
typedef struct _SheetSubRec *SheetSub;
typedef struct _SheetSubListRec *SheetSubList;
typedef struct _SheetRec *Sheet;
typedef struct _SheetListRec *SheetList;
typedef struct _TurnRec *Turn;
typedef struct _TurnListRec *TurnList;
typedef struct _SsbondRec *Ssbond;
typedef struct _SsbondListRec *SsbondList;
typedef struct _FeatureRec *Feature;
typedef struct _GeneralRec *General;

typedef struct _DateEntryRec {
  char *date_string;
  char *kind;
} DateEntryRec;

typedef struct _DateListRec {
  struct _DateEntryRec *date;
  struct _DateListRec *next;
} DateListRec;

typedef struct _HelixRec {
  char *helix_id;
  int start, end;
  char *type;
  char *comment;
} HelixRec;

typedef struct _HelixListRec {
  Helix helix;
  struct _HelixListRec *next;
} HelixListRec;

typedef struct _SheetSubRec {
  int sheet_index;
  int start, end, xyz;
} SheetSubRec;

typedef struct _SheetSubListRec {
  SheetSub sheet_sub;
  struct _SheetSubListRec *next;
} SheetSubListRec;

typedef struct _SheetRec {
  char *sheet_id;
  SheetSubList sheet_sub_list;
} SheetRec;

typedef struct _SheetListRec {
  Sheet sheet;
  struct _SheetListRec *next;
} SheetListRec;

typedef struct _TurnRec {
  char *turn_id;
  int start, end;
  char *comment;
} TurnRec;

typedef struct _TurnListRec {
  Turn turn;
  struct _TurnListRec *next;
} TurnListRec;

typedef struct _SsbondRec {
  int start, end;
} SsbondRec;

typedef struct _SsbondListRec {
  Ssbond ssbond;
  struct _SsbondListRec *next;
} SsbondListRec;

typedef struct _SequenceRec {
  int length;
  char *data;
} SequenceRec;

typedef struct _FeatureRec {
  Sequence sequence;
  HelixList  helix_list;
  SheetList  sheet_list;
  TurnList   turn_list;
  SsbondList ssbond_list;
} FeatureRec;

typedef struct _GeneralRec {
  char *id_code;
  char *func_name;
  DateList date_list;
  char *compound;
  char *source;
  StringList sid_code;
  Feature feature;
} GeneralRec;

typedef struct _SearchInfoRec * SearchInfo;

typedef struct _SearchInfoRec {
  Widget id_code;
  Widget func_name;
  Widget compound;
  Widget source;
} SearchInfoRec;
