/*
/*	(C)1992 Institute for New Generation Computer Technology
/*		$BG[I[$=$NB>$O(BCOPYRIGHT$B%U%!%$%k$r;2>H$7$F2<$5$$(B
/*		(Read COPYRIGHT for detailed information.)
 */
#include <stdio.h>
#include <string.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include <X11/Shell.h>
#include <Xm/PanedW.h>
#include <Xm/Form.h>
#include <Xm/RowColumn.h>
#include <Xm/Label.h>
#include <Xm/LabelG.h>
#include <Xm/Text.h>
#include <Xm/TextF.h>
#include <Xm/PushB.h>
#include <Xm/List.h>

#include "Fig.h"
#include "FigLine.h"
#include "FigText.h"
#include "FigArrow.h"

#include "DataBaseP.h"
#include "ObjectsP.h"
#include "PdbP.h"
#include "SearchP.h"
#include "DispWinP.h"
#include "app_res.h"
#include "AttribP.h"

#include "kappa_rpc1.h"

#include "misc.h"

static void getInfo ();
static void getTitle ();
static void printInfo ();
static void freeInfo ();
static void makeSearchInput ();
static void freeSearchInfo ();
static void makeDataWindow ();
static void makeFig ();
static void makeFeatureStringList ();
static void makeAttributeWindow ();

extern Display *display;
extern void Attr ();

static DataBaseRec PDB_databaseRec =
{
  "pdb_gen",
  getInfo,
  getTitle,
  printInfo,
  freeInfo,
  makeSearchInput,
  freeSearchInfo,
  makeDataWindow,
  makeFig,
  makeFeatureStringList,
  makeAttributeWindow,
};

DataBase PDB_database = &PDB_databaseRec;


static void getList (swd)
     SearchWinData swd;
{
  extern KPS *Kappa;
  XmStringTable str_table;
  char *term;
  char *temp0, *temp1, *result;
  char database_gen[30]; /* I guess this is enough... */
  char output_format[50]; /* I guess this is enough... */
  DataBase database = app_resources.database;

  int i;
  int ret;

  strcpy (database_gen, "pdb_gen");
  strcpy (database_gen + sizeof ("pdb_gen") -1, app_resources.database_no);

  if (swd->string_list)
    {
      freeStringList (swd->string_list);
      swd->string_list = NULL;
    }

  {
    char *string;
    SearchInfo s;

    s = swd->s;

    temp0 = NULL;
    XtVaGetValues(s->id_code, XmNvalue, &string, NULL);
    term = makeTerm (string, "id_code");
    temp1 = makeExp (temp0, term);
    XtFree (term);

    temp0 = temp1;
    XtVaGetValues(s->func_name, XmNvalue, &string, NULL);
    term = makeTerm (string, "func_name");
    temp1 = makeExp (temp0, term);
    XtFree (term);
    XtFree (temp0);

    temp0 = temp1;
    XtVaGetValues(s->compound, XmNvalue, &string, NULL);
    term = makeTerm (string, "compound");
    temp1 = makeExp (temp0, term);
    XtFree (term);
    XtFree (temp0);

    temp0 = temp1;
    XtVaGetValues(s->source, XmNvalue, &string, NULL);
    term = makeTerm (string, "source");
    temp1 = makeExp (temp0, term);
    XtFree (term);
    XtFree (temp0);
  }

  result = temp1;
  printf ("Q: %s\n", result);

  if (result == NULL)
    /* do nothing */
    return;

  if ((ret = KappaOpen (Kappa,
			database_gen)))
    {
      XtFree (result);
      fprintf (stderr, "KappaOpen Error : %d\n",ret);
      return;
    }

  sprintf (output_format, "(pdb_gen%s(id_code))", app_resources.database_no);
  if (KappaSearch (Kappa, result, 1, output_format,"_",
		   &(swd->number_of_hits)) != 0)
    {
      fprintf (stderr, "Kappa Search Failed : %d\n",ret);
      swd->number_of_hits = 0;
    }
  XtFree (result);

  swd->string_list = NULL;
  if (swd->number_of_hits > 0)
    {
      if (ret = KappaReadAll (Kappa,"_", data, BUF_LEN))
        {
          fprintf (stderr, "KappaRead Error : %d\n",ret);
          swd->string_list = NULL;
	  swd->number_of_hits = 0;
        }
      else
        {
	  int len;
	  StringList sl;

          /* parse the contents */
          point = 0;
          advance (0);
          swd->string_list = parseStringSetList ();
	  for (len=0, sl=swd->string_list; sl; len++,sl=sl->next);
	  swd->number_of_hits = len;
        }
    }
  if (swd->string_list)
    {
      char num[10];
      XmString str;

      str_table = (XmStringTable)
        XtMalloc (sizeof (XmString *) * swd->number_of_hits);
      {
        StringList sl;

        for (i=0, sl = swd->string_list; sl; i++,sl = sl->next)
          str_table[i] = XmStringCreateSimple (sl->string);
      }

      XtVaSetValues (swd->list,
                     XmNitems, str_table,
                     XmNitemCount, swd->number_of_hits,
                     NULL);

      for (i = 0; i < swd->number_of_hits; i++)
        XmStringFree (str_table[i]);
      XtFree (str_table);

      sprintf (num, "%d", swd->number_of_hits);
      str = XmStringCreateSimple (num);
      XtVaSetValues (swd->total_hits,
                     XmNlabelString, str,
                     NULL);
      XmStringFree (str);
    }
  else
    {
      XmString str;

      XtVaSetValues (swd->list,
                     XmNitems, NULL,
                     XmNitemCount, 0,
                     NULL);

      str = XmStringCreateSimple ("0");
      XtVaSetValues (swd->total_hits,
		     XmNlabelString, str,
		     NULL);
      XmStringFree (str);
    }

  if ((ret = KappaClose(Kappa)))
    {
      fprintf (stderr, "KappaClose Error : %d\n",ret);
    }
}

static DateEntry parseDateEntry ()
{
  DateEntry de;

  de = (DateEntry) XtMalloc (sizeof (DateEntryRec));
  advance ('{');
  de->date_string = parseSTRINGorWORD ();
  advance (',');
  de->kind = parseSTRINGorWORD ();
  advance ('}');

  return de;
}

static DateList parseDateList ()
{
  DateList dl, dl_current, dl_top;
  DateEntry de;

  advance ('[');
  if (token == ']')
    {
      advance (']');
      return NULL;
    }
  de = parseDateEntry ();
  dl = (DateList) XtMalloc (sizeof (DateListRec));
  dl->date = de;
  dl_top = dl_current = dl;

  while (token != ']')
    {
      advance (',');
      de = parseDateEntry ();
      dl = (DateList) XtMalloc (sizeof (DateListRec));
      dl->date = de;
      dl_current->next = dl;
      dl_current = dl;
    }

  dl_current->next = NULL;
  advance (']');

  return dl_top;
}

static General parseGeneralSUB ()
{
  General g;

  g =  (General)XtMalloc (sizeof (GeneralRec));

  g->id_code = parseSTRINGorWORD ();
  advance (',');
  g->func_name = parseSTRINGorWORD ();
  advance (',');
  g->date_list = parseDateList ();
  advance (',');
  g->compound = parseSTRINGorWORD ();
  advance (',');
  g->source = parseSTRINGorWORD ();
  advance (',');
  g->sid_code = parseStringList ();
  g->feature = NULL;
  return g;
}

static General parseGeneral ()
{
  General g;

  advance ('{');
  g = parseGeneralSUB ();
  advance ('}');

  return g;
}

static Sequence parseSequence ()
{
  Sequence s;

  advance ('{');
  s = (Sequence) XtMalloc (sizeof (SequenceRec));
  s->length = parseINTEGER ();
  advance (',');
  s->data   = parseSTRINGorWORD ();
  advance ('}');

  return s;
}

static Helix parseHelix ()
{
  Helix h;
  char *string;

  h = (Helix) XtMalloc (sizeof (HelixRec));
  advance ('{');
  h->helix_id = parseSTRINGorWORD ();
  advance (',');
  string = parseSTRINGorWORD ();  h->start = atoi (string);  XtFree (string);
  advance (',');
  advance (WORD);
  advance (',');
  string = parseSTRINGorWORD ();  h->end = atoi (string);  XtFree (string);
  advance (',');
  advance (WORD);
  advance (',');
  h->type = parseSTRINGorWORD ();
  advance (',');
  h->comment = parseSTRINGorWORD ();
  advance ('}');

  return h;
}

static HelixList parseHelixList ()
{
  HelixList hl, hl_current, hl_top;
  Helix h;

  advance ('[');
  if (token == ']')
    {
      advance (']');
      return NULL;
    }
  h = parseHelix ();
  hl = (HelixList) XtMalloc (sizeof (HelixListRec));
  hl->helix = h;
  hl_top = hl_current = hl;

  while (token != ']')
    {
      advance (',');
      h = parseHelix ();
      hl = (HelixList) XtMalloc (sizeof (HelixListRec));
      hl->helix = h;
      hl_current->next = hl;
      hl_current = hl;
    }

  hl_current->next = NULL;
  advance (']');

  return hl_top;
}

static skipSTRINGorWORD ()
{
  if (token == WORD || token == STRING)
    advance (token);
}

static SheetSub parseSheetSub ()
{
  SheetSub ss;
  char *string;

  ss = (SheetSub) XtMalloc (sizeof (SheetSubRec));
  advance ('{');
  ss->sheet_index = parseINTEGER ();
  advance (',');
  string = parseSTRINGorWORD ();  ss->start = atoi (string);  XtFree (string);
  advance (',');
  advance (WORD);
  advance (',');
  string = parseSTRINGorWORD ();  ss->end = atoi (string);  XtFree (string);
  advance (',');
  advance (WORD);
  advance (',');
  ss->xyz = parseINTEGER ();
  advance (',');
  skipSTRINGorWORD ();
  advance (',');
  skipSTRINGorWORD ();
  advance (',');
  skipSTRINGorWORD ();
  advance (',');
  skipSTRINGorWORD ();
  advance (',');
  skipSTRINGorWORD ();
  advance (',');
  skipSTRINGorWORD ();
  advance ('}');

  return ss;
}

static SheetSubList parseSheetSubList ()
{
  SheetSubList ssl, ssl_current, ssl_top;
  SheetSub ss;

  advance ('[');
  if (token == ']')
    {
      advance (']');
      return NULL;
    }
  ss = parseSheetSub ();
  ssl = (SheetSubList) XtMalloc (sizeof (SheetSubListRec));
  ssl->sheet_sub = ss;
  ssl_top = ssl_current = ssl;

  while (token != ']')
    {
      advance (',');
      ss = parseSheetSub ();
      ssl = (SheetSubList) XtMalloc (sizeof (SheetSubListRec));
      ssl->sheet_sub = ss;
      ssl_current->next = ssl;
      ssl_current = ssl;
    }

  ssl_current->next = NULL;
  advance (']');

  return ssl_top;
}

static Sheet parseSheet ()
{
  Sheet s;

  advance ('{');
  s = (Sheet) XtMalloc (sizeof (SheetRec));
  s->sheet_id = parseSTRINGorWORD ();
  advance (',');
  s->sheet_sub_list = parseSheetSubList ();
  advance ('}');

  return s;
}

static SheetList parseSheetList ()
{
  SheetList sl, sl_current, sl_top;
  Sheet s;

  advance ('[');
  if (token == ']')
    {
      advance (']');
      return NULL;
    }
  s = parseSheet ();
  sl = (SheetList) XtMalloc (sizeof (SheetListRec));
  sl->sheet = s;
  sl_top = sl_current = sl;

  while (token != ']')
    {
      advance (',');
      s = parseSheet ();
      sl = (SheetList) XtMalloc (sizeof (SheetListRec));
      sl->sheet = s;
      sl_current->next = sl;
      sl_current = sl;
    }

  sl_current->next = NULL;
  advance (']');

  return sl_top;
}

static Turn parseTurn ()
{
  Turn t;
  char *string;

  advance ('{');
  t = (Turn) XtMalloc (sizeof (TurnRec));
  t->turn_id = parseSTRINGorWORD ();
  advance (',');
  string = parseSTRINGorWORD ();  t->start = atoi (string);  XtFree (string);
  advance (',');
  advance (WORD);
  advance (',');
  string = parseSTRINGorWORD ();  t->end = atoi (string);  XtFree (string);
  advance (',');
  advance (WORD);
  advance (',');
  t->comment = parseSTRINGorWORD ();
  advance ('}');

  return t;
}

static TurnList parseTurnList ()
{
  TurnList tl, tl_current, tl_top;
  Turn t;

  advance ('[');
  if (token == ']')
    {
      advance (']');
      return NULL;
    }
  t = parseTurn ();
  tl = (TurnList) XtMalloc (sizeof (TurnListRec));
  tl->turn = t;
  tl_top = tl_current = tl;

  while (token != ']')
    {
      advance (',');
      t = parseTurn ();
      tl = (TurnList) XtMalloc (sizeof (TurnListRec));
      tl->turn = t;
      tl_current->next = tl;
      tl_current = tl;
    }

  tl_current->next = NULL;
  advance (']');

  return tl_top;
}

static Ssbond parseSsbond ()
{
  Ssbond s;
  char *string;

  advance ('{');
  s = (Ssbond) XtMalloc (sizeof (SsbondRec));
  string = parseSTRINGorWORD ();  s->start = atoi (string);  XtFree (string);
  advance (',');
  advance (WORD);
  advance (',');
  string = parseSTRINGorWORD ();  s->end = atoi (string);  XtFree (string);
  advance (',');
  advance (WORD);
  advance ('}');

  return s;
}

static SsbondList parseSsbondList ()
{
  SsbondList sl, sl_current, sl_top;
  Ssbond s;

  advance ('[');
  if (token == ']')
    {
      advance (']');
      return NULL;
    }
  s = parseSsbond ();
  sl = (SsbondList) XtMalloc (sizeof (SsbondListRec));
  sl->ssbond = s;
  sl_top = sl_current = sl;

  while (token != ']')
    {
      advance (',');
      s = parseSsbond ();
      sl = (SsbondList) XtMalloc (sizeof (SsbondListRec));
      sl->ssbond = s;
      sl_current->next = sl;
      sl_current = sl;
    }

  sl_current->next = NULL;
  advance (']');

  return sl_top;
}

static Feature parseFeature ()
{
  Feature f;
  StringList sl;

  advance ('{');
  advance (STRING); /* skip sid_code */
  advance (',');
  f = (Feature) XtMalloc (sizeof (FeatureRec));
  f->sequence = parseSequence ();
  advance (',');
  f->helix_list = parseHelixList ();
  advance (',');
  f->sheet_list = parseSheetList ();
  advance (',');
  f->turn_list =  parseTurnList ();
  advance (',');
  f->ssbond_list =  parseSsbondList ();
  advance ('}');

  return f;
}

static General  getGeneral (hostname, database_no, id_code)
     char *hostname;
     char *database_no; 
     char *id_code;
{
  extern KPS *Kappa;
  char query[100];
  int hits;
  int ret;
  char database_gen[20]; /* I guess this is enough... */
  char output_format[250]; /* I guess this is enough... */

  strcpy (database_gen, "pdb_gen");
  strcpy (database_gen+sizeof ("pdb_gen")-1, database_no);

  sprintf (query, "id_code=\"%s\"", id_code);
  printf ("Q: %s\n", query);

  if ((ret = KappaOpen (Kappa,
			database_gen)))
    {
      fprintf (stderr, "KappaOpen Error : %d\n",ret);
      return NULL;
    }

  sprintf (output_format,
	   "(pdb_gen%s(id_code,func_name,date,compound,source,sid_code))",
	   database_no);
  if (KappaSearch (Kappa, query, 1,
		   output_format,
		   "_",
		   &hits) != 0)
    {
      fprintf (stderr, "Kappa Search Failed : %d\n",ret);
      hits = 0;
    }

  if (hits > 0)
    {
      if (ret = KappaRead (Kappa,"_", data, BUF_LEN))
	{
	  fprintf (stderr, "KappaRead Error : %d\n",ret);
	}

      if ((ret = KappaClose(Kappa)))
	{
	  fprintf (stderr, "KappaClose Error : %d\n",ret);
	}
      /* parse the contents */
      point = 0;
      advance (0);
      return parseGeneral ();
    }
  else
    {
      if ((ret = KappaClose(Kappa)))
	{
	  fprintf (stderr, "KappaClose Error : %d\n",ret);
	}
      return NULL;
    }
}

static Feature getFeature (hostname, database_no, sid_code)
     char *hostname;
     char *database_no;
     StringList sid_code;
{
  extern KPS *Kappa;
  char query[100];
  int hits;
  int ret;
  char database_fea[200]; /* I guess this is enough... */
  char output_format[50]; /* I guess this is enough... */

  strcpy (database_fea, "pdb_seq");
  strcpy (database_fea+sizeof ("pdb_seq")-1, database_no);

  sprintf (query, "sid_code=\"%s\"", sid_code->string);
  printf ("Q: %s\n", query);

  if ((ret = KappaOpen (Kappa,
			  database_fea)))
    {
      fprintf (stderr, "KappaOpen Error : %d\n",ret);
      return NULL;
    }

  sprintf (output_format, "(pdb_seq%s(sid_code,sequence,helix,sheet,turn,ssbond))",
	   database_no);
  if (KappaSearch (Kappa, query, 1, output_format,"_",
		   &hits) != 0)
    {
      fprintf (stderr, "Kappa Search Failed : %d\n",ret);
      hits = 0;
    }

  if (hits > 0)
    {
      if (ret = KappaRead (Kappa,"_", data, BUF_LEN))
	{
	  fprintf (stderr, "KappaRead Error : %d\n",ret);
	}

      if ((ret = KappaClose(Kappa)))
	{
	  fprintf (stderr, "KappaClose Error : %d\n",ret);
	}
      /* parse the contents */
      point = 0;
      advance (0);
      return parseFeature ();
    }
  else
    {
      if ((ret = KappaClose(Kappa)))
	{
	  fprintf (stderr, "KappaClose Error : %d\n",ret);
	}
      return NULL;
    }
}

static void getInfo (dwd)
     DispWinData dwd;
{
  General g;

  char *hostname    = dwd->hostname;
  char *database_no = dwd->database_no;
  char *id_code     = dwd->candidate_list[dwd->current];

  g = getGeneral (hostname, database_no, id_code);
  g->feature = getFeature (hostname, database_no, g->sid_code);

  dwd->g = g;
  return;
}

static void getTitle (dwd, buffer)
     DispWinData dwd;
     char *buffer;
{
  General g = dwd->g;

  sprintf (buffer, "%s:pdb_kappa", g->id_code);
}

static void printInfo (g)
     General g;
{
  printf ("Not Supported yet.\n");
}

static void freeDateEntry (d)
     DateEntry d;
{
  XtFree (d->date_string);
  XtFree (d->kind);
  XtFree (d);
}

static void freeDateList (dl)
     DateList dl;
{
  DateList dl1, dl2;

  for (dl1 = dl; dl1; dl1 = dl2)
    {
      dl2 = dl1->next;
      freeDateEntry (dl1->date);
      XtFree (dl1);
    }
}

static void freeHelix (h)
     Helix h;
{
  XtFree (h->helix_id);
  XtFree (h->type);
  XtFree (h->comment);
  XtFree (h);
}

static void freeHelixList (l)
     HelixList l;
{
  HelixList l1, l2;

  for (l1 = l; l1; l1 = l2)
    {
      l2 = l1->next;
      freeHelix (l1->helix);
      XtFree (l1);
    }
}

static void freeSheetSub (s)
     SheetSub s;
{
  XtFree (s);
}

static void freeSheetSubList (l)
     SheetSubList l;
{
  SheetSubList l1, l2;

  for (l1 = l; l1; l1 = l2)
    {
      l2 = l1->next;
      freeSheetSub (l1->sheet_sub);
      XtFree (l1);
    }
}

static void freeSheet (s)
     Sheet s;
{
  XtFree (s->sheet_id);
  freeSheetSubList (s->sheet_sub_list);
  XtFree (s);
}

static void freeSheetList (l)
     SheetList l;
{
  SheetList l1, l2;

  for (l1 = l; l1; l1 = l2)
    {
      l2 = l1->next;
      freeSheet (l1->sheet);
      XtFree (l1);
    }
}

static void freeTurn (t)
     Turn t;
{
  XtFree (t->turn_id);
  XtFree (t->comment);
  XtFree (t);
}

static void freeTurnList (l)
     TurnList l;
{
  TurnList l1, l2;

  for (l1 = l; l1; l1 = l2)
    {
      l2 = l1->next;
      freeTurn (l1->turn);
      XtFree (l1);
    }
}

static void freeSsbond (ss)
     Ssbond ss;
{
  XtFree (ss);
}

static void freeSsbondList (l)
     SsbondList l;
{
  SsbondList l1, l2;

  for (l1 = l; l1; l1 = l2)
    {
      l2 = l1->next;
      freeSsbond (l1->ssbond);
      XtFree (l1);
    }
}

static void freeSequence (s)
     Sequence s;
{
  XtFree (s->data);
  XtFree (s);
}

static void freeFeature (f)
     Feature f;
{
  freeSequence (f->sequence);
  freeHelixList (f->helix_list);
  freeSheetList (f->sheet_list);
  freeTurnList (f->turn_list);
  freeSsbondList (f->ssbond_list);
  XtFree (f);
}

static void freeInfo (g)
     General g;
{
  freeDateList (g->date_list);
  freeFeature (g->feature);
  freeStringList (g->sid_code);
  XtFree (g->id_code);
  XtFree (g->func_name);
  XtFree (g->compound);
  XtFree (g->source);
  XtFree (g);
}

static void Search (widget, clientData, callData)
     Widget widget;
     XtPointer clientData, callData;
{
  SearchWinData swd = (SearchWinData) clientData;

  getList (swd);
}

static void makeSearchInput (swd)
     SearchWinData swd;
{
  Widget i_title;
  Widget input;
  Widget command_search;
  Widget form;

  swd->inputs = input =
    XtVaCreateWidget ("input", xmRowColumnWidgetClass, swd->form, NULL);

  /* Make Input */
  i_title = XtVaCreateManagedWidget ("search", xmLabelGadgetClass, input,
                                     XmNalignment, XmALIGNMENT_BEGINNING,
				     NULL);

  {
    SearchInfo s;

    s = (SearchInfo) XtMalloc (sizeof (SearchInfoRec));
    swd->s = s;

    form = XtVaCreateWidget ("form", xmFormWidgetClass, input,
			     XmNfractionBase, 10,
			     NULL);
    XtVaCreateManagedWidget ("id_code", xmLabelWidgetClass, form,
			     XmNtopAttachment,    XmATTACH_FORM,
			     XmNbottomAttachment, XmATTACH_FORM,
			     XmNleftAttachment,   XmATTACH_FORM,
			     XmNrightAttachment,  XmATTACH_POSITION,
			     XmNrightPosition,    2,
			     XmNalignment,        XmALIGNMENT_END,
			     NULL);
    s->id_code =
      XtVaCreateManagedWidget ("id_code_value", xmTextFieldWidgetClass, form,
			       XmNtraversalOn,     True,
			       XmNrightAttachment, XmATTACH_FORM,
			       XmNleftAttachment,  XmATTACH_POSITION,
			       XmNleftPosition,    3,
			       NULL);
    XtAddCallback (s->id_code, XmNactivateCallback,
		   XmProcessTraversal, XmTRAVERSE_NEXT_TAB_GROUP);
    XtManageChild (form);


    form = XtVaCreateWidget ("form", xmFormWidgetClass, input,
			     XmNfractionBase, 10,
			     NULL);
    XtVaCreateManagedWidget ("func_name", xmLabelWidgetClass, form,
			     XmNtopAttachment,    XmATTACH_FORM,
			     XmNbottomAttachment, XmATTACH_FORM,
			     XmNleftAttachment,   XmATTACH_FORM,
			     XmNrightAttachment,  XmATTACH_POSITION,
			     XmNrightPosition,    2,
			     XmNalignment,        XmALIGNMENT_END,
			     NULL);
    s->func_name =
      XtVaCreateManagedWidget ("func_name_value", xmTextFieldWidgetClass, form,
			       XmNtraversalOn,     True,
			       XmNrightAttachment, XmATTACH_FORM,
			       XmNleftAttachment,  XmATTACH_POSITION,
			       XmNleftPosition,    3,
			       NULL);
    XtAddCallback (s->func_name, XmNactivateCallback,
		   XmProcessTraversal, XmTRAVERSE_NEXT_TAB_GROUP);
    XtManageChild (form);


    form = XtVaCreateWidget ("form", xmFormWidgetClass, input,
			     XmNfractionBase, 10,
			     NULL);
    XtVaCreateManagedWidget ("compound", xmLabelWidgetClass, form,
			     XmNtopAttachment,    XmATTACH_FORM,
			     XmNbottomAttachment, XmATTACH_FORM,
			     XmNleftAttachment,   XmATTACH_FORM,
			     XmNrightAttachment,  XmATTACH_POSITION,
			     XmNrightPosition,    2,
			     XmNalignment,        XmALIGNMENT_END,
			     NULL);
    s->compound =
      XtVaCreateManagedWidget ("compound_value", xmTextFieldWidgetClass, form,
			       XmNtraversalOn,     True,
			       XmNrightAttachment, XmATTACH_FORM,
			       XmNleftAttachment,  XmATTACH_POSITION,
			       XmNleftPosition,    3,
			       NULL);
    XtAddCallback (s->compound, XmNactivateCallback,
		   XmProcessTraversal, XmTRAVERSE_NEXT_TAB_GROUP);
    XtManageChild (form);


    form = XtVaCreateWidget ("form", xmFormWidgetClass, input,
			     XmNfractionBase, 10,
			     NULL);
    XtVaCreateManagedWidget ("source", xmLabelWidgetClass, form,
			     XmNtopAttachment,    XmATTACH_FORM,
			     XmNbottomAttachment, XmATTACH_FORM,
			     XmNleftAttachment,   XmATTACH_FORM,
			     XmNrightAttachment,  XmATTACH_POSITION,
			     XmNrightPosition,    2,
			     XmNalignment,        XmALIGNMENT_END,
			     NULL);
    s->source =
      XtVaCreateManagedWidget ("source_value", xmTextFieldWidgetClass, form,
			       XmNtraversalOn,     True,
			       XmNrightAttachment, XmATTACH_FORM,
			       XmNleftAttachment,  XmATTACH_POSITION,
			       XmNleftPosition,    3,
			       NULL);
    XtAddCallback (s->source, XmNactivateCallback,
		   XmProcessTraversal, XmTRAVERSE_NEXT_TAB_GROUP);
    XtManageChild (form);
  }

  /* command box SEARCH */
  form = XtVaCreateWidget ("form", xmFormWidgetClass, input,
                           XmNfractionBase, 10,
                           NULL);
  command_search =
    XtVaCreateManagedWidget ("command_search", xmPushButtonWidgetClass, form,
                             XmNtopAttachment,    XmATTACH_FORM,
                             XmNbottomAttachment, XmATTACH_FORM,
                             XmNleftAttachment,   XmATTACH_POSITION,
                             XmNleftPosition,    8,
                             XmNrightAttachment,  XmATTACH_FORM,
                             NULL);
  XtManageChild (form);
  XtAddCallback (command_search, XmNactivateCallback, Search, swd);

  XtManageChild (input);
  /* end of Input */
}

static void freeSearchInfo (s)
     SearchInfo s;
{
  XtFree (s);
}

static void makeDataWindow (dwd)
     DispWinData dwd;
{
  char ttl[50];
  XmString str;
  General g = (General) dwd->g;
  Widget data_window;
  Widget length;
  Widget funcname, compound, source;
  Widget funcname_value;
  Widget attribute;
  Widget glue;

  data_window =
    XtVaCreateWidget ("dataWindow", xmFormWidgetClass, dwd->frame0,
                      NULL);
  sprintf (ttl, "Length: %d", g->feature->sequence->length);
  str = XmStringCreateSimple (ttl);
  length =
    XtVaCreateManagedWidget ("length", xmLabelGadgetClass, data_window,
                             XmNlabelString, str,
                             XmNtopAttachment,  XmATTACH_FORM,
                             XmNleftAttachment, XmATTACH_FORM,
                             NULL);
  XmStringFree (str);

  funcname =
    XtVaCreateManagedWidget ("funcname", xmLabelGadgetClass, data_window,
                             XmNalignment,      XmALIGNMENT_END,
                             XmNtopAttachment,  XmATTACH_WIDGET,
                             XmNtopWidget,      length,
                             XmNleftAttachment, XmATTACH_FORM,
                             NULL);
  funcname_value =
    XtVaCreateManagedWidget ("funcnameValue",
                             xmTextFieldWidgetClass, data_window,
                             XmNvalue, g->func_name,
                             XmNtopAttachment,   XmATTACH_OPPOSITE_WIDGET,
                             XmNtopWidget,       funcname,
                             XmNtopOffset,       0,
                             XmNleftAttachment,  XmATTACH_WIDGET,
                             XmNleftWidget,      funcname,
                             XmNrightAttachment, XmATTACH_FORM,
                             XmNeditable,        False,
                             NULL);
  compound =
    XtVaCreateManagedWidget ("compound", xmLabelGadgetClass, data_window,
                             XmNalignment,       XmALIGNMENT_END,
                             XmNtopAttachment,   XmATTACH_WIDGET,
                             XmNtopWidget,       funcname,
                             XmNrightOffset,     0,
                             XmNleftAttachment,  XmATTACH_FORM,
                             XmNrightAttachment, XmATTACH_OPPOSITE_WIDGET,
                             XmNrightWidget,     funcname,
                             NULL);

  XtVaCreateManagedWidget ("compoundValue",
                           xmTextFieldWidgetClass, data_window,
                           XmNvalue, g->compound,
                           XmNtopOffset,       0,
                           XmNleftOffset,      0,
                           XmNtopAttachment,   XmATTACH_OPPOSITE_WIDGET,
                           XmNtopWidget,       compound,
                           XmNleftAttachment,  XmATTACH_OPPOSITE_WIDGET,
                           XmNleftWidget,      funcname_value,
                           XmNrightAttachment, XmATTACH_FORM,
                           XmNeditable,        False,
                           NULL);

  source =
    XtVaCreateManagedWidget ("source", xmLabelGadgetClass, data_window,
                             XmNalignment,       XmALIGNMENT_END,
                             XmNrightOffset,     0,
                             XmNtopAttachment,   XmATTACH_WIDGET,
                             XmNtopWidget,       compound,
                             XmNleftAttachment,  XmATTACH_FORM,
                             XmNrightAttachment, XmATTACH_OPPOSITE_WIDGET,
                             XmNrightWidget,     funcname,
                             NULL);
  XtVaCreateManagedWidget ("sourceValue", xmTextFieldWidgetClass, data_window,
                           XmNvalue,           g->source,
                           XmNtopOffset,       0,
                           XmNleftOffset,      0,
                           XmNtopAttachment,   XmATTACH_OPPOSITE_WIDGET,
                           XmNtopWidget,       source,
                           XmNleftAttachment,  XmATTACH_OPPOSITE_WIDGET,
                           XmNleftWidget,      funcname_value,
                           XmNrightAttachment, XmATTACH_FORM,
                           XmNeditable,        False,
                           NULL);
  attribute =
    XtVaCreateManagedWidget ("attribute",
                             xmPushButtonWidgetClass, data_window,
                             XmNtopAttachment,   XmATTACH_WIDGET,
                             XmNtopWidget,       source,
                             XmNleftAttachment,  XmATTACH_FORM,
                             NULL);
  XtAddCallback (attribute,
                 XmNactivateCallback, Attr, (XtPointer)dwd);
  glue =
    XtVaCreateManagedWidget ("", xmLabelGadgetClass, data_window,
                             XmNtopAttachment,    XmATTACH_WIDGET,
                             XmNtopWidget,        attribute,
                             XmNbottomAttachment, XmATTACH_FORM,
                             NULL);
  XtManageChild (data_window);
}

static void makeFeatureStringList (dwd)
     DispWinData dwd;
{
  int i;
  int num_of_features;
  Feature f;
  HelixList hl;
  SheetList sl;
  TurnList  tl;
  SsbondList ssl;

  General g = dwd->g;

  /* count number of features */
  num_of_features = 0;
  for (hl = g->feature->helix_list; hl; hl = hl->next)
    num_of_features++;
  for (sl = g->feature->sheet_list; sl; sl = sl->next)
    num_of_features++;
  for (tl = g->feature->turn_list; tl; tl = tl->next)
    num_of_features++;
  for (ssl = g->feature->ssbond_list; ssl; ssl = ssl->next)
    num_of_features++;
  dwd->num_of_features = num_of_features;

  if (num_of_features == 0)
    {
      dwd->feature_string_list = NULL;
      return;
    }
    
  dwd->feature_string_list =
    (String *) XtMalloc (sizeof (String) * (num_of_features+1));
  dwd->feature_string_list[num_of_features] = NULL;

  i =0;
  /* for each feature */
  for (hl = g->feature->helix_list; hl; hl = hl->next, i++)
    {
      dwd->feature_string_list[i] =
        (String) XtMalloc (safe_strlen (hl->helix->helix_id)
                           + safe_strlen (hl->helix->comment)
                           + 10);
      sprintf (dwd->feature_string_list[i],
               "Helix (%s) %s", hl->helix->helix_id, hl->helix->comment);
    }

  for (sl = g->feature->sheet_list; sl; sl = sl->next, i++)
    {
      dwd->feature_string_list[i] =
        (String) XtMalloc (safe_strlen (sl->sheet->sheet_id)
                           + 9);
      sprintf (dwd->feature_string_list[i],
               "Sheet (%s)", sl->sheet->sheet_id);
    }

  for (tl = g->feature->turn_list; tl; tl = tl->next, i++)
    {
      dwd->feature_string_list[i] =
        (String) XtMalloc (safe_strlen (tl->turn->turn_id)
                           + safe_strlen (tl->turn->comment)
                           + 9);
      sprintf (dwd->feature_string_list[i],
               "Turn (%s) %s", tl->turn->turn_id, tl->turn->comment);
    }

  for (ssl = g->feature->ssbond_list; ssl; ssl = ssl->next, i++)
    {
      dwd->feature_string_list[i] = (String) XtMalloc (7);
      sprintf (dwd->feature_string_list[i], "SSBond");
    }
}

static void makeFig (dwd)
     DispWinData dwd;
{
  int i, j, k;
  int length;
  char name[256];
  int font_height;
  int font_width;
  General g = dwd->g;
  Feature f;
  HelixList hl;
  SheetList sl;
  SheetSubList s_sl;
  TurnList tl;
  SsbondList ssl;
  Boolean state;
  int x, y;
  int x1, y1;
  int x2, y2;
  int num_of_features = dwd->num_of_features;

  f = g->feature;
  dwd->fig =
    XtVaCreateWidget ("fig", figWidgetClass, dwd->scrolled_window,
		      NULL);

  length = f->sequence->length;

  font_height = app_resources.font_a[dwd->cur_mag]->ascent
    + app_resources.font_a[dwd->cur_mag]->descent;

  font_width = app_resources.font_a[dwd->cur_mag]->max_bounds.width;

  /* make sequence */
  for (i=0; i < length; i++)
    {
      char text[2];
      sprintf (name, "seq%c", f->sequence->data[i]);
      text[0] = f->sequence->data[i];
      text[1] = '\0';
      XtVaCreateManagedWidget (name, figTextClass, dwd->fig,
                               XtNlabel, text,
                               XtNfont, app_resources.font_a[dwd->cur_mag],
                               XtNy1,
			       font_height * 2
			       + app_resources.font_a[dwd->cur_mag]->ascent,
                               XtNx1, (i + 1) * font_width,
                               NULL);
    }

  dwd->features = 
    (Widget **) XtMalloc (sizeof (Widget *) * (num_of_features+1));
  dwd->features[num_of_features] = NULL;

  {
    int number_of_widgets =0;

    y1 = font_height * 2 - 2;


    /* for each feature */
    sprintf (name, "line_helix");

    for (i=0, hl = f->helix_list; hl; i++, hl = hl->next)
      {
        number_of_widgets = 3;

        dwd->features[i] =
          (Widget *) XtMalloc (sizeof (Widget) * (number_of_widgets +1));
        dwd->features[i][number_of_widgets] = NULL;

        j = 0;

        x1 = font_width * hl->helix->start + font_width/2;
        x2 = font_width * hl->helix->end + font_width/2;

	y2 = font_height
	  - font_height * i / num_of_features + 2;

        dwd->features[i][j++] =
          XtVaCreateWidget (name, figLineClass, dwd->fig,
                            XtNx1, x1,
                            XtNy1, y1,
                            XtNx2, x1,
                            XtNy2, y2,
                            NULL);
        dwd->features[i][j++] =
          XtVaCreateWidget (name, figLineClass, dwd->fig,
                            XtNx1, x2,
                            XtNy1, y1,
                            XtNx2, x2,
                            XtNy2, y2,
                            NULL);
        dwd->features[i][j++] =
          XtVaCreateWidget (name, figLineClass, dwd->fig,
                            XtNx1, x1,
                            XtNy1, y2,
                            XtNx2, x2,
                            XtNy2, y2,
                            NULL);
      }

    sprintf (name, "line_sheet");

    for (sl = f->sheet_list; sl; i++, sl = sl->next)
      {
        number_of_widgets = 0;

        for (s_sl = sl->sheet->sheet_sub_list; s_sl; s_sl = s_sl->next)
          number_of_widgets += 3;

        dwd->features[i] =
          (Widget *) XtMalloc (sizeof (Widget) * (number_of_widgets +1));
        dwd->features[i][number_of_widgets] = NULL;

        j = 0;

	y2 = font_height
	  - font_height * i / num_of_features + 2;

        for (s_sl = sl->sheet->sheet_sub_list; s_sl; s_sl = s_sl->next)
          {
            x1 = font_width * s_sl->sheet_sub->start + font_width/2;
            x2 = font_width * s_sl->sheet_sub->end + font_width/2;

            dwd->features[i][j++] =
              XtVaCreateWidget (name, figLineClass, dwd->fig,
                                XtNx1, x1,
                                XtNy1, y1,
                                XtNx2, x1,
                                XtNy2, y2,
                                NULL);
            dwd->features[i][j++] =
              XtVaCreateWidget (name, figLineClass, dwd->fig,
                                XtNx1, x2,
                                XtNy1, y1,
                                XtNx2, x2,
                                XtNy2, y2,
                                NULL);
            dwd->features[i][j++] =
              XtVaCreateWidget (name, figLineClass, dwd->fig,
                                XtNx1, x1,
                                XtNy1, y2,
                                XtNx2, x2,
                                XtNy2, y2,
                                NULL);
          }
      }

    sprintf (name, "line_turn");

    for (tl = f->turn_list; tl; i++, tl = tl->next)
      {
        number_of_widgets = 3;

        dwd->features[i] =
          (Widget *) XtMalloc (sizeof (Widget) * (number_of_widgets +1));
        dwd->features[i][number_of_widgets] = NULL;

        j = 0;

        x1 = font_width * tl->turn->start + font_width/2;
        x2 = font_width * tl->turn->end + font_width/2;

	y2 = font_height
	  - font_height * i / num_of_features + 2;

        dwd->features[i][j++] =
          XtVaCreateWidget (name, figLineClass, dwd->fig,
                            XtNx1, x1,
                            XtNy1, y1,
                            XtNx2, x1,
                            XtNy2, y2,
                            NULL);
        dwd->features[i][j++] =
          XtVaCreateWidget (name, figLineClass, dwd->fig,
                            XtNx1, x2,
                            XtNy1, y1,
                            XtNx2, x2,
                            XtNy2, y2,
                            NULL);
        dwd->features[i][j++] =
          XtVaCreateWidget (name, figLineClass, dwd->fig,
                            XtNx1, x1,
                            XtNy1, y2,
                            XtNx2, x2,
                            XtNy2, y2,
                            NULL);
      }

    sprintf (name, "line_ssbond");

    for (ssl = f->ssbond_list; ssl; i++, ssl = ssl->next)
      {
        number_of_widgets = 3;

        dwd->features[i] =
          (Widget *) XtMalloc (sizeof (Widget) * (number_of_widgets +1));
        dwd->features[i][number_of_widgets] = NULL;

        j = 0;

        x1 = font_width * ssl->ssbond->start + font_width/2;
        x2 = font_width * ssl->ssbond->end + font_width/2;

	y2 = font_height
	  - font_height * i / num_of_features + 2;

        dwd->features[i][j++] =
          XtVaCreateWidget (name, figLineClass, dwd->fig,
                            XtNx1, x1,
                            XtNy1, y1,
                            XtNx2, x1,
                            XtNy2, y2,
                            NULL);
        dwd->features[i][j++] =
          XtVaCreateWidget (name, figLineClass, dwd->fig,
                            XtNx1, x2,
                            XtNy1, y1,
                            XtNx2, x2,
                            XtNy2, y2,
                            NULL);
        dwd->features[i][j++] =
          XtVaCreateWidget (name, figLineClass, dwd->fig,
                            XtNx1, x1,
                            XtNy1, y2,
                            XtNx2, x2,
                            XtNy2, y2,
                            NULL);
      }
  }


  {
    int selected_item_count;
    int *selected_item_positions;

    if (XmListGetSelectedPos (dwd->listbox,
                              &selected_item_positions,
                              &selected_item_count))
      {
        RefreshSelection (dwd, selected_item_count, selected_item_positions);
        XtFree (selected_item_positions);
      }
  }
 
  XtManageChild (dwd->fig);
}

static char *find_date_field (field, date_list)
     char *field;
     DateList date_list;
{
  DateList dl;

  for (dl = date_list; dl; dl=dl->next)
    {
      if (strcmp (dl->date->kind, field) == 0)
	{
	  return dl->date->date_string;
	}
    }
  return "";
}

static void makeAttributeWindow (dwd)
     DispWinData dwd;
{
  char name[50];
  AttrWinData awd;
  char *strings;
  int i;
  Widget form;
  Widget initialdate, alldate;
  Widget initialdate_value;
  Widget ok;
  General g;
  Feature f;

  g = dwd->g;

  awd = dwd->attr_win_data =
    (AttrWinData) XtMalloc (sizeof (struct _AttrWinDataRec));
  awd->dwd = dwd;
  sprintf (name, "%s:attrib:pdb_kappa", g->sid_code->string);
  awd->top = 
    XtVaAppCreateShell (name, "KappaAttr",
			applicationShellWidgetClass, display,
			/* XtNtransient, True,*/
			NULL);
  form =
    XtVaCreateWidget ("form", xmFormWidgetClass, awd->top,
		      NULL);

  initialdate =
    XtVaCreateManagedWidget ("initialdate", xmLabelGadgetClass, form,
                             XmNalignment,      XmALIGNMENT_END,
                             XmNtopAttachment,  XmATTACH_FORM,
                             XmNleftAttachment, XmATTACH_FORM,
                             NULL);

  initialdate_value =
    XtVaCreateManagedWidget ("initialdateValue", xmTextFieldWidgetClass, form,
                             XmNvalue,
                             find_date_field ("INITIAL", g->date_list),
                             XmNtopAttachment,  XmATTACH_FORM,
                             XmNleftAttachment, XmATTACH_WIDGET,
                             XmNleftWidget,      initialdate,
                             XmNrightAttachment, XmATTACH_FORM,
                             XmNeditable,        False,
                             NULL);

  alldate =
    XtVaCreateManagedWidget ("alldate", xmLabelGadgetClass, form,
                             XmNalignment,       XmALIGNMENT_END,
                             XmNtopAttachment,   XmATTACH_WIDGET,
                             XmNtopWidget,       initialdate,
                             XmNleftAttachment,  XmATTACH_FORM,
                             XmNrightOffset,     0,
                             XmNrightAttachment, XmATTACH_OPPOSITE_WIDGET,
                             XmNrightWidget,     initialdate,
                             NULL);

  XtVaCreateManagedWidget ("alldateValue", xmTextFieldWidgetClass, form,
			   XmNvalue,
			   find_date_field ("ALL", g->date_list),
                           XmNtopOffset,       0,
                           XmNleftOffset,      0,
                           XmNtopAttachment,   XmATTACH_OPPOSITE_WIDGET,
                           XmNtopWidget,       initialdate,
                           XmNleftAttachment,  XmATTACH_OPPOSITE_WIDGET,
                           XmNleftWidget,      initialdate_value,
                           XmNrightAttachment, XmATTACH_FORM,
                           XmNeditable,        False,
			   NULL);

  ok =
    XtVaCreateManagedWidget ("ok", xmPushButtonWidgetClass, form,
                             XmNbottomAttachment, XmATTACH_FORM,
                             XmNleftAttachment,   XmATTACH_FORM,
			     NULL);
  XtAddCallback (ok, XmNactivateCallback, AttrOK, (XtPointer)awd);

  XtManageChild (form);
  XtRealizeWidget (awd->top);
}
