%
%	(C)1992 Institute for New Generation Computer Technology
%		$BG[I[$=$NB>$O(BCOPYRIGHT$B%U%!%$%k$r;2>H$7$F2<$5$$(B
%		(Read COPYRIGHT for detailed information.)
%
class kappa_purge has
nature
    as_program;

instance
    component
        (window := Window :-
            :create(#kappa_purge_window,Window));

:goal(Obj):-
    Window = Obj!window,
%    :set_message(Window,"Now purging"),
%    :activate(Window),
    :kappa_purge(Obj,">sys>user>kappa"),
    :retrieve(#directory,Directory,"me:",_),
    :purge(Directory),
    :set_message(Window,"--- success ---"),
    :activate(Window),
    :read(Obj!window,_);

:kappa_purge(Obj,Path_name):-
    :append(#string,[Path_name,">*"],Wild_card),
    :retrieve_with_wildcard(#directory,Object_list,Wild_card,_),
    purge_directory(Object_list,Path_name);

local
 
purge_directory([],_):-!;
purge_directory([{Name,Object}|Obj_list],Path_name):-
    :is_directory(Object),!,
    :purge(Object),
    :append(#string,[Path_name,">",Name],Child_pathname),
    :append(#string,[Child_pathname,">*"],Wild_card),
    :retrieve_with_wildcard(#directory,Child_object_list,Wild_card,_),
    purge_directory(Child_object_list,Child_pathname),
    purge_directory(Obj_list,Path_name);
purge_directory([_|Obj_list],Path_name):-
    purge_directory(Obj_list,Path_name);

end.

class kappa_purge_window has

nature
    with_margin,
    with_border,
    as_menu,
    as_single_select,
    as_mouse_input,
    with_bell,
    temporary_window;

:create(Class,Window):-!,
    :create(Class,
        [items_list([{"-- success --",no_select,_,_}])],Window);
instance

:set_message(Obj,Message):-
    :clear_items(Obj),
    :add_item(Obj,{Message,no_select,_,_},0);


end.