/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include "prtalk.h"
#include "../3dview/symbol.h"
#include "../3dview/data.h"
#include "../3dview/hash.h"
#include "../3dview/exit.h"
#include "../3dview/group.h"

extern group *root_obj;
extern char line_buffer[BUFSIZ];
extern chain   chainTable;

/* #define _SELF_SPHERE_ */
/* 饤֥Ѥʤ */

globe::globe()
//{}
//ҵ奪֥Ȥιۻ
//{}
{
  type = POL_ATOM;
  sym_id = sym_atom;
  dstate = ObjectHidding;
  scale = 1.0;

  chainNo = NULL;
  aminoNo = 0;

#ifdef DEBUG
  printf ("this (%x) rc %d void sphere::sphere()\n",(unsigned int) this,ref_c);
#endif
}

/* Sphereɽɽ
   chainName : ̾RootꤹƤκͭȤʤ롣
   aminoID   : Ĵֹ桢ꤷĴʾоݤȤ롣
   sphereFlag: 0ɽ1ɽ
*/
void globe::Draw(void)
{

  chain* searchChain = chainTable.tops();
  PushGroup("Root");
  PushGroup("Residue");
  while(searchChain != NULL){
    char cname = searchChain->chainIDs();
    if(strncmp(chainNo,"Root",4) != 0 && cname != chainNo[0]){
      searchChain = (chain*)searchChain->Next();
      continue;
    }
    char tmp[20];
    sprintf(tmp,"%c",cname);
    PushGroup(tmp);

    residue* searchResidue = searchChain->GetResidue(aminoNo);

    while(searchResidue != NULL){
      atom* searchAtom = searchResidue->first();
      char* aminoID = searchResidue->aminoIDs();
      int resID = searchResidue->resIDs();

      sprintf(tmp,"Res%d",resID);
      PushGroup(tmp);

      while(searchAtom != NULL){
	char symbol = searchAtom->names();
	int remo = searchAtom->remotenesses();
	int bran = searchAtom->branchs();

	if((modeFlag & 0x20) != 0) {     /* main chain only */
	  if(remo > 1 ){
	    searchAtom = (atom*)searchAtom->Next();
	    continue;
	  }
	}
	if(remo == 0 && bran == 0) sprintf(tmp,"%c",symbol);
	else if(remo == 0 && bran != 0)
	 sprintf(tmp,"%c%c",symbol, RBranch(bran));
	else if(remo != 0 && bran == 0)
	 sprintf(tmp,"%c%c",symbol, RRemote(remo));
	else if(remo != 0 && bran != 0)
	 sprintf(tmp,"%c%c%c",symbol, RRemote(remo), RBranch(bran));
	if(sphereFlag == 1)
	  HideObject(tmp);
	else
	  DrawObject(tmp);
	searchAtom = (atom*)searchAtom->Next();
      }
      PopGroup();
      searchResidue = (residue*)searchResidue->Next();      
    }
    PopGroup();
    searchChain = (chain*)searchChain->Next();
  }
  PopGroup();

  /* if group CA is exist */
  if(ObjectExistence("CA") > 0) {
    PushGroup("CA");
    chain* searchChain = chainTable.tops();
    while(searchChain != NULL){
      double bx = 0.0, by = 0.0, bz = 0.0;
      char tmp[20];
      sprintf(tmp,"%c",searchChain->chainIDs());
      PushGroup(tmp);

      residue* searchResidue = searchChain->firstResidues();
      
      while(searchResidue != NULL){
	atom* searchAtom = searchResidue->first();
	int resID = searchResidue->resIDs();
	sprintf(tmp,"CA%d",resID);
	HideObject(tmp);
	searchResidue = (residue*)searchResidue->Next();      
      }
      searchChain = (chain*)searchChain->Next();
      PopGroup();
    }
    PopGroup();
  }

  PopGroup();
}

void globe::CopySplitMember()
//{}
// 奪֥ȤΥԡΥФλȥȽ
//{}
{
#ifdef DEBUG
  printf ("this (%x) rc %d void sphere::CopyMember()\n",(unsigned int) this,ref_c);
#endif
  object_location->Split();
  object_rotation->Split();
  int color_id = color->Id();
  header* cv = color->Value();
  cv->Split();
  color = new node[1];
  color->Id(color_id);
  color->Value(cv);
  header* value;
  int c ;
  for (c = 0;c<SPHERE_WORD_SIZE;c++) {
    value = obj[c].Value();
    value->Split();
  }
}

 void globe::Close()
//{}
// ΥԤʤ
// ȥȤ0ˤʤäˡΰ롣
// ⤷ޤ¾黲ȤƤСȥȤ
// 1餹
//{}
{
#ifdef DEBUG
  printf ("this (%x) rc %d void sphere::Close()\n",(unsigned int) this,ref_c);
#endif
  ref_c--;
  if (ref_c == 0) {
    color->Close();
    object_location->Close();
    for (int cc = 0;cc < SPHERE_WORD_SIZE;cc++) {
      obj[cc].Close();
    }
    free(this);
  }
}

 header* globe::Reference(int id)
//{}
//奪֥ȤΥл
//ϥåidĥ̾ΥФ¸ߤС
//ФΥΡɤΥɥ쥹֤ǤʤС
//0֤
//{}
{
#ifdef DEBUG
  printf("this (%x) header* shpere::Reference(int %d(char* %s))\n",(unsigned int)this,id,hash_table.idWord(id));
#endif
  if (id == sym_om_color) return (header*)(color);
  for (int cc = 0;cc < SPHERE_WORD_SIZE;cc++) {
    if (id == (obj[cc].Id())) {
      return (header*)(obj+cc);
    }
  }
  return (header*)0;
}
