/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <stdio.h>
#include <ctype.h>
#include <unistd.h>
#include "../3dview/object.h"
#include "../3dview/group.h"
#include "../3dview/gorth.h"
#include "../3dview/sphere.h"
#include "../3dview/node.h"
#include "../3dview/hash.h"
#include "../3dview/symbol.h"

#include "method.h"

extern header* make_instance(int);
extern void method_is(node*, header*);
extern void method_move_object(header*, header*);
extern void method_from_set_object(header*, header*);
extern void method_to_set_object(header*, header*);
extern void method_drawall(header*);
extern void method_hideall(header*);
extern void method_draw(header*);
extern void method_hide(header*);
extern void method_into(header*);
extern void method_push(header*);
extern void method_pop(void);
extern header* object_member(header*, int);
extern header* insert_list(header*, header*);
extern void nurbs_object(header*, header*);
extern header* create_string(int);
extern group* current_ref_group;
extern group* root_obj;

#ifdef MOTIF
#define GROUP_FLAG 2
void AddObject(const char* string, int flag);
void DeleteAllItem(void);

ObjectTypeTag GetObjectType(char *name)
{
  node* np = (node *)current_ref_group->Search_and_Create(name);
  if(np->Value() != NULL) {
    return(np->Value()->Type());
  }
  else return -1;
}

void GroupList(char *name, int flag)
{
  node* np2 = (node *)current_ref_group->Search_and_Create(name);
  while(np2->Next() != NULL){
    AddObject(np2->Name(), flag);
    np2 = (node*)(np2->Next());
  }
  AddObject(np2->Name(), flag);
}

void InGroup(char *name)
{
  PushGroup(name);
  node* np = (node *)current_ref_group->First();
  DeleteAllItem();
  GroupList((char*)np->Name(),1);
}

char* OutGroup(void)
{
  PopGroup();
  node* np2 = (node *)current_ref_group->First();
  node* np1 = (node *)current_ref_group->Parent();
  DeleteAllItem();
  if(strcmp(np1->Name(),":") == 0) GroupList("Root",0);
  else GroupList((char*)np2->Name(),1);
  return (char*)np1->Name();
}

void LocationValue(char* cName, char* x, char* y, char* z)
{
  node* np = (node *)current_ref_group->Search_and_Create(cName);
  if(np->Value() != NULL) {
    header* nc = (header *)((object *)np->Value())->Location();
    sprintf(x, "%.2f",((rotation *)nc)->X());
    sprintf(y, "%.2f",((rotation *)nc)->Y());
    sprintf(z, "%.2f",((rotation *)nc)->Z());
  }
}

void RotationValue(char* cName, char* x, char* y, char* z)
{
  node* np = (node *)current_ref_group->Search_and_Create(cName);
  if(np->Value() != NULL) {
    header* nc = (header *)((object *)np->Value())->Rotate();
    sprintf(x, "%.2f",((rotation *)nc)->X());
    sprintf(y, "%.2f",((rotation *)nc)->Y());
    sprintf(z, "%.2f",((rotation *)nc)->Z());
  }
}

void SphereValue(char* name, char* rad, char* dep)
{
  node* np = (node *)current_ref_group->Search_and_Create(name);
  if(np->Value() == NULL) return;
  sphere* target = (sphere *)np->Value();

  header* member = target->Reference(sym_om_radius);
  if(((node*)member)->Value() == NULL){
    
  }
  else{
    header* radius = ((node *)member)->Value();
    if(radius->Type() == DAT_INTEGER) {
      sprintf(rad,"%d\n",((fixed_number*)radius)->Value());
    }
    else {
      sprintf(rad,"%.3f\n",((float_number*)radius)->Value());
    }
  }
  member = target->Reference(sym_om_depth);
  header* depth = ((node *)member)->Value();
  sprintf(dep,"%d\n",((fixed_number*)depth)->Value());
}

void ColorValue(char* cName, char* red, char* green, char* blue)
{
  node* np = (node *)root_obj->Search_and_Create(cName);
  material* nc = (material *)np->Value();
  sprintf(red,  "%.0f",nc->Red());
  sprintf(green,"%.0f",nc->Green());
  sprintf(blue, "%.0f",nc->Blue());
}

void SpecularValue(char* cName, char* red, char* green, char* blue)
{
  node* np = (node *)root_obj->Search_and_Create(cName);
  material* nc = (material *)np->Value();
  sprintf(red,  "%.0f",nc->SRed());
  sprintf(green,"%.0f",nc->SGreen());
  sprintf(blue, "%.0f",nc->SBlue());
}

float AlphaValue(char* cName)
{
  node* np = (node *)root_obj->Search_and_Create(cName);
  material* nc = (material *)np->Value();
  return nc->Alpha();
}

float ShinessValue(char* cName)
{
  node* np = (node *)root_obj->Search_and_Create(cName);
  material* nc = (material *)np->Value();
  return nc->Shiness();
}

float FloatValue(char* cName)
{
  node* np = (node *)root_obj->Search_and_Create(cName);
  float_number* nc = (float_number *)np->Value();
  return nc->Value();
}

int IntegerValue(char* cName)
{
  node* np = (node *)root_obj->Search_and_Create(cName);
  fixed_number* nc = (fixed_number *)np->Value();
  return nc->Value();
}

char* StringValue(char* cName)
{
  node* np = (node *)root_obj->Search_and_Create(cName);
  string* nc = (string *)np->Value();
  return nc->Value();
}
#endif

int ObjectExistence(char* name)
{
  node* np = (node *)current_ref_group->Search_and_Create(name);
  if(np->Value() == NULL) return(-1);
  else return(1);
}

void MakeGroupObject(char *name)
{
  node* np = (node *)current_ref_group->Search_and_Create(name);
  if(np->Value() == NULL){
    header* gp = make_instance(sym_group);
    method_is(np, gp);
    printf("%s is a group;\n", name);
  }
}

void MakeSphereObject(char *name)
{
  node* np = (node *)current_ref_group->Search_and_Create(name);
  if(np->Value() == NULL){
    header* gp = make_instance(sym_sphere);
    method_is(np, gp);
    printf("%s is a sphere;\n", name);
  }
}

void MakePipe0Object(char *name)
{
  node* np = (node *)current_ref_group->Search_and_Create(name);
  if(np->Value() == NULL){
    header* gp = make_instance(sym_pipe0);
    method_is(np, gp);
    printf("%s is a pipe0;\n", name);
  }
}

void MakeLineObject(char *name)
{
  node* np = (node *)current_ref_group->Search_and_Create(name);
  if(np->Value() == NULL){
    header* gp = make_instance(sym_segment);
    method_is(np, gp);
    printf("%s is a segment;\n", name);
  }
}

void MakePolygonObject(char *name)
{
  node* np = (node *)current_ref_group->Search_and_Create(name);
  if(np->Value() == NULL){
    header* gp = make_instance(sym_mesh);
    method_is(np, gp);
    printf("%s is a mesh;\n", name);
  }
}

void MakeTextObject(char *name)
{
  node* np = (node *)current_ref_group->Search_and_Create(name);
  if(np->Value() == NULL){
    header* gp = make_instance(sym_text);
    method_is(np, gp);
    printf("%s is a text;\n", name);
  }
}

void MakeListObject(char *name)
{
  printf("%s is [];\n", name);
  current_ref_group->Search_and_Create(name);
}

void MoveObject(char *name, double x, double y, double z)
{
  printf("%s moves{%f,%f,%f};\n",name, x,y,z);
  location* lp;
  lp = new location[1];
  lp->X(x);
  lp->Y(y);
  lp->Z(z);
  node* np = (node *)current_ref_group->Search_and_Create(name);
  method_move_object(np->Value(), lp);
}

void InsertList(char *name, coodinate first, coodinate second)
{
  printf("%s is (%s insert[{%f,%f,%f},{%f,%f,%f}]);\n",name,name,
	 first.CoodinateX(), first.CoodinateY(), first.CoodinateZ(),
	 second.CoodinateX(),second.CoodinateY(),second.CoodinateZ());
  location* lp1;
  lp1 = new location[1];
  lp1->X(first.CoodinateX());
  lp1->Y(first.CoodinateY());
  lp1->Z(first.CoodinateZ());
  location* lp2;
  lp2 = new location[1];
  lp2->X(second.CoodinateX());
  lp2->Y(second.CoodinateY());
  lp2->Z(second.CoodinateZ());
  header* l1 = insert_list(lp1, (header *)0);
  header* l2 = insert_list(lp2, l1);
  node* np = (node *)current_ref_group->Search_and_Create(name);
  insert_list(l2, np->Value());
}

void FromObject(char *name, double x, double y, double z)
{
  printf("%s from{%f,%f,%f};\n",name, x,y,z);
  location* lp;
  lp = new location[1];
  lp->X(x);
  lp->Y(y);
  lp->Z(z);
  node* np = (node *)current_ref_group->Search_and_Create(name);
  method_from_set_object(np->Value(), lp);
}

void ToObject(char *name, double x, double y, double z)
{
  printf("%s to{%f,%f,%f};\n",name, x,y,z);
  location* lp;
  lp = new location[1];
  lp->X(x);
  lp->Y(y);
  lp->Z(z);
  node* np = (node *)current_ref_group->Search_and_Create(name);
  method_to_set_object(np->Value(), lp);
  delete lp;
}

void RadiusObject(char *name, const char *radius)
{
  /* ȤnameõƥΡɥݥ󥿤֤ */
  node* np = (node *)current_ref_group->Search_and_Create(name);

  /* ֥ȤΥФ򸡺nodeΥɥ쥹֤ */
  node* nr = (node *)object_member(np->Value(),sym_om_radius);

  if(!isdigit(radius[0])){
    printf("%s radius is :%s;\n",name, radius);
    node* nc = (node *)root_obj->Search_and_Create((char*)radius);
    method_is(nr, nc->Value());
  }
  else {
    printf("%s radius is %s;\n",name, radius);
    fixed_number* ret_fn = new fixed_number[1];
    ret_fn->Value(atoi(radius));
    method_is(nr, (header*)ret_fn);
  }
}

void DepthObject(char *name, const char *depth)
{
  /* ȤnameõƥΡɥݥ󥿤֤ */
  node* np = (node *)current_ref_group->Search_and_Create(name);

  /* ֥ȤΥФ򸡺nodeΥɥ쥹֤ */
  node* nr = (node *)object_member(np->Value(),sym_om_depth);

  if(!isdigit(depth[0])){
    printf("%s depth is :%s;\n",name, depth);
    node* nc = (node *)root_obj->Search_and_Create((char*)depth);
    method_is(nr, nc->Value());
  }
  else {
    printf("%s depth is %s;\n",name, depth);
    fixed_number* ret_fn = new fixed_number[1];
    ret_fn->Value(atoi(depth));
    method_is(nr, (header*)ret_fn);
  }
}

void BottomObject(char *name, char *radius)
{
  printf("%s bottom is %s;\n",name, radius);
  node* np = (node *)current_ref_group->Search_and_Create(name);
  node* nr = (node *)object_member(np->Value(),sym_om_bottom);
  node* nc = (node *)root_obj->Search_and_Create(radius);
  method_is(nr, nc->Value());
}

void TopObject(char *name, char *radius)
{
  printf("%s top is %s;\n",name, radius);
  node* np = (node *)current_ref_group->Search_and_Create(name);
  node* nr = (node *)object_member(np->Value(),sym_om_top);
  node* nc = (node *)root_obj->Search_and_Create(radius);
  method_is(nr, nc->Value());
}

void ColorObject(char *name, const char *color)
{
  printf("%s color is %s;\n",name, color);
  node* np = (node *)current_ref_group->Search_and_Create(name);
  node* nr = (node *)object_member(np->Value(),sym_om_color);
  node* nc = (node *)root_obj->Search_and_Create((char*)color);
  method_is(nr, nc->Value());
}

void StringObject(char *name, char *string)
{
  printf("%s string is \"%s\";\n",name, string);
  node* np = (node *)current_ref_group->Search_and_Create(name);
  node* nr = (node *)object_member(np->Value(),sym_om_string);
  node* nc = (node *)root_obj->Search_and_Create(string);
  method_is(nr, nc->Value());
}

void PointsObject(char *name, char *point)
{
  printf("%s points is %s;\n",name, point);
  node* np = (node *)current_ref_group->Search_and_Create(name);
  node* nr = (node *)object_member(np->Value(),sym_om_points);
  node* nc = (node *)current_ref_group->Search_and_Create(point);
  method_is(nr, nc->Value());
}

void DrawAll(char *name)
{
  printf("%s drawall;\n",name);
  node* np = (node *)current_ref_group->Search_and_Create(name);
  method_drawall(np->Value());
}

void DrawObject(char *name)
{
  printf("%s draw;\n",name);
  node* np = (node *)current_ref_group->Search_and_Create(name);
  method_draw(np->Value());
}

void HideAll(char *name)
{
  printf("%s hideall;\n",name);
  node* np = (node *)current_ref_group->Search_and_Create(name);
  method_hideall(np->Value());
}

void HideObject(char *name)
{
  printf("%s hide;\n",name);
  node* np = (node *)current_ref_group->Search_and_Create(name);
  method_hide(np->Value());
}

void IntoGroup(char* name)
{
  printf("into %s;\n",name);
  node* np = (node *)current_ref_group->Search_and_Create(name);
  method_into(np->Value());
}

void PushGroup(char* name)
{
  printf("push %s;\n",name);
  node* np = (node *)current_ref_group->Search_and_Create(name);
  method_push(np->Value());
}

void PopGroup(void)
{
  printf("pop;\n");
  method_pop();
}

void NurbsObject(char* name)
{
  printf("%s nurbs on;\n",name);
  node* np = (node *)current_ref_group->Search_and_Create(name);
  header* hp = create_string(sym_param_on);
  nurbs_object(np->Value(),hp);
}
