/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>

/* Protein-Talkɬפincludeե */
#include "method.h"
#include "pdb.h"
#include "../3dview/boolean.h"

extern int user_main(int argc,char** argv);
extern void load_initial_file();
extern int yyparse();
extern void initialize();
extern int is_read_eof;
extern char parse_buffer[BUFSIZ];
extern char* parse_point;
extern const char *ver;
extern const char *date;
const char* sys_name = "proview";

#ifdef MOTIF
void MainLoop(int argc, char** argv);
#endif

int is_not_load_initial_file;
int is_only_pr_talk;

FILE *fp_in;
secondStructure helixTable;
unsigned helixCount = 0;
chain chainTable;
unsigned chainCount = 0;
int *residueTable;
unsigned residueCount = 0;
secondStructure sheetTable;
secondStructure turnTable;

unsigned modeFlag = 0;
unsigned long gj = 0;
double gx = 0.0, gy = 0.0, gz = 0.0;


void usage(void)
{
  fprintf(stderr,"%s Ver%s\n%s\n",sys_name,ver,date);
  fprintf(stderr, "-h : helix\n");
//  fprintf(stderr, "-w : hydrogen\n");
  fprintf(stderr, "-r : ribbon\n");
  fprintf(stderr, "-s : sheet\n");
  fprintf(stderr, "-T [amino] : Display amino\n");
  exit(1);
}

int main (int argc, char **argv)
{
  int digit_optind = 0;
  char testname[5];

  while (1){
    int this_option_optind = optind ? optind : 1;

    int c = getopt (argc, argv, "Oprthmsco:a2wT:");
    if (c == EOF) break;

    switch(c){
      case '2':                   // 2nd_struct
	if (digit_optind != 0 && digit_optind != this_option_optind)
	  printf("digits occur in two different argv-elements.\n");
	digit_optind = this_option_optind;
	printf("# option %c\n", c);
	break;
	
      case 'a':                  // ca_chain
	printf("# option a\n");
	break;

      case 'c':                  // 
	modeFlag |= 0x308;
	break;

      case 'o':                  // oligo_chain
	printf("# option o with value `%s'\n", optarg);
	break;

      case 'm':                  // main_chain 00110000
	modeFlag |= 0x30;
	strcpy(testname, "ALL");
	break;
      case 's':                  // Sheet
	modeFlag |= 0x04;
	break;
      case 'h':
	modeFlag |= 0x02;        // Helix
	break;
      case 'w':
	modeFlag |= 0x08;        // Hydorogen
	break;
      case 't':
	modeFlag |= 0x80;        // Turn
	break;
      case 'O':
	modeFlag |= 0x40;
	break;
      case 'r':
	modeFlag |= 0x01;        // Ribbon
	break;
      case 'T':                  // TEST MODE
	strcpy(testname, optarg);
	modeFlag |= 0x10;
	break;

      default:
	printf("?? getopt returned character code 0%o ??\n", c);
	usage();
    }
  }

  char filename[80];
  if (optind < argc){
    strncpy(filename,argv[optind],80);
    if((fp_in = fopen(filename,"r")) == NULL){
      fprintf(stderr,"%c: file not exist. %s\n", argv[0], filename);
      exit(1);
    }
  }else{
    fp_in = stdin;
  }

  /* 3D-TALKΥ˥饤 */
  initialize();
  user_main(argc,argv);

  is_not_load_initial_file = FALSE;
  load_initial_file();

  MakeGroupObject("Root");

  /* PDBǡꥹȤɤ߹ */
  ReadPdb();

  /* ܥɾϢ */
  BackBone();
  SideChain();
  ConnectBackBone();

/*  if((modeFlag & 0x40) == 0x40) {
    HelixSearch();
    DisplayHelix();
  }*/
  if((modeFlag & 0x01) != 0) DisplayRibbonAll("Root");
  if((modeFlag & 0x02) != 0) DisplayRibbonHelix("Root");
  if((modeFlag & 0x04) != 0) DisplayRibbonSheet("Root");
  if((modeFlag & 0x40) != 0) DisplayRibbonOther();
  if((modeFlag & 0x80) != 0) DisplayRibbonTurn("Root");
  if((modeFlag & 0x08) != 0) HydrogenSearch();
  if((modeFlag & 0x10) != 0) TestPrint(testname);
  if((modeFlag & 0x300) != 0) HydrogenConnect();
  if(modeFlag == 0) TestPrint("ALL");
  GravityPoint(&gx, &gy, &gz);
  MoveObject("Root",gx,gy,gz);
  DrawAll("Root");
  fflush(stdout);

#ifdef MOTIF
  MainLoop(argc, argv);
#else
  /*⤷ʸpr_talkͭΤΤǤС*/
  /*¹ԻˤΥե饰(is_only_pr_talk)TRUEȤ뤳ȡ*/
  parse_point = parse_buffer;
  *parse_point = '\0';
  while((!is_read_eof)) {
    is_only_pr_talk = FALSE;
    int yy_ans = yyparse();
    if (!is_only_pr_talk) {
      /*ʸȤС3dviewή*/
      printf("%s\n",parse_buffer);
      fflush(stdout);
    }
    is_only_pr_talk = FALSE;
    parse_point = parse_buffer;
    *parse_point = '\0';
  }
#endif
  exit (0);
}
