/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/*
  helix.c
  helix object
*/
#include <stdio.h>
#include "helix.h"
#include "method.h"

#include "../3dview/symbol.h"

 helix::helix()
{
  sym_id = sym_helix;
  type = POL_HELIX;
}

void helix::CopySplitMember()
{
#ifdef DEBUG
  printf("cylinder::CopySplitMember()\n");
#endif
  object_location->Split();
  object_rotation->Split();
  int color_id = color->Id();
  header* cv = color->Value();
  cv->Split();
  color = new node[1];
  color->Split();
  color->Id(color_id);
  color->Value(cv);
}

void helix::Draw()
//{}
//Ԥʤ
//{}
{
  double gx = 0.0, gy = 0.0, gz = 0.0;

  MakeGroupObject("Root");
  int i = DisplayRibbonHelix("Root");
  if(i<0){
    fprintf(stderr, "ProteinTalk Error: Helix is not exist.\n");
    return;
  }
  GravityPoint(&gx, &gy, &gz);
  MoveObject("Root",gx,gy,gz);
  PushGroup("Root");
/*
  if(strncmp(groupName,"Root",4) != 0){
    DrawObject("Helix");
    PushGroup("Helix");
    DrawAll((char*)groupName);
    PopGroup();
  }
  else
*/
  DrawAll("Helix");
  PopGroup();
}

void helix::Close()
//{}
// ܥɤΥԤʤ
// ȥȤ0ˤʤäˡΰ롣
// ⤷ޤ¾黲ȤƤСȥȤ
// 1餹
//{}
{
#ifdef DEBUG
  printf("helix::Close()\n");
#endif
  ref_c--;
  if (ref_c == 0) {
    color->Close();
    free(this);
  }
}

header* helix::Reference(int id)
//{}
//ܥɥ֥ȤΥл
//ϥåidĥ̾ΥФ¸ߤС
//ФΥΡɤΥɥ쥹֤ǤʤС
//0֤
//{}
{
  if ((color->Id()) == id){
    return (header*)color;
  }
  return (header*)0;
}
