/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/*
  bond.c
  bond object
*/
#include <stdio.h>
#include "bond.h"

#include "../3dview/symbol.h"

//const double rad2theta = (180.0/M_PI);
//const double halfpie = (M_PI/2.0);

 bond::bond()
{
  sym_id = sym_bond;
  dx = 0.0; dy = 0.0; dz = 0.0;
  cx = 0.0; cy = 0.0; cz = 0.0;
  xtheta = 0.0; ytheta = 0.0;
  type = POL_BOND;
  
}

void bond::CopySplitMember()
{
#ifdef DEBUG
  printf("cylinder::CopySplitMember()\n");
#endif
  object_location->Split();
  object_rotation->Split();
  int color_id = color->Id();
  header* cv = color->Value();
  cv->Split();
  color = new node[1];
  color->Split();
  color->Id(color_id);
  color->Value(cv);
}

void bond::Draw()
//{}
//Ԥʤ
//{}
{
  first.print();
  second.print();
}

void bond::From(location* l)
{
#ifdef DEBUG
  printf("bond::From{%g %g %g}\n",l->X(),l->Y(),l->Z());
#endif
  first.CoodinateSetX(l->X());
  first.CoodinateSetY(l->Y());
  first.CoodinateSetZ(l->Z());
}

void bond::To(location* l)
{
#ifdef DEBUG
  fprintf(stderr,"cylinder::To{%g %g %g}\n",l->X(),l->Y(),l->Z());
#endif
  second.CoodinateSetX(l->X());
  second.CoodinateSetY(l->Y());
  second.CoodinateSetZ(l->Z());
}

void bond::Close()
//{}
// ܥɤΥԤʤ
// ȥȤ0ˤʤäˡΰ롣
// ⤷ޤ¾黲ȤƤСȥȤ
// 1餹
//{}
{
#ifdef DEBUG
  printf("bond::Close()\n");
#endif
  ref_c--;
  if (ref_c == 0) {
    color->Close();
    free(this);
  }
}

header* bond::Reference(int id)
//{}
//ܥɥ֥ȤΥл
//ϥåidĥ̾ΥФ¸ߤС
//ФΥΡɤΥɥ쥹֤ǤʤС
//0֤
//{}
{
  if ((color->Id()) == id){
    return (header*)color;
  }
  return (header*)0;
}
