/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <stdlib.h>
#include <stream.h>
#include <math.h>
#include "wavelet.h"

main(int ArgCnt,char** ArgVal)
{
  if(ArgCnt<3)
    {
      cerr <<"Too few arguments\n";
      exit(1);
    }
  int NW = atoi(ArgVal[1]);
  int W  = atoi(ArgVal[2]);
  wavelet Wavelet(NW,W);
  for(int I=0;I<NW;++I)
    {
      for(int J=0;J<NW;++J)
	{
	  cerr << form("%10.5lf ",Wavelet.product(I,J));
	}
      cerr << '\n';
    }
  for(int J=0;J<W;++J)
    {
      for(int I=0;I<NW;++I)
	{
	  cout << form("%10.5lf ",Wavelet.position(I,J));
	}
      cout << '\n';
    }
}
