/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <stdlib.h>
#include <stdio.h>
#include <stream.h>

class mainChain
{
  int    Order;
  char   AminoID[5];
  double X,Y,Z;
  mainChain* Next;
 public:
  mainChain(void);
  inline  mainChain* next(void);
  inline  void next(mainChain*);
  int read(void);
  mainChain* smooth(mainChain*,mainChain*);
  void print(void);
};

class mainChainList
{
  mainChain* First;
  mainChain* Last;
 public:
  mainChainList(void);
  ~mainChainList(void);
  void smooth(void);
  void print(void);
};

mainChain::mainChain(void)
{
  Order = 0;
  X = Y = Z = 0.0;
  Next = NULL;
}

inline mainChain* mainChain::next(void)
{
  return Next;
}

inline void mainChain::next(mainChain* NextNew)
{
  Next = NextNew;
}

int mainChain::read(void)
{
  static char Buff[128];
  if(NULL==gets(Buff))
    {
      return NULL;
    }
  sscanf(Buff,"%d %s %lg %lg %lg",&Order,AminoID,&X,&Y,&Z);
  return 1;
}

mainChain* mainChain::smooth(mainChain* Prev,mainChain* Next)
{
  mainChain* New = new mainChain;
  strcpy(New->AminoID,AminoID);
  New->Order = Order;
  New->X = X/2.0 + Prev->X/4.0 + Next->X/4.0;
  New->Y = Y/2.0 + Prev->Y/4.0 + Next->Y/4.0;
  New->Z = Z/2.0 + Prev->Z/4.0 + Next->Z/4.0;
  
  return New;
}


void mainChain::print(void) 
{
  cout << form("%4d %s  %7.3lf  %7.3lf  %7.3lf\n",
	       Order,AminoID,X,Y,Z);
}

mainChainList::mainChainList(void)
{
  mainChain* MainChain = new mainChain;
  if(NULL == MainChain->read())
    {
      delete MainChain;
      return;
    }
  First = Last = MainChain;

  while(1)
    {
      mainChain* MainChain = new mainChain;
      if(NULL == MainChain->read())
	{
	  delete MainChain;
	  break;
	}
      Last->next(MainChain);
      Last = MainChain;
    }
}
  
mainChainList::~mainChainList(void)
{
  mainChain* New;
  mainChain* Del;
  
  for(Del = First; Del!=NULL;)
    {
      New = Del->next();
      delete Del;
      Del = New;
    }
}

void mainChainList::smooth(void)
{
  mainChain* FirstNew;
  mainChain* LastNew;

  mainChain* Prev;
  mainChain* Main;
  mainChain* Next;

  mainChainList* MainChainList = new mainChainList;

  Prev = First;
  Main = First;
  Next = First;

  FirstNew = LastNew = Main->smooth(Prev,Next);

  for(
      Prev = First,Main= First->next();
      Main!= Last;
      Prev = Prev->next(),Main=Main->next()
      )
    {
      Next = Main->next();
      LastNew ->next(Main->smooth(Prev,Next));
      LastNew = LastNew->next();
    }
  Prev = Last;
  Main = Last;
  Next = Last;
  LastNew->next(Main->smooth(Prev,Next));
  LastNew=LastNew->next();

  mainChain* New;
  mainChain* Del;
  
  for(Del = First; Del!=NULL;)
    {
      New = Del->next();
      delete Del;
      Del = New;
    }
  Last = LastNew;
  First = FirstNew;
}
  

void mainChainList::print(void)
{
  for(mainChain* MainChain=First;MainChain!=NULL;MainChain=MainChain->next())
    {
      MainChain->print();
    }
}

main(int argc,char* argv[2])
{
  if(argc<2)
    {
      cout << "Usage\n\tsmooth WIDTH";
      exit(0);
    }

  int Width = atoi(argv[1]);
  mainChainList MainChainList;

  for(int I = 0;I<Width;++I)
    MainChainList.smooth();

  MainChainList.print();
}

