/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <ctype.h>
#include <stdio.h>
#include <stream.h>
#include <GetOpt.h>
#include <String.h>
#include "field.h"

int CharFlag   = 0;
int FirstFlag  = 0;
int LastFlag   = 0;
int TopFlag    = 0;
int BottomFlag = 0;
int AllFlag    = 0;

int peekDetect(int N, int* FieldID)
{
  char    BuffA[1024];
  char    BuffB[1024];

  char*   BuffNow;
  char*   BuffNew;
  char    Peek[N+1];
  double  FieldValOld[N];
  double  FieldValNow[N];
  double  FieldValNew[N];
  String  Field[32];

  BuffNow = BuffA;
  BuffNew = BuffB;

  int Width = beginCheck();
  if(Width == 0)
    {
      return 0;
    }

  cout << "#Width = " << Width << "\n#Begin\n";

  if(NULL==gets(BuffNow))
    {
      cout << "#End\n";
      return 0;
    }
  if(0==strncmp(BuffNow,"#End",4))
    {
      cout << "#End\n";
      return 1;
    }

  if(AllFlag || CharFlag)
    {
      for(int I=0;I<N;++I) Peek[I] = 'F';
    }
  Peek[N] = '\0';

  int NW = getField(BuffNow,Field);
  for(int P=0;P<N;++P)
    {
      if(NW>FieldID[P])
	{
	  FieldValOld[P] = atof(Field[FieldID[P]]);
	}
    }
  if(AllFlag || FirstFlag)
    {
      if(CharFlag) cout << Peek << " ";
      cout << BuffNow << "\n";
    }

  if(NULL==gets(BuffNow))
    {
      cout << "#End\n";
      return 0;
    }
  if(0==strncmp(BuffNow,"#End",4))
    {
      cout << "#End\n";
      return 1;
    }

  NW = getField(BuffNow,Field);
  for(P=0;P<N;++P)
    {
      if(NW>FieldID[P])
	{
	  FieldValNow[P] = atof(Field[FieldID[P]]);
	}
    }

  while(gets(BuffNew))
    {
      int TopLocalFlag    = 0;
      int BottomLocalFlag = 0;

      if(0==strncmp(BuffNew,"#End",4))
	{
	  if(CharFlag)
	    {
	      for(int I=0;I<N;++I) Peek[I] = 'L';
	    }
	  if(AllFlag || LastFlag)
	    {
	      if(CharFlag) cout << Peek << " ";
	      cout << BuffNow << "\n";
	    }
	  cout << "#End\n";
	  return 1;
	}

      int NW = getField(BuffNew,Field);
      for(int P=0;P<N;++P)
	{
	  if(NW>FieldID[P])
	    {
	      FieldValNew[P] = atof(Field[FieldID[P]]);
	    }
	}

      for(P=0;P<N;++P)
	{
	  if(   FieldValNow[P] > FieldValOld[P]
	     && FieldValNow[P] > FieldValNew[P])
	    {
	      Peek[P] = '^';
	      TopLocalFlag = 1;
	    }
	  else if(   FieldValNow[P] < FieldValOld[P] 
		  && FieldValNow[P] < FieldValNew[P])
	    {
	      Peek[P] = '_';
	      BottomLocalFlag = 1;
	    }
	  else if(   FieldValNew[P] > FieldValOld[P])
	    {
	      Peek[P] = '/';
	    }
	  else if(   FieldValNew[P] < FieldValOld[P])
	    {
	      Peek[P] = '\\';
	    }

	}
      if(   AllFlag 
	 || (TopFlag && TopLocalFlag)
	 || (BottomFlag && BottomLocalFlag))
	{
	  if(CharFlag) cout << Peek << " ";
	  cout << BuffNow << "\n";
	}

      char* BuffTmp = BuffNew;
      BuffNew = BuffNow;
      BuffNow = BuffTmp;

      for(P=0;P<N;++P)
	{
	  FieldValOld[P] = FieldValNow[P];
	  FieldValNow[P] = FieldValNew[P];
	}
    }
  return 0;
}

main(int argc,char** argv)
{
  GetOpt getopt (argc, argv, "cfltbxa");
  int Ch;
  while((Ch=getopt())!=EOF)
    {
      switch(char(Ch))
	{
	case 'c':
	  CharFlag  = 1;
	case 'f':
	  FirstFlag = 1;
	  break;
	case 'l':
	  LastFlag  = 1;
	  break;
	case 't':
	  TopFlag = 1;
	  break;
	case 'b':
	  BottomFlag = 1;
	  break;
	case 'x':
	  CharFlag = FirstFlag = LastFlag = TopFlag = BottomFlag = 1;
	  break;
	case 'a':
	  AllFlag   = 1;
	  break;
	default:
	  exit(1);
	}
    }

  int FieldID[16];
  int Cnt   = 0;
  if(getopt.optind < argc)
    {
      while(getopt.optind <= argc)
	FieldID[Cnt++] = atoi(argv[getopt.optind++]);
    }
  else
    {
      cerr << "Usage\n\tpeek FIELDID FIELDID .... -[cfltbxa]\n";
      exit(0);
    }
  int NumOfField = Cnt-1;
  while(peekDetect(NumOfField,FieldID)){}
}
