/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <String.h>
#include "matrix.h"
#include "field.h"

class statistic
{
  int     FieldID;
  double  Mean;
  double  Max;
  double  Min;
  double  StdD;
 public:
  inline statistic(void)
    {FieldID =  0; Mean = 0.0; Max = 0.0; Min = 0.0; StdD = 0.0;}
  inline statistic(int ID)
    {FieldID = ID; Mean = 0.0; Max = 0.0; Min = 0.0; StdD = 0.0;}
  inline statistic(double M,double S)
    {FieldID =  0; Mean =   M; Max = 0.0; Min = 0.0; StdD =   S;}
  inline statistic(int ID,double M,double S)
    {FieldID = ID; Mean =   M; Max = 0.0; Min = 0.0; StdD =   M;}
  inline int    id(void)      {return FieldID;}
  inline void   id(int ID)    {FieldID = ID;}
  inline double mean(void)    {return Mean;}
  inline double max (void)    {return Max;}
  inline double min (void)    {return Min;}
  inline void   val (double Val)
    {
      if(Max != 0.0)
	{
	  if(Val > Max)
	    Max = Val;
	}
      else
	{
	  Max = Val;
	}
      if(Min != 0.0)
	{
	  if(Val < Min)
	    Min = Val;
	}
      else
	{
	  Min = Val;
	}
    }
  inline void   mean(double M){Mean = M;}
  inline void   max (double M){Max  = M;}
  inline void   min (double M){Min  = M;}
  inline double stdD(void)    {return StdD;}
  inline void   stdD(double S){StdD = S;}
  friend inline operator=(statistic& A,statistic& B)
    {
      A.FieldID = B.FieldID;
      A.Mean    = B.Mean;
      A.StdD    = B.StdD;
    }
};

class principal
{
  double     ContRatio;
  matrix     Axis;
 public:
  inline principal(void)
    {
      ContRatio = 0.0;
    }
  inline principal(int NE)
    {
      ContRatio = 0.0;
      Axis = matrix(NE,1);
    }
  inline void    axisInit(int NE)       {Axis = matrix(NE,1);}
  inline void    contRatio(double CR)   {ContRatio = CR;}
  inline double  contRatio(void)        {return ContRatio;}
  inline void    axis(int I,double Elem){Axis(I,0) = Elem;}
  inline double  axis(int I)            {return Axis(I,0);}
  inline matrix& axis(void)             {return Axis;}
};

class multivar
{
  char*      DataFileName;
  matrix     S;
  matrix     MV;
  matrix     MH;

  int        NumData;
  int        NumElem;
  statistic* Statistic;
  double     TotalVar;
  principal* Principal;
 public:
  inline multivar(void)
    {
      NumData   = 0;
      NumElem   = 0;
      Statistic = NULL;
      TotalVar  = 0.0;
      Principal = NULL;
    }
  multivar(char*);
  multivar(char*,int,int*);
  multivar(matrix*,char*,int,int*,int,int);
  inline ~multivar(void)
    {
      delete DataFileName;
      delete Statistic;
      delete Principal;
    }
  inline char*      dataFileName(void){return DataFileName;}
  inline int        numData(void)     {return NumData;}
  inline void       numData(int ND)   {NumData = ND;}
  inline int        numElem(void)     {return NumElem;}
  inline void       numElem(int NE)   {NumElem = NE;}
  inline statistic& statistic(int P)  {return Statistic[P];}
  inline double     totalVar(void)    {return TotalVar;}
  inline principal& principal(int P)  {return Principal[P];}
  void fprint(FILE*);
  void print(void);
  void get(char*);
  void push(char*);
  void end(int,int);
};

class pushData
{
  int       DataID;
  int       AxisID;
  double    Data;
  pushData* Next;
 public:
  inline pushData(int DID,int AID,double D)
    {
      DataID  = DID;
      AxisID  = AID;
      Data    = D;
      Next    = NULL;
    }
  inline ~pushData(void)            {delete Next;}

  inline void      next(pushData* N){Next = N;}
  inline int       dataID(void)     {return DataID;}
  inline int       axisID(void)     {return AxisID;}
  inline double    data(void)       {return Data;}
  inline pushData* next(void)       {return Next;}
};

class multiData
{
  multivar*  Multivar;
  matrix*    DataMatrix;
  matrix*    Histogram;
  matrix*    HistogramSmooth;
  int        NumAxis;
  int        NumData;
  int        NumHist;
  double     Range;
  pushData*  First;
  pushData*  Last;
  multiData* Next;
 public:
  inline multiData(void)
    {
      NumAxis         = 0;
      NumData         = 0;
      NumHist         = 0;
      Multivar        = NULL;
      DataMatrix      = NULL;
      Histogram       = NULL;
      HistogramSmooth = NULL;
      First = Last    = NULL;
      Next            = NULL;
    }
  inline multiData(int NA,int* FieldID)
    {
      NumAxis         = NA;
      NumData         = 0;
      NumHist         = 0;
      Multivar        = NULL;
      DataMatrix      = NULL;
      Histogram       = NULL;
      HistogramSmooth = NULL;
      First = Last    = NULL;
      Next            = NULL;
    }

  multiData(char*,int,int*,int,int);
  multiData(matrix*,char*,int*,int,int);
  multiData(multivar*);

  inline ~multiData(void)
    {
      if(Multivar        != NULL) delete Multivar;
      if(DataMatrix      != NULL) delete DataMatrix;
      if(Histogram       != NULL) delete Histogram;
      if(HistogramSmooth != NULL) delete HistogramSmooth;
    }
  inline void       count(void)            {NumData++;};
  inline void       push(int J,double Data){push(NumData,J,Data);}
  inline void       next(multiData*   MD)  {Next = MD;}
  inline multivar*  multivar(void)         {return Multivar;}
  inline matrix*    dataMatrix(void)       {return DataMatrix;}
  inline double     range(void)            {return Range;}
  inline int        numData(void)          {return NumData;}
  inline int        numAxis(void)          {return NumAxis;}
  inline int        numHist(void)          {return NumHist;}
  inline multiData* next(void)             {return Next;}
  
  matrix*           makePrincipalVal(matrix&);
  matrix*           makePrincipalVal(int);

  void   calcRange();
  void   push(int,int,double);
  void   end(char*,int*,int,int);
  void   makeHistogram(void);
  void   smoothHistogram(void);
  void   printData(void);
  void   printHistogram(void);
  void   printHistogramSmooth(void);
  void   printHisto(matrix*,char*);
  void   printPrincipalVal(void);
  void   outPrincipalVal(char*);
  int    div(char*,FILE*,int,int,int,int*,int,int);
};

class multiDataList
{
  multiData* First;
  multiData* Last;
 public:
  inline multiDataList(void)
    {
      First=Last=NULL;
    }
  inline push(multiData* MultiData)
    {
      if(First==NULL)
	{
	  First=Last=MultiData;
	}
      else
	{
	  Last->next(MultiData);
	  Last = MultiData;
	}
    }
  inline multiData* first(void){return First;}
  inline multiData* last (void){return Last; }
  inline void print(void)
    {
      multiData* MultiData;
      for(MultiData=First;MultiData!=NULL;MultiData=MultiData->next())
	{
	  MultiData->multivar()->print();
	  MultiData->printData();
	}
    }
};

extern multiDataList* MultiDataList;
