/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <stdio.h>
#include <stream.h>
#include <GetOpt.h>
#include "local.h"


int AngFlag = 0;
int LenFlag = 0;
int WavFlag = 0;
int RotFlag = 0;
int IntFlag = 0;
int SeqFlag = 0;

int localStructCalc(int Width)
{
  static int    BuffFlag = 0;
  static char   Buff[128];
  localStruct LocalStruct(Width);
  int    Order;
  char   OrderID[8];
  char   AminoTriplet[4];
  double X,Y,Z;
  int    Internality;
  int OrderOld = -1000;
  d3vector CoordinateOld;
  for(int I = 0;I<Width-1;++I)
    {
      if(0==BuffFlag)
	{
	  if(NULL==gets(Buff))
	    {
	      cerr << "Width too long!\n";
	      printf("#Width = %4d\n",Width);
	      printf("#Begin\n");
	      printf("#End\n");
	      return 0;
	    }
	}
      BuffFlag = 0;
      sscanf(Buff,"%d %s %s %lg %lg %lg %d",
	     &Order,OrderID,AminoTriplet,&X,&Y,&Z,&Internality);
      d3vector Coordinate(X,Y,Z);
      if(OrderOld!=-1000)
	{
	  if(Order!=OrderOld+1 || (CoordinateOld^Coordinate) > 4.5)
	    {
	      BuffFlag = 1;
	      cerr << "Data Inconsistency detected and Width too long!\n";
	      cerr << form("Distance between CA Atom is %10.5lf\n",
			   CoordinateOld^Coordinate);
	      cerr << form("Difference of Order is %4d\n",Order-OrderOld);
	      printf("#Width = %4d\n",Width);
	      printf("#Begin\n");
	      printf("#End\n");
	      return 1;
	    }
	}
      OrderOld = Order;
      CoordinateOld = Coordinate;
      amino AminoID(AminoTriplet);
      LocalStruct.input(Order,AminoID,Coordinate,Internality);
    }
  Wavelet = wavelet(5,Width);

  int   BeginFlag = 0;
  char* GetsFlag;
  while(GetsFlag = gets(Buff))
    {
      sscanf(Buff,"%d %s %s %lg %lg %lg %d",
	     &Order,OrderID,AminoTriplet,&X,&Y,&Z,&Internality);
      d3vector Coordinate(X,Y,Z);
      if(BeginFlag == 0)
	{
	  printf("#Width = %4d\n",Width);
	  printf("#Begin\n");
	  BeginFlag = 1;
	}
      if(Order!=OrderOld+1 || (CoordinateOld^Coordinate) > 4.5)
	{
	  BuffFlag = 1;
	  cerr << "Data Inconsistency detected!\n";
	      cerr << form("Distance between CA Atom is %10.5lf\n",
			   CoordinateOld^Coordinate);
	      cerr << form("Difference of Order is %4d\n",Order-OrderOld);
	  printf("#End\n");
	  return 1;
	}
      OrderOld = Order;
      CoordinateOld = Coordinate;
      amino AminoID(AminoTriplet);
      LocalStruct.input(Order,AminoID,Coordinate,Internality);
      printf("%4d",LocalStruct.residue(0).order());
      if(AngFlag)
	{
	  printf(" %10.5f %10.5f %10.5f",
		 LocalStruct.longVector().length(),
		 LocalStruct.bendVector().length(),
		 LocalStruct.angleLongBend()/M_PI
		 );
	}
      if(LenFlag)
	{
	  printf(" %10.5f %10.5f",
		 LocalStruct.startVector().length(),
		 LocalStruct.endVector().length()
		 );
	}
      if(WavFlag)
	{
	  printf(" %10.5f %10.5f %10.5f %10.5f %10.5f %10.5f",
		 LocalStruct.elemI(LocalStruct.longVector()),
		 LocalStruct.elemJ(LocalStruct.longVector()),
		 LocalStruct.elemK(LocalStruct.longVector()),
		 LocalStruct.elemI(LocalStruct.bendVector()),
		 LocalStruct.elemJ(LocalStruct.bendVector()),
		 LocalStruct.elemK(LocalStruct.bendVector())
		 );

	  d3vector Wv3Vector = LocalStruct.wv3Vector();
	  d3vector Wv4Vector = LocalStruct.wv4Vector();

	  printf(" %10.5f %10.5f %10.5f %10.5f %10.5f %10.5f",
		 LocalStruct.elemI(Wv3Vector),
		 LocalStruct.elemJ(Wv3Vector),
		 LocalStruct.elemK(Wv3Vector),
		 LocalStruct.elemI(Wv4Vector),
		 LocalStruct.elemJ(Wv4Vector),
		 LocalStruct.elemK(Wv4Vector)
		 );
	}
      if(RotFlag)
	{
	  d3vector RotVector = LocalStruct.rotVector();
	  printf(" %10.5f %10.5f %10.5f",
		 LocalStruct.elemI(RotVector),
		 LocalStruct.elemJ(RotVector),
		 LocalStruct.elemK(RotVector)
		 );
	}
      if(IntFlag)
	{
	  d3vector IntVector = LocalStruct.intVector();
	  printf(" %10.5f %10.5f %10.5f",
		 LocalStruct.elemI(IntVector),
		 LocalStruct.elemJ(IntVector),
		 LocalStruct.elemK(IntVector)
		 );
	  printf(" %10.5f %10.5f %10.5f",
		 LocalStruct.int0(),
		 LocalStruct.int1(),
		 LocalStruct.int2()
		 );
	}
      if(SeqFlag)
	{
	  LocalStruct.printSeq();
	}
      printf("\n");
    }
  if(LocalStruct.fullCnt() < Width)
    {
      cerr << "Width too long!\n";
      printf("#Width = %4d\n",Width);
      printf("#Begin\n");
      printf("#End\n");
      if(GetsFlag == NULL)
	return 0;
      else
	return 1;
    }
  printf("#End\n");
  return 0;
}

main(int argc,char** argv)
{
  GetOpt getopt (argc, argv, "alwrisx");
  int Ch;
  while((Ch=getopt())!=EOF)
    {
      switch(char(Ch))
	{
	case 'a':
	  AngFlag = 1;
	  break;
	case 'l':
	  LenFlag = 1;
	  break;
	case 'w':
	  WavFlag = 1;
	  break;
	case 'r':
	  RotFlag = 1;
	  break;
	case 'i':
	  IntFlag = 1;
	  break;
	case 's':
	  SeqFlag = 1;
	  break;
	case 'x':
	  AngFlag = LenFlag = WavFlag = RotFlag = IntFlag = SeqFlag = 1;
	  break;
	default:
	  exit(1);
	}
    }
  int Width;
  if (getopt.optind < argc)
    Width = atoi(argv[getopt.optind]);
  else
    {
      cerr << "Usage\n\tlocalstruct WIDTH -[alwrisx]\n";
      exit(0);
    }
      
  if(Width%2==0)
    Width ++;
  if(Width < 5)
    WavFlag = 0;
  while(localStructCalc(Width)){}
}

