/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#ifndef _d3vector_h_
#define _d3vector_h_

#ifndef _matrix_h_
#include "matrix.h"
#endif

class d3vector : public matrix {
 public:
  d3vector(double,double,double);
  d3vector(void);
  void init(void);
  void print(void);
  void pmPrint(void);
  double length(void);
  d3vector normalize(void);
  double &operator ()(int I);
  ~d3vector(void);
};

extern d3vector operator *(d3vector& A, d3vector& B); // vector product
extern double   operator %(d3vector& A, d3vector& B); // scalar product
extern double   operator ^(d3vector& A, d3vector& B); // distance
extern double   operator &(d3vector& A, d3vector& B); // angle

extern d3vector operator *(double&   K, d3vector& A); 
extern d3vector operator *(d3vector& A, double&   K);
extern d3vector operator /(d3vector& A, double&   K);
extern d3vector operator +(d3vector& A, d3vector& B);
extern d3vector operator -(d3vector& A, d3vector& B);
extern d3vector operator -(d3vector& A);
extern d3vector operator =(d3vector& A, d3vector& B);

extern d3vector operator+=(d3vector& A, d3vector& B);
extern d3vector operator-=(d3vector& A, d3vector& B);
extern d3vector operator*=(d3vector& A, double&   K);
extern d3vector operator/=(d3vector& A, double&   K);

#endif /* eof ifndef _d3vector_h_ */
