/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <stdio.h>
#include <sys/types.h>
#include <malloc.h>
#include <math.h>
#include <gl/gl.h>
#include "vect.h"

void vset(float *v, float x, float y, float z)
{
  v[0] = x; v[1] = y; v[2] = z;
}

void vcopy(const float *v1, float *v2)
{
  v2[0] = v1[0]; v2[1] = v1[1]; v2[2] = v1[2];
}

void vcross(const float *v1, const float *v2, float *cross)
{
  cross[0] = v1[1] * v2[2] - v1[2] * v2[1];
  cross[1] = v1[2] * v2[0] - v1[0] * v2[2];
  cross[2] = v1[0] * v2[1] - v1[1] * v2[0];
}

float vlength(const float *v)
{
  return sqrt(v[0] * v[0] + v[1] * v[1] + v[2] * v[2]);
}

void vnormal(float *v)
{
  float leng = 1.0/sqrt(v[0] * v[0] + v[1] * v[1] + v[2] * v[2]);
  v[0] *= leng;
  v[1] *= leng;
  v[2] *= leng;
}










