/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/* -*-C++-*- */
#include "primitive.h"
#include "group.h"
#include "data.h"
#include "hash.h"
#include "symbol.h"
#include "exit.h"
#include "boolean.h"

#ifdef _DISABLE_GL_
#define SML_ON 1
#define SML_OFF 0
#endif
//#define MAX_CNTL_POINTS (15*1024)
#define MAX_CNTL_POINTS (200*1024)
/* nurbs$@%]%j%4%s$N@)8fE@%F!<%V%k$N%5%$%:(J*/
#define MAT_U_POINTS 1024
#define MAT_V_POINTS 1024

/* $@$3$3$K$O0J2<$N(J $@%0%i%U%#%C%/%W%j%_%F%#%V$N%/%i%9$N%a%s%P!<4X?t$r(J */
/* $@Dj5A$7$F$$$k!#(J                                                  */
/*  dot  :    $@!VE@!W(J 		*/
/*  segment : $@!V@~!W(J 		*/
/*  line  :   $@!VO"B3$9$k@~!W(J	*/
/*  polygon : $@!VLL!W(J 		*/

extern void nvector(float* A,float* B,float* C,float* n);
extern group *root_obj;
extern char line_buffer[BUFSIZ];
char* errmsg_dot_material_invalid  = 
	"Fatal : \ndot member material invalid object\n";
char* errmsg_segment_style_invalid    = 
	"Fatal : \nsegment member style invalid object\n";
char* errmsg_segment_width_invalid    = 
	"Fatal : \nsegment member width invalid object\n";
char* errmsg_segment_material_invalid = 
	"Fatal : \nsegment member material invalid object\n";
char* errmsg_line_style_invalid    = 
	"Fatal : \nline member style invalid object\n";
char* errmsg_line_width_invalid    = 
	"Fatal : \nline member width invalid object\n";
char* errmsg_line_material_invalid = 
	"Fatal : \nline member material invalid object\n";
char* errmsg_line_points_invalid = 
	"Fatal : \nline member points invalid object\n";
char* errmsg_mesh_material_invalid = 
	"Fatal : \nmesh member material invalid object\n";
char* errmsg_mesh_points_invalid = 
	"Fatal : \nmesh member points invalid object\n";
char* errmsg_fatal_full_cntlp = "Fatal: table of control point was full\n";
node* node_default_segment_width;
node* node_default_segment_style;

double ctlpnt [MAX_CNTL_POINTS][3];
const int order = 3;

double u_knots[MAT_U_POINTS];
double v_knots[MAT_V_POINTS];

void initialize_primitive()
//{}
// $@%$%s%9%?%s%9@8@.;~$N=i4|CM(J
//{}
{
  float_number* default_segment_width;
  fixed_number* default_segment_style;
  default_segment_width = new float_number[1];
  default_segment_width->Split();
  default_segment_width->Value(1.0);
  default_segment_style = new fixed_number[1];
  default_segment_style->Split();
  default_segment_style->Value(0xffff);
  node_default_segment_width = (node*)(root_obj->Search_and_Create("DefaultLineWidth"));
  node_default_segment_width->Split();
  node_default_segment_width->Value(default_segment_width);
  node_default_segment_style = (node*)(root_obj->Search_and_Create("DefaultLineStyle"));
  node_default_segment_style->Split();
  node_default_segment_style->Value(default_segment_style);
}

void check_segmentwidth_and_set(header* obj,char* errmsgstr)
{
#ifndef _DISABLE_GL_
  if (obj == (header*)0) {
    fprintf(stderr,"%s\n",line_buffer);
    fprintf(stderr,errmsgstr);
    error_exit();
  }
  ObjectTypeTag mem_type = obj->Type();
  if (mem_type == DAT_INTEGER) {
    linewidth((short)(((fixed_number*)obj)->Value()));
  }else if (mem_type == DAT_FLOAT) {
    linewidthf((float)(((float_number*)obj)->Value()));
  }else{
    fprintf(stderr,"%s\n",line_buffer);
    fprintf(stderr,errmsgstr);
    error_exit();
  }
#endif
}

graphic_primitive::graphic_primitive()
//{}
//$@%0%i%U%#%C%/%W%j%_%F%#%V$N9=C[;R(J
//{}
{
  anti_alias = FALSE;
  smooth = SML_OFF;
}

void graphic_primitive::AliasState(char* str)
//{}
//$@%"%s%A%(%$%j%"%9%b!<%I$r@_Dj$9$k!#(J
//{}
{
  int id ;
  id = hash_table.wordId(str);
  if (id == sym_param_on) {
    anti_alias = TRUE;
  }
  if (id == sym_param_off) {
    anti_alias = FALSE;
  }
}

char* graphic_primitive::AliasState()
//{}
//$@%"%s%A%(%$%j%"%9%b!<%I$,(Jon$@$J$i(J,"on"$@$=$&$G$J$$$J$i(J"off"$@$rJV$9!#(J
//{}
{
  return ((anti_alias) ? hash_table.idWord(sym_param_on):hash_table.idWord(sym_param_off));
}

void graphic_primitive::SmoothState(char* str)
//{}
//$@%9%`!<%9%b!<%I$r@_Dj$9$k!#(J
//{}
{
  int id ;
  id = hash_table.wordId(str);
  if (id == sym_param_on) {
    smooth = SML_ON;
  }
  if (id == sym_param_off) {
    smooth = SML_OFF;
  }
}

void graphic_primitive::Scale(double s)
{
  scale = s;
}

char* graphic_primitive::SmoothState()
//{}
//$@%9%`!<%9%b!<%I$,(Jon$@$J$i(J,"on"$@$=$&$G$J$$$J$i(J"off"$@$rJV$9!#(J
//{}
{
  return ((smooth == SML_ON) ? hash_table.idWord(sym_param_on):hash_table.idWord(sym_param_off));
}

 dot::dot()
//{}
// $@E@$N9=C[;R(J
//{}
{
  type = PR_DOT;
  sym_id = sym_dot;
#ifdef DEBUG
  printf ("this (%x) rc %d dot::dot()\n",(unsigned int) this,ref_c);
#endif
}

void dot::Draw()
//{}
// $@E@$NIA2h4X?t(J
//{}
{
#ifdef DEBUG
  printf ("this (%x) rc %d void dot::Draw()\n",(unsigned int) this,ref_c);
#endif
#ifndef _DISABLE_GL_
  if (dstate == ObjectHidding) return;
  check_material_and_bind(color->Value(),errmsg_dot_material_invalid);
  float v[3];
  PushScale();
  PushTranslation();
  pntsmooth(smooth);
  subpixel(anti_alias);
  bgnpoint();
  v[0] = 0;  v[1] = 0;  v[2] = 0; v3f(v);
  endpoint();
  pntsmooth(SML_OFF);
  subpixel(FALSE);
  PopTranslation();
  PopScale();
#endif
}

void dot::Close()
//{}
// $@E@$N%/%m!<%:$r9T$J$&!#(J
// $@;2>H%+%&%s%H$,(J0$@$K$J$C$?;~$K!"<+NN0h$r2rJ|$9$k!#(J
// $@$b$7$^$@!"B>$+$i;2>H$5$l$F$$$l$P!";2>H%+%&%s%H$r(J
// 1$@8:$i$9$@$1!#(J
//{}
{
#ifdef DEBUG
  printf ("this (%x) rc %d void dot::Close()\n",(unsigned int) this,ref_c);
#endif
  ref_c --;
  if (ref_c == 0) {
    free(this);
  }
}

 segment::segment()
//{}
// $@@~$N9=C[;R(J
//{}
{
  type = PR_SEGMENT;
  sym_id = sym_segment;
  header* value;
  value = node_default_segment_width->Value();
  value->Split();
  width[0].Id(sym_om_width);
  width[0].Split();
  width[0].Value(value);
  value = node_default_segment_style->Value();
  value->Split();
  style[0].Id(sym_om_style);
  style[0].Split();
  style[0].Value(value);
  anti_alias = FALSE;
#ifdef DEBUG
  printf ("this (%x) rc %d segment::segment()\n",(unsigned int) this,ref_c);
#endif
}

void segment::CopySplitMember()
//{}
// $@@~%*%V%8%'%/%H$N%3%T!<;~$N%a%s%P$N;2>H%+%&%s%H=hM}(J
//{}
{
#ifdef DEBUG
  printf ("this (%x) rc %d void segment::CopySplitMember()\n",
	  (unsigned int) this,ref_c);
#endif
  object_location->Split();
  object_rotation->Split();
  int color_id = color->Id();
  header* cv = color->Value();
  cv->Split();
  color = new node[1];
  color->Split();
  color->Id(color_id);
  color->Value(cv);
  header* value;
  value = style[0].Value();
  value->Split();
  value = width[0].Value();
  value->Split();
}

void segment::From(location* l)
//{}
//
//{}
{
#ifdef DEBUG
  printf ("this (%x) rc %d void segment::From(location* %x (",(unsigned int) this,ref_c,(unsigned int)l);
  if (l != (location*)0) l->Print();
  printf ("))\n");
#endif
  float xo,yo,zo;
  xo = (object_location->X())+dx;
  yo = (object_location->Y())+dy;
  zo = (object_location->Z())+dz;
  Move(l);
  dx = xo - (l->X());
  dy = xo - (l->Y());
  dz = xo - (l->Z());
}

void segment::To(location* l)
//{}
//
//{}
{
#ifdef DEBUG
  printf ("this (%x) rc %d void segment::To(location* %x (",(unsigned int) this,ref_c,(unsigned int)l);
  if (l != (location*)0) l->Print();
  printf ("))\n");
#endif
  dx = (l->X())-(object_location->X());
  dy = (l->Y())-(object_location->Y());
  dz = (l->Z())-(object_location->Z());
}

header* segment::Reference(int id)
//{}
//$@%i%$%s%*%V%8%'%/%H$N%a%s%P;2>H(J
//$@%O%C%7%eCM(Jid$@$r$b$D%a%s%PL>$N%a%s%P$,B8:_$9$l$P!"(J
//$@%a%s%P$N%N!<%I$N%"%I%l%9$rJV$7!"$=$&$G$J$1$l$P!"(J
//0$@$rJV$9!#(J
//{}
{
#ifdef DEBUG
  printf ("this (%x) rc %d header segment::Reference(int %d(char* %s))\n",(unsigned int) this,ref_c,id,hash_table.idWord(id));
#endif
  header* ret;
  ret = (header*)0;
  if (sym_om_color == id){
    ret =  (header*)(color);
  }else if (sym_om_width == id) {
    ret =  (header*)(width);
  }else if (sym_om_style == id) {
    ret =  (header*)(style);
  }
  return ret;
}

void segment::Close()
//{}
// $@@~$N%/%m!<%:$r9T$J$&!#(J
// $@;2>H%+%&%s%H$,(J0$@$K$J$C$?;~$K!"<+NN0h$r2rJ|$9$k!#(J
// $@$b$7$^$@!"B>$+$i;2>H$5$l$F$$$l$P!";2>H%+%&%s%H$r(J
// 1$@8:$i$9$@$1!#(J
//{}
{
#ifdef DEBUG
  printf ("this (%x) rc %d void segment::Close()\n",(unsigned int) this,ref_c);
#endif
  ref_c --;
  if (ref_c == 0) {
    header* op;
    op = width[0].Value();
    op->Close();
    free(this);
  }
}


void segment::Draw()
//{}
// $@@~$NIA2h4X?t(J
//{}
{
#ifdef DEBUG
  printf ("this (%x) rc %d void segment::Draw()\n",(unsigned int) this,ref_c);
#endif
#ifndef _DISABLE_GL_
  unsigned short segment_style;
  segment_style = (unsigned short)numerical2int(style[0].Value(),errmsg_segment_style_invalid);
  deflinestyle(1,segment_style);
  setlinestyle(1);
  check_segmentwidth_and_set(width[0].Value(),errmsg_segment_width_invalid);
  if (dstate == ObjectHidding){
    return;
  }
  check_material_and_bind(color->Value(),errmsg_segment_material_invalid);
  PushScale();
  PushTranslation();
  PushRotation();
  linesmooth(smooth);
  subpixel(anti_alias);
  float v[3];
  bgnline();
  v[0] = 0;  v[1] = 0;  v[2] = 0; v3f(v);
  v[0] = dx;  v[1] = dy;  v[2] = dz; v3f(v);
  endline();
  linewidth(1);
  linesmooth(SML_OFF);
  subpixel(FALSE);
  deflinestyle(1,0xffff);
  setlinestyle(0);
  PopRotation();
  PopTranslation();
  PopScale();
#endif
}

line::line()
//{}
// $@O"B3@~$N9=C[;R(J
//{}
{
  type = PR_LINE;
  sym_id = sym_line;
  header* value;
  value = node_default_segment_width->Value();
  value->Split();
  width[0].Id(sym_om_width);
  width[0].Value(value);
  width[0].Split();
  value = node_default_segment_style->Value();
  value->Split();
  style[0].Id(sym_om_style);
  style[0].Split();
  style[0].Value(value);

  points[0].Id(sym_om_points);
  points[0].Value((cons*)0);
  points[0].Split();
  anti_alias = FALSE;
  is_nurbs = FALSE;
}

void line::CopySplitMember()
//{}
// $@O"B3@~%*%V%8%'%/%H$N%3%T!<;~$N%a%s%P$N;2>H%+%&%s%H=hM}(J
//{}
{
  object_location->Split();
  object_rotation->Split();
  int color_id = color->Id();
  header* cv = color->Value();
  cv->Split();
  color = new node[1];
  color->Split();
  color->Id(color_id);
  color->Value(cv);
  header* value;
  value = style[0].Value();
  value->Split();
  value = width[0].Value();
  value->Split();
  value = points[0].Value();
  value->Split();
}

header* line::Reference(int id)
//{}
//$@O"B3@~%*%V%8%'%/%H$N%a%s%P;2>H(J
//$@%O%C%7%eCM(Jid$@$r$b$D%a%s%PL>$N%a%s%P$,B8:_$9$l$P!"(J
//$@%a%s%P$N%N!<%I$N%"%I%l%9$rJV$7!"$=$&$G$J$1$l$P!"(J
//0$@$rJV$9!#(J
//{}
{
#ifdef DEBUG
  printf ("this (%x) rc %d header line::Reference(int %d(char* %s))\n",(unsigned int) this,ref_c,id,hash_table.idWord(id));
#endif
  header* ret;
  ret = (header*)0;
  if (sym_om_points == id) {
    ret =  (header*)(points);
  }else if (sym_om_color == id) {
    ret =  (header*)(color);
  }else if (sym_om_width == id) {
    ret =  (header*)(width);
  }else if (sym_om_style == id) {
    ret =  (header*)(style);
  }
  return ret;
}

void line::Draw()
//{}
// $@O"B3@~$NIA2h4X?t(J
//{}
{
#ifdef DEBUG
  printf ("this (%x) rc %d void line::Draw()\n",(unsigned int)this,ref_c);
#endif
#ifndef _DISABLE_GL_
  unsigned short segment_style;
  segment_style = (unsigned short)numerical2int(style[0].Value(),errmsg_line_style_invalid);
  deflinestyle(1,segment_style);
  setlinestyle(1);
  check_segmentwidth_and_set(width[0].Value(),errmsg_line_width_invalid);
  if (dstate == ObjectHidding){
    return;
  }
  if (dstate == ObjectHidding) return;
  check_material_and_bind(color->Value(),errmsg_line_material_invalid);
  PushScale();
  PushTranslation();
  PushRotation();
  linesmooth(smooth);
  subpixel(anti_alias);
  cons* wp = (cons*)(points[0].Value());
  if (wp != (header*)0) {
    if (wp->Type() != DAT_LIST) {
      fprintf(stderr,"%s\n",line_buffer);
      fprintf(stderr,errmsg_line_points_invalid);
      error_exit();
    }
    if (is_nurbs) {
      int size_data;
      cons* leng_p;
      size_data = 0;
      leng_p = (cons*)wp;
      for (;;size_data++) {
	if (leng_p == (cons*)0) {
	  break;
	}
	leng_p = (cons*)leng_p->Cdr();
      }
      if (size_data <3) {
	bgnline();
	for (;wp != (cons*)0;wp = (cons*)(wp->Cdr())) {
	  location* lp;
	  lp = (location*)(wp->Car());
	  if (lp != (location*)0) {
	    v3d(lp->VP());
	  }
	}
	endline();
      }else{
	double ctlpnt [1000][3];
	int u = 0;
	for (;;u++) {
	  if ((wp == (cons*)NULL)||(wp == (cons*)0)) break;
	  location* lp;
	  lp = (location*)(wp->Car());
	  if (lp != (location*)0) {
	    ctlpnt[u][0] = (lp->X());  ctlpnt[u][1] = (lp->Y()); ctlpnt[u][2] = (lp->Z());
	  }
	  wp = (cons*)(wp->Cdr());
	}
	int order = 3;
	double s_knots[1003];
	for (int count = 0;count<(size_data+order);count++) {
	  s_knots[count] = ((double)(count))/(size_data+order-1);
	}
	bgncurve();
	nurbscurve(size_data+order,s_knots,3*sizeof(double),&ctlpnt[0][0],order,N_V3D);
	endcurve();
      }
    }else {
      bgnline();
      for (;wp != (cons*)0;wp = (cons*)(wp->Cdr())) {
	location* lp;
	lp = (location*)(wp->Car());
	if (lp != (location*)0) {
	  v3d(lp->VP());
	}
      }
      endline();
    }
  }
  linewidth(1);
  linesmooth(SML_OFF);
  subpixel(FALSE);
  deflinestyle(1,0xffff);
  setlinestyle(0);
  PopRotation();
  PopTranslation();
  PopScale();
#endif
}
void line::Close()
//{}
// $@O"B3@~$N%/%m!<%:$r9T$J$&!#(J
// $@;2>H%+%&%s%H$,(J0$@$K$J$C$?;~$K!"<+NN0h$r2rJ|$9$k!#(J
// $@$b$7$^$@!"B>$+$i;2>H$5$l$F$$$l$P!";2>H%+%&%s%H$r(J
// 1$@8:$i$9$@$1!#(J
//{}
{
#ifdef DEBUG
  printf ("this (%x) rc %d void line::Close()\n",(unsigned int) this,ref_c);
#endif
  ref_c--;
  if (ref_c == 0) {
#ifdef DEBUG
    printf ("line member close begin\n");
#endif
    color->Close();
    header* hp;
    hp = points[0].Value();
    hp->Close();
    hp = width[0].Value();
    hp->Close();
    hp = style[0].Value();
    hp->Close();
#ifdef DEBUG
    printf ("line member close end\n");
#endif
    free(this);
  }
}

char* line::Nurbs()
//{}
//
//{}
{
  return ((is_nurbs) ? hash_table.idWord(sym_param_on):hash_table.idWord(sym_param_off));
}

void line::Nurbs(char* str)
//{}
//
//{}
{
  int id ;
  id = hash_table.wordId(str);
  if (id == sym_param_on) {
    is_nurbs = TRUE;
  }
  if (id == sym_param_off) {
    is_nurbs = FALSE;
  }
}

char* mesh::Nurbs()
//{}
//
//{}
{
  return ((is_nurbs) ? hash_table.idWord(sym_param_on):hash_table.idWord(sym_param_off));
}

void mesh::Nurbs(char* str)
//{}
//
//{}
{
#ifdef DEBUG
  fprintf(stderr,"void mesh::Nurbs(char* %s)\n",str);
#endif
  int id ;
  id = hash_table.wordId(str);
  if (id == sym_param_on) {
    is_nurbs = TRUE;
  }
  if (id == sym_param_off) {
    is_nurbs = FALSE;
  }
}

void mesh::CopySplitMember()
//{}
// $@%]%j%4%s%*%V%8%'%/%H$N%3%T!<;~$N%a%s%P$N;2>H%+%&%s%H=hM}(J
//{}
{
#ifdef DEBUG
  fprintf(stderr,"void mesh::CopySplitMember()\n");
#endif
  object_location->Split();
  object_rotation->Split();
  int color_id = color->Id();
  header* cv = color->Value();
  cv->Split();
  color = new node[1];
  color->Split();
  color->Id(color_id);
  color->Value(cv);
  header* value;
  value = points[0].Value();
  value->Split();
}

void mesh::Draw()
//{}
// $@%]%j%4%s$NIA2h4X?t(J
//{}
{
#ifdef DEBUG
  printf ("this (%x) rc %d void mesh::Draw()\n",(unsigned int)this,ref_c);
#endif
#ifndef _DISABLE_GL_
  if (dstate == ObjectHidding) return;
  check_material_and_bind(color->Value(),errmsg_mesh_material_invalid);
  PushScale();
  PushTranslation();
  PushRotation();
  backface(FALSE);
  cons* wp = (cons*)(points[0].Value());
  if (wp == (cons*)0) {
    goto trough_end;
  }
  if (wp->Type() != DAT_LIST) {
    fprintf(stderr,"%s\n",line_buffer);
    fprintf(stderr,errmsg_mesh_points_invalid);
    error_exit();
  }
  cons* bp;
  bp = (cons*)wp->Car();
  if (bp == (cons*)0) {
    goto trough_end;
  }
  if (anti_alias) {
    subpixel(TRUE);
  }else{
    subpixel(FALSE);
  }
  if (is_nurbs == TRUE) {
    int size_node,size_data;
    cons* leng_p;
    size_data = 0;
    leng_p = (cons*)wp->Car();
    for (;;size_data++) {
      if (leng_p == (cons*)0) {
	break;
      }
      leng_p = (cons*)leng_p->Cdr();
    }
    size_node = 0;
    leng_p = wp;
    for (;;size_node++) {
      if (leng_p == (cons*)0) {
	break;
      }
      leng_p = (cons*)leng_p->Cdr();
    }
    if ((size_node == 1)||(size_data ==1)) {
      //fprintf(stderr,"Warning : \nNurbs illegal points\n");
      goto trough_end;
    }else{
      int uis2 = FALSE, vis2 = FALSE,uis3 = FALSE,vis3 = FALSE;
      if (size_node == 2) {
	size_node+= 2;
	uis2 = TRUE;
      }
      if (size_data == 2) {
	size_data+= 2;
	vis2 = TRUE;
      }
      if (size_node == 3) {
	size_node++;
	uis3 = TRUE;
      }
      if (size_data == 3) {
	size_data++;
	vis3 = TRUE;
      }
      {
	int u = 0;
	int v = 0;
	int u_knots_size = size_node+order,v_knots_size = size_data+order;
	int no_of_bytes = sizeof(double)*3;
	int count;
	if (MAX_CNTL_POINTS<(size_node*size_data)) {
	  fprintf(stderr,"%s\n",line_buffer);
	  fprintf(stderr,errmsg_fatal_full_cntlp);
	  error_exit();
	}
	for (u = 0;u < size_node;u++) {
	  const int index = u*size_data;
	  cons* cp;
	  if ((wp == (cons*)NULL)||(wp == (cons*)0)) break;
	  cp = (cons*)wp->Car();
	  for (v = 0;v < size_data;v++) {
	    location* lp;
	    if ((cp == (cons*)0)||(cp == (cons*)NULL)) break;
	    lp = (location*)(cp->Car());
	    if (lp != (location*)0) {
	      ctlpnt[index+v][0] = (lp->X());
	      ctlpnt[index+v][1] = (lp->Y());
	      ctlpnt[index+v][2] = (lp->Z());
	    }
	    cp = (cons*)(cp->Cdr());
	  }
	  wp = (cons*)(wp->Cdr());
	}
	if (uis3){
	  int pv;
	  const int index1 = size_data;
	  const int index2 = 2*size_data;
	  const int index3 = 3*size_data;
	  for (pv = 0;pv < size_data;pv++) {
	    ctlpnt[index3+pv][0] = ctlpnt[index2+pv][0];
	    ctlpnt[index3+pv][1] = ctlpnt[index2+pv][1];
	    ctlpnt[index3+pv][2] = ctlpnt[index2+pv][2];
	    ctlpnt[index2+pv][0] = (ctlpnt[index3+pv][0]+ctlpnt[index1+pv][0])/2;
	    ctlpnt[index2+pv][1] = (ctlpnt[index3+pv][1]+ctlpnt[index1+pv][1])/2;
	    ctlpnt[index2+pv][2] = (ctlpnt[index3+pv][2]+ctlpnt[index1+pv][2])/2;
	  }
	}
	if (uis2){
	  int pv;
	  const int index1 = size_data;
	  const int index2 = 2*size_data;
	  const int index3 = 3*size_data;
	  for (pv = 0;pv < size_data;pv++) {
	    ctlpnt[index3+pv][0] = ctlpnt[index1+pv][0];
	    ctlpnt[index3+pv][1] = ctlpnt[index1+pv][1];
	    ctlpnt[index3+pv][2] = ctlpnt[index1+pv][2];
	    ctlpnt[index1+pv][0] = (ctlpnt[index3+pv][0]+ctlpnt[pv][0]*2)/3;
	    ctlpnt[index1+pv][1] = (ctlpnt[index3+pv][1]+ctlpnt[pv][1]*2)/3;
	    ctlpnt[index1+pv][2] = (ctlpnt[index3+pv][2]+ctlpnt[pv][2]*2)/3;
	    ctlpnt[index2+pv][0] = (ctlpnt[index3+pv][0]*2+ctlpnt[pv][0])/3;
	    ctlpnt[index2+pv][1] = (ctlpnt[index3+pv][1]*2+ctlpnt[pv][1])/3;
	    ctlpnt[index2+pv][2] = (ctlpnt[index3+pv][2]*2+ctlpnt[pv][2])/3;
	  }
	}
	if (vis3){
	  int pu;
	  for (pu = 0;pu < size_node;pu++) {
	    const int index = pu*size_data;
	    ctlpnt[index+3][0] = ctlpnt[index+2][0];
	    ctlpnt[index+3][1] = ctlpnt[index+2][1];
	    ctlpnt[index+3][2] = ctlpnt[index+2][2];
	    ctlpnt[index+2][0] = (ctlpnt[index+3][0]+ctlpnt[index+1][0])/2;
	    ctlpnt[index+2][1] = (ctlpnt[index+3][1]+ctlpnt[index+1][1])/2;
	    ctlpnt[index+2][2] = (ctlpnt[index+3][2]+ctlpnt[index+1][2])/2;
	  }
	}
	if (vis2){
	  int pu;
	  for (pu = 0;pu < size_node;pu++) {
	    const int index = pu*size_data;
	    ctlpnt[index+3][0] = ctlpnt[index+1][0];
	    ctlpnt[index+3][1] = ctlpnt[index+1][1];
	    ctlpnt[index+3][2] = ctlpnt[index+1][2];
	    ctlpnt[index+1][0] = (ctlpnt[index+3][0]+ctlpnt[index][0]*2)/3;
	    ctlpnt[index+1][1] = (ctlpnt[index+3][1]+ctlpnt[index][1]*2)/3;
	    ctlpnt[index+1][2] = (ctlpnt[index+3][2]+ctlpnt[index][2]*2)/3;
	    ctlpnt[index+2][0] = (ctlpnt[index+3][0]*2+ctlpnt[index][0])/3;
	    ctlpnt[index+2][1] = (ctlpnt[index+3][1]*2+ctlpnt[index][1])/3;
	    ctlpnt[index+2][2] = (ctlpnt[index+3][2]*2+ctlpnt[index][2])/3;
	  }
	}
	for (count = 0;count < u_knots_size;count++) {
	  u_knots[count] = ((double)(count))/(u_knots_size-1);
	}
	for (count = 0;count < v_knots_size;count++) {
	  v_knots[count] = ((double)(count))/(v_knots_size-1);
	}
	if (dstate == ObjectDrawing) {
	  polysmooth(smooth);
	  bgnsurface();
	  nurbssurface(u_knots_size,u_knots,v_knots_size,v_knots,size_data*no_of_bytes,no_of_bytes,&ctlpnt[0][0],order,order,N_V3D);
	  endsurface();
	  polysmooth(SML_OFF);
	}else{
	  linesmooth(smooth);
	  setnurbsproperty(N_DISPLAY,N_OUTLINE_POLY);
	  bgnsurface();
	  nurbssurface(u_knots_size,u_knots,v_knots_size,v_knots,size_data*no_of_bytes,no_of_bytes,&ctlpnt[0][0],order,order,N_V3D);
	  endsurface();
	  setnurbsproperty(N_DISPLAY,N_FILL);
	  linesmooth(SML_OFF);
	}
      }
    }
  } else {
    if (bp != (cons*)0) {
      wp = (cons*)(wp->Cdr());
      for (;wp != (cons*)0;wp = (cons*)(wp->Cdr())) {
	cons* cp; cons* sp;
	float n[3];
	float A[3],B[3],C[3],D[3];
	n[0] = 0; n[1] = 0; n[2] = 0;
	cp = (cons*)wp->Car();
	sp = cp;
	location* lp;
	for (;cp != (cons*)0;) {
	  lp = (location*)(cp->Car());
	  if (lp != (location*)0) {
	    C[0] = (lp->X()); C[1] = (lp->Y()); C[2] = (lp->Z());
	  }
	  cp = (cons*)(cp->Cdr());
	  if (cp == (cons*)0) break;
	  lp = (location*)(cp->Car());
	  if (lp != (location*)0) {
	    D[0] = (lp->X()); D[1] = (lp->Y()); D[2] = (lp->Z());
	  }
	  lp = (location*)(bp->Car());
	  if (lp != (location*)0) {
	    A[0] = (lp->X()); A[1] = (lp->Y());  A[2] = (lp->Z());
	  }
	  bp = (cons*)(bp->Cdr());
	  lp = (location*)(bp->Car());
	  if (lp != (location*)0) {
	    B[0] = (lp->X()); B[1] = (lp->Y()); B[2] = (lp->Z());
	  }
	  if (dstate == ObjectDrawing) {
	    polysmooth(smooth);
	    nvector(A,B,C,n);
	    bgnpolygon();
	    n3f(n);
	    v3f(A); v3f(B); v3f(C);
	    endpolygon();
	    nvector(B,D,C,n);
	    bgnpolygon();
	    n3f(n);
	    v3f(B); v3f(D);v3f(C);
	    endpolygon();
/*	    bgnqstrip();
	    nvector(A,B,C,n);
	    n3f(n);
	    v3f(A); v3f(B); v3f(C); v3f(D);
	    endqstrip();*/
	    polysmooth(SML_OFF);
	  }else {
	    linesmooth(smooth);
	    bgnline();
	    v3f(A);   v3f(B);  v3f(D);  v3f(C);  v3f(A);
	    endline();
	    linesmooth(SML_OFF);
	  }
	}
	bp = sp;
      }
    }
  }
  trough_end:
  if (anti_alias) {
    subpixel(FALSE);
  }
  backface(FALSE);
  PopRotation();
  PopTranslation();
  PopScale();
#endif
}

mesh::mesh()
//{}
// $@%]%j%4%s$N9=C[;R(J
//{}
{
  type = POL_MESH;
  sym_id = sym_mesh;
  points[0].Id(sym_om_points);
  points[0].Value((cons*)0);
  anti_alias = FALSE;
  is_nurbs = FALSE;
}

header* mesh::Reference(int id)
//{}
//$@%]%j%4%s%*%V%8%'%/%H$N%a%s%P;2>H4X?t(J
//$@%O%C%7%eCM(Jid$@$r$b$D%a%s%PL>$N%a%s%P$,B8:_$9$l$P!"(J
//$@%a%s%P$N%N!<%I$N%"%I%l%9$rJV$7!"$=$&$G$J$1$l$P!"(J
//0$@$rJV$9!#(J
//{}
{
#ifdef DEBUG
  printf ("this (%x) rc %d header mesh::Reference(int %d(char* %s))\n",(unsigned int) this,ref_c,id,hash_table.idWord(id));
#endif
  header* ret;
  ret = (header*)0;
  if (sym_om_color == id) {
    ret =  (header*)(color);
  }else if (sym_om_points == id) {
    ret =  (header*)(points);
  }
  return ret;
}

void mesh::Close()
//{}
// $@%]%j%4%s$N%/%m!<%:$r9T$J$&!#(J
// $@;2>H%+%&%s%H$,(J0$@$K$J$C$?;~$K!"<+NN0h$r2rJ|$9$k!#(J
// $@$b$7$^$@!"B>$+$i;2>H$5$l$F$$$l$P!";2>H%+%&%s%H$r(J
// 1$@8:$i$9$@$1!#(J
//{}
{
#ifdef DEBUG
  printf ("this (%x) rc %d void mesh::Close()\n",(unsigned int) this,ref_c);
#endif
  ref_c--;
  if (ref_c == 0) {
#ifdef DEBUG
    printf ("mesh member close begin \n");
#endif
    color->Close();
    header* hp;
    hp = points[0].Value();
    hp->Close();
#ifdef DEBUG
    printf ("mesh member close end \n");
#endif
    free(this);
  }
}
