/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
%{
#include <stdio.h>
#include <stream.h>
extern "C" {
#include <malloc.h>
};
#include "header.h"
#include "object.h"
#include "node.h"
#include "group.h"
#include "data.h"
#include "hash.h"
#include "message.h"
#include "function.h"
#include "exit.h"
#include "boolean.h"

extern message* make_message(MethodID id,header* args);
extern message* insert_message(message* top,message* tail);
extern header* execute(header* obj,message* mess);
extern header* make_instance(int id);
extern header* insert_list(header* a,header* b);
extern header* builtin_function(FunctionID fid,header* arg);
extern header* object_member(header* obj,int id);
extern int arg_length(header* arg);
extern header* make_location(header* arg);
extern header* append_args(header* top,header* tail);
extern int yylex();
extern void yyerror(const char* s);
extern group* var_list;
extern node* root;
extern char line_buffer[BUFSIZ];
extern int line_number;
extern int is_not_load_initial_file;
extern group* current_ref_group;
char parse_buffer[BUFSIZ];
char* parse_point;
%}
%union {
  int ival;
  double fval;
  MethodID midval;
  FunctionID fidval;
  header* oval;
  message* mval;
}

%type <oval> expr
%type <oval> args
%type <oval> argment 
%type <oval> list
%type <oval> expression
%type <oval> var
%type <mval> message

%token <oval> SWSYM
%token <fval> FLOAT
%token <ival> INTEGER
%token <ival> SYMBOL
%token <ival> STRING
%token <ival> MEMBER
%token <fidval> MATH_FUNC
%token <midval> METHOD_ONLY_NAME
%token <midval> METHOD_NAME
%token <ival> OBJECT_TYPE

%token COMMA ENDARGS BGNARGS ENDLIST BGNLIST PLUS MINUS TE NEW QS
%token BGNSTR ENDSTR ENDFILE

%token DIV MU
%left PLUS MINUS
%left DIV MUL

%%
  program : {
#ifdef _DISABLE_GL_
  printf("\n");
#endif
}
| ENDFILE
{
#ifdef _DISABLE_GL_
  printf("\n");
#endif
}
| expression TE
{
#ifdef _DISABLE_GL_
/*  if (is_not_load_initial_file == TRUE){
    printf("%s",parse_buffer);
  }
  parse_point = parse_buffer;
  *parse_point = '\0';*/
#endif
};

expression : expression message
{
  $$ = execute($1,$2);
}
|var message
{
  $$ = execute($1,$2);
}
| message
{
  $$ = execute(root,$1);
};

var : var MEMBER
{
  node* wp;
  wp = (node*)($1);
  char* name ;
#ifdef _VAR_DEBUG_
  name = hash_table.idWord($2);
  printf(" var (%s) (MEMBER %s)\n",wp->Name(),name);
#endif
  header* member;
  member = object_member(wp->Value(),$2);
  if (member == (header*)0) {
    name = hash_table.idWord($2);
    fprintf(stderr,"Syntax Error : %s member(%s)\nNo such member\n",wp->Name(),name);
    error_exit();
  }
  $$ = member;
}
| var SYMBOL
{
  header* val;
  val = (header*)(((node*)$1)->Value());
  if ((val == (header*)0) || ((val->Type()) != GROUP_OBJ)) {
    fprintf(stderr,"%s",line_buffer);
    fprintf(stderr,"Fatal : object %s\nIs not group object %d\n",(((node*)$1)->Name()),line_number);
    error_exit();
  } 
#ifdef _VAR_DEBUG_
  char* name ;
  name = hash_table.idWord($2);
  printf(" (%s) var QS (STRING : %s)\n",((node*)$1)->Name(),name);
#endif
  $$ = ((group*)val)->Search_and_Create($2);
}
| SYMBOL
{
#ifdef _VAR_DEBUG_
  char* name ;
  name = hash_table.idWord($1);
  printf(" root var QS (STRING : %s)\n",name);
#endif
  $$ = (header*)(current_ref_group->Search_and_Create($1));
}
| QS
{
#ifdef _VAR_DEBUG_
  printf(" root var QS \n");
#endif
  $$ = root;
};

list : ENDLIST
{
  $$ = (header*)0;
}
| argment COMMA list
{
  $$ = insert_list($1,$3);
}
| argment  ENDLIST
{
  $$ = insert_list($1,(header*)0);
};

args : expr  ENDARGS
{
  $$ = append_args($1,(header*)0);
}
| expr COMMA args
{
  $$ = append_args($1,$3);
};

argment : NEW OBJECT_TYPE
{
  $$ = make_instance($2);
}
| BGNLIST list
{
  $$ = $2;
}
| BGNARGS args 
{
  if (arg_length($2) == 3) {
    $$ = make_location($2);
  } else {
    $$ = (header*)$2;
  }
}
| BGNSTR expression ENDSTR
{
  $$ = $2;
}
| SWSYM
{
  $$ = (header*)$1;
}
| expr 
{
  $$ = $1;
}
| STRING 
{
  header* sp;
  sp = create_string($1);
  sp->Split();
  $$ = (header*)sp;
};

message : METHOD_NAME argment 
{
  $$ = make_message($1,$2);
}
| METHOD_ONLY_NAME 
{
  $$ = make_message($1,(header*)0);
};

expr : MATH_FUNC BGNSTR expr ENDSTR
{
  $$ = builtin_function($1,$3);
}
|BGNSTR expr ENDSTR
{
  $$ = $2;
}
| MINUS expr
{
  $$ =  minus($2);
}
| expr PLUS expr
{
  $$ = add($1,$3);
}
| expr MINUS expr
{
  $$ = sub($1,$3);
}
| expr MUL expr
{
  $$ = mul($1,$3);
}
| expr DIV expr
{
  $$ = dev($1,$3);
}
| var
{
  $$ = ((node*)$1)->Value();
}
| FLOAT
{
  header* fp;
  fp = create_float($1);
  fp->Split();
  $$ = (header*)fp;
}
| INTEGER
{
  header* fp;
  fp = create_integer($1);
  fp->Split();
  $$ = (header*)fp;
};

%%

