/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#ifndef _panel_h_
#define _panel_h_

typedef enum{
  Left,
  Right,
  Center
} StringLocation;

class Item {
 protected:
  StringLocation loc;
  char str[100];
  int x1,y1,x2,y2;
  int current;
  int size;
  long dial_color;
  long sdial_color; 
  char** array;
  float total;
  float value;
  void (*behavior)(Item*);
  void (*display)(Item*);
  void (*select)(Item*);
 public:
  Item();
  void SetRect(int a,int b,int c,int d);
  int Xb();
  int Yb();
  int Xe();
  int Ye();
  void Total(float);
  float Total();
  void Value(float);
  float Value();
  void Location(StringLocation l);
  StringLocation Location();
  void Text(char* s);
  char* Text();
  void TextArray(char** s);
  char** TextArray();
  void NoOfSelect(int s);
  int NoOfSelect();
  void CurrentEntry(int s);
  int CurrentEntry();
  void DialColor(long i);
  long DialColor();
  void SmallDialColor(long i);
  long SmallDialColor();
  void Behavior(void (*u_func)(Item*));
  void Behavior(Item* c);
  void Display(void (*u_func)(Item*));
  void Display(Item* c);
  void Select(void (*u_func)(Item*));
  void Select(Item* c);
  int IsSelected(int x,int y);
};
#endif
