/* ---------------------------------------------------------- 
%   (C)1992 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <stdio.h>
#include "message.h"
#include "hash.h"
#include "symbol.h"

extern int msg_sym_table[METHOD_END];

message::message()
{
  msg = METHOD_END;
  arg = (header*)0;
  next = (message*)0;
}

 void message::Type(MethodID t)
{
  msg = t;
}

 MethodID message::Type()
{
  return msg;
}

 void message::Arg(header* h)
{
  arg = h;
}

 header* message::Arg()
{
  return arg ;
}

 void message::Next(message* m)
{
  next = m;
}

 message* message::Next()
{
  return next;
}

message* make_message(MethodID id,header* arg)
{
#ifdef DEBUG
  printf("message* make_message(MethodID %d,header* %x)\n",(int)id,(unsigned int)arg);
#endif
  message* ret;
  ret = new message[1];
  ret->Type(id);
  ret->Arg(arg);
#ifdef DEBUG
  printf("return value is %x\n",(unsigned int)ret);
#endif
  return ret;
}

message* insert_message(message* top,message* tail)
{
  top->Next(tail);
  return top;
}

char* MsgId_2_str(MethodID id)
{
  if (id == METHOD_END) return (char*)0;
  return hash_table.idWord(msg_sym_table[id]);
}

